package com.xunlei.niux.manager.web.model;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStreamReader;
import java.net.URLDecoder;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.http.client.HttpClient;
import org.apache.http.client.ResponseHandler;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.impl.client.BasicResponseHandler;
import org.apache.http.impl.client.DefaultHttpClient;
import org.apache.log4j.Logger;
import org.codehaus.jackson.JsonParseException;
import org.codehaus.jackson.map.JsonMappingException;
import org.codehaus.jackson.map.ObjectMapper;
import com.ferret.common.dao.enums.OrderType;
import com.ferret.common.dao.vo.Page;
import com.xunlei.common.facade.IFacadeCommon;
import com.xunlei.common.util.FunRef;
import com.xunlei.common.util.PagedFliper;
import com.xunlei.common.util.Sheet;
import com.xunlei.common.util.XLRuntimeException;
import com.xunlei.niux.data.vipgame.bo.BigCustomerQueryBo;
import com.xunlei.niux.data.vipgame.facade.FacadeFactory;
import com.xunlei.niux.data.vipgame.vo.BigCustomerQuery;
import com.xunlei.niux.manager.web.util.NiUxFunctionConstant;
import com.xunlei.niux.manager.web.vo.JsonRecord;
import com.xunlei.niux.manager.web.vo.Record;

/**
 * 大客户查询业务处理类
 * @author lisu
 * 2012-11-21
 */
@FunRef(NiUxFunctionConstant.NIUX_FUNCTION_BIGCUSTOMER)
public class BigCustomerManagedBean extends BaseManagedBean{
	private static final Logger logger = Logger.getLogger(BigCustomerManagedBean.class.getName());
	private BigCustomerQueryBo bigCustomerQueryBo;
	private int rownum = 0;
	private List<Map<String,Object>> detailLists = null;
	private List<Map<String,Object>> pageDetailLists = null;
	
	private static DecimalFormat  myformat = new DecimalFormat();
	static{
		myformat.applyPattern("##,###.00");
	}
	
	
	public BigCustomerManagedBean(){
		bigCustomerQueryBo = FacadeFactory.INSTANCE.getBigCustomerQueryBo();
		//初始化行号
		int pageNo=this.getFliper().getPageNo();
		int pageSize=this.getFliper().getPageSize();
		rownum=rownum+(pageNo-1)*pageSize+1;
		if(detailLists == null){
			detailLists = new ArrayList<Map<String,Object>>();
		}
		if(pageDetailLists == null){
			pageDetailLists = new ArrayList<Map<String,Object>>();
		}
	}
	
	public int getRownum() {
		return rownum++;
	}

	public void setRownum(int rownum) {
		this.rownum = rownum;
	}
	
	/**
	 * 大客户查询
	 */
	 public String getQueryBigCustomerQueryList(){
	    logger.info("开始大客户查询");
        this.authenticateRun();//验证运行权限
        BigCustomerQuery customer = findBean(BigCustomerQuery.class, "bigcustomerquery");
        if(customer.getFromdaytime() != null&& !"".equals(customer.getFromdaytime())){
        	customer.setFromdaytime(formatTime(customer.getFromdaytime()));
        }
        if(customer.getTodaytime() != null&& !"".equals(customer.getTodaytime())){
        	customer.setTodaytime(formatTime(customer.getTodaytime()));
        }
        PagedFliper pagedFliper = this.getFliper();
        int count = bigCustomerQueryBo.count(customer);
        pagedFliper.setRecordCount(count);
        List<BigCustomerQuery> list = new ArrayList<BigCustomerQuery>();
        if (count > 0) {
        	rownum = 1;
        	Page page=new Page();
        	page.setPageNo(pagedFliper.getPageNo());
        	page.setPageSize(pagedFliper.getPageSize());
        	page.addOrder("daytime", OrderType.DESC);
            list = bigCustomerQueryBo.find(customer,page.getPageNo(),page.getPageSize());
        }
        Sheet<BigCustomerQuery> sheet = new Sheet<BigCustomerQuery>(count, list);
        for(BigCustomerQuery query:sheet.getDatas()){
            query.setDaytime(formatDay(query.getDaytime()));
            query.setPaytotal(myformat.format(new Double(query.getPaytotal())));
            query.setAddpaytotal(myformat.format(new Double(query.getAddpaytotal())));
        }
        this.mergePagedDataModel(sheet, pagedFliper);
        return "";
	 }
	 
	 
	 /**
	  * 格式化日期 转化成：yyyyMMdd
	  * @param time
	  * @return
	  */
	 public String formatTime(String time){
		 if(time == null ||"".equals(time))return "";
		 String strs[] = time.split("-");
		 return strs[0]+strs[1]+strs[2];
	 }
	
	/**
	 * 大客户详情查询
	 * @return
	 */
	public String getQueryBigCustomerDetailList(){
		logger.info("开始大客户详情查询");
        this.authenticateRun();//验证运行权限
        String uid = findParameter("uid")==null?null:findParameter("uid").trim();
        Sheet<Map<String, Object>> comments = new Sheet<Map<String, Object>>();	
        //满足分页功能
        PagedFliper pagedFliper = this.getFliper();
        /**
        if(uid != null&&!"".equals(uid)){
        	//从集合中找出客户信息 
        	List<Map<String,Object>> uidList = new ArrayList<Map<String,Object>>();
        	if(lists==null){
        		lists = new ArrayList<Map<String,Object>>();
        		//调用查询接口，将数据绑定到指定集合中
                bindDatas(lists);  
        	}
        	for(Map<String,Object> map:lists){
        		while(uid.equals((String)map.get("userid"))){
        			uidList.add(map);//查询到一条信息
        		}
        	}
        	Sheet<Map<String, Object>> comments = new Sheet<Map<String, Object>>();		
    		comments.setDatas(uidList);
    		
    		this.mergePagedDataModel(comments, pagedFliper);
    		return "";
        }
        if(lists!=null)
            lists.clear();//每次查询时都把数据集合清空
        
        rownum = 1;
        if(lists==null)
           lists = new ArrayList<Map<String,Object>>();
        //调用查询接口，将数据绑定到指定集合中
        bindDatas(lists);        
       
        //处理分页问题 
        int len = lists.size();
        int pageNo = pagedFliper.getPageNo();
        int pageSize = pagedFliper.getPageSize();

System.out.println("pageNo:"+pageNo+",pageSize:"+pageSize);
System.out.println("len====================>"+len);
        Collection<Map<String,Object>> tmpcollections = new ArrayList<Map<String,Object>>();  
        if(pageNo==1){
        	if(pageNo*pageSize > len){//如果记录数少于一页
        		for(int i=0;i<len;i++){
                	tmpcollections.add(lists.get(i));
                }
        	}else{//如果记录数多于一页
        		for(int i=(pageNo-1)*pageSize;i<pageNo*pageSize;i++){
                	tmpcollections.add(lists.get(i));
                }
        	}
        }else{       	
        	for(int i=(pageNo-1)*pageSize;i<pageNo*pageSize;i++){
            	tmpcollections.add(lists.get(i));
            }
        }
System.out.println("lists==========>"+lists);  
System.out.println("tmpcollections==========>"+tmpcollections);
        //用完之后清空集合
        lists.clear();
        lists = null;
        //setDataFromFile("d:/1350625508821.txt");
        rownum = 1;
       
		Sheet<Map<String, Object>> comments = new Sheet<Map<String, Object>>();		
		//comments.setDatas(lists);
		//将集合中的数据放到可以在页面显示的集合中		
		comments.setDatas(tmpcollections);
		comments.setRowcount(tmpcollections.size());**/
        rownum = 1;
        List<Map<String,Object>> lists = getDataFromFile("d:/1350625508821(1).txt");
//System.out.println("lists==========>"+lists);         
        comments.setDatas(lists);
        comments.setRowcount(lists.size());
//System.out.println("comments=========>"+comments);		
		this.mergePagedDataModel(comments, pagedFliper);

		return "";
	}

	/**
	 * 从指定文件中读取数据，然后填充到集合中
	 * 
	 */
	public List<Map<String,Object>> getDataFromFile(String filepath){
		File file = new File(filepath);
		FileInputStream fis = null;
		BufferedReader br = null;
		try {
			fis = new FileInputStream(file);
			br = new BufferedReader(new InputStreamReader(fis));
			String readLine = br.readLine();
			int line = 0;//读取的行号
			List<String> loginlist = new ArrayList<String>();//登录集合
			List<Double> paylist = new ArrayList<Double>();//支付集合
			List<Map<String,Object>> lists = new ArrayList<Map<String,Object>>();
			double total = 0D;
			while(readLine != null){
				line ++;
System.out.println("readLine=============>"+readLine);				
				//开始解析数据
				String arr[] = readLine.split(",");
				loginlist.clear();//清空集合
				paylist.clear();
				Map<String,Object> map = new HashMap<String,Object>();
				for(String data:arr){
					if(data.indexOf("userid=")>-1){								
						map.put("userid",data.substring(data.indexOf("=")+1)==null?"":data.substring(data.indexOf("=")+1).trim());//取出用户id						
					}
					if(data.indexOf("login_")>-1){					
						loginlist.add("201"+data.substring(data.indexOf("_")+1).split("=")[0]);//将多个日期放到集合
					}
					if(data.indexOf("pay_")>-1){						
						paylist.add(new Double(data.substring(data.indexOf("_")).split("=")[1]));//将多个金额放到集合
					}
				}
				Collections.sort(loginlist);//将日期排序
System.out.println("collectionslist=======>"+loginlist);
                if(loginlist.size()>0)
                   map.put("platLastLogin", loginlist.get(loginlist.size()-1));//取出日期最大的
                
                for(Double pay:paylist){
                	total += pay;//求出总金额
                }
                map.put("totalAmt", total);
				//填充集合
                lists.add(map);
				//读取下一行的数据
				readLine = br.readLine();
			}
			return lists;
		} catch (FileNotFoundException e) {
			logger.info("文件找不到，文件路径为："+filepath+"，请查看是否正确。错误代码："+e.getMessage());
			throw new XLRuntimeException("文件找不到，文件路径为："+filepath+"，请查看是否正确");
		} catch (IOException e) {
			logger.info("文件格式不正确，文件路径为："+filepath+"。错误代码："+e.getMessage());
			throw new XLRuntimeException("文件格式不正确，文件路径为："+filepath);
		}finally{
			try{
				if(br != null){
					br.close();
					br = null;
				}
			}catch(Exception e){
				e.printStackTrace();
			}
			try{
				if(fis != null){
					fis.close();
					fis = null;
				}
			}catch(Exception e){
				e.printStackTrace();
			}
		}		
	}
	
	/**
	 * 大客户游戏详情查询
	 */
	public List<Map<String,Object>> getQueryGameDetailList(){
		detailLists.clear();
		pageDetailLists.clear();
		logger.info("开始大客户游戏详情查询");
		bindDatas();
		//Sheet<Map<String, Object>> comments = new Sheet<Map<String, Object>>();		
	
//		 //满足分页功能
//        PagedFliper pagedFliper = this.getFliper();
//        rownum = 1;
//        int pageNo = pagedFliper.getPageNo();
//        int pageSize = pagedFliper.getPageSize();
//        int size = detailLists.size();
//        if(size<=pageSize){
//        	comments.setDatas(pageDetailLists);
//    		comments.setRowcount(detailLists.size());
//        }else{
//        	if(size%pageSize==0){//如果是整页数
//        		for(int i=(pageNo-1)*pageSize;i<pageNo*pageSize;i++){
//        			pageDetailLists.add(detailLists.get(i));
//        		}
//        	}else{
//        		int totalPage = size/pageSize+1;//总页数
//        		if(pageNo == totalPage){
//        			for(int i=(pageNo-1)*pageSize;i<((pageNo-1)*pageSize+size%pageSize);i++){
//            			pageDetailLists.add(detailLists.get(i));
//            		}
//        		}else{
//        			for(int i=(pageNo-1)*pageSize;i<pageNo*pageSize;i++){
//            			pageDetailLists.add(detailLists.get(i));
//            		}
//        		}
//        	}
//        	comments.setDatas(pageDetailLists);
//    		comments.setRowcount(detailLists.size());
//        }
		//comments.setDatas(detailLists);
		//comments.setRowcount(detailLists.size());
		 //满足分页功能
//        PagedFliper pagedFliper = this.getFliper();
//        rownum = 1;
//System.out.println("pageNo===============>"+pagedFliper.getPageNo());
//        pagedFliper.setPageSize(100);
//		this.mergePagedDataModel(comments, pagedFliper);
		return detailLists;
	}
	
	/**
	 * 此方法调用接口，解析数据，并且封装到集合中
	 * @return
	 */
	public void bindDatas(){
		String bigCustomerInterface=IFacadeCommon.INSTANCE.getLibconfigValueByConfigNo("bigCustomerInterface");	
        String uid = findParameter("uid");
        String suid = findParameter("suid");
        suid = suid == null?"":suid.trim();
        uid = uid == null?"":uid.trim();
        if("".equals(uid)){
        	uid = suid;
        }
		//String cmd = "http://192.168.109.240:8001/getBigRdata?userid=69551120";
        logger.info("bigCustomerInterface====================>"+bigCustomerInterface+"?userid="+uid);
		String jsonStr = getInfoForHttpGetMothed(bigCustomerInterface+"?userid="+uid);
		if(jsonStr == null){
			return;
		}
		ObjectMapper mapper = new ObjectMapper();
		try {
			JsonRecord record = mapper.readValue(jsonStr, JsonRecord.class);
			
			//绑定游戏详情数据
			List<Record> recordList = record.getList();
			logger.info("recordList========>"+recordList);	
            long paycount = 0;
			for(Record detail:recordList){
				Map<String,Object> dmap = new HashMap<String,Object>();
				dmap.put("gameName", URLDecoder.decode(detail.getGameName(),"utf8"));//玩过的游戏
				dmap.put("serverId", detail.getServerId());//玩过的服区
				dmap.put("payAmt", detail.getPayAmt());//充值金额
				dmap.put("payTimes", detail.getPayTimes());//充值次数
				paycount += detail.getPayTimes();
				dmap.put("lastLogin", formatDay(detail.getLastLoginTime()));//上次登录时间
				detailLists.add(dmap);
			}
			setRequestAttribute("paycount", paycount);
		} catch (JsonParseException e) {
			e.printStackTrace();
		} catch (JsonMappingException e) {
			e.printStackTrace();
		} catch (IOException e) {
			e.printStackTrace();
		}
	}
	
	/**
	 * 格式化日期
	 * @param day
	 * @return
	 */
	public String formatDay(String lastlogin){
		if(lastlogin==null||"".equals(lastlogin.trim()))return "无登录记录";	
		if(lastlogin.length()<8&&lastlogin.length()>3){			
			return "无登录记录";
		}
		String year = lastlogin.substring(0, 4);		
  		String tmp = lastlogin.substring(4, 8);		
        String month = tmp.substring(0,2);
        String day = tmp.substring(2);
        return year+"-"+month+"-"+day;
	}
   
	/**
	 * 通过get方式调用接口
	 * @param url
	 * @return
	 */
	public  String getInfoForHttpGetMothed(String url) {
		try {
			logger.info(" Get/URL :" + url);
			HttpGet httpget = new HttpGet(url);
			HttpClient client = new DefaultHttpClient();
			String backStr = "";
			ResponseHandler<String> responseHandler = new BasicResponseHandler();
			backStr = client.execute(httpget, responseHandler);
			return backStr;
		} catch (Exception e) {
			e.printStackTrace();
		}
		return "";
	}	
}
