package com.xunlei.niux.manager.web.model;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.math.BigDecimal;
import java.net.HttpURLConnection;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLDecoder;
import java.text.DecimalFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.faces.context.FacesContext;
import javax.faces.model.SelectItem;
import javax.servlet.http.HttpServletResponse;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.impl.client.DefaultHttpClient;
import org.apache.http.util.EntityUtils;
import org.apache.poi.ss.usermodel.Workbook;
import com.ferret.common.dao.enums.OrderType;
import com.ferret.common.dao.vo.Page;
import com.xunlei.common.util.FunRef;
import com.xunlei.common.util.PagedFliper;
import com.xunlei.common.util.Sheet;
import com.xunlei.common.util.XLRuntimeException;
import com.xunlei.niux.data.vipgame.bo.BigCustomerDetailBo;
import com.xunlei.niux.data.vipgame.facade.FacadeFactory;
import com.xunlei.niux.data.vipgame.vo.BigCustomerDetail;
import com.xunlei.niux.data.vipgame.vo.BigCustomerQuery;
import com.xunlei.niux.data.vipgame.vo.ChargeAmountProfileSettings;
import com.xunlei.niux.data.vipgame.vo.InterfaceMan;
import com.xunlei.niux.data.vipgame.vo.SendMailRecord;
import com.xunlei.niux.manager.web.util.ExcelUtil;
import com.xunlei.niux.manager.web.util.NiUxFunctionConstant;
import com.xunlei.proxy.ProxyFactory;
import com.xunlei.proxy.socket.UserInfoProxy;
import com.xunlei.proxy.socket.bin.resp.Resp_getuserinfo_base;
import com.xunlei.proxy.socket.bin.resp.Resp_getuserinfo_sec;
import com.xunlei.proxy.socket.bin.resp.Resp_name2id;


@FunRef(NiUxFunctionConstant.NIUX_FUNCTION_BIGCUSTOMERDETAIL)
public class BigCustomerDetailManagedBean extends BaseManagedBean {
	private int rownum = 0;
	private BigCustomerDetailBo bigCustomerDetailBo;
	private final String SPEEDPATH = "/tmp/bigcustomerdetail/";
	private static DecimalFormat  myformat = new DecimalFormat();
	static{
		myformat.applyPattern("##,###.00");
	}
	
	public BigCustomerDetailManagedBean(){
		bigCustomerDetailBo = FacadeFactory.INSTANCE.getBigCustomerDetailBo();
		//初始化行号
		int pageNo=this.getFliper().getPageNo();
		int pageSize=this.getFliper().getPageSize();
		rownum=rownum+(pageNo-1)*pageSize+1;
	}
	
	public int getRownum() {
		return rownum++;
	}

	public void setRownum(int rownum) {
		this.rownum = rownum;
	}
	
	 public List<SelectItem> getAmountProfileList() {
	        List<SelectItem> tempList = new ArrayList<SelectItem>();
	        SelectItem sm = new SelectItem();
	        sm.setLabel("全部");
	        sm.setValue(800);
	        tempList.add(sm);
	        tempList.addAll(getAddFlatnoList());
	        return tempList;
	 }
	 
	 public List<SelectItem> getAddFlatnoList() {
	        List<ChargeAmountProfileSettings> list = FacadeFactory.INSTANCE.getChargeAmountProfileSettingsBo().findChargeAmountProfileSettingsList();
	        List<SelectItem> tempList = new ArrayList<SelectItem>();
	        for (ChargeAmountProfileSettings flat : list) {
	            SelectItem si = new SelectItem();
	            si.setValue(flat.getAmount());
	            si.setLabel(flat.getAmount()+"");
	            tempList.add(si);
	        }
	        return tempList;
	    }
	
	 /**
	  * 如果大客户数据有问题，手动一键重新执行。邮件提醒功能除外。
	  */
	 public void onekey(){
		 make();//生成大客户统计数据
		 replay();//生成大客户详情数据
		 speed();//加速
		 modify();//更新差异数
		 getphone();//更新电话号码
		 
	 }
	 
	/**
	 * 重新执行手动执行定时任务，新增大客户详情数据
	 */
	public void replay(){
		try{
			String time = findParameter("beginday");
	        logger.info("time==================>"+time);		
			if(time == null||"".equals(time)){
				throw new XLRuntimeException("请传到参数time");
			}
			replay(time);
		}catch(Exception e){
			mergeJsmessage("执行统计的任务执行失败，原因：" + e.getMessage());
		}

	}
	
	/**
	 * 重新执行手动执行定时任务，更新数据
	 */
	public void modify(){
		try{
			String time = findParameter("beginday");
	        logger.info("time==================>"+time);		
			if(time == null||"".equals(time)){
				throw new XLRuntimeException("请传到参数time");
			}
			//time = formatBeforeDay(time);
			execute(time);
		}catch(Exception e){
			mergeJsmessage("更新差异数的任务执行失败，原因：" + e.getMessage());
		}

	}
	
	/**
	 * 游戏详情查询效率提速
	 */
	public void speed(){
		try{
			String time = findParameter("daytime");
			String beginday = findParameter("beginday");
			if(beginday != null && !"".equals(beginday)){//如果大客户管理界面中有输入日期
				time = beginday;
				time = formatBeforeDay(time);//取得当前日期的前一天
			}
			if(time==null||"".equals(time)){
				time = now();
			}
	        logger.info("time==================>"+time);		
			if(time == null||"".equals(time)){
				throw new XLRuntimeException("请传到参数time");
			}
			String baseUrl = getUrl();		
			String filepath = getFilesPath(time);	
			String path = SPEEDPATH;
			String dirtime = formatDay2(time);
			if(!checkFile(path+dirtime)){
				if(filepath.indexOf(",")>-1){//如果有多个文件
					for(String subFilePath:filepath.split(",")){
						downLoad(baseUrl, subFilePath, time, path);
					}
				}else{//如果只有一个文件
					downLoad(baseUrl, filepath, time, path);
				}
				alertJS("游戏详情查询加速成功");
			}else{
				alertJS("游戏详情查询已经加速");
			}
	
		}catch(Exception e){
			alertJS("游戏详情查询加速失败，原因：" + e.getMessage());
		}
	}
	
	/**
	 * 判断目录下是否有文体存在
	 * @param time
	 * @return
	 */
	public boolean checkFile(String path){
		File file = null;
		try{
			file = new File(path);
            long len = 0L;
			if(file.exists()){
            	File [] files = file.listFiles();
            	if(files != null && files.length > 0)
	            	for(File child:files){
	            		len += child.length();
	            	}
            }else{
            	file.mkdir();
            }
			len = len/(1024*1024);
		    if(len <= 3){
		    	File [] files = file.listFiles();
		    	if(files != null && files.length > 0)
			    	for(File child:files){
	            		child.delete();
	            	}
		    	return false;
		    }
		}catch(Exception e){
			e.printStackTrace();
		}
		return true;
	}
	
	public String formatDay2(String time){
		if(time != null){
			String stimes[] = time.split("-");
			time = stimes[0]+stimes[1]+stimes[2];
		}	
		return time;
	}
	
	
	/**
	 * 显示充值统计
	 */
	public Map getTotal(){
		Map map = (Map)getRequestAttribute("paytotal");
		String sflag = findParameter("flag");
		int flag = 0;
		if(sflag != null && !"".equals(sflag))flag = Integer.parseInt(sflag);
		else
			flag = 0;
		if(map == null){
			try{
				String time = findParameter("time");
				String stime = findParameter("stime");

				String now = now();
				now = now.split(" ")[0];
				if(time == null||"".equals(time)){
					if(stime == null ||"".equals(stime)){
						time = now;//默认按当前日期的前一天
						time = formatBeforeDay(time);
					}else{
						time = stime;
					}
					
				}
				if(flag==1){//如果是账户信息那边使用
					time = formatBeforeDay(time);
				}
				String uid = findParameter("uid");	
				String suid = findParameter("suid");
				if(uid == null||"".equals(uid))uid = suid;
		        logger.info("time================>"+time);
				if(time == null||"".equals(time)){
					throw new XLRuntimeException("请传到参数time");
				}
				if(uid == null||"".equals(uid)){
					logger.info("uid为空");
					throw new XLRuntimeException("uid为空");
				}
				String baseUrl = getUrl();		
				logger.info("baseUrl======================>"+baseUrl);	
				String filepath = getFilesPath(time);
				logger.info("filepath======================>"+filepath);	
				if(filepath.indexOf(",")>-1){//如果有多个文件
					for(String subFilePath:filepath.split(",")){
						map = getPayDetail(baseUrl,subFilePath,time,uid);
						if(map == null)continue;
						if(map.size()>1){
							break;
						}
					}
				}else{//如果只有一个文件
					map = getPayDetail(baseUrl,filepath,time,uid);
				}
				setRequestAttribute("paytotal", map);
			}catch(Exception e){
				mergeJsmessage("更新差异数的任务执行失败，原因：" + e.getMessage());
			}
		 }	
          return map;
	}
	
	/**
	 * 重新执行手动执行定时任务，更新数据
	 */
	public void getphone(){
		try{
			String time = findParameter("beginday");
	        logger.info("time==================>"+time);
	        if(time == null||"".equals(time)){//如果参数为空则传当前日期				
				time = now();
			}
			if(time == null||"".equals(time)){
				throw new XLRuntimeException("请传到参数time");
			}
			
			time = formatBeforeDay(time);
			updatePhone(time);
		}catch(Exception e){
			mergeJsmessage("获得电话的任务执行失败，原因：" + e.getMessage());
		}

	}
	
	/**
	 * 调用远程接口生成大客户统计数据
	 */
	public void run(){
		String time = findParameter("beginday");      	
		if(time == null||"".equals(time)){
			throw new XLRuntimeException("请传到参数time");
		}
		time = formatBeforeDay(time);
		String sub[] = time.split("-");
		time = sub[0] + sub[1] + sub[2];
		logger.info("time==================>"+time);	
		String url = "http://twin13024.sandai.net:8001/scanPlatNewForBigR?date="+time;
		String message = null;
		int flag = 0;
	    try{
	    	String responseString =  getHtml(url);	    	
	    	if(responseString != null && !"".equals(responseString)){
	    		String str[] = responseString.split("&");
	    		String status = str[0].split("=")[1];
	    		message = str[1].split("=")[1];
	    		flag = Integer.parseInt(status);
	    		if(flag != 1){
	    			throw new XLRuntimeException(URLDecoder.decode(message,"utf8"));
	    		}
	    	}
	    }catch(Exception e){
	    	mergeJsmessage("大客户统计的任务执行失败，原因：" + e.getMessage());
	    }
	}
	
	/**
	 * 删除大客户统计数据
	 * @param time
	 */
	public void delBigCustomerQuery(String time){
		String sql = "delete from bigcustomerquery where daytime='"+time+"'";
		List<String> paramList = new ArrayList<String>();		
		FacadeFactory.INSTANCE.getBigCustomerQueryBo().execute(sql, paramList);
	}
	
	/**
	 * 生成大客户统计数据
	 */
	public  void make(){
		String time = findParameter("beginday");
		SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd");
		if(time == null||"".equals(time))
		    time = sdf.format(new Date());
		time = formatBeforeDay(time);//取得输入日期的前一天
		String sub[] = time.split("-");
		time = sub[0] + sub[1] + sub[2];
		logger.info("time==================>"+time);	
		
		//清空指定日期的大客户统计数据
		logger.info("开始清空"+time+"日大客户统计数据");
		delBigCustomerQuery(time);
		logger.info("大客户统计数据清空完毕");
		
		String url = "http://twin13024.sandai.net:8001/scanPlatNewForBigR?date="+time;
		String message = null;
		int flag = 0;
		 try{
		    	String responseString =  getHtml(url);	    	
		    	if(responseString != null && !"".equals(responseString)){
		    		String str[] = responseString.split("&");
		    		String status = str[0].split("=")[1];
		    		message = str[1].split("=")[1];
		    		flag = Integer.parseInt(status);
		    		if(flag != 1){
		    			throw new XLRuntimeException(URLDecoder.decode(message,"utf8"));
		    		}
		    	}
		    }catch(Exception e){
		    	logger.info("大客户统计的任务执行失败，原因：" + e.getMessage());
		    }
	}
	
	/**
	 * 大客户详情查询
	 */
	 public String getQueryBigCustomerDetailList(){		
	    logger.info("开始大客户详情查询");
        this.authenticateRun();//验证运行权限
        String daytime = findParameter("daytime");
        String isnew = findParameter("isnew");
        BigCustomerDetail detail = findBean(BigCustomerDetail.class, "bigcustomerdetail");
        detail.setDaytime(daytime);
        if("1".equals(isnew)){
        	detail.setAddtime(daytime);
        }
        PagedFliper pagedFliper = this.getFliper();
        int count = bigCustomerDetailBo.count(detail);
        pagedFliper.setRecordCount(count);
        List<BigCustomerDetail> list = new ArrayList<BigCustomerDetail>();
        if (count > 0) {
        	rownum = 1;
        	Page page=new Page();
        	page.setPageNo(pagedFliper.getPageNo());
        	page.setPageSize(pagedFliper.getPageSize());
        	page.addOrder("daytime", OrderType.DESC);
        	if(pagedFliper.isNotEmptySortColumn()){
        		String str[] = pagedFliper.getSortColumn().split(" ");
        		page.addOrder(str[0].trim(), str[1].trim().equals("asc")?OrderType.ESC:OrderType.DESC);
        	}
            list = bigCustomerDetailBo.find(detail,page);
        }
        Sheet<BigCustomerDetail> sheet = new Sheet<BigCustomerDetail>(count, list);
        for(BigCustomerDetail bcd:sheet.getDatas()){
        	bcd.setTotalAmt(myformat.format(new Double(bcd.getTotalAmt())));
        	bcd.setPlatLastLogin((bcd.getPlatLastLogin()==null||"".equals(bcd.getPlatLastLogin()))?"无登录记录":bcd.getPlatLastLogin());
        }
        this.mergePagedDataModel(sheet, pagedFliper);
        return "";
	 }
	 
	 

		/**
		 * 按照日期读出统计前一天的数据
		 * @return
		 */
		public String getFilesPath(String nowtime){			
			BigCustomerQuery query = new BigCustomerQuery();
			logger.info("nowtime=====================>"+nowtime);		
			String strs[] = nowtime.split("-");
			query.setDaytime(strs[0]+strs[1]+strs[2]);
			List<BigCustomerQuery> lists = FacadeFactory.INSTANCE.getBigCustomerQueryBo().find(query, 1, 1);		
			if(lists == null||lists.size()==0){
				logger.info("大客户表中数据有问题,日期不对,日期为："+nowtime);
				throw new XLRuntimeException("大客户表中数据有问题,日期不对,日期为："+nowtime);
			}
			if(lists.size() > 1){
				logger.info("大客户表中数据有问题,记录有重复,日期为："+nowtime);
				throw new XLRuntimeException("大客户表中数据有问题,记录有重复,日期为："+nowtime);
			}
			String filepath = ((BigCustomerQuery)lists.get(0)).getFileurl();
			if(filepath==null||"".equals(filepath)){
				logger.info("大客户表中数据有问题,路径为空。日期为："+nowtime);
				throw new XLRuntimeException("大客户表中数据有问题,路径为空。日期为："+nowtime);
			}		
			//String arrs[] = filepath.split("/");
			//if(arrs==null||arrs.length<6)return null;
			//return "/"+arrs[1]+"/"+arrs[2]+"/"+arrs[3]+"/"+arrs[4]+"/"+arrs[5]+"/"+arrs[6];
			return filepath;
			
		}
		
		public void execBigCustomerDetail(String beforetime) {	
			String baseUrl = getUrl();		
			logger.info("baseUrl======================>"+baseUrl);	
			String filepath = getFilesPath(beforetime);
			logger.info("filepath======================>"+filepath);		
			if(filepath.indexOf(",")>-1){//如果有多个文件
				for(String subFilePath:filepath.split(",")){
				   initData(baseUrl,subFilePath,beforetime);
					//updateLastLoginTimeData(baseUrl,subFilePath,beforetime);
				}
			}else{//如果只有一个文件
				initData(baseUrl,filepath,beforetime);
				//updateLastLoginTimeData(baseUrl,filepath,beforetime);
			}
		
		}
		
		public static String getHtml(String url) throws Exception {
			HttpGet httpGet = new HttpGet(url);
			HttpResponse response;
			String responseString = "";
			HttpEntity entity = null;
			try {
				DefaultHttpClient httpClient = new DefaultHttpClient();
				response = httpClient.execute(httpGet);
				entity = response.getEntity(); // 返回服务器响应
				// 这样获取返回的html就不需要象以前的打印流了
				responseString = EntityUtils.toString(response.getEntity()); //返回服务器响应HTML代码
			} catch (Exception e) {
				e.printStackTrace();
			} finally {
				if (entity != null) {
					entity.consumeContent(); // 释放连接
				}
			}
			return responseString;
		}
		

		/**
		 * 调用远程接口查询出安全手机号
		 * @param account
		 * @return
		 */
		public String getPhone(UserInfoProxy userInfoProxy,String account){	
			Resp_getuserinfo_sec userinfosec=userInfoProxy.getuserinfo_sec(account, (byte)2);
			if(userinfosec==null)return "";
			return userinfosec.getMobile()==0?"":userinfosec.getMobile()+"";
		}
		
		/**
		 * 查询用户信息
		 * @param userInfoProxy
		 * @param account
		 * @return
		 */
		public Resp_getuserinfo_sec getUserInfo(UserInfoProxy userInfoProxy,String uid){
		   return userInfoProxy.getuserinfo_sec(uid, (byte) 2);	
		}
		
		/**
		 * 调用远程接口根据账户查询出uid
		 * @param userInfoProxy
		 * @param account
		 * @return
		 */
		public long getRealUid(UserInfoProxy userInfoProxy,String account){
			logger.info("调用远程接口根据账户查询出uid.account="+account);
			Resp_name2id resp_name2id = userInfoProxy.name2id(account, (byte) -1);
			if(resp_name2id==null)return 0;
			return resp_name2id.getUserno();
		}
		
		/**
		 * 取时间格式为：yyyyMMdd 日期的前一天 
		 * @param daytime
		 * @return
		 */
		public String formatDay(String daytime){
			daytime = formatTime(daytime);
			if(daytime==null||"".equals(daytime))return null;
			Calendar cal = Calendar.getInstance();
			SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd");
			Date date = null;
			try {
				date = sdf.parse(daytime);
			} catch (ParseException e) {
				e.printStackTrace();
			}
			cal.setTime(date);
			cal.add(Calendar.DAY_OF_MONTH, -1);	
			String now = sdf.format(cal.getTime());
			logger.info("now================>"+now);		
			now = now.replaceAll("-", "");
			return now;
		}
		
		/**
		 * 取时间格式为：yyyy-MM-dd 日期的前一天 
		 * @param daytime
		 * @return
		 */
		public static String formatBeforeDay(String daytime){
			if(daytime==null||"".equals(daytime))return null;
			Calendar cal = Calendar.getInstance();
			SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd");
			Date date = null;
			try {
				date = sdf.parse(daytime);
			} catch (ParseException e) {
				e.printStackTrace();
			}
			cal.setTime(date);
			cal.add(Calendar.DAY_OF_MONTH, -1);	
			String now = sdf.format(cal.getTime());
			logger.info("now================>"+now);		
			return now;
		}
		
		/**
		 * 取时间格式为：yyyy-MM-dd 日期的后一天 
		 * @param daytime
		 * @return
		 */
		public static String formatAfterDay(String daytime){
			if(daytime==null||"".equals(daytime))return null;
			Calendar cal = Calendar.getInstance();
			SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd");
			Date date = null;
			try {
				date = sdf.parse(daytime);
			} catch (ParseException e) {
				e.printStackTrace();
			}
			cal.setTime(date);
			cal.add(Calendar.DAY_OF_MONTH, 1);	
			String now = sdf.format(cal.getTime());
			logger.info("now================>"+now);		
			return now;
		}
		
		
		/**
		 * 通过http的形式访问远程文件，并且读取文件中的数据，保存到数据库
		 * @param path
		 * @return
		 */
		public void initData(String baseUrl,String filepath,String beforetime){
			URL url = null;
			UserInfoProxy userInfoProxy = null;
			List params = new ArrayList();
			try {
				userInfoProxy = ProxyFactory.getInstance().getUserInfoProxy();
				url = new URL(baseUrl+filepath);
	logger.info("url========================>"+url);			
			} catch (MalformedURLException e) {
				logger.info("文件找不到，文件路径为："+baseUrl+filepath+"，请查看是否正确。错误代码："+e.getMessage());
				throw new XLRuntimeException("文件找不到，文件路径为："+baseUrl+filepath+"，请查看是否正确");
			} 
			HttpURLConnection httpUrl = null;
			BufferedReader br = null;
			//连接指定的网络资源 
			try {
				httpUrl = (HttpURLConnection) url.openConnection(); 
				httpUrl.connect();
				//获取网络输入流 
				br = new BufferedReader(new InputStreamReader((httpUrl.getInputStream()))); 
				
				/**-----------
				 * 开始解析数据
				 * -----------
				 */
	logger.info("========开始解析数据==========");			
				String readLine = br.readLine();
				int line = 0;//读取的行号
				List<String> loginlist = new ArrayList<String>();//登录集合
				List<Double> paylist = new ArrayList<Double>();//支付集合
				
				String before2day = formatBeforeDay(beforetime);
				String beforesql = "select * from bigcustomerdetail where daytime='"+before2day+"' ";
				List beforeDetails = FacadeFactory.INSTANCE.getBigCustomerDetailBo().findBySql(BigCustomerDetail.class, beforesql, params);	
				while(readLine != null){
					double total = 0D;
					line ++;
					logger.info("line=============>"+line);				
					//开始解析数据
					String arr[] = readLine.split(",");
					loginlist.clear();//清空集合
					paylist.clear();
					BigCustomerDetail detail = new BigCustomerDetail();
					for(String data:arr){
						if(data.indexOf("pay_")>-1){	
							String payday = data.substring(data.indexOf("_")+1).split("=")[0];//支付时间
							payday = getFormatYear(payday);
							if(compareDay(beforetime, payday)>=0)
						      paylist.add(new Double(data.substring(data.indexOf("_")).split("=")[1]));//将多个金额放到集合
						}
						if(data.indexOf("userid=")>-1){													
							detail.setUid(data.substring(data.indexOf("=")+1)==null?"":data.substring(data.indexOf("=")+1).trim());
						}
						if(data.indexOf("login_")>-1){	
							String loginday = data.substring(data.indexOf("_")+1).split("=")[0];
							String maxday = getFormatYear(loginday);
							if(compareDay(beforetime, maxday)>=0)
							   loginlist.add(loginday);//将多个日期放到集合						
						}
						
					}
					Collections.sort(loginlist);//将日期排序
	                if(loginlist.size()>0){
	                	String maxday = loginlist.get(loginlist.size()-1);
//	                	String year = maxday.substring(0, 1);		
//	              		String tmp = maxday.substring(1, 5);		
//	                    String month = tmp.substring(0,2);
//	                    String day = tmp.substring(2); 
////	                	if("1".equals(year)){
////	                		year = "2011";
////	                	}else if("2".equals(year)){
////	                		year = "2012";
////	                	}else if("3".equals(year)){
////	                		year = "2013";
////	                	}else if("4".equals(year)){
////	                		year = "2014";
////	                	}
//	                    year = getFormatYear(year);
//	                	maxday = year+"-"+month+"-"+day;
	                	maxday = getFormatYear(maxday);
	                	detail.setPlatLastLogin(maxday);//取出日期最大的
	                }  
	                for(Double pay:paylist){
	                	total += pay;//求出总金额
	                }
	                detail.setTotalAmt(total+"");
	                detail.setDaytime(beforetime);
	                detail.setCallTotal(FacadeFactory.INSTANCE.getBigCustomerDetailBo().getCallRecordCount(detail.getUid(),beforetime));	                
	                detail.setPhone(getPhone(userInfoProxy,detail.getUid()));		
//	                if(beforeDetails != null && beforeDetails.size()>0){
//	                	flag = false;//假设没找到
//		                for(Object beforeobj:beforeDetails){
//		                	BigCustomerDetail beforeDetail = (BigCustomerDetail)beforeobj;
//		                	if(detail.getUid().equals(beforeDetail.getUid())){//如果从昨天的数据中找到了同一个id的数据
//		                		flag = true;//设置状态为找到了
//		                		beforeTotal = beforeDetail.getTotalAmt();//取出昨天的金额
//		                	}		                	
//		                }
//		                
//		                if(flag){//如果昨天有这个id的记录，则需要算出今天的差异数
//		                	detail.setModifyAmt((Double.valueOf(total)-Double.valueOf(beforeTotal))+"");
//		                }else{//如果昨天没有这个id的记录，则需要更新添加时间
//		                	detail.setAddtime(beforetime);
//		                }  
//	                }               
	                //插入到数据库中               
	                FacadeFactory.INSTANCE.getBigCustomerDetailBo().insert(detail);
	                
					//读取下一行的数据
					readLine = br.readLine();
				}											
				//清空集合
				 beforeDetails.clear();
				 beforeDetails = null;
			} catch (IOException e) {
				logger.info(e.getMessage());
				e.printStackTrace();
			}finally{
				try{
					if(br != null){
						br.close();
						br =  null;
					}
					if(httpUrl != null){
						httpUrl.disconnect();
						httpUrl = null;
					}
				}catch(Exception e){
					logger.info(e.getMessage());
					e.printStackTrace();
				}
			}
		}
		

		/**
		 * 通过http的形式访问远程文件，并且读取文件中的数据，保存到数据库
		 * @param path
		 * @return
		 */
		public void updateLastLoginTimeData(String baseUrl,String filepath,String beforetime){
			URL url = null;
			List params = new ArrayList();
			try {
				url = new URL(baseUrl+filepath);		
			} catch (MalformedURLException e) {
				logger.info("文件找不到，文件路径为："+baseUrl+filepath+"，请查看是否正确。错误代码："+e.getMessage());
				throw new XLRuntimeException("文件找不到，文件路径为："+baseUrl+filepath+"，请查看是否正确");
			} 
			HttpURLConnection httpUrl = null;
			BufferedReader br = null;
			//连接指定的网络资源 
			try {
				httpUrl = (HttpURLConnection) url.openConnection(); 
				httpUrl.connect();
				//获取网络输入流 
				br = new BufferedReader(new InputStreamReader((httpUrl.getInputStream()))); 
				
				/**-----------
				 * 开始解析数据
				 * -----------
				 */
	logger.info("========开始解析数据==========");			
				String readLine = br.readLine();
				int line = 0;//读取的行号
				
				String beforesql = "select * from bigcustomerdetail where daytime='"+beforetime+"' ";
				List<BigCustomerDetail> beforeDetails = FacadeFactory.INSTANCE.getBigCustomerDetailBo().findBySql(BigCustomerDetail.class, beforesql, params);	
				while(readLine != null){
					double total = 0D;
					String lastLoginDay = null;
					line ++;
					logger.info("line=============>"+line);				
					//开始解析数据
					String arr[] = readLine.split(",");
					BigCustomerDetail detail = new BigCustomerDetail();
					for(String data:arr){
						if(data.indexOf("pay_")>-1){	
							String payday = data.substring(data.indexOf("_")+1).split("=")[0];//支付时间
							payday = getFormatYear(payday);
							if(compareDay(beforetime, payday)==0)
								total+=new Double(data.substring(data.indexOf("_")).split("=")[1]);//将多个金额放到集合
						}
						if(data.indexOf("userid=")>-1){													
							detail.setUid(data.substring(data.indexOf("=")+1)==null?"":data.substring(data.indexOf("=")+1).trim());
						}
						if(data.indexOf("login_")>-1){	
							String loginday = data.substring(data.indexOf("_")+1).split("=")[0];
							String maxday = getFormatYear(loginday);
							if(compareDay(beforetime, maxday)==0)
								lastLoginDay = beforetime;			
						}						
					}
					for(BigCustomerDetail mydetail:beforeDetails){
						if(detail.getUid().trim().equals(mydetail.getUid())){
							if(total >0)
							    mydetail.setTotalAmt((new Double(mydetail.getTotalAmt())+total)+"");	   
							if(lastLoginDay != null&& !"".equals(lastLoginDay))mydetail.setPlatLastLogin(lastLoginDay);
			                //插入到数据库中               
			                FacadeFactory.INSTANCE.getBigCustomerDetailBo().update(mydetail);
						}
					}
						                
					//读取下一行的数据
					readLine = br.readLine();
				}											
				//清空集合
				 beforeDetails.clear();
				 beforeDetails = null;
			} catch (IOException e) {
				logger.info(e.getMessage());
				e.printStackTrace();
			}finally{
				try{
					if(br != null){
						br.close();
						br =  null;
					}
					if(httpUrl != null){
						httpUrl.disconnect();
						httpUrl = null;
					}
				}catch(Exception e){
					logger.info(e.getMessage());
					e.printStackTrace();
				}
			}
		}
		
		
		public String getFormatYear(String maxday){
			String year = maxday.substring(0, 1);		
      		String tmp = maxday.substring(1, 5);		
            String month = tmp.substring(0,2);
            String day = tmp.substring(2); 

			if("1".equals(year)){
        		year = "2011";
        	}else if("2".equals(year)){
        		year = "2012";
        	}else if("3".equals(year)){
        		year = "2013";
        	}else if("4".equals(year)){
        		year = "2014";
        	}else if("5".equals(year)){
        		year = "2015";
        	}else if("6".equals(year)){
        		year = "2016";
        	}else if("7".equals(year)){
        		year = "2017";
        	}else if("8".equals(year)){
        		year = "2018";
        	}else if("9".equals(year)){
        		year = "2019";
        	}
			maxday = year+"-"+month+"-"+day;
			return maxday;
		}
		
		
		/**
		 * 查询指定用户的账户情况
		 * @param baseUrl
		 * @param filepath
		 * @param beforetime
		 * @param uid
		 * @return
		 */
		public Map getPayDetail(String baseUrl,String filepath,String beforetime,String uid){
			URL url = null;
			UserInfoProxy userInfoProxy = null;
			Map map = new HashMap();
			HttpURLConnection httpUrl = null;
			BufferedReader br = null;			
			List<String> loginlist = new ArrayList<String>();//登录集合
			List<Double> paylist = new ArrayList<Double>();//充值集合
            List<String> payTimeList = new ArrayList<String>();//充值时间集合
            String rightData = null;
			userInfoProxy = ProxyFactory.getInstance().getUserInfoProxy();			
			String dirtime = formatDay2(beforetime);
				if(checkFile(SPEEDPATH+dirtime)){//如果文件在本地服务器中已存在，则优先读取本地
					
					try {
						filepath = filepath.substring(filepath.lastIndexOf("/"));
						br = new BufferedReader(new InputStreamReader(new FileInputStream(new File(SPEEDPATH+dirtime+"/"+filepath))));
					} catch (FileNotFoundException e) {
						e.printStackTrace();
					}
				}else{					
					try{
						url = new URL(baseUrl+filepath);
						httpUrl = (HttpURLConnection) url.openConnection(); 
						httpUrl.connect();

						//获取网络输入流 
						br = new BufferedReader(new InputStreamReader((httpUrl.getInputStream()))); 
						
					}catch(Exception e){
						e.printStackTrace();
					}
					
				}
				
				try{

					/**-----------
					 * 开始解析数据
					 * -----------
					 */
		            logger.info("========开始解析数据==========");			
					String readLine = br.readLine();
				
					while(readLine != null){						
						if(readLine.indexOf(uid)!=-1){
							rightData = readLine;
	                    	break;
						}					
						//读取下一行的数据
						readLine = br.readLine();
					}
		
                   logger.info("rightData:"+rightData);		
                    if(rightData==null)return null;
					double total = 0D;				
					//开始解析数据
					String arr[] = rightData.split(",");
					loginlist.clear();//清空集合
					paylist.clear();
					payTimeList.clear();
					BigCustomerDetail detail = new BigCustomerDetail();
					for(String data:arr){						
						if(data.indexOf("userid=")>-1){													
							detail.setUid(data.substring(data.indexOf("=")+1)==null?"":data.substring(data.indexOf("=")+1).trim());						
						}
						if(data.indexOf("login_")>-1){					
							loginlist.add(data.substring(data.indexOf("_")+1).split("=")[0]);//将多个日期放到集合						
						}
						if(data.indexOf("pay_")>-1){	
						    paylist.add(new Double(data.substring(data.indexOf("_")).split("=")[1]));//将多个金额放到集合
						    payTimeList.add(data.substring(data.indexOf("_")+1).split("=")[0]);//将多个充值时间放到集合
						}
					}				
				
					Collections.sort(loginlist);//将日期排序
					Collections.sort(payTimeList);//将充值日期排序
					long lastLoginDays = 0;
					String firstLoginTime = "";
	                if(loginlist.size()>0){
	                	String maxday = loginlist.get(loginlist.size()-1);
	                	String minday = loginlist.get(0);
	                	maxday = timeHandle(maxday);//最后登录时间
	                	firstLoginTime = timeHandle(minday);//首次登录时间
	                	lastLoginDays = compareTime(beforetime,maxday);//上次登录后经过的天数
	                	detail.setPlatLastLogin(maxday);//取出日期最大的
	                }    
	                long lastPayDays = 0;
	                String firstPayTime = "";
	                String lastPayTime = "";
	                if(payTimeList.size()>0){
	                	String maxday = payTimeList.get(payTimeList.size()-1);
	                	String minday = payTimeList.get(0);
	                	maxday = timeHandle(maxday);//最后充值时间
	                	lastPayTime= maxday;
	                	firstPayTime = timeHandle(minday);//首次充值时间
	                	lastPayDays = compareTime(beforetime,maxday);//上次充值后经过的天数
	                }
	                long paycount = 0;//充值总次数
	                for(Double pay:paylist){
	                	total += pay;//求出总金额
	                }
	                paycount = (Long)getRequestAttribute("paycount");
	                
	                double averagePayTotal = total/paycount;//平均充值
	                Resp_getuserinfo_base base = userInfoProxy.getuserinfo_base(uid, (byte)2);
	                map.put("uid", uid);//迅雷uid
					map.put("account", base.getUserAccount());//账号
					map.put("total", total);//充值总金额
					BigDecimal bg = new BigDecimal(averagePayTotal);        
					double j = bg.setScale(2, BigDecimal.ROUND_HALF_UP).doubleValue();
					map.put("averagePayTotal", j);//平均充值
					map.put("paycount", paycount);//充值次数
					map.put("lastPayDays", lastPayDays);//停充天数
					if(firstLoginTime==null||"".equals(firstLoginTime)){
						firstLoginTime = "无记录";
						detail.setPlatLastLogin("无记录");
						
					}
					map.put("firstLoginTime", firstLoginTime);//首次登录时间
					map.put("firstPayTime", firstPayTime);//首次充值时间
					map.put("lastLoginDays", lastLoginDays);//上次登录后经过的天数
					map.put("lastLoginTime", detail.getPlatLastLogin());//最后时间
					map.put("lastPayTime", lastPayTime);//最后充值时间
					
					loginlist.clear();
					loginlist = null;
					paylist.clear();
					paylist = null;
					payTimeList.clear();
					payTimeList = null;
				}catch(Exception e){
					e.printStackTrace();
				}finally{
					try{
						if(br != null){
							br.close();
							br = null;
						}
						if(httpUrl != null){
							httpUrl.disconnect();
							httpUrl = null;
						}
					}catch(Exception e){
						e.printStackTrace();
					}
				}
			return map;
		}
		
		/**
		 * 比较两个时间相隔多少天
		 *  
		 * @param fromtime 格式 yyyy-MM-dd
		 * @param totime   格式 yyyy-MM-dd
		 * @return
		 */
		public long compareTime(String fromtime,String totime){
			SimpleDateFormat df = new SimpleDateFormat("yyyy-MM-dd");  
            Date one = null;
            Date two = null;
            long days=0;  

            try{
            	one = df.parse(fromtime);  
            	two = df.parse(totime); 
            	long time1 = one.getTime();  
            	long time2 = two.getTime();  
            	long diff ;
            	if(time1<time2) {  
            		diff = time2 - time1;  
            	}else{
            		diff = time1 - time2;
            	}
            	days = diff / (1000 * 60 * 60 * 24);  

            }catch(ParseException  e){
            	e.printStackTrace();  

            }
			return days;
		}
		
		public long compareDay(String fromtime,String totime){
			SimpleDateFormat df = new SimpleDateFormat("yyyy-MM-dd");  
            Date one = null;
            Date two = null;
            try{
            	one = df.parse(fromtime);  
            	two = df.parse(totime); 	
            }catch(ParseException  e){
            	e.printStackTrace();  

            }
			return one.getTime()-two.getTime();
		}
		
		public String timeHandle(String time){
			String year = time.substring(0, 1);		
      		String tmp = time.substring(1, 5);		
            String month = tmp.substring(0,2);
            String day = tmp.substring(2); 
        	if("1".equals(year)){
        		year = "2011";
        	}else if("2".equals(year)){
        		year = "2012";
        	}else if("3".equals(year)){
        		year = "2013";
        	}else if("4".equals(year)){
        		year = "2014";
        	}else if("5".equals(year)){
        		year = "2015";
        	}else if("6".equals(year)){
        		year = "2016";
        	}else if("7".equals(year)){
        		year = "2017";
        	}else if("8".equals(year)){
        		year = "2018";
        	}else if("9".equals(year)){
        		year = "2019";
        	}
        	
        	time = year+"-"+month+"-"+day;
			return time;
		}
		
		public String formatTime(String daytime){
			String year = daytime.substring(0, 4);		
	  		String tmp = daytime.substring(4, 8);		
	        String month = tmp.substring(0,2);
	        String day = tmp.substring(2);
	        return year+"-"+month+"-"+day;
		}
		
		
		/**
		 * 重新执行指定日期的任务
		 * 手动执行
		 */
		public void replay(String time){
			//取指定日期的前一天
			time = formatBeforeDay(time);
			//清除以前执行的记录
			FacadeFactory.INSTANCE.getBigCustomerDetailBo().delete(time);
			//重新执行
			execBigCustomerDetail(time);
			
		}
		
	    /**
	     * 获得文件服务器地址
	     * @return
	     */
		public String getUrl(){
			//logger.info("开始获得url");
			//String bigCustomerRemoteUrl=IFacadeCommon.INSTANCE.getLibconfigValueByConfigNo("bigCustomerRemoteUrl");	
			String bigCustomerRemoteUrl= "http://twin13024.sandai.net:8080/hdfs-webdav";
			logger.info("url获得成功");
			return bigCustomerRemoteUrl;
		}
		
		
		/**
		 * 更新今日大客户详情中的 新增日期 和 差异数
		 */
		public void updateData(String time){
			try{
				//取指定日期的前一天
				String beforetime = formatBeforeDay(time);
				List params = new ArrayList();
				String todaysql = "select * from bigcustomerdetail where daytime='"+time+"' ";
				String beforesql = "select * from bigcustomerdetail where daytime='"+beforetime+"' ";
				logger.info("time=================>"+time);

				List todayDetails = FacadeFactory.INSTANCE.getBigCustomerDetailBo().findBySql(BigCustomerDetail.class, todaysql, params);	
				List beforeDetails = FacadeFactory.INSTANCE.getBigCustomerDetailBo().findBySql(BigCustomerDetail.class, beforesql, params);	

				if(todayDetails==null||todayDetails.size()<=0){
					throw new XLRuntimeException("==========更新'新增日期' 和 '差异数'时出错，昨天的大客户详情信息为空，请检查日期为："+time+"的大客户详情信息");
				}	
				if(beforeDetails==null||beforeDetails.size()<=0){
					throw new XLRuntimeException("==========更新'新增日期' 和 '差异数'时出错，前天的大客户详情信息为空，请检查日期为："+beforetime+"的大客户详情信息");
				}
				int line = 0;
				boolean flag = false;
				long []amounts  = getChargeAmountProfile();//获得金额档
				//List<SendMailRecord> sendMailDetails = new ArrayList<SendMailRecord>();
				String total = null;
				  for(Object todayobj:todayDetails){//拿出今天的记录，到昨天的记录中取找
					    line++;				    
					    BigCustomerDetail todayDetail = (BigCustomerDetail)todayobj;				    
                        flag = false;//假设没找到
		                for(Object beforeobj:beforeDetails){
		                	BigCustomerDetail beforeDetail = (BigCustomerDetail)beforeobj;
		                	if((todayDetail.getUid().trim()).equals(beforeDetail.getUid().trim())){//如果从昨天的数据中找到了同一个id的数据
		                		flag = true;//设置状态为找到了
		                		total = beforeDetail.getTotalAmt();//取出昨天的金额
		                	}		                	
		                }
		                
		                if(flag){//如果昨天有这个id的记录，则需要算出今天的差异数
		                	todayDetail.setModifyAmt((Double.valueOf(todayDetail.getTotalAmt())-Double.valueOf(total))+"");
		                	//如果满足金额档条件
		                	double bcamount = Double.parseDouble(todayDetail.getTotalAmt());		   		
		    		   		int index = 0;
		    		   		boolean status = false;//是否满足条件
		    		   		for(int i=amounts.length-1;i>=0;i--){//金额档从大到小比较，第一次发现金额满足某一档时，则记录该金额档，并且不用再继续比较了。		   			
		    		   			if(bcamount >= amounts[i]){	   				
		    		   				index = i;
		    		   				status = true;
		    		   				break;
		    		   			}
		    		   		}
		    		   		if(status&&!isExists(todayDetail.getUid(),amounts[index],time)){//如果这个档之前没有相关记录，则需要增加记录  		
//		    		   			todayDetail.setAddtime(time);
//		    		   			SendMailRecord smd = new SendMailRecord();
//		    	   				smd.setUid(todayDetail.getUid());
//		    	   				smd.setAmount(amounts[index]);
//		    	   				smd.setRealamount(Double.parseDouble(todayDetail.getTotalAmt()));
//		    	   				sendMailDetails.add(smd);
		    	   			}
		    		   		
		                }else{//如果昨天没有这个id的记录，则需要更新添加时间
		                	todayDetail.setAddtime(time);
		                }  
		                
		                FacadeFactory.INSTANCE.getBigCustomerDetailBo().update(todayDetail);//更新数据	                
				}
				  
				  
//				  for(SendMailRecord smd:sendMailDetails){			
//						//记录哪些用户，在哪些金额档发过邮件
//						smd.setTime(time);
//						FacadeFactory.INSTANCE.getSendMailRecordBo().insert(smd);
//					}
			  //清空集合
			  todayDetails.clear();
			  todayDetails = null;
			  beforeDetails.clear();
			  beforeDetails = null;
			}catch(Throwable e){
				logger.info(e.getMessage());
			}							
		}
		
		
		/**
		 * 更新今日大客户详情中的 新增日期 和 差异数
		 */
		public void updateData2(String time){
			try{
				//取指定日期的前一天
				String beforetime = formatBeforeDay(time);
				List params = new ArrayList();
				String todaysql = "select * from bigcustomerdetail where daytime='"+time+"' ";
				String beforesql = "select * from bigcustomerdetail where daytime='"+beforetime+"' ";
				logger.info("time=================>"+time);

				List todayDetails = FacadeFactory.INSTANCE.getBigCustomerDetailBo().findBySql(BigCustomerDetail.class, todaysql, params);	
				List beforeDetails = FacadeFactory.INSTANCE.getBigCustomerDetailBo().findBySql(BigCustomerDetail.class, beforesql, params);	

				if(todayDetails==null||todayDetails.size()<=0){
					throw new XLRuntimeException("==========更新'新增日期' 和 '差异数'时出错，昨天的大客户详情信息为空，请检查日期为："+time+"的大客户详情信息");
				}	
				if(beforeDetails==null||beforeDetails.size()<=0){
					throw new XLRuntimeException("==========更新'新增日期' 和 '差异数'时出错，前天的大客户详情信息为空，请检查日期为："+beforetime+"的大客户详情信息");
				}
				int line = 0;
				String total = null;
				  for(Object todayobj:todayDetails){//拿出今天的记录，到昨天的记录中取找
					    line++;				    
					    BigCustomerDetail todayDetail = (BigCustomerDetail)todayobj;				    
		                for(Object beforeobj:beforeDetails){
		                	BigCustomerDetail beforeDetail = (BigCustomerDetail)beforeobj;
		                	if((todayDetail.getUid().trim()).equals(beforeDetail.getUid().trim())){//如果从昨天的数据中找到了同一个id的数据
		                		total = beforeDetail.getTotalAmt();//取出昨天的金额
		                		//如果满足金额档条件
		                		todayDetail.setModifyAmt((Double.valueOf(todayDetail.getTotalAmt())-Double.valueOf(total))+"");
			                	
		                	}		                	
		                }
		                              
		                FacadeFactory.INSTANCE.getBigCustomerDetailBo().update(todayDetail);//更新数据	                
				}
				  				  		
			  todayDetails.clear();
			  todayDetails = null;
			  beforeDetails.clear();
			  beforeDetails = null;
			}catch(Throwable e){
				logger.info(e.getMessage());
			}							
		}
		
		/**
		 * 获得金额档
		 * @return
		 */
		public long[] getChargeAmountProfile(){
			String sql = "SELECT * FROM chargeamountprofilesettings order by amount asc";//按金额升序
			List params = new ArrayList();
			List datas = FacadeFactory.INSTANCE.getChargeAmountProfileSettingsBo().findBySql(ChargeAmountProfileSettings.class, sql, params);
			long amounts[] = new long[datas.size()];
			int j = 0;
			//到数据查询
			for(Object data:datas){
				ChargeAmountProfileSettings settings = (ChargeAmountProfileSettings)data;
				amounts[j] = settings.getAmount();
				j++;
			}
			return amounts;
		}
		
		
		/**
		 * 检查某用户在某金额档是否已经发送过邮件
		 * @param uid
		 * @param amount
		 * @return
		 */
		public boolean isExists(String uid,long amount,String time){
			String aftertime = formatAfterDay(time);
			time = aftertime;
			aftertime = formatAfterDay(aftertime);
			String sql = "select count(1) from sendmailrecord where uid = ? and amount = ? and time < '"+time+" 00:00:00' and time >'"+aftertime+" 00:00:00'";
			int count = FacadeFactory.INSTANCE.getSendMailRecordBo().queryForInt(sql, new Object[]{uid,amount});
			return count>0?true:false;
		}
		
		
		/**
		 * 由于调用远程接口是个非常耗时的操作，所以单独执行更新
		 */
		public void updatePhone(String time){
			List params = new ArrayList();
			UserInfoProxy userInfoProxy  = ProxyFactory.getInstance().getUserInfoProxy();
			String todaysql = "select * from bigcustomerdetail where daytime='"+time+"' ";
			String afterTime = formatAfterDay(time);
			String afterSql = "select * from bigcustomerdetail where daytime='"+afterTime+"' ";
			List todayDetails = FacadeFactory.INSTANCE.getBigCustomerDetailBo().findBySql(BigCustomerDetail.class, todaysql, params);
			List afterDetails = FacadeFactory.INSTANCE.getBigCustomerDetailBo().findBySql(BigCustomerDetail.class, afterSql, params);
			if(todayDetails==null||todayDetails.size()<=0){
				throw new XLRuntimeException("==========更新'安全手机号'时出错，昨天的大客户详情信息为空，请检查日期为："+time+"的大客户详情信息");
			}	
			int line = 0;
			String phone = null;
			 for(Object todayobj:todayDetails){//拿出今天的记录
				 line++;	
				 phone = null;
				 BigCustomerDetail todayDetail = (BigCustomerDetail)todayobj;
				 for(Object afterobj:afterDetails){
					 BigCustomerDetail afterDetail = (BigCustomerDetail)afterobj;
					 if(todayDetail.getUid().trim().equals(afterDetail.getUid().trim())){
						 phone = afterDetail.getPhone();
					 }
				 }
				
                 logger.info("line="+line+",调用远程接口，取得电话,uid="+todayDetail.getUid());				 
				 todayDetail.setPhone(phone==null?getPhone(userInfoProxy,todayDetail.getUid()):phone);
				 FacadeFactory.INSTANCE.getBigCustomerDetailBo().update(todayDetail);//更新数据
			 }
		}
		
		/**
		 * 将查询的数据导出到excel中
		 */
		public void export(){
			    logger.info("开始大客户详情导出到excel文件");
			    String daytime = findParameter("daytime");
		        String isnew = findParameter("isnew");		        
		        BigCustomerDetail detail = findBean(BigCustomerDetail.class, "bigcustomerdetail");		        
		        List params = new ArrayList();
		        StringBuffer todaysql = new StringBuffer("select * from bigcustomerdetail where daytime='")
		                               .append(daytime).append("'");
		        if("1".equals(isnew)){//如果选择了新增用户查询
		        	detail.setAddtime(daytime);
		        	todaysql.append("  and addtime='").append(daytime).append("'");
		        }
		        if(detail.getUid()!= null&&!"".equals(detail.getUid())){//如果输入id作为查询条件
		        	todaysql.append("  and uid='").append(detail.getUid()).append("'");
		        }
		        todaysql.append(" and totalAmt >=").append(detail.getAmountProfile());//根据金额档过滤
                logger.info("todaysql==============>"+todaysql.toString());	        
		        List todayDetails = FacadeFactory.INSTANCE.getBigCustomerDetailBo().findBySql(BigCustomerDetail.class, todaysql.toString(), params);
		        FacesContext facesContext = FacesContext.getCurrentInstance();
		        HttpServletResponse response = (HttpServletResponse) facesContext.getExternalContext().getResponse();
//System.out.println("todayDetails.size==============>"+todayDetails.size());	        
		        List datas = new ArrayList();
		    	SimpleDateFormat sdf = new SimpleDateFormat("yyyyMMddHHmmss");
				String now = sdf.format(new Date()); 
				Workbook wb = null;
		        if("1".equals(isnew)){//如果选择了新增用户查询
		        	UserInfoProxy userInfoProxy = ProxyFactory.getInstance().getUserInfoProxy();
		        	 int line = 0;
		        	 for(Object obj:todayDetails){
		        		    line ++;
				        	List list = new ArrayList();
				        	BigCustomerDetail bcd = (BigCustomerDetail)obj;		        	        	
		                    logger.info("line="+line+",调用远程接口，查询用户相关信息,uid="+bcd.getUid());	        	
				        	Resp_getuserinfo_sec info = getUserInfo(userInfoProxy,bcd.getUid());	 
				        	Resp_getuserinfo_base base = userInfoProxy.getuserinfo_base(bcd.getUid(), (byte)2);
				        	list.add(base.getUserAccount());
				        	list.add(bcd.getUid());	
				        	list.add(bcd.getTotalAmt());
				        	list.add(bcd.getPlatLastLogin());
				        	list.add(info.getMobile());
				        	list.add(info.getMail());
				        	list.add(info.getTelphone());
				        	datas.add(list);
				        }
		        	    String title = "贵宾数据-新增贵宾";
						String[] columnName = { "迅雷账号", "userid", "充值金额", "最后登录时间", "手机", "邮箱", "绑定安全手机" };
						String filePath = "/tmp/addbigcustomerdetail.xls";
						long beginTime = System.currentTimeMillis();					
						wb = ExcelUtil.create("新增贵宾统计",title,columnName,filePath,datas);
						long endTime = System.currentTimeMillis();
		                logger.info("生成excel文件花费："+(endTime-beginTime)+"ms");
		        }else{
		        	 for(Object obj:todayDetails){
				        	List list = new ArrayList();
				        	BigCustomerDetail bcd = (BigCustomerDetail)obj;		        	        	
				        	list.add(bcd.getUid());	
				        	list.add(bcd.getTotalAmt());
				        	list.add(bcd.getPlatLastLogin());
				        	list.add(bcd.getCallTotal());
				        	list.add(bcd.getModifyAmt());
				        	list.add(bcd.getPhone());
				        	datas.add(list);
				        }
		        	    String title = daytime+"日金额超过"+detail.getAmountProfile()+"档的大客户详情统计";
						String[] columnName = {"userid", "充值总金额", "最后登录时间", "外呼记录","新增金额","绑定安全手机号"};
						String filePath = "/tmp/bigcustomerdetail.xls";
						long beginTime = System.currentTimeMillis();
						wb = ExcelUtil.create("大客户详情统计",title,columnName,filePath,datas);
						long endTime = System.currentTimeMillis();
						logger.info("生成excel文件花费："+(endTime-beginTime)+"ms");
		        }		       		       
				
				//清空数据
				todayDetails.clear();		
				todayDetails = null;
				
				//弹出下载窗口
				response.setHeader("Content-disposition", "attachment;filename="+now+"_data.xls"); 
				response.setContentType("application/x-download");
				OutputStream ouputStream = null;
				try {
					ouputStream = response.getOutputStream();
					wb.write(ouputStream);  
				} catch (IOException e) {
					// TODO Auto-generated catch block
					e.printStackTrace();
				}   						
				FacesContext.getCurrentInstance().responseComplete();	            
		}

		
		
		/**
		 * /
		 * 将远程服务器上面的文件下载到本地服务器，以达到提速的效果
		 * @param baseUrl 远程服务器路径
		 * @param filepath 文件名称
		 * @param time 指定时间
		 * @param path 要保存的路径
 		 */
		public void downLoad(String baseUrl,String fileName,String time,String path){
			URL url = null;
			File file = null;
			try {
				url = new URL(baseUrl+fileName);
	            logger.info("url========================>"+url);			
			} catch (MalformedURLException e) {
				logger.info("文件找不到，文件路径为："+baseUrl+fileName+"，请查看是否正确。错误代码："+e.getMessage());
				throw new XLRuntimeException("文件找不到，文件路径为："+baseUrl+fileName+"，请查看是否正确");
			} 
			HttpURLConnection httpUrl = null;
			BufferedReader br = null;
			FileOutputStream fos = null;
			BufferedWriter bw = null;
			//连接指定的网络资源 
			try {
				httpUrl = (HttpURLConnection) url.openConnection(); 
				httpUrl.connect();
				//获取网络输入流 
				if(fileName != null){
					fileName = fileName.substring(fileName.lastIndexOf("/"));
				}
				time = formatDay2(time);			
				br = new BufferedReader(new InputStreamReader((httpUrl.getInputStream()))); 
				file = new File(path+time);
				if(!file.exists()){
					file.mkdirs();
				}
				file =  new File(path+time+fileName);
                logger.info(path+time+fileName);				
				if(!file.exists()){
					file.createNewFile();
				}
				fos = new FileOutputStream(file);
				bw = new BufferedWriter(new OutputStreamWriter(fos));	
				String readLine = br.readLine();
				int line = 0;
				while(readLine != null){
				   line ++;	   
                   bw.write(readLine);
                   bw.write("\n");
                   readLine = br.readLine();
				}
				bw.flush();
		}catch(Exception e){
			logger.info(e.getMessage());
			e.printStackTrace();
		}finally{
			try{
			   if(bw != null){
				   bw.close();
				   bw = null;
			   }
			   if(fos != null){
				   fos.close();
				   fos = null;
			   }
			   if(br != null){
				   br.close();
				   br = null;
			   }
			   if(httpUrl != null){
				   httpUrl.disconnect();
				   httpUrl = null;
			   }
			}catch(Exception e){
				
			}
		}
	}
		/**
		 * 计算玩家充值情况，判断达到某个档之后发送提醒邮件给对应负责人
		 */
		public void execute(String nowtime){
			
			try{
				/**
				 * 取出所有前一天的大客户信息
				 */
				//取指定日期的前一天
				String beforetime = formatBeforeDay(nowtime);
				String sql = "select * from bigcustomerdetail where daytime='"+beforetime+"' order by totalAmt asc";
				List params = new ArrayList();
		        logger.info("sql===============================>"+sql);
				List bigCustomerDetails = FacadeFactory.INSTANCE.getBigCustomerDetailBo().findBySql(BigCustomerDetail.class, sql, params);
				if(bigCustomerDetails==null||bigCustomerDetails.size()<=0){
					throw new XLRuntimeException("==========邮件发送失败，大客户详情信息为空，请检查日期为："+beforetime+"的大客户详情信息");
				}		
				/**
				 * 读取金额档
				 */
				sql = "SELECT * FROM chargeamountprofilesettings order by amount asc";//按金额升序		
				params.clear();
				logger.info("sql2====================>"+sql);
				List datas = FacadeFactory.INSTANCE.getChargeAmountProfileSettingsBo().findBySql(ChargeAmountProfileSettings.class, sql, params);
				if(datas==null || datas.size()<=0){
					throw new XLRuntimeException("=======邮件发送失败，充值金额档为空，请设置充值金额档");
				}
				long amounts[] = new long[datas.size()];
				int j = 0;
				//到数据查询，是否有发送邮件，如果已发送邮件就不用再发
				for(Object data:datas){
					ChargeAmountProfileSettings settings = (ChargeAmountProfileSettings)data;
					amounts[j] = settings.getAmount();
					j++;
				}
				/**
				 * 分析大客户总金额
				 */
				List<SendMailRecord> sendMailDetails = new ArrayList<SendMailRecord>();
				findGamePlayer(sendMailDetails,bigCustomerDetails,amounts);		
				
				
				/**
				 * 对于需要发送邮件的大客户，发送邮件给对应负责人
				 */
				
				//找出负责人邮箱
				params.clear();
				sql = "select * from interfaceman";
				logger.info("sql3============>"+sql);
				List mailDatas = FacadeFactory.INSTANCE.getInterfaceManBo().findBySql(InterfaceMan.class, sql, params);	
				if(mailDatas == null || mailDatas.size()<=0){
					throw new XLRuntimeException("邮件发送失败，接口人列表为空，请配置接口人信息");
				}
				String receivers[] = new String[mailDatas.size()];
				int i = 0;
				for(Object mailData:mailDatas){
					InterfaceMan m = (InterfaceMan)mailData;
					receivers[i] = m.getInterfaceEmail();			
					i++;
				}
				if(sendMailDetails!=null&&sendMailDetails.size()>0){
					updateData3(beforetime);
			       //发送邮件
					for(SendMailRecord smd:sendMailDetails){			
						//记录哪些用户，在哪些金额档发过邮件
						smd.setTime(nowtime);
						FacadeFactory.INSTANCE.getSendMailRecordBo().insert(smd);
					}
				}											
				
				//清空集合
				sendMailDetails.clear();
				sendMailDetails = null;
				bigCustomerDetails.clear();
				bigCustomerDetails = null;
				datas.clear();
				datas = null;
				mailDatas.clear();
				mailDatas = null;
			}catch(Throwable e){
				logger.info(e.getMessage());		
			}
			
		}
		/**
		 * 查找满足发邮件条件的数据
		 * @param sendMailDetails
		 * @param details
		 * @param amounts
		 * @return
		 */
		public void findGamePlayer(List<SendMailRecord> sendMailDetails,List details,long amounts[]) throws Exception{			
		   	for(Object obj:details){		   		
		   		BigCustomerDetail detail = (BigCustomerDetail)obj;
		   		double bcamount = Double.parseDouble(detail.getTotalAmt());		   		
		   		int index = 0;
		   		boolean flag = false;//是否满足条件
		   		for(int i=amounts.length-1;i>=0;i--){//金额档从大到小比较，第一次发现金额满足某一档时，则记录该金额档，并且不用再继续比较了。		   			
		   			if(bcamount >= amounts[i]){	   				
		   				index = i;
		   				flag = true;
		   				break;
		   			}
		   		}
		   		if(flag&&!isSendMail(detail.getUid(),amounts[index])){//如果这个档之前没有发送过邮件，则需要发送邮件	   		
		   			SendMailRecord smd = new SendMailRecord();
	   				smd.setUid(detail.getUid());
	   				smd.setAmount(amounts[index]);
	   				smd.setRealamount(Double.parseDouble(detail.getTotalAmt()));
	   				sendMailDetails.add(smd);
	   			}
		   	}	
		}
		

		/**
		 * 更新今日大客户详情中的 新增日期 和 差异数
		 */
		public void updateData3(String time) throws Exception{
				//取指定日期的前一天
				String beforetime = formatBeforeDay(time);
				List params = new ArrayList();
				String todaysql = "select * from bigcustomerdetail where daytime='"+time+"' ";
				String beforesql = "select * from bigcustomerdetail where daytime='"+beforetime+"' ";
				logger.info("time=================>"+time);
				logger.info("beforetime=================>"+beforetime);
				List todayDetails = FacadeFactory.INSTANCE.getBigCustomerDetailBo().findBySql(BigCustomerDetail.class, todaysql, params);	
				List beforeDetails = FacadeFactory.INSTANCE.getBigCustomerDetailBo().findBySql(BigCustomerDetail.class, beforesql, params);	

				if(todayDetails==null||todayDetails.size()<=0){
					throw new XLRuntimeException("==========更新'新增日期' 和 '差异数'时出错，昨天的大客户详情信息为空，请检查日期为："+time+"的大客户详情信息");
				}	
				if(beforeDetails==null||beforeDetails.size()<=0){
					throw new XLRuntimeException("==========更新'新增日期' 和 '差异数'时出错，前天的大客户详情信息为空，请检查日期为："+beforetime+"的大客户详情信息");
				}
				int line = 0;
				boolean flag = false;
				long []amounts  = getChargeAmountProfile();//获得金额档
				
				String total = null;
				  for(Object todayobj:todayDetails){//拿出今天的记录，到昨天的记录中取找
					    line++;				    
					    BigCustomerDetail todayDetail = (BigCustomerDetail)todayobj;				    
	                    flag = false;//假设没找到
		                for(Object beforeobj:beforeDetails){
		                	BigCustomerDetail beforeDetail = (BigCustomerDetail)beforeobj;
		                	if((todayDetail.getUid().trim()).equals(beforeDetail.getUid().trim())){//如果从昨天的数据中找到了同一个id的数据
		                		flag = true;//设置状态为找到了
		                		total = beforeDetail.getTotalAmt();//取出昨天的金额
		                	}		                	
		                }
		                
		                if(flag){//如果昨天有这个id的记录，则需要算出今天的差异数
		                	todayDetail.setModifyAmt((Double.valueOf(todayDetail.getTotalAmt())-Double.valueOf(total))+"");
		                	//如果满足金额档条件
		                	double bcamount = Double.parseDouble(todayDetail.getTotalAmt());		   		
		    		   		int index = 0;
		    		   		boolean status = false;//是否满足条件
		    		   		for(int i=amounts.length-1;i>=0;i--){//金额档从大到小比较，第一次发现金额满足某一档时，则记录该金额档，并且不用再继续比较了。		   			
		    		   			if(bcamount >= amounts[i]){	   				
		    		   				index = i;
		    		   				status = true;
		    		   				break;
		    		   			}
		    		   		}
		    		   		if(status&&!isSendMail(todayDetail.getUid(),amounts[index])){//如果这个档之前没有相关记录，则需要增加记录  		
		    		   			todayDetail.setAddtime(time);
		    	   			}
		    		   		
		                }else{//如果昨天没有这个id的记录，则需要更新添加时间
		                	todayDetail.setAddtime(time);
		                }  
		                
		                FacadeFactory.INSTANCE.getBigCustomerDetailBo().update(todayDetail);//更新数据	                
				}
				  
			  //清空集合
			  todayDetails.clear();
			  todayDetails = null;
			  beforeDetails.clear();
			  beforeDetails = null;								
		}


		/**
		 * 检查某用户在某金额档是否已经发送过邮件
		 * @param uid
		 * @param amount
		 * @return
		 */
		public boolean isSendMail(String uid,long amount) throws Exception{
			String sql = "select count(1) from sendmailrecord where uid = ? and amount = ?";
			int count = FacadeFactory.INSTANCE.getSendMailRecordBo().queryForInt(sql, new Object[]{uid,amount});
			return count>0?true:false;
		}
		
}
