package com.xunlei.niux.manager.web.model;

import java.text.SimpleDateFormat;
import java.util.List;

import javax.faces.context.ExternalContext;
import javax.faces.context.FacesContext;
import javax.servlet.http.HttpSession;

import com.xunlei.common.util.Sheet;
import com.xunlei.common.web.model.AbstractManagedBean;

public abstract class BaseManagedBean extends AbstractManagedBean {
	protected static SimpleDateFormat sdf_time=new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
	protected String getSessionValue(String key){
		FacesContext facesContext = FacesContext.getCurrentInstance();
		ExternalContext extContext =facesContext.getExternalContext();
		HttpSession session =(HttpSession)extContext.getSession(true); 
		Object obj=session.getAttribute(key);
		return (obj==null)?null:obj.toString();
	}
	protected void addSessionValue(String key,Object value){
		FacesContext facesContext = FacesContext.getCurrentInstance();
		ExternalContext extContext =facesContext.getExternalContext();
		HttpSession session =(HttpSession)extContext.getSession(true); 
		session.setAttribute(key, value);
	}
	protected <T> String mergePagedDataModel(int count,List<T> list){
		Sheet<T> sheet=new Sheet<T>(count,list);
		this.mergePagedDataModel(sheet, this.getFliper());
		return "";
	}
}
