package com.xunlei.niux.manager.web.model;

import java.util.ArrayList;
import java.util.List;
import org.apache.log4j.Logger;
import com.ferret.common.dao.enums.OrderType;
import com.ferret.common.dao.vo.Page;
import com.xunlei.common.util.FunRef;
import com.xunlei.common.util.PagedFliper;
import com.xunlei.common.util.Sheet;
import com.xunlei.common.util.XLRuntimeException;
import com.xunlei.niux.data.vipgame.bo.AutoCountBo;
import com.xunlei.niux.data.vipgame.bo.AutoProductBo;
import com.xunlei.niux.data.vipgame.bo.BonusProductBo;
import com.xunlei.niux.data.vipgame.facade.FacadeFactory;
import com.xunlei.niux.data.vipgame.vo.AutoProduct;
import com.xunlei.niux.data.vipgame.vo.BonusProduct;
import com.xunlei.niux.data.vipgame.vo.LinkInfo;
import com.xunlei.niux.manager.web.util.NiUxFunctionConstant;

/**
 * 自动发放奖品业务处理类
 * @author lisu
 *  2013-04-19
 */
@FunRef(NiUxFunctionConstant.NIUX_FUNCTION_AUTOPRODUCT)
public class AutoProductManagedBean extends BaseManagedBean {
	private static final Logger logger = Logger.getLogger(AutoProductManagedBean.class.getName());
	private AutoProductBo autoProductBo;
	private AutoCountBo autoCountBo;
	private BonusProductBo bonusProductBo;
	private int rownum = 0;
	
	
	public AutoProductManagedBean(){
		autoProductBo = FacadeFactory.INSTANCE.getAutoProductBo();
		bonusProductBo = FacadeFactory.INSTANCE.getBonusProductBo();
		autoCountBo = FacadeFactory.INSTANCE.getAutoCountBo();
		//初始化行号
		int pageNo=this.getFliper().getPageNo();
		int pageSize=this.getFliper().getPageSize();
		rownum=rownum+(pageNo-1)*pageSize+1;
	}
	

	public int getRownum() {
		return rownum++;
	}

	public void setRownum(int rownum) {
		this.rownum = rownum;
	}
	/**
	 * 查询自动发放奖品设置
	 * @return
	 */
	public String getQueryAutoProductList(){
		logger.info("开始自动发放奖品设置查询");
        this.authenticateRun();//验证运行权限
        AutoProduct product = findBean(AutoProduct.class, "autoproduct");
        PagedFliper pagedFliper = this.getFliper();
        int count = autoProductBo.count(product);
        pagedFliper.setRecordCount(count);
        List<AutoProduct> list = new ArrayList<AutoProduct>();
        if (count > 0) {
        	rownum = 1;
        	Page page=new Page();
        	page.setPageNo(pagedFliper.getPageNo());
        	page.setPageSize(pagedFliper.getPageSize());
        	page.addOrder("time", OrderType.DESC);
            list = autoProductBo.findAutoProduct(product, page);
        }
        Sheet<AutoProduct> sheet = new Sheet<AutoProduct>(count, list);
        this.mergePagedDataModel(sheet, pagedFliper);
        return "";
	}
	
	/**
	 * 新增自动发放奖品
	 * @return
	 */
	public String add(){
		logger.info("开始自动发放奖品信息添加");		
		AutoProduct product = this.findBean(AutoProduct.class,"autoproduct");	
		try{
			if(product==null){
				logger.info("自动发放奖品信息为空");
				throw new XLRuntimeException("自动发放奖品信息为空");
			}		
			product.setInputBy(this.currentUserLogo());
			product.setInputTime(now());
			
			BonusProduct bp = new BonusProduct();
			bp.setProductNo(product.getProductid().trim());
			List<BonusProduct> bplist = bonusProductBo.find(bp, 0, 0);
			if(bplist == null || bplist.size()==0){
				logger.info("您输入的奖品编号:"+product.getProductid()+" 在系统中不存在");
				throw new XLRuntimeException("您输入的奖品编号:"+product.getProductid()+" 在系统中不存在");
			}
			BonusProduct bonusProduct = bplist.get(0);
//			 //获得发放奖品列表
//			LinkInfo linkinfo = new LinkInfo();
//			Page page = new Page();
//			page.addOrder("validdatetime", OrderType.DESC);
//			linkinfo.setLinklocid("229");
//			linkinfo.setLinktitle(bonusProduct.getSeqId()+"");
//			List<LinkInfo> lilist=FacadeFactory.INSTANCE.getLinkInfoBo().find(linkinfo,page);
//			if(lilist == null||lilist.size()==0){
//				logger.info("您输入的奖品编号:"+product.getProductid()+" 不在奖品发放列表中");
//				throw new XLRuntimeException("您输入的奖品编号:"+product.getProductid()+" 不在奖品发放列表中");
//			}
			
			product.setProductName(bonusProduct.getProductName());
			product.setFlag(false);
			autoProductBo.insert(product);
		}catch(Exception e){
			logger.error("添加失败", e);
			mergeJsmessage("添加失败，原因：" + e.getMessage());
		}
		return "";
	}
	
	/**
	 * 修改自动发放奖品
	 * @return
	 */
	public String edit(){
		logger.info("开始自动发放奖品信息修改");
		this.authenticateEdit();//编辑权限
		AutoProduct product =this.findBean(AutoProduct.class,"autoproduct");
		try{
			if(product==null){
				logger.info("自动发放奖品信息为空");
				throw new XLRuntimeException("自动发放奖品信息为空");
			}		
			if(product.getFlag()){
				logger.info("该定时任务已执行，无法修改");
				throw new XLRuntimeException("该定时任务已执行，无法修改");
			}
			product.setEditBy(this.currentUserLogo());
			product.setEditTime(now());
			BonusProduct bp = new BonusProduct();
			bp.setProductNo(product.getProductid().trim());
			List<BonusProduct> bplist = bonusProductBo.find(bp, 0, 0);
			if(bplist == null || bplist.size()==0){
				logger.info("您输入的奖品编号:"+product.getProductid()+" 在系统中不存在");
				throw new XLRuntimeException("您输入的奖品编号:"+product.getProductid()+" 在系统中不存在");
			}
			BonusProduct bonusProduct = bplist.get(0);
//			 //获得发放奖品列表
//			LinkInfo linkinfo = new LinkInfo();
//			Page page = new Page();
//			page.addOrder("validdatetime", OrderType.DESC);
//			linkinfo.setLinklocid("229");
//			linkinfo.setLinktitle(bonusProduct.getSeqId()+"");
//			List<LinkInfo> lilist=FacadeFactory.INSTANCE.getLinkInfoBo().find(linkinfo,page);
//			if(lilist == null||lilist.size()==0){
//				logger.info("您输入的奖品编号:"+product.getProductid()+" 不在奖品发放列表中");
//				throw new XLRuntimeException("您输入的奖品编号:"+product.getProductid()+" 不在奖品发放列表中");
//			}
			
			product.setProductName(bonusProduct.getProductName());
			autoProductBo.update(product);		
		}catch(Exception e){
			logger.error("修改失败", e);
			mergeJsmessage("修改失败，原因：" + e.getMessage());
		}
		return "";
	}
	
	/**
	 * 删除自动发放奖品信息
	 * @return
	 */
	public String delete(){	
		logger.info("开始自动发放奖品信息删除");
		this.authenticateDel();//删除权限
		String delseqids = findParameter("delseqids");		
		try{
			String ids[] = delseqids.split(",");
			for(String id:ids)
				autoProductBo.delete(new Long(id));			
		}catch(Exception e){
			logger.error("删除失败", e);
			mergeJsmessage("删除失败，原因：" + e.getMessage());
		}
		return "";
	}
}
