package com.xunlei.niux.manager.web.model;

import java.util.ArrayList;
import java.util.List;

import com.ferret.common.dao.vo.Page;
import com.xunlei.common.util.PagedFliper;
import com.xunlei.common.util.Sheet;
import com.xunlei.niux.data.vipgame.facade.FacadeFactory;
import com.xunlei.niux.data.vipgame.vo.bonus.AuctionRecord;
import com.xunlei.niux.manager.web.util.PageUtil;

public class AuctionRecordManagedBean extends BaseManagedBean {
	
	public String getQueryAuctionRecordList(){
		AuctionRecord query=findBean(AuctionRecord.class, "auctionrecord");
		String auctionProuctIdStr=findParameter("auctionProductId");
		if(auctionProuctIdStr!=null&&!"".equals(auctionProuctIdStr)){
			 query.setAuctionProductId(Long.valueOf(auctionProuctIdStr));
		}
		if(query.getAuctionProductId()!=null&&query.getAuctionProductId()==0){
			 query.setAuctionProductId(null);
		}
		query.setIsValid(true);
		PagedFliper pagedFliper = this.getFliper();
		int count =FacadeFactory.INSTANCE.getAuctionRecordBo().count(query);
		List<AuctionRecord> arList=new ArrayList<AuctionRecord>();
		if(count>0){
			Page page=PageUtil.formatPage(pagedFliper, "auctionTime","desc");
			arList=FacadeFactory.INSTANCE.getAuctionRecordBo().finds(query, page);
		}
		Sheet<AuctionRecord> sheet = new Sheet<AuctionRecord>(count, arList);
	    this.mergePagedDataModel(sheet, pagedFliper);
		return "";
	}
}
