package com.xunlei.niux.manager.web.model;

import org.apache.myfaces.custom.fileupload.UploadedFile;

import com.xunlei.common.util.FunRef;
import com.xunlei.common.util.PagedFliper;
import com.xunlei.common.util.Sheet;
import com.xunlei.niux.data.manager.facade.FacadeFactory;
import com.xunlei.niux.data.manager.vo.AdvSeat;
import com.xunlei.niux.data.manager.vo.Advertisement;
import com.xunlei.niux.manager.web.util.FileUploadUtil;
import com.xunlei.niux.manager.web.util.NiUxFunctionConstant;

import freemarker.log.Logger;

/**
 * 广告
 * @author admin
 *
 */
@FunRef(NiUxFunctionConstant.NIUX_FUNCTION_ADVERTISEMENT)
public class AdvertisementManagedBean extends BaseManagedBean {
	private static final Logger logger=Logger.getLogger(AdvertisementManagedBean.class.getName());
	private UploadedFile bigfile;
	private UploadedFile smallfile;
	/**
	 * 查询广告位
	 * @return
	 */
	public String getQueryAdvSeatList(){
		logger.info("开始广告位查询");
		//获取查询条件
		AdvSeat as=this.findBean(AdvSeat.class,"advseat");
		if(as!=null){
			logger.info(as.getSeatNo());
		}
		//获取条件
		PagedFliper fliper=this.getFliper();//
		Sheet<AdvSeat> sheet=FacadeFactory.INSTANCE.getAdvertisementBo().queryAdvSeats(as, fliper);
		this.mergePagedDataModel(sheet, fliper);
		logger.info("完成广告位查询");
		return "";
	}
	/**
	 * 编辑广告位
	 * @return
	 */
	public String editSeat(){
		logger.info("开始广告位编辑");
		AdvSeat querySeat=this.findBean(AdvSeat.class,"advseat");
		if(querySeat==null){
			logger.info("广告位为空");
			this.mergeBean("广告位为空", "jsmessage");
			return "";
		}
		try{
			FacadeFactory.INSTANCE.getAdvertisementBo().updateAdvSeat(querySeat);
			logger.info("完成广告位编辑");
			alertJS("编辑成功");
			return "";
		}catch(Exception e){
			logger.info("编辑广告位失败",e);
			alertJS("编辑失败,原因："+e.getMessage());
			return "";
		}
	}
	public String addSeat(){
		logger.info("开始添加广告位");
		AdvSeat querySeat=this.findBean(AdvSeat.class,"advseat");
		try{
			logger.info("大图分辨率："+querySeat.getBigPicResolution());
			FacadeFactory.INSTANCE.getAdvertisementBo().addAdvSeat(querySeat);
			alertJS("添加成功");
			return "";
		}catch(Exception e){
			logger.info("添加广告位失败",e);
			alertJS("添加失败,原因："+e.getMessage());
			return "";
		}
	}
	/**
	 * 查询广告位
	 * @return
	 */
	public String getQueryAdvertisementList(){
		logger.info("开始广告查询");
		//获取查询条件
		Advertisement as=this.findBean(Advertisement.class,"advertisement");
		if(as!=null){
			if(as.getAdvNo()!=null&&as.getAdvNo()==0){
				as.setAdvNo(null);
			}
			logger.info(as.getSeatNo());
		}
		//获取条件
		PagedFliper fliper=this.getFliper();//
		Sheet<Advertisement> sheet=FacadeFactory.INSTANCE.getAdvertisementBo().queryAdv(as,fliper );
		this.mergePagedDataModel(sheet, fliper);
		logger.info("完成广告查询");
		return "";
	}
	/**
	 * 编辑广告位
	 * @return
	 */
	public String editAdv(){
		logger.info("开始广告编辑");
		Advertisement adv=this.findBean(Advertisement.class,"advertisement");
		if(adv==null){
			logger.info("广告为空");
			alertJS("编辑失败,原因：广告为空");
			return "";
		}
		try{
			Advertisement adv2=FacadeFactory.INSTANCE.getAdvertisementBo().queryAdvById(adv.getAdvNo());
			if(bigfile!=null){
				String bigfilename=FileUploadUtil.upLoadFile(bigfile);
				adv.setBigPicPath(bigfilename);
			}else{
				adv.setBigPicPath(adv2.getBigPicPath());
			}
			if(smallfile!=null){
				String smallfilename=FileUploadUtil.upLoadFile(smallfile);
				adv.setSmallPicPath(smallfilename);
			}else{
				adv.setSmallPicPath(adv2.getSmallPicPath());
			}
			FacadeFactory.INSTANCE.getAdvertisementBo().updateAdv(adv);
			logger.info("完成广告位编辑");
			alertJS("编辑成功");
			return "";
		}catch(Exception e){
			logger.info("编辑广告位失败",e);
			alertJS("编辑失败,原因："+e.getMessage());
			return "";
		}
	}
	public String addAdv(){
		logger.info("开始添加广告");
		Advertisement adv=this.findBean(Advertisement.class,"advertisement");
		try{
			if(bigfile!=null){
				String bigfilename=FileUploadUtil.upLoadFile(bigfile);
				adv.setBigPicPath(bigfilename);
			}
			if(smallfile!=null){
				String smallfilename=FileUploadUtil.upLoadFile(smallfile);
				adv.setSmallPicPath(smallfilename);
			}
			FacadeFactory.INSTANCE.getAdvertisementBo().addAdvs(adv);
			alertJS("添加成功");
			return "";
		}catch(Exception e){
			logger.info("添加广告失败",e);
			alertJS("添加失败,原因："+e.getMessage());
			return "";
		}

	}
	public UploadedFile getBigfile() {
		return bigfile;
	}
	public void setBigfile(UploadedFile bigfile) {
		this.bigfile = bigfile;
	}
	public UploadedFile getSmallfile() {
		return smallfile;
	}
	public void setSmallfile(UploadedFile smallfile) {
		this.smallfile = smallfile;
	}
	
}
