package com.xunlei.niux.manager.web.model;


import org.apache.log4j.Logger;
import org.apache.myfaces.custom.fileupload.UploadedFile;

import com.xunlei.common.util.FunRef;
import com.xunlei.common.util.PagedFliper;
import com.xunlei.common.util.Sheet;
import com.xunlei.niux.data.manager.facade.FacadeFactory;
import com.xunlei.niux.data.manager.vo.Activity;
import com.xunlei.niux.manager.web.util.FileUploadUtil;
import com.xunlei.niux.manager.web.util.NiUxFunctionConstant;

/**
 * 专题活动业务控制
 * @author lin
 * @date 2012-8-7
 * @Descripter:
 */
@FunRef(NiUxFunctionConstant.NIUX_FUNCTION_ACTIVITY)
public class ActivityManagedBean extends BaseManagedBean{
	private static final Logger logger = Logger.getLogger(ActivityManagedBean.class.getName());
	private UploadedFile upfile;
	
	public UploadedFile getUpfile() {
		return upfile;
	}
	public void setUpfile(UploadedFile upfile) {
		this.upfile = upfile;
	}
	/**
	 * 查询专题活动
	 * @return
	 */
	public String getQueryActivityList(){
		logger.info("开始专题活动查询");
		this.authenticateRun();//验证运行权限
		//获取查询条件
		Activity queryAct=this.findBean(Activity.class,"activity");
		if(queryAct!=null){
			logger.info(queryAct.getActNo());
		}
		//获取条件
		PagedFliper fliper=this.getFliper();//
		Sheet<Activity> sheet=FacadeFactory.INSTANCE.getActivityBo().queryActivities(queryAct, fliper);
		this.mergePagedDataModel(sheet, fliper);
		logger.info("完成专题活动查询");
		return "";
	}
	/**
	 * 编辑专题 活动
	 * @return
	 */
	public String edit(){
		logger.info("开始专题活动编辑");
		this.authenticateEdit();//编辑权限
		Activity queryAct=this.findBean(Activity.class,"activity");
		if(queryAct==null){
			logger.info("活动为空");
			alertJS("编辑失败，原因：活动为空");
			return "";
		}
		try{
			String filename=null;
			if(upfile!=null){
				filename=FileUploadUtil.upLoadFile(upfile);
			}
			Activity act=FacadeFactory.INSTANCE.getActivityBo().queryActivityById(queryAct.getActNo());
			if(act==null){
				logger.info(queryAct.getActNo()+"不存在");
				alertJS("编辑失败，原因：活动"+queryAct.getActNo()+"不存在");
				return "";
			}
			act.setActBeginDate(queryAct.getActBeginDate());
			act.setActEndDate(queryAct.getActEndDate());
			act.setActDesc(queryAct.getActDesc());
			act.setActName(queryAct.getActName());
			act.setParticipator(queryAct.getParticipator());
			act.setHomePageShow(queryAct.getHomePageShow());
			act.setShowBeginDate(queryAct.getShowBeginDate());
			act.setShowEndDate(queryAct.getShowEndDate());
			if(filename!=null){
				act.setPicPath(filename);
			}
			act.setLinkPath(queryAct.getLinkPath());
			act.setDisplayorder(queryAct.getDisplayorder());
			FacadeFactory.INSTANCE.getActivityBo().updateActivity(act);
			logger.info("完成专题活动编辑");
			Runtime.getRuntime().exec("syn_niuxpic.sh");
			alertJS("编辑成功");
			return "";
		}catch(Exception e){
			logger.info("编辑失败",e);
			alertJS("编辑失败，原因："+e.getMessage());
			return "";
		}
	}
	public String add(){
		logger.info("开始添加专题活动");
		this.authenticateAdd();//添加权限
		if(upfile==null){
			logger.info("图片为空");
			alertJS("添加失败，原因：图片为空");
		    return "";
		}
		String fileName="";
		try {
			fileName=FileUploadUtil.upLoadFile(upfile);
		} catch (Exception e) {
			logger.info("添加失败", e);
			alertJS("添加失败，原因："+e.getMessage());
			return "";
		}
		Activity activity=this.findBean(Activity.class, "activity");
		if(activity==null){
			logger.info("活动为空");
			alertJS("添加失败，原因：活动为空");
			return "";
		}
		logger.info("actNo:"+activity.getActNo());
		logger.info("actName:"+activity.getActName());
		activity.setPicPath(fileName);
		try{
			FacadeFactory.INSTANCE.getActivityBo().addActivity(activity);
			logger.info("完成添加专题活动");
			Runtime.getRuntime().exec("syn_niuxpic.sh");
			alertJS("添加成功");
			return "";
		}catch(Exception e){
			logger.info("添加失败",e);
			alertJS("添加失败，原因："+e.getMessage());
			return "";
		}
	}
}
