package com.xunlei.niux.manager.web.file;

import java.io.BufferedWriter;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStreamWriter;
import java.io.PrintStream;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.dom4j.Attribute;
import org.dom4j.Document;
import org.dom4j.DocumentException;
import org.dom4j.DocumentHelper;
import org.dom4j.Element;
import org.dom4j.io.OutputFormat;
import org.dom4j.io.SAXReader;
import org.dom4j.io.XMLWriter;

public class XmlUtil
{
    public static void makeGameXml(Gameid gameid, List<Object> plist, String filePath)
    {
        Document document = DocumentHelper.createDocument();

        Element messageElement = document.addElement("gameid");
        messageElement.addAttribute("id", gameid.getId());
        messageElement.addAttribute("name", gameid.getName());

        for (Iterator localIterator = plist.iterator(); localIterator.hasNext(); ) { Object pp = localIterator.next();
            if ((pp instanceof Property)) {
                Property p = (Property)pp;
                Element propertyElement = messageElement.addElement("property");
                propertyElement.addAttribute("name", p.getName());
                propertyElement.addAttribute("value", p.getValue());
            } else if ((pp instanceof Parameter)) {
                Parameter p = (Parameter)pp;
                Element propertyElement = messageElement.addElement("parameter");
                propertyElement.addAttribute("name", p.getName());
                propertyElement.addAttribute("value", p.getValue());
            }
        }

        XMLWriter out = null;
        BufferedWriter bw = null;
        OutputStreamWriter osw = null;
        FileOutputStream fos = null;
        try {
            File xmlFile = new File(filePath);
            xmlFile.exists();

            fos = new FileOutputStream(xmlFile);
            osw = new OutputStreamWriter(fos, "UTF-8");
            bw = new BufferedWriter(osw);

            OutputFormat format = OutputFormat.createPrettyPrint();
            format.setEncoding("UTF-8");
            out = new XMLWriter(bw, format);
            out.write(document);
        } catch (IOException e) {
            e.printStackTrace();
            try
            {
                if (out != null) {
                    out.close();
                    out = null;
                }
                if (bw != null) {
                    bw.close();
                    bw = null;
                }
                if (osw != null) {
                    osw.close();
                    osw = null;
                }
                if (fos != null) {
                    fos.close();
                    fos = null;
                }
            } catch (IOException e1) {
                e1.printStackTrace();
            }
        }
        finally
        {
            try
            {
                if (out != null) {
                    out.close();
                    out = null;
                }
                if (bw != null) {
                    bw.close();
                    bw = null;
                }
                if (osw != null) {
                    osw.close();
                    osw = null;
                }
                if (fos != null) {
                    fos.close();
                    fos = null;
                }
            } catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    public static void makeGameUserXml(Game game, List<Property> plist, String filePath)
    {
        File xmlFile = new File(filePath);
        Document document = null;
        boolean flag;
        if (xmlFile.isFile()) {
            SAXReader saxReader = new SAXReader();
            try {
                document = saxReader.read(xmlFile);
            } catch (DocumentException e) {
                e.printStackTrace();
            }

            Element rootElement = document.getRootElement();

            Iterator oneLevelElementItor = rootElement.elementIterator();
            flag = false;
            while ((oneLevelElementItor.hasNext()) && (!flag)) {
                Element e1 = (Element)oneLevelElementItor.next();
                String gameid = e1.attribute("id").getText();
                if (gameid.equals(game.getId())) {
                    flag = true;
                    rootElement.remove(e1);
                }
            }
            Element gameElement = rootElement.addElement("game");
            gameElement.addAttribute("name", game.getName());
            gameElement.addAttribute("id", game.getId());
            for (Iterator localIterator1 = plist.iterator(); localIterator1.hasNext(); ) {
                Property p = (Property)localIterator1.next();
                Element propertyElement = gameElement.addElement("property");
                propertyElement.addAttribute("name", p.getName());
                propertyElement.addAttribute("value", p.getValue()); }
        }
        else {
            document = DocumentHelper.createDocument();

            Element gamesElement = document.addElement("games");
            Element gameElement = gamesElement.addElement("game");
            gameElement.addAttribute("name", game.getName());
            gameElement.addAttribute("id", game.getId());

            for (Property p : plist) {
                Element propertyElement = gameElement.addElement("property");
                propertyElement.addAttribute("name", p.getName());
                propertyElement.addAttribute("value", p.getValue());
            }
        }
        XMLWriter out = null;
        BufferedWriter bw = null;
        OutputStreamWriter osw = null;
        FileOutputStream fos = null;
        try {
            fos = new FileOutputStream(xmlFile);
            osw = new OutputStreamWriter(fos, "UTF-8");
            bw = new BufferedWriter(osw);

            OutputFormat format = OutputFormat.createPrettyPrint();
            format.setEncoding("UTF-8");
            out = new XMLWriter(bw, format);
            out.write(document);
        } catch (IOException e) {
            e.printStackTrace();
            try
            {
                if (out != null) {
                    out.close();
                    out = null;
                }
                if (bw != null) {
                    bw.close();
                    bw = null;
                }
                if (osw != null) {
                    osw.close();
                    osw = null;
                }
                if (fos != null) {
                    fos.close();
                    fos = null;
                }
            } catch (IOException e1) {
                e1.printStackTrace();
            }
        }
        finally
        {
            try
            {
                if (out != null) {
                    out.close();
                    out = null;
                }
                if (bw != null) {
                    bw.close();
                    bw = null;
                }
                if (osw != null) {
                    osw.close();
                    osw = null;
                }
                if (fos != null) {
                    fos.close();
                    fos = null;
                }
            } catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    public static Element readXmlRoot(String filePath)
            throws Exception
    {
        File xmlFile = new File(filePath);
        SAXReader saxReader = new SAXReader();
        Document document = saxReader.read(xmlFile);
        return document.getRootElement();
    }

    public static void makeGameUserServerXml(Game game, List<Property> plist, String filePath)
    {
        File xmlFile = new File(filePath);
        Document document = null;
        boolean flag;
        if (xmlFile.isFile()) {
            SAXReader saxReader = new SAXReader();
            try {
                document = saxReader.read(xmlFile);
            } catch (DocumentException e) {
                e.printStackTrace();
            }

            Element rootElement = document.getRootElement();

            Iterator oneLevelElementItor = rootElement.elementIterator();
            flag = false;
            while ((oneLevelElementItor.hasNext()) && (!flag)) {
                Element e1 = (Element)oneLevelElementItor.next();
                String gameid = e1.attribute("id").getText();
                if (gameid.equals(game.getId())) {
                    flag = true;
                    rootElement.remove(e1);
                }
            }
            Element gameElement = rootElement.addElement("game");
            gameElement.addAttribute("name", game.getName());
            gameElement.addAttribute("id", game.getId());
            for (Iterator localIterator1 = plist.iterator(); localIterator1.hasNext(); ) {
                Property p = (Property)localIterator1.next();
                Element propertyElement = gameElement.addElement("property");
                propertyElement.addAttribute("name", p.getName());
                propertyElement.addAttribute("value", p.getValue()); }
        }
        else {
            document = DocumentHelper.createDocument();

            Element gamesElement = document.addElement("games");
            Element gameElement = gamesElement.addElement("game");
            gameElement.addAttribute("name", game.getName());
            gameElement.addAttribute("id", game.getId());

            for (Property p : plist) {
                Element propertyElement = gameElement.addElement("property");
                propertyElement.addAttribute("name", p.getName());
                propertyElement.addAttribute("value", p.getValue());
            }
        }
        XMLWriter out = null;
        BufferedWriter bw = null;
        OutputStreamWriter osw = null;
        FileOutputStream fos = null;
        try {
            fos = new FileOutputStream(xmlFile);
            osw = new OutputStreamWriter(fos, "UTF-8");
            bw = new BufferedWriter(osw);

            OutputFormat format = OutputFormat.createPrettyPrint();
            format.setEncoding("UTF-8");
            out = new XMLWriter(bw, format);
            out.write(document);
        } catch (IOException e) {
            e.printStackTrace();
            try
            {
                if (out != null) {
                    out.close();
                    out = null;
                }
                if (bw != null) {
                    bw.close();
                    bw = null;
                }
                if (osw != null) {
                    osw.close();
                    osw = null;
                }
                if (fos != null) {
                    fos.close();
                    fos = null;
                }
            } catch (IOException e1) {
                e1.printStackTrace();
            }
        }
        finally
        {
            try
            {
                if (out != null) {
                    out.close();
                    out = null;
                }
                if (bw != null) {
                    bw.close();
                    bw = null;
                }
                if (osw != null) {
                    osw.close();
                    osw = null;
                }
                if (fos != null) {
                    fos.close();
                    fos = null;
                }
            } catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    public static String findValue(List<Property> plist, String name)
    {
        for (Property p : plist) {
            if (name.equals(p.getName())) {
                return p.getValue();
            }
        }
        return "";
    }

    public static void commonOneLevelXml(String fileName, String tagName, String keyName, String keyValue, Map<String, String> attMap, Map<String, String> proMap)
            throws Exception
    {
        File xmlFile = new File(fileName);
        Document document = null;
        if (xmlFile.isFile()) {
            SAXReader saxReader = new SAXReader();
            try {
                document = saxReader.read(xmlFile);

                Element rootElement = document.getRootElement();

                Iterator oneLevelElementItor = rootElement.elementIterator();
                while (oneLevelElementItor.hasNext()) {
                    Element e1 = (Element)oneLevelElementItor.next();
                    String mykeyValue = e1.attribute(keyName).getText();
                    if (mykeyValue.equals(keyValue)) {
                        rootElement.remove(e1);
                        break;
                    }
                }

                Element gElement = rootElement.addElement(tagName);
                addCommonElement(gElement, attMap);

                for (Iterator iter = proMap.keySet().iterator(); iter.hasNext(); ) {
                    Element sElement = gElement.addElement("property");
                    String key = (String)iter.next();
                    String value = (String)proMap.get(key);
                    sElement.addAttribute("name", key);
                    sElement.addAttribute("value", value);
                }
            } catch (DocumentException e) {
                e.printStackTrace();
            }
        }

        XMLWriter out = null;
        BufferedWriter bw = null;
        OutputStreamWriter osw = null;
        FileOutputStream fos = null;
        try
        {
            fos = new FileOutputStream(xmlFile);
            osw = new OutputStreamWriter(fos, "UTF-8");
            bw = new BufferedWriter(osw);
            OutputFormat format = OutputFormat.createPrettyPrint();
            format.setEncoding("UTF-8");
            out = new XMLWriter(bw, format);
            out.write(document);
        } catch (IOException e) {
            e.printStackTrace();
            try
            {
                if (out != null) {
                    out.close();
                    out = null;
                }
                if (bw != null) {
                    bw.close();
                    bw = null;
                }
                if (osw != null) {
                    osw.close();
                    osw = null;
                }
                if (fos != null) {
                    fos.close();
                    fos = null;
                }
            } catch (IOException e1) {
                e1.printStackTrace();
            }
        }
        finally
        {
            try
            {
                if (out != null) {
                    out.close();
                    out = null;
                }
                if (bw != null) {
                    bw.close();
                    bw = null;
                }
                if (osw != null) {
                    osw.close();
                    osw = null;
                }
                if (fos != null) {
                    fos.close();
                    fos = null;
                }
            } catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    public static void commonOneLevelXml(String fileName, String tagName, Map<String, String> attMap)
            throws Exception
    {
        File xmlFile = new File(fileName);
        Document document = null;
        if (xmlFile.isFile()) {
            SAXReader saxReader = new SAXReader();
            try {
                document = saxReader.read(xmlFile);

                Element rootElement = document.getRootElement();

                Iterator oneLevelElementItor = rootElement.elementIterator();
                while (oneLevelElementItor.hasNext()) {
                    Element e1 = (Element)oneLevelElementItor.next();
                    String mytagName = e1.getName();
                    if (mytagName.equals(tagName)) {
                        rootElement.remove(e1);
                        break;
                    }
                }

                Element gElement = rootElement.addElement(tagName);

                for (Iterator iter = attMap.keySet().iterator(); iter.hasNext(); ) {
                    String key = (String)iter.next();
                    String value = (String)attMap.get(key);

                    Element sElement = gElement.addElement(key);
                    System.out.println("key=============>" + key + ",value=========>" + value);
                    sElement.setText(value == null ? "" : value);
                }
            } catch (DocumentException e) {
                e.printStackTrace();
            }
        }

        XMLWriter out = null;
        BufferedWriter bw = null;
        OutputStreamWriter osw = null;
        FileOutputStream fos = null;
        try
        {
            fos = new FileOutputStream(xmlFile);
            osw = new OutputStreamWriter(fos, "UTF-8");
            bw = new BufferedWriter(osw);
            OutputFormat format = OutputFormat.createPrettyPrint();
            format.setEncoding("UTF-8");
            out = new XMLWriter(bw, format);
            out.write(document);
        } catch (IOException e) {
            e.printStackTrace();
            try
            {
                if (out != null) {
                    out.close();
                    out = null;
                }
                if (bw != null) {
                    bw.close();
                    bw = null;
                }
                if (osw != null) {
                    osw.close();
                    osw = null;
                }
                if (fos != null) {
                    fos.close();
                    fos = null;
                }
            } catch (IOException e1) {
                e1.printStackTrace();
            }
        }
        finally
        {
            try
            {
                if (out != null) {
                    out.close();
                    out = null;
                }
                if (bw != null) {
                    bw.close();
                    bw = null;
                }
                if (osw != null) {
                    osw.close();
                    osw = null;
                }
                if (fos != null) {
                    fos.close();
                    fos = null;
                }
            } catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    private static void addCommonElement(Element element, Map<String, String> map)
            throws Exception
    {
        for (Iterator iter = map.keySet().iterator(); iter.hasNext(); ) {
            String key = (String)iter.next();
            String value = (String)map.get(key);
            element.addAttribute(key, value);
        }
    }

    public static void makeGamesXml(Game game, String filePath)
    {
        File xmlFile = new File(filePath);
        Document document = null;
        if (xmlFile.isFile()) {
            SAXReader saxReader = new SAXReader();
            try {
                document = saxReader.read(xmlFile);

                Element rootElement = document.getRootElement();

                Iterator oneLevelElementItor = rootElement.elementIterator();
                while (oneLevelElementItor.hasNext()) {
                    Element e1 = (Element)oneLevelElementItor.next();
                    String gameid = e1.attribute("id").getText();
                    if (gameid.equals(game.getId())) {
                        rootElement.remove(e1);
                        break;
                    }
                }
                Element gameElement = rootElement.addElement("game");
                gameElement.addAttribute("name", game.getName());
                gameElement.addAttribute("id", game.getId());
                gameElement.addAttribute("configfile", game.getConfigfile());
            }
            catch (DocumentException e) {
                e.printStackTrace();
            }
        } else {
            document = DocumentHelper.createDocument();

            Element gamesElement = document.addElement("games");

            Element gameElement = gamesElement.addElement("game");
            gameElement.addAttribute("name", game.getName());
            gameElement.addAttribute("id", game.getId());
            gameElement.addAttribute("configfile", game.getConfigfile());
        }

        XMLWriter out = null;
        BufferedWriter bw = null;
        OutputStreamWriter osw = null;
        FileOutputStream fos = null;
        try
        {
            fos = new FileOutputStream(xmlFile);
            osw = new OutputStreamWriter(fos, "UTF-8");
            bw = new BufferedWriter(osw);
            OutputFormat format = OutputFormat.createPrettyPrint();
            format.setEncoding("UTF-8");
            out = new XMLWriter(bw, format);
            out.write(document);
        } catch (IOException e) {
            e.printStackTrace();
            try
            {
                if (out != null) {
                    out.close();
                    out = null;
                }
                if (bw != null) {
                    bw.close();
                    bw = null;
                }
                if (osw != null) {
                    osw.close();
                    osw = null;
                }
                if (fos != null) {
                    fos.close();
                    fos = null;
                }
            } catch (IOException e1) {
                e1.printStackTrace();
            }
        }
        finally
        {
            try
            {
                if (out != null) {
                    out.close();
                    out = null;
                }
                if (bw != null) {
                    bw.close();
                    bw = null;
                }
                if (osw != null) {
                    osw.close();
                    osw = null;
                }
                if (fos != null) {
                    fos.close();
                    fos = null;
                }
            } catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    public static User readXmlFile(String filePath) throws DocumentException,IOException {
        File xmlFile = new File(filePath);
        if (!xmlFile.exists())
            xmlFile.createNewFile();
        SAXReader saxReader = new SAXReader();
        Document document = saxReader.read(xmlFile);
        //获取根元素Message
        Element messageElement = document.getRootElement();

        //获取Message元素下的子元素
        Iterator<Element> oneLevelElementItor = messageElement.elementIterator();
        Map<String,String> userAttrMap = new HashMap<String,String>();
        Map<String,String> addressAttrMap = new HashMap<String,String>();

        while(oneLevelElementItor.hasNext()){
            Element e1 = oneLevelElementItor.next();
            System.out.println("Message子元素："+e1.getName());
            //获取User元素下的子元素
            Iterator<Element> twoLevelElementItor = e1.elementIterator();
            while(twoLevelElementItor.hasNext()) {
                Element e2 = twoLevelElementItor.next();
                System.out.println("User子元素："+e2.getName());
                userAttrMap.put(e2.getName(), e2.getText());

                //获取Address下的子元素
                if("Address".equals(e2.getName())) {
                    Iterator<Element> threeLevelElementItor = e2.elementIterator();
                    while(threeLevelElementItor.hasNext()) {
                        Element e3 = threeLevelElementItor.next();
                        System.out.println("Address子元素："+e3.getName());
                        addressAttrMap.put(e3.getName(), e3.getText());
                    }
                }
            }
        }

        //将解析出来的数据封装成User
        User user = new User();
        user.setId(Long.valueOf(userAttrMap.get("id")));
        user.setName(userAttrMap.get("name"));
        user.setAge(Integer.valueOf(userAttrMap.get("age")));

        Address address = new Address();
        address.setId(Long.valueOf(addressAttrMap.get("id")));
        address.setProvince(addressAttrMap.get("province"));
        address.setCity(addressAttrMap.get("city"));
        address.setArea(addressAttrMap.get("area"));
        address.setStreet(addressAttrMap.get("street"));

        user.setAddress(address);
        return user;
    }
}