package com.xunlei.niux.manager.web.client;

import com.google.gson.Gson;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import com.google.gson.reflect.TypeToken;
import com.xunlei.common.util.XLRuntimeException;
import com.xunlei.niux.client.util.HttpClientUtil;
import com.xunlei.niux.easyutils.propertyutils.EnvPropertyUtil;
import com.xunlei.niux.manager.web.util.SignUtil;
import com.xunlei.niux.manager.web.vo.spreadinfoaudit.ChannelInfo;
import com.xunlei.niux.manager.web.vo.spreadinfoaudit.UserInfo;

import java.util.HashMap;
import java.util.List;
import java.util.Map;

/**
 * Created by jamesjxin on 14-7-9.
 */
public class SpreadInfoAuditClient {
    private static final String BaseUrl = EnvPropertyUtil.loadProperty("niux", "auditUrl", "");
    private static final String priKey = EnvPropertyUtil.loadProperty("niux", "auditpriKey", "");

    public static boolean auditUser(String userId,String valid){
        String url = BaseUrl + "audit?";

        Map<String,String> params = new HashMap<String, String>();
        params.put("uid",userId);
        params.put("valid",valid);
        String sign = SignUtil.sign(params,priKey,"UTF-8");

        params.put("signMsg",sign);

        String result = HttpClientUtil.get(url+SignUtil.getSignatureContent(params,"UTF-8")+"&signMsg="+sign);

        JsonObject resultJson = new JsonParser().parse(result).getAsJsonObject();
        int code = resultJson.get("code").getAsInt();
        if (code != 0) {
            String msg = resultJson.get("msg").getAsString();
            throw new XLRuntimeException("审核用户信息失败：" + msg);
        }

        return true;
    }

    public static List<UserInfo> getListUsers(String valid){
        String url = BaseUrl + "listUsers?";

        Map<String,String> params = new HashMap<String, String>();
        params.put("valid",valid);
        String sign = SignUtil.sign(params, priKey,"UTF-8");

        params.put("signMsg",sign);

        String result = HttpClientUtil.get(url+SignUtil.getSignatureContent(params,"UTF-8")+"&signMsg="+sign);
//        String result = getUserResult();

        JsonObject resultJson = new JsonParser().parse(result).getAsJsonObject();
        int code = resultJson.get("code").getAsInt();
        if (code != 0) {
            String msg = resultJson.get("msg").getAsString();
            throw new XLRuntimeException("查询用户信息失败：" + msg);
        }

        Gson gson = new Gson();
        List<UserInfo> userInfoList = gson.fromJson(resultJson.get("data"), new TypeToken<List<UserInfo>>() {
        }.getType());

        return userInfoList;
    }

    public static List<ChannelInfo> getListUserChnls(String userId){
        String url = BaseUrl + "listUserChnls?";

        Map<String,String> params = new HashMap<String, String>();
        params.put("uid",userId);
        String sign = SignUtil.sign(params,priKey,"UTF-8");


        String result = HttpClientUtil.get(url+SignUtil.getSignatureContent(params,"UTF-8")+"&signMsg="+sign);
//        String result = getChannelResult();

        JsonObject resultJson = new JsonParser().parse(result).getAsJsonObject();
        int code = resultJson.get("code").getAsInt();
        if(code != 0){
            String msg = resultJson.get("msg").getAsString();
            throw new XLRuntimeException("查询用户渠道信息失败："+msg);
        }

        Gson gson = new Gson();
        List<ChannelInfo> channelInfoList = gson.fromJson(resultJson.get("data"), new TypeToken<List<ChannelInfo>>(){}.getType());

        return channelInfoList;
    }

    public static boolean addUserChnl(String userId,String chnl,String caption){
        String url = BaseUrl + "addUserChnl?";
        Map<String, String> paramMap = new HashMap<String, String>();
        paramMap.put("uid",userId);
        paramMap.put("chnl",chnl);
        paramMap.put("caption",caption);
        String sign = SignUtil.sign(paramMap,priKey,"UTF-8");

        paramMap.put("signMsg",sign);

        url += SignUtil.getSignatureContent(paramMap,"UTF-8")+"&signMsg="+sign;

        String result = HttpClientUtil.get(url);

        JsonObject resultJson = new JsonParser().parse(result).getAsJsonObject();
        int code = resultJson.get("code").getAsInt();
        if(code != 0){
            String msg = resultJson.get("msg").getAsString();
            throw new XLRuntimeException("增加用户渠道失败："+msg);
        }

        return true;
    }

    public static void main(String[] args){
        String str = "uid=1";
        String sign = SignUtil.sign(str,priKey);
        System.out.println(sign);
    }

}
