package com.xunlei.niux.manager.web.cache;

import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;

import org.apache.commons.beanutils.BeanUtils;
import org.springframework.util.CollectionUtils;

import com.ferret.common.dao.enums.OrderType;
import com.ferret.common.dao.vo.Page;
import com.xunlei.niux.data.vipgame.facade.FacadeFactory;
import com.xunlei.niux.data.vipgame.vo.mobilegameapkversion.CommonSpreadInfo;

public class ApkSpreadCache {
		private static ApkSpreadCache instance;
		private static Object obj = new Object();
		private Object updateCacheLock=new Object();
		private static Page page = new Page();
		private Map<String,CommonSpreadInfo> allCommSpreadInfoMap = new ConcurrentHashMap<String,CommonSpreadInfo>();
		private Map<String,CommonSpreadInfo> newCommSpreadInfoMap = new ConcurrentHashMap<String,CommonSpreadInfo>();
		private Map<String,CommonSpreadInfo> newChannelCommSpreadInfoMap = new ConcurrentHashMap<String,CommonSpreadInfo>();
		private List<CommonSpreadInfo> allSpreadInfoList=new ArrayList<CommonSpreadInfo>();//所有跳转list
		private List<CommonSpreadInfo> newSpreadInfoList=new ArrayList<CommonSpreadInfo>();//最新包跳转list
		
		public static ApkSpreadCache getInstance(){
			if(instance == null){
				synchronized(obj){
					if(instance == null){
						instance = new ApkSpreadCache();						
					}
				}
			}
			return instance;
		}
		
		private  ApkSpreadCache(){
			 updateCache();
			 System.out.println("newCommSpreadInfoMap:"+newCommSpreadInfoMap);
		}
		
		public  void updateCache(){
			CommonSpreadInfo query = new CommonSpreadInfo();
			query.setIsValid(true);
			page.addOrder("seqId", OrderType.ESC);//按序列升序
			List<CommonSpreadInfo> csiList = FacadeFactory.INSTANCE.getBaseSo().findObjects(query, page);
			if(CollectionUtils.isEmpty(csiList))return;
			updateCache(csiList);
		}
		
		private void updateCache(List<CommonSpreadInfo> csiList){
			Map<String,CommonSpreadInfo> allMap=new ConcurrentHashMap<String, CommonSpreadInfo>();
			Map<String,CommonSpreadInfo> newMap=new ConcurrentHashMap<String, CommonSpreadInfo>();
			Map<String,CommonSpreadInfo> newChannelMap=new ConcurrentHashMap<String, CommonSpreadInfo>();
			for(CommonSpreadInfo csi:csiList){
				allMap.put(csi.getGameId()+csi.getVersion(), csi);
				newMap.put(csi.getGameId(), csi);
				newChannelMap.put(csi.getGameId()+csi.getAdvNo(), csi);
				allSpreadInfoList.add(csi);
			}
			synchronized(updateCacheLock){
				allCommSpreadInfoMap = allMap ;
				newCommSpreadInfoMap = newMap;
				newChannelCommSpreadInfoMap = newChannelMap;
				allSpreadInfoList  = csiList;
				newSpreadInfoList = getCommonSpreadInfo(newCommSpreadInfoMap);
			}
		}
		
		private List<CommonSpreadInfo> getCommonSpreadInfo(Map<String,CommonSpreadInfo> newCommonSpreadInfoMap){
			List<CommonSpreadInfo> list = new ArrayList<CommonSpreadInfo>();
			Set<String> set = newCommonSpreadInfoMap.keySet();
			for(Iterator<String> iter = set.iterator();iter.hasNext();){
				String key = iter.next();
				list.add(newCommonSpreadInfoMap.get(key));
			}
			return list;
		}
		
		
		/**
		 * 根据游戏编号和渠道号获取最新版本的跳转信息
		 * @param gameId
		 * @param advNo
		 * @return
		 */
		public CommonSpreadInfo getCommonSpreadInfoByGameIdAndAdvNo(String gameId,String advNo){
			return copy(newChannelCommSpreadInfoMap.get(gameId+advNo));
		}
		
		/**
		 * 根据游戏编号和版本号获得跳转信息
		 * @param gameId
		 * @param version
		 * @return
		 */
		public CommonSpreadInfo getCommonSpreadInfoByGameIdAndVersion(String gameId,String version){
			return copy(allCommSpreadInfoMap.get(gameId+version));
		}
		
		/**
		 * 根据游戏编号获得最新版本的跳转信息
		 * @param gameId
		 * @return
		 */
		public CommonSpreadInfo getCommonSpreadInfoByGameId(String gameId){
			return copy(newCommSpreadInfoMap.get(gameId));
		}
		
		/**
		 * 根据游戏编号获得最新版本的跳转地址
		 * @param gameId
		 * @return
		 */
		public String getSpreadJumpUrlByGameId(String gameId){
			CommonSpreadInfo spread = newCommSpreadInfoMap.get(gameId);
			if(spread == null)return "http://niu.xunlei.com";
			return spread.getShortUrl();
		}
		
		/**
		 * 返回所有的跳转信息
		 * @return
		 */
		public List<CommonSpreadInfo> getCommonSpreadInfoAllList(){
			List<CommonSpreadInfo> allSpreadInfo = allSpreadInfoList;
			List<CommonSpreadInfo> list = new ArrayList<CommonSpreadInfo>();
			for(CommonSpreadInfo info:allSpreadInfo){
				list.add(info);
			}
			return list;
		}
		
		/**
		 * 返回每个游戏最新的跳转信息
		 * @return
		 */
		public List<CommonSpreadInfo> getCommonSpreadInfoNewList(){
			List<CommonSpreadInfo> allSpreadInfo = newSpreadInfoList;
			List<CommonSpreadInfo> list = new ArrayList<CommonSpreadInfo>();
			for(CommonSpreadInfo info:allSpreadInfo){
				list.add(info);
			}
			return list;
		}
		
		
		private CommonSpreadInfo copy(CommonSpreadInfo info){
			if(info==null){
				return null;
			}
			CommonSpreadInfo rg=new CommonSpreadInfo();
			try {
				BeanUtils.copyProperties(info, rg);
			} catch (IllegalAccessException e) {
				e.printStackTrace();
			} catch (InvocationTargetException e) {
				e.printStackTrace();
			}
			return rg;
		}
		
}
