package com.xunlei.niux.manager.template.thread;

import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.List;

import com.xunlei.niux.data.vipgame.bo.HtmlTemplateBo;
import com.xunlei.niux.data.vipgame.facade.IFacade;
import org.apache.log4j.Logger;
import com.xunlei.niux.data.vipgame.facade.FacadeFactory;
import com.xunlei.niux.data.vipgame.vo.HtmlTemplate;
import com.xunlei.niux.data.vipgame.vo.TemplateSchema;
import com.xunlei.niux.manager.template.builder.ITemplateBuilder;

/**
 * 模板生成线程
 * @author lin
 * @date 2012-10-13
 * @Descripter:
 */
public class TempBuildThread extends Thread{
	private static final Logger logger=Logger.getLogger(TempBuildThread.class);
	private static final SimpleDateFormat sdf=new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
//    private static final HtmlTemplateBo htmlTemplateBo = FacadeFactory.INSTANCE.getHtmlTemplateBo();
    private static final IFacade facade = FacadeFactory.INSTANCE;
	public void run(){
        boolean flag = true;
		while(flag){
            try{
                exec();
            } catch (Exception e) {
                flag = false;
                logger.error("模板任务出错", e);
            }

			try {
				sleep(1000);
			} catch (InterruptedException e) {
				logger.error("睡眠出错");
			}
		}
	}
	private void exec(){
		try{
			logger.info("开始执行模板生成计划");
			//添加自动计划
			addautoexecshcema();
			//执行已添加的计划
			String now=sdf.format(new Date());
			TemplateSchema queryTs=new TemplateSchema();
			queryTs.setIsexecuted(false);
			queryTs.setToschematime(now);
			List<TemplateSchema> list=facade.getTemplateSchemaBo().find(queryTs);
			for(TemplateSchema ts:list){
				exec(ts);
			}
			logger.info("结束执行模板生成计划");
		}catch(Exception e){
			logger.error(e);
		}
	}
	private void exec(TemplateSchema ts){
		try{
			HtmlTemplate htmltemplate=facade.getHtmlTemplateBo().find(ts.getTemplateid());
			if(null==htmltemplate.getExecclass()||"".equals(htmltemplate.getExecclass())){
				throw new Exception("模板id："+ts.getTemplateid()+"的execlass为空");
			}
			Class<?> clazz=Class.forName(htmltemplate.getExecclass());
			ITemplateBuilder builder=(ITemplateBuilder)clazz.newInstance();
			builder.build(ts.getSchemaid());
		}catch(Exception e){
			logger.error(e);
		}
	}
	/**
	 * 添加自动执行计划
	 */
	private void addautoexecshcema(){
		try{
			HtmlTemplate queryHt=new HtmlTemplate();
			queryHt.setAutoexec(true);
			List<HtmlTemplate> list=facade.getHtmlTemplateBo().find(queryHt);
			for(HtmlTemplate ht:list){
				addautoexecshcema(ht);
			}
		}catch(Exception e){
			logger.error(e);
		}
	}
	private void addautoexecshcema(HtmlTemplate ht){
		try{
			Integer interval=ht.getAutoexecinterval();//获取执行间隔
			if(interval==null||interval<=0){
				logger.debug("时间间隔没有设置");
				//没有设置执行间隔，表示不主动执行
				return;
			}
			//判断时间间隔是否满足自动添加条件
			String nowStr=sdf.format(new Date());
			long now=System.currentTimeMillis()/1000;
			long lasttime=formatLastSchemaExecTime(ht.getLastautoexectime())/1000;
			long i=now-lasttime;
			if(i<interval){
				logger.debug("还没到时间");
				return ;
			}
			System.out.println(ht.getExecclass());
			Class<?> clazz=Class.forName(ht.getExecclass());
			ITemplateBuilder builder=(ITemplateBuilder)clazz.newInstance();
			builder.addTeamplateSchema(ht, false);
			//更新htmltemplate的最后执行时间
			ht.setLastautoexectime(nowStr);
			FacadeFactory.INSTANCE.getHtmlTemplateBo().update(ht);
		}catch(Exception e){
			logger.error(e);
		}
	}
	private long formatLastSchemaExecTime(String datetime) throws ParseException{
		if(datetime==null||"".equals(datetime)){
			return 0;
		}
		Date d=sdf.parse(datetime);
		return d.getTime();
	}
}
