package com.xunlei.niux.manager.template.model;

import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.*;
import javax.faces.model.SelectItem;
import org.apache.log4j.Logger;
import org.springframework.util.CollectionUtils;
import com.ferret.common.dao.enums.OrderType;
import com.ferret.common.dao.vo.Page;
import com.xunlei.common.util.FunRef;
import com.xunlei.common.util.PagedFliper;
import com.xunlei.common.util.Sheet;
import com.xunlei.common.vo.UserInfo;
import com.xunlei.niux.data.vipgame.bo.TemplateSchemaBo;
import com.xunlei.niux.data.vipgame.facade.FacadeFactory;
import com.xunlei.niux.data.vipgame.vo.HtmlTemplate;
import com.xunlei.niux.data.vipgame.vo.TemplateSchema;
import com.xunlei.niux.manager.template.builder.ITemplateBuilder;
import com.xunlei.niux.manager.web.model.BaseManagedBean;
import com.xunlei.niux.manager.web.util.NiUxFunctionConstant;

/**
 * 模板执行计划
 * @author lin
 * @date 2012-10-10
 * @Descripter:
 */
@FunRef(NiUxFunctionConstant.NIUX_FUNCTION_TEMPLATESCHEMA)
public class TemplateSchemaModel extends BaseManagedBean{
	private static final Logger logger = Logger.getLogger(TemplateSchemaModel.class.getName());
	private static final SimpleDateFormat sdf=new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
	private List<SelectItem> htmlTemplateList;
	private Map<String,String> htmlTemplateMap;
	private List<HtmlTemplate> htlist;
	/**
	 * 查询执行计划
	 * @return
	 */
	@SuppressWarnings("unchecked")
	public String getQueryTemplateSchemaList(){
	//	this.authenticateRun();//验证运行权限
		TemplateSchema tsc=this.findBean(TemplateSchema.class,"tempateschema");
		PagedFliper fliper=this.getFliper();
		//如果schemaid==0,将schemaid设置为null
		if(tsc!=null&&tsc.getSchemaid()!=null&&tsc.getSchemaid()==0){
			tsc.setSchemaid(null);
		}
		//查询满足条件的总行数
		int rowcount=FacadeFactory.INSTANCE.getTemplateSchemaBo().count(tsc);
		List<TemplateSchema> list=new ArrayList<TemplateSchema>();
		if(rowcount>0){
			Page page=new Page();
			page.setPageNo(fliper.getPageNo());
			page.setPageSize(fliper.getPageSize());
			page.addOrder("schematime", OrderType.DESC);
			list=FacadeFactory.INSTANCE.getTemplateSchemaBo().find(tsc, page);
		}
		this.mergePagedDataModel(new Sheet(rowcount,list), fliper);
		return "";
	}
	
	private boolean checkTempldate(TemplateSchema tsc){
		TemplateSchema query = new TemplateSchema();
		query.setTemplateid(tsc.getTemplateid());//同一个模版
		query.setExt1(tsc.getExt1());//同一个类别
		query.setIsexecuted(false);//没有执行
		Page page = new Page();
		page.setPageNo(1);
		page.setPageSize(1);
		page.addOrder("schemaid", OrderType.DESC);
		List<TemplateSchema> tslist = FacadeFactory.INSTANCE.getTemplateSchemaBo().find(query, page);
		//System.out.println("tslist:"+tslist);
		if(!CollectionUtils.isEmpty(tslist)){
			TemplateSchema tschema = tslist.get(0);
			String schematime = tschema.getSchematime();
			String addSchematime = tsc.getSchematime();
			long time  = compareTime(addSchematime, schematime);
			if(time<10&&time>0){//如果两个未生成的模版，添加的时间间隔小于 10分钟				
				return false;
			}
		}
		return true;
	}
	
	/**
	 * 添加执行计划
	 */
	public String add(){
		//this.authenticateAdd();//验证运行权限
		TemplateSchema tsc=this.findBean(TemplateSchema.class,"tempateschema");
		//获取当前时间
		String now = sdf.format(new Date());
		//添加用户信息
		UserInfo user=this.currentUserInfo();
		tsc.setInputby(user.getTrueName());
		tsc.setInputtime(now);
		//设置默认值
		tsc.setIsexecuted(false);
		try{
			if(!checkTempldate(tsc)){
				alertJS("该模版执行计划已存在，请不要重复添加");
				return "";
			}	
			HtmlTemplate ht=FacadeFactory.INSTANCE.getHtmlTemplateBo().find(tsc.getTemplateid());
			Class<?> clazz=Class.forName(ht.getExecclass());
			ITemplateBuilder builder=(ITemplateBuilder)clazz.newInstance();
			if(tsc.getSchematime()==null||"".equals(tsc.getSchematime().trim())){
				tsc.setSchematime(sdf.format(new Date()));
			}			
			builder.manualAddTemplateSchema(ht, tsc);
			alertJS("添加成功");
		}catch(Exception e){
			logger.error("手动添加执行计划失败",e);
			alertJS("手动添加执行计划失败,原因："+e.getMessage());
		}
		return "";
	}
	
	/**
	 * 两个时间相关多少分钟
	 * @param fromtime
	 * @param totime
	 * @return
	 */
	public  long compareTime(String fromtime,String totime){
		SimpleDateFormat df = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");  
        Date one = null;
        Date two = null;
        long days=0;  
        try{
        	one = df.parse(fromtime);  
        	two = df.parse(totime); 
        	long time1 = one.getTime();  
        	long time2 = two.getTime();  
        	long diff = time1 - time2;
        	days = diff / (1000 * 60);          
        }catch(ParseException  e){
        	e.printStackTrace();  
        }
		return days;
	}
	
	/**
	 * 添加执行计划
	 */
	public String edit(){
		//this.authenticateAdd();//验证运行权限
		TemplateSchema tsc=this.findBean(TemplateSchema.class,"tempateschema");
		//获取当前时间
		String now = sdf.format(new Date());
		//添加用户信息
		UserInfo user=this.currentUserInfo();
		tsc.setInputby(user.getTrueName());
		tsc.setInputtime(now);
		try{
			FacadeFactory.INSTANCE.getTemplateSchemaBo().insert(tsc);
		}catch(Exception e){
			logger.error("手动添加执行计划失败",e);
			alertJS("手动编辑执行计划失败,原因："+e.getMessage());
		}
		return "";
	}
	public List<SelectItem> getHtmlTemplateList() {
		if(htmlTemplateList==null){
			if(htlist==null){
				htlist=FacadeFactory.INSTANCE.getHtmlTemplateBo().find(new HtmlTemplate());
			}
			List<SelectItem> tlist=new ArrayList<SelectItem>();
			for(HtmlTemplate ht:htlist){
				SelectItem si=new SelectItem();
				si.setValue(ht.getTemplateid());
				si.setLabel(ht.getTemplatename());
				tlist.add(si);
			}
			htmlTemplateList=tlist;
		}
		return htmlTemplateList;
	}
	public void setHtmlTemplateList(List<SelectItem> htmlTemplateList) {
		this.htmlTemplateList = htmlTemplateList;
	}
	public Map<String, String> getHtmlTemplateMap() {
		if(htmlTemplateMap==null){
			if(htlist==null){
				htlist=FacadeFactory.INSTANCE.getHtmlTemplateBo().find(new HtmlTemplate());
			}
			Map<String, String> tmap=new HashMap<String,String>();
			for(HtmlTemplate ht:htlist){
				tmap.put(ht.getTemplateid(), ht.getTemplatename());
			}
			htmlTemplateMap=tmap;
		}
		return htmlTemplateMap;
	}
	public void setHtmlTemplateMap(Map<String, String> htmlTemplateMap) {
		this.htmlTemplateMap = htmlTemplateMap;
	}
	public List<SelectItem> getHtmpTemplateAndQufenGameSiList(){
		List<SelectItem> tlist=new ArrayList<SelectItem>();
		List<HtmlTemplate> htlist=FacadeFactory.INSTANCE.getHtmlTemplateBo().find(new HtmlTemplate());
		for(HtmlTemplate ht:htlist){
			SelectItem si=new SelectItem();
			Boolean qufengame=ht.getQufengame();
			String qufengameStr=(qufengame!=null&&qufengame)?"1":"0";
			si.setValue(ht.getTemplateid()+"_"+qufengameStr);
			si.setLabel(ht.getTemplatename());
			tlist.add(si);
		}
		return tlist;
	}
	/**
	 * 从参数列表中查询模板对应的模板计划
	 * @return
	 */
   public String getQueryOneHtmpTemplateSchema(){
	   String templateId=findParameter("templateId");
	   HtmlTemplate ht=this.findBean(HtmlTemplate.class,"htmltemplate");
	   if(ht.getTemplateid()==null||"".equals(ht.getTemplateid())){
		   //从参数列表中获取值
		   HtmlTemplate tempHt=FacadeFactory.INSTANCE.getHtmlTemplateBo().find(templateId);
		   ht.setTemplateid(tempHt.getTemplateid());
		   ht.setQufengame(tempHt.getQufengame());
		   ht.setTemplatename(tempHt.getTemplatename());
	   }
	   TemplateSchema tsc=this.findBean(TemplateSchema.class,"tempateschema");
	   tsc.setTemplateid(ht.getTemplateid());
	   PagedFliper fliper=this.getFliper();
	    //如果schemaid==0,将schemaid设置为null
		if(tsc!=null&&tsc.getSchemaid()!=null&&tsc.getSchemaid()==0){
			tsc.setSchemaid(null);
		}
		//查询满足条件的总行数
		int rowcount=FacadeFactory.INSTANCE.getTemplateSchemaBo().count(tsc);
		List<TemplateSchema> list=new ArrayList<TemplateSchema>();
		if(rowcount>0){
			Page page=new Page();
			page.setPageNo(fliper.getPageNo());
			page.setPageSize(fliper.getPageSize());
			page.addOrder("schematime", OrderType.DESC);
			list=FacadeFactory.INSTANCE.getTemplateSchemaBo().find(tsc, page);
		}
		this.mergePagedDataModel(new Sheet(rowcount,list), fliper);
		return "";
   }
   
   public String delete() {
       this.authenticateRun();

       String paramseqids = findParameter("delseqids");
       TemplateSchemaBo schemaBo = FacadeFactory.INSTANCE.getTemplateSchemaBo();
       List<TemplateSchema> list = schemaBo.getTemplatesByIds(paramseqids);
       
       try{
    	   if(list!=null&&list.size()>0){
    		  for(TemplateSchema schema : list){
    			  if(!schema.getIsexecuted()){
    				  schemaBo.delete(schema.getSchemaid());
    			  }
    		  }
    	   }
          
       } catch (Exception e) {
           logger.error("删除失败", e);
           mergeBean("删除失败，原因：" + e.getMessage(), "jsmessage");
       }

       getQueryTemplateSchemaList();

       return "";
   }

}
