package com.xunlei.niux.manager.template.builder.xmp;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

import com.xunlei.niux.data.vipgame.facade.FacadeFactory;
import com.xunlei.niux.data.vipgame.vo.Games;
import com.xunlei.niux.data.vipgame.vo.LinkInfo;
import com.xunlei.niux.manager.template.builder.AbstractTemplateBuilder;
import com.xunlei.niux.manager.web.cache.GameCache;
import com.xunlei.niux.manager.web.util.FreemarkerUtil;
/**
 * xmpbox浮层推荐游戏
 * @author Administrator
 *
 */
public class BoxExternalBuilder extends AbstractTemplateBuilder {

	public void executeShcema() throws Exception {
		Map<String,Object> root=new HashMap<String,Object>();
		root.put("gameinfolist", getTuiJianGameInfoList());
		String tempPath=htmlTemplate.getTemplateroot();
		String templateFileName="boxexternal.ftl";
		String htmlFilePath=isPreView?htmlTemplate.getPreviewhtmlroot():htmlTemplate.getHtmlroot();
		String htmlFileName="index.html";
		FreemarkerUtil.buildHtml(tempPath, templateFileName, root, htmlFilePath, htmlFileName);
	}
	private List<Map<String,String>> getTuiJianGameInfoList(){
		List<Map<String,String>> list=new ArrayList<Map<String,String>>();
		List<LinkInfo> lilist=FacadeFactory.INSTANCE.getLinkInfoBo().getValidteLinkInfoListByLinkLocId_V2("269", 3, isPreView);
		for(LinkInfo li:lilist){
			Games game=GameCache.getInstance().getGameByGameId(li.getGameidbytuijian());
			if(game==null){
				continue;
			}
			Map<String,String> map=new HashMap<String,String>();
			map.put("gameno", game.getGameNo());
			map.put("gamename", game.getGameName());
			map.put("linkurl", li.getLinkurl()==null?"":li.getLinkurl());
			map.put("imgurl",li.getPicurl()==null?"":li.getPicurl());
			map.put("gametype", li.getExt1()==null?"":li.getExt1());
			map.put("starnum", getStarNum(li.getExt3())+"");
			map.put("scorenum", li.getExt3()==null?"":li.getExt3());
			map.put("content", li.getLinkcontents()==null?"":li.getLinkcontents());
			list.add(map);
		}
		return list;
	}
	private static int getStarNum(String value){
		double d=Double.valueOf(value);
		int i=(int)d;
		return d-i>0?i+1:i;
	}
}
