package com.xunlei.niux.manager.template.builder.seo;

import java.io.BufferedWriter;
import java.io.File;
import java.io.FileOutputStream;
import java.io.OutputStreamWriter;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.log4j.Logger;
import com.ferret.common.dao.enums.OrderType;
import com.ferret.common.dao.vo.Page;
import com.xunlei.common.facade.IFacadeCommon;
import com.xunlei.niux.data.vipgame.facade.FacadeFactory;
import com.xunlei.niux.data.vipgame.vo.Games;
import com.xunlei.niux.data.vipgame.vo.SeoAdvice;
import com.xunlei.niux.data.vipgame.vo.SeoGame;
import com.xunlei.niux.manager.template.builder.AbstractTemplateBuilder;
import com.xunlei.niux.manager.web.cache.GameCache;
import com.xunlei.niux.manager.web.util.Constant;
import com.xunlei.niux.manager.web.util.FreemarkerUtil;

/**
 * @author lisu
 * 2013-09-11
 */
public class SeoBuilder extends AbstractTemplateBuilder {
    private static final int PAGESIZE = 50;   //SEO标题页每页最多的标题数
    private static final Logger logger = Logger.getLogger(SeoBuilder.class);
    private static final String FILEPATH = IFacadeCommon.INSTANCE.getLibconfigValueByConfigNo("advicePhotoPath");//
    private static final String REMOREFILEPATH = IFacadeCommon.INSTANCE.getLibconfigValueByConfigNo("remoteAdvicePicPath");
    private static final String KANKANURL = IFacadeCommon.INSTANCE.getLibconfigValueByConfigNo("kankanurl");
    private  List<String> linklist = new ArrayList<String>();
    
    
    public static void main(String args[]){
    	try {
			new SeoBuilder().executeShcema();
		} catch (Exception e) {
			e.printStackTrace();
		}
    }
    
    @Override
    public void executeShcema() throws Exception {
        String seqid = this.schema.getExt1();
    	//String gameId = "000126";
        if(seqid == null)return;
        if( Constant.BASEGAMEID.equals(seqid)){
        	  makeGameJs();       	 
        }else{
        	executeById(seqid);
        }                 
    }


    /**
     * 为每款游戏添加SEO文章时，都会重新生成文章
     * @param gameId
     */
    private void executeById(String gameId) {
    	String regEx = "<[^>]+>"; //定义HTML标签的正则表达式
    	logger.info("gameId:"+gameId+",make seo advice start");
    	SeoAdvice sa = new SeoAdvice();
    	sa.setGameId(gameId);
        List<SeoAdvice> list = FacadeFactory.INSTANCE.getBaseSo().findObjects(sa, new Page());
       // String tempPath = "c:/tmp/office/member/";
       String tempPath = htmlTemplate.getTemplateroot();
       String htmlFilePath = isPreView ? htmlTemplate.getPreviewhtmlroot() : htmlTemplate.getHtmlroot() ;
       // String htmlFilePath = "c:/tmp/office/member/test/";
        if(!htmlFilePath.endsWith("/")) {
            htmlFilePath = htmlFilePath + "/";
        }
        for(SeoAdvice adv:list){
            Map<String, Object> root = new HashMap<String, Object>();
        	Map<String,String> articleMap = new HashMap<String,String>();
        	articleMap.put("title", adv.getTitle());
        	String content = adv.getContent();
			if(content != null){
				if(content.indexOf(FILEPATH)!= -1){
					content = content.replaceAll(FILEPATH, REMOREFILEPATH);
				}
			}
        	articleMap.put("content", content);
        	articleMap.put("gameId", adv.getGameId());
        	content = removeHtml(regEx,content);
        	if(content !=null ){
        		content = content.replaceAll("\n", "");
        		content = content.replaceAll("\r","");
        		content = content.replaceAll("&nbsp;", "");
        		content = content.trim();
        		if(content.length()>80)
        		   content = content.substring(0,80);
        	}
        	articleMap.put("description", content);
        	Games game=GameCache.getInstance().getGameByGameId(adv.getGameId());
        	articleMap.put("gameName", game.getGameName());
        	root.put("articleMap", articleMap);
        	root.put("articleList", getArticleList(list,adv.getSeqid()));
        	       	
        	String gameno = game.getGameNo();
        	String path = htmlFilePath+gameno;
        	File file = new File(path);
        	if(!file.exists()){
        		file.mkdir();
        	}
            //生成详情页面
        	FreemarkerUtil.buildHtml(tempPath,
    				"article.html", root, path,
    				adv.getSeqid()+".html");
        }
        makeAdviceTitleList();
        makePageText();
    }
    
    
    /**
     * 去掉html格式
     * @param content
     * @return
     */
    private String removeHtml(String regEx, String content){   	    
        Pattern pattern = Pattern.compile(regEx,Pattern.CASE_INSENSITIVE);    
        Matcher  matcher = pattern.matcher(content);    
        content = matcher.replaceAll(""); //过滤html标签    
    	return content;
    }
    
    /**
     * 生成页面链接页
     */
    private void makePageText() {
    	FileOutputStream fos = null;
    	BufferedWriter bw = null;
    	try{
    		fos = new FileOutputStream(new File("/tmp/seolinks.txt"));
        	bw = new BufferedWriter(new OutputStreamWriter(fos));
        	Page page = new Page();
        	SeoGame sg = new SeoGame();
        	List<SeoGame> sglist =  FacadeFactory.INSTANCE.getBaseSo().findObjects(sg, page);       	        	
        	SeoAdvice sa = new SeoAdvice();
            List<SeoAdvice> list = FacadeFactory.INSTANCE.getBaseSo().findObjects(sa, page);
            for(SeoGame game:sglist){
            	String gameid = game.getGameId();
               Games games = GameCache.getInstance().getGameByGameId(gameid);
            	for(SeoAdvice advice :list){
            		if(advice.getGameId().equals(gameid)){
            			bw.write(KANKANURL+games.getGameNo()+"/"+advice.getSeqid()+".html");
                		bw.write("\n");
            		}
            	}
            }
        	bw.flush();
    	}catch(Exception e){
    		e.printStackTrace();
    	}finally{
    		try{
    			if(bw != null){
    				bw.close();
    				bw = null;
    			}
    			if(fos != null){
    				fos.close();
    				fos = null;
    			}
    		}catch(Exception e){
    			e.printStackTrace();
    		}
    	}

    }
    
    /**
     * 生成文章标题列表页
     */
    private void makeAdviceTitleList(){
    	if(linklist != null&& linklist.size()>0)
    	      linklist.clear();
        Page page = new Page();
        page.addOrder("inputTime", OrderType.DESC);
        SeoAdvice sa = new SeoAdvice();        
        List<SeoAdvice> list = FacadeFactory.INSTANCE.getBaseSo().findObjects(sa,page);      
        if(list !=null&&list.size()>0){
        	String tempPath = htmlTemplate.getTemplateroot();
        	// String tempPath = "c:/tmp/office/member/";
             String htmlFilePath = isPreView ? htmlTemplate.getPreviewhtmlroot() : htmlTemplate.getHtmlroot() ;
        	// String htmlFilePath = "c:/tmp/office/member/test/";
        	 if(!htmlFilePath.endsWith("/")) {
                htmlFilePath = htmlFilePath + "/";
            }
        	long len = list.size();
        	List<Map<String,String>> articleList = null;
        	if(len<=PAGESIZE){
        		articleList = new ArrayList<Map<String,String>>(PAGESIZE);        		
        		for(SeoAdvice advice:list){
            		Map<String,String> map = new HashMap<String,String>();
            		map.put("title", advice.getTitle());
            		map.put("id", advice.getSeqid()+"");
            		map.put("gameNo", GameCache.getInstance().getGameByGameId(advice.getGameId()).getGameNo());
            		articleList.add(map);
            	}       		
        		Map<String,Integer> pageMap = new HashMap<String,Integer>();
        		pageMap.put("cur", 1);
        		pageMap.put("total", 1);
        		Map<String, Object> root = new HashMap<String, Object>();
        		root.put("articleList", articleList);
        	    root.put("pageMap", pageMap);
        		  //生成详情页面
            	FreemarkerUtil.buildHtml(tempPath,
        				"list.html", root, htmlFilePath,
        				"list.html");
        	}else{
        		int jj = 0;
        		long total =( len%PAGESIZE==0)?len/PAGESIZE:(len/PAGESIZE+1);
        		for(int i=0;i<len;i++){
        			if(i%PAGESIZE==0){        				  				     
        				if(i>0){
        					jj++;      
        					Map<String,Object> pageMap = new  HashMap<String,Object>();
            				pageMap.put("cur", jj);
            				pageMap.put("total", total);
            				Map<String, Object> root = new HashMap<String, Object>();
                    		root.put("articleList", articleList);
                    	    root.put("pageMap", pageMap);
                    		  //生成详情页面
                        	FreemarkerUtil.buildHtml(tempPath,
                    				"list.html", root, htmlFilePath,
                    				(jj==1?"list":"list_"+jj)+".html");
        				}  
        				articleList = new ArrayList<Map<String,String>>(PAGESIZE);    
        			}
        			SeoAdvice advice = list.get(i);
        			Map<String,String> map = new HashMap<String,String>();
            		map.put("title", advice.getTitle());
            		map.put("gameNo", GameCache.getInstance().getGameByGameId(advice.getGameId()).getGameNo());
            		map.put("id", advice.getSeqid()+"");
            		articleList.add(map);
            		if(i==len-1){//如果是最后一个元素
            			jj++;
            			Map<String,Object> pageMap = new  HashMap<String,Object>();
        				pageMap.put("cur", jj);
        				pageMap.put("total", total);
        				Map<String, Object> root = new HashMap<String, Object>();
                		root.put("articleList", articleList);
                	    root.put("pageMap", pageMap);
                		  //生成详情页面
                    	FreemarkerUtil.buildHtml(tempPath,
                				"list.html", root, htmlFilePath,
                				(jj==1?"list":"list_"+jj)+".html");
            		}            		
        		}     		
        	}       	
        }
    }
    
    
    /**
     * 生成推荐游戏的js
     */
    private void makeGameJs(){
    	 //String tempPath = "c:/tmp/office/member/";
    	// String htmlFilePath = "c:/tmp/office/member/test/";
         String tempPath = htmlTemplate.getTemplateroot();
         String htmlFilePath = isPreView ? htmlTemplate.getPreviewhtmlroot() : htmlTemplate.getHtmlroot() ;
         if(!htmlFilePath.endsWith("/")) {
            htmlFilePath = htmlFilePath + "/";
         }
         Page page = new Page();
         page.addOrder("displayOrder", OrderType.ESC);
    	 List<SeoGame> list = FacadeFactory.INSTANCE.getBaseSo().findObjects(new SeoGame(), page);
    	 Map<String, Object> root = new HashMap<String, Object>();
    	 if(list != null && list.size()>0){
    		 List<Map<String,String>> result = new ArrayList<Map<String,String>>(list.size());   	 
        	 for(SeoGame sg:list){
        		 Map<String,String> map = new HashMap<String,String>();
        		 map.put("img", sg.getPhoto());
        		 String gameid = sg.getGameId();
        		 map.put("gameId",gameid);
        		 //游戏信息
        		 Games game=GameCache.getInstance().getGameByGameId(gameid);
        		 map.put("gameName",game.getGameName());
        		 map.put("enterGameUrl", sg.getEnterGameUrl());
        		 map.put("giftUrl", sg.getGetGiftUrl());
        		 result.add(map);
        	 }    	
        	 root.put("recomGameList", result);           
    	 }else{
    		 root.put("recomGameList", null);
    	 }
//    	 htmlFilePath = htmlFilePath.replace("/niu/", "/gamedata/");
//
//    	System.out.println("htmlFilePath:"+htmlFilePath);
//    	System.out.println("htmlFilePath:"+htmlFilePath);
//    	System.out.println("htmlFilePath:"+htmlFilePath);

        String niuOfficialJsPath = IFacadeCommon.INSTANCE.getLibconfigValueByConfigNo("niuOfficialJsPath");
        if (niuOfficialJsPath.endsWith("/")) {
            niuOfficialJsPath = niuOfficialJsPath.substring(0, niuOfficialJsPath.length() - 1);
        }

    	  //生成详情页面
        FreemarkerUtil.buildHtml(tempPath,
                "niugongluerecom.js", root, niuOfficialJsPath + "/gamedata/",
                "niugongluerecom.js");
    }
    
    /**
     * 获得同一款游戏下其他文章
     * @param seqid
     * @return
     */
    private List<Map<String,String>>  getArticleList(List<SeoAdvice> list,long seqid){
    	if(list == null||list.size()<=1)return null;
    	List<Map<String,String>> salist = new ArrayList<Map<String,String>>(5);
    	int i=1;
    	for(SeoAdvice sa:list){
    		if(i>5)break;
    		if(sa.getSeqid() == seqid)continue;
    		Map<String,String> map = new HashMap<String,String>();
    		map.put("title", sa.getTitle());
    		map.put("gameNo", GameCache.getInstance().getGameByGameId(sa.getGameId()).getGameNo());
    		map.put("id", sa.getSeqid()+"");
    		salist.add(map);
    		i++;
    	}
    	return salist;
    }
}
