package com.xunlei.niux.manager.template.builder.question;

import java.io.File;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.log4j.Logger;
import com.xunlei.niux.data.vipgame.facade.FacadeFactory;
import com.xunlei.niux.data.vipgame.vo.GameServers;
import com.xunlei.niux.data.vipgame.vo.Games;
import com.xunlei.niux.data.vipgame.vo.LinkInfo;
import com.xunlei.niux.manager.constant.LinkLocationIdConstant;
import com.xunlei.niux.manager.template.builder.AbstractTemplateBuilder;
import com.xunlei.niux.manager.web.util.FreemarkerUtil;

public class CommonQuestionBuilder extends AbstractTemplateBuilder {
	private static final Logger logger = Logger.getLogger(CommonQuestionBuilder.class);
	private boolean ispreview=false;
	private static final String PHOTOURL = "http://help.xunlei.com";
	
	
	@Override
	public void executeShcema() throws Exception {
		logger.info("===开始生成客服系统中常见问题模版===");	
		buildCommonGameQuestion();
		buildCommonPlanformQuestion();
		logger.info("===客服系统中常见问题模版生成成功===");
	}

	/**
	 * 生成游戏类常见问题模版
	 */
	private void buildCommonGameQuestion() {
		Connection conn = JdbcUtil.getConnection();
		String sql = "SELECT contentno,pcontentno,contentname FROM `contents` WHERE pcontentno = '00050001' AND inuser=1";// 取出所有游戏
		ResultSet gamers = JdbcUtil.getResultSet(conn, sql);
		sql = "SELECT contentno,pcontentno,contentname FROM `contents` WHERE pcontentno LIKE '000500010%'  AND inuser=1";// 取得游戏下所有类别
		ResultSet typers = JdbcUtil.getResultSet(conn, sql);
		sql = "SELECT seqid,articleno,title,contents FROM `articles` WHERE articleno LIKE '00050001%'";// 取得类别下所有文章
		ResultSet articlers = JdbcUtil.getResultSet(conn, sql);
		List<Map<String, String>> gameList = new ArrayList<Map<String, String>>();
		List<Map<String, String>> typeList = new ArrayList<Map<String, String>>();
		List<Map<String, String>> questionList = new ArrayList<Map<String, String>>();
		
		List<Map<String, String>> allquestions = new ArrayList<Map<String, String>>();
		try {
			while (gamers.next()) {
				Map game = new HashMap();
				game.put("gameId", gamers.getString("contentno"));
				game.put("gameName", gamers.getString("contentname"));
				gameList.add(game);
			}
			logger.info("gameList.size============>" + gameList.size());
			while (typers.next()) {
				Map type = new HashMap();
				type.put("gameId", typers.getString("pcontentno"));
				type.put("typeId", typers.getString("contentno"));
				type.put("typeName", typers.getString("contentname"));
				typeList.add(type);
			}
			logger.info("typeList.size============>" + typeList.size());
			while (articlers.next()) {
				Map article = new HashMap();
				article.put("questionId", articlers.getString("seqid"));
				article.put("typeId", (String) (articlers.getString("articleno")));
				article.put("questionTitle", articlers.getString("title"));
				article.put("content", articlers.getString("contents"));
				questionList.add(article);
			}
			logger.info("questionList.size============>"+ questionList.size());
			String gameId = null;
			String typeId = null;
			String gameTypeId = null;
			String questionTypeId = null;
			List<Map<String, String>> types = new ArrayList<Map<String, String>>();
			List<Map<String, String>> questions = null;
			
			for (Map game : gameList) {
				gameId = (String) (game.get("gameId"));				
				for (Map type : typeList) {					
					typeId = (String) (type.get("gameId"));
					gameTypeId = (String) (type.get("typeId"));
					if (!gameId.trim().equals(typeId.trim())) {
						continue;// 如果游戏类别 和 游戏不对应
					}
					
					types.clear();
					findType(types,gameId,typeList);
					
					
					questions = new ArrayList<Map<String, String>>();
					for (Map question : questionList) {
						questionTypeId = (String) (question.get("typeId"));
						if (gameTypeId.trim().equals(questionTypeId.trim())) {// 查到同一个类别下的所有问题
							questions.add(question);
						}
					}
					logger.info("==========封装数据==========");
					// 填充页面数据
					Map<String, Object> pageMap = new HashMap<String, Object>();
				
					BaseInfo baseInfo = new BaseInfo();
					baseInfo.setGameId(gameId);
					baseInfo.setGameName((String) game.get("gameName"));
					baseInfo.setListOrDetail("list");
					baseInfo.setPageType("game");
					baseInfo.setTypeId((String)type.get("typeId"));
					baseInfo.setTypeName((String) type.get("typeName"));
					pageMap.put("baseInfo", baseInfo);
					
					pageMap.put("seomap", getKeyWord());
					
					pageMap.put("gameList", gameList);
					pageMap.put("typeList", types);
					pageMap.put("activessideadvdata", getActiviesSideAdvHtml());
					pageMap.put("latestplaygamesideadvdata", getLatestPlayGameSideAdv());
					PageInfo pageInfo = new PageInfo();
					int i = 0;					
					pageInfo.setPageSize(15);
					int pageTotal = questions.size();//总记录数
					int pageCount = pageTotal%pageInfo.getPageSize()==0?pageTotal/pageInfo.getPageSize():pageTotal/pageInfo.getPageSize()+1;
					if(pageCount<=1){
						pageCount = 1;
					}
					pageInfo.setTotalNum(pageCount);
					
					List<Map<String,String>> pageQuestions = new ArrayList<Map<String,String>>();
					int count = 0;
					if(questions.size() <= pageInfo.getPageSize()){												
						pageInfo.setCurPage(1);
						pageMap.put("pageInfo", pageInfo);
						count = questions.size();

						for(int j=i*(pageInfo.getPageSize());j<count;j++){
							pageQuestions.add(questions.get(j));
						}
						pageMap.put("questionList", pageQuestions);					
						logger.info("===开始生成模版===");
						// 生成模版页
						String tempPath=htmlTemplate.getTemplateroot();
						//String tempPath = "d:/tmp/game/";
						String templateFileName = "list.html";
						String htmlFilePath=isPreView?htmlTemplate.getPreviewhtmlroot():htmlTemplate.getHtmlroot();
						//String htmlFilePath = "d:/tmp/";
						String dirname = "game/"+gameId+"/"+gameTypeId+"/";
						logger.info("dirname===========>"+dirname);
						File file = new File(htmlFilePath+dirname);
						if(!file.exists()){//如果目录不存在，则创建目录
							file.mkdirs();
						}
						String htmlFileName = dirname + "1.html";					
						logger.info("filename=========>" + htmlFileName);
						FreemarkerUtil.buildHtml(tempPath, templateFileName,pageMap, htmlFilePath, htmlFileName);
						logger.info("===模版生成结束===");

						
					}else{
						for(int j=1;j<=pageCount;j++){
							pageInfo.setCurPage(j);
							pageMap.put("pageInfo", pageInfo);
							if(j==pageCount){								
								count = ((pageTotal%(pageInfo.getPageSize()))==0)?(j*(pageInfo.getPageSize())):((j-1)*(pageInfo.getPageSize())+pageTotal%(pageInfo.getPageSize()));
							}else{
								count = j*(pageInfo.getPageSize());	

							}
							
					        pageQuestions.clear();
							for(int jj=(j-1)*(pageInfo.getPageSize());jj<count;jj++){
								pageQuestions.add(questions.get(jj));
							}
							pageMap.put("questionList", pageQuestions);
							logger.info("===开始生成模版===");
							// 生成模版页
						    String tempPath=htmlTemplate.getTemplateroot();
							//String tempPath = "d:/tmp/game/";
							String templateFileName = "list.html";
							String htmlFilePath=isPreView?htmlTemplate.getPreviewhtmlroot():htmlTemplate.getHtmlroot();
							//String htmlFilePath = "d:/tmp/";
							String dirname = "game/"+gameId+"/"+gameTypeId+"/";
							logger.info("dirname===========>"+dirname);
							File file = new File(htmlFilePath+dirname);
							if(!file.exists()){//如果目录不存在，则创建目录
								file.mkdirs();
							}
							String htmlFileName = dirname+ j+".html";
							//System.out.println("pageMap==========>"+pageMap);
							FreemarkerUtil.buildHtml(tempPath, templateFileName,pageMap, htmlFilePath, htmlFileName);
							logger.info("===模版生成结束===");

						}												
					}															
				}
				
				
				//生成某游戏下全部问题
				allquestions.clear();
				findQuestion(allquestions,typeList,gameId,questionList);
				// 填充页面数据
				Map<String, Object> pageMap = new HashMap<String, Object>();
			
				BaseInfo baseInfo = new BaseInfo();
				baseInfo.setGameId(gameId);
				baseInfo.setGameName((String) game.get("gameName"));
				baseInfo.setListOrDetail("list");
				baseInfo.setPageType("game");
				baseInfo.setTypeId("all");
				baseInfo.setTypeName("全部");
				pageMap.put("baseInfo", baseInfo);

				pageMap.put("seomap", getKeyWord());
				
				pageMap.put("gameList", gameList);
				pageMap.put("typeList", types);
				pageMap.put("activessideadvdata", getActiviesSideAdvHtml());
				pageMap.put("latestplaygamesideadvdata", getLatestPlayGameSideAdv());
				PageInfo pageInfo = new PageInfo();
				int i = 0;					
				pageInfo.setPageSize(15);
				int pageTotal = allquestions.size();//总记录数
				int pageCount = pageTotal%pageInfo.getPageSize()==0?pageTotal/pageInfo.getPageSize():pageTotal/pageInfo.getPageSize()+1;
				if(pageCount<=1){
					pageCount = 1;
				}
				pageInfo.setTotalNum(pageCount);
				
				List<Map<String,String>> pageQuestions = new ArrayList<Map<String,String>>();
				int count = 0;
				if(allquestions.size() <= pageInfo.getPageSize()){												
					pageInfo.setCurPage(1);
					pageMap.put("pageInfo", pageInfo);
					count = allquestions.size();

					for(int j=i*(pageInfo.getPageSize());j<count;j++){
						pageQuestions.add(allquestions.get(j));
					}
					pageMap.put("questionList", pageQuestions);					
					logger.info("===开始生成列表模版===");
					// 生成模版页
					String tempPath=htmlTemplate.getTemplateroot();
					//String tempPath = "d:/tmp/game/";
					String templateFileName = "list.html";
					String htmlFilePath=isPreView?htmlTemplate.getPreviewhtmlroot():htmlTemplate.getHtmlroot();
					//String htmlFilePath = "d:/tmp/";
					String dirname = "game/"+gameId+"/all/";
					logger.info("dirname===========>"+dirname);
					File file = new File(htmlFilePath+dirname);
					if(!file.exists()){//如果目录不存在，则创建目录
						file.mkdirs();
					}
					String htmlFileName = dirname + "1.html";					
					logger.info("filename=========>" + htmlFileName);
					FreemarkerUtil.buildHtml(tempPath, templateFileName,pageMap, htmlFilePath, htmlFileName);
					logger.info("===游戏列表模版生成结束===");

					
				}else{
					for(int j=1;j<=pageCount;j++){
						pageInfo.setCurPage(j);
						pageMap.put("pageInfo", pageInfo);
						if(j==pageCount){								
							count = ((pageTotal%(pageInfo.getPageSize()))==0)?(j*(pageInfo.getPageSize())):((j-1)*(pageInfo.getPageSize())+pageTotal%(pageInfo.getPageSize()));
						}else{
							count = j*(pageInfo.getPageSize());	
						}
						
				        pageQuestions.clear();
						for(int jj=(j-1)*(pageInfo.getPageSize());jj<count;jj++){
							pageQuestions.add(allquestions.get(jj));
						}
						pageMap.put("questionList", pageQuestions);
						logger.info("===开始生成游戏列表模版===");
						// 生成模版页
						String tempPath=htmlTemplate.getTemplateroot();
						//String tempPath = "d:/tmp/game/";
						String templateFileName = "list.html";
						String htmlFilePath=isPreView?htmlTemplate.getPreviewhtmlroot():htmlTemplate.getHtmlroot();
						//String htmlFilePath = "d:/tmp/";
						String dirname = "game/"+gameId+"/all/";
						File file = new File(htmlFilePath+dirname);
						if(!file.exists()){//如果目录不存在，则创建目录
							file.mkdirs();
						}
						String htmlFileName = dirname+ j+".html";
						FreemarkerUtil.buildHtml(tempPath, templateFileName,pageMap, htmlFilePath, htmlFileName);
						logger.info("===游戏列表模版生成结束===");

					}												
				}															
			}
			
			
			//生成问题详细页面
			for(Map<String, String> game: gameList){
				gameId = (String) (game.get("gameId"));				
				for (Map type : typeList) {					
					typeId = (String) (type.get("gameId"));
					gameTypeId = (String) (type.get("typeId"));
					if (!gameId.trim().equals(typeId.trim())) {
						continue;// 如果游戏类别 和 游戏不对应
					}
					for (Map question : questionList) {
						questionTypeId = (String) (question.get("typeId"));
						if (gameTypeId.trim().equals(questionTypeId.trim())) {// 查到同一个类别下的所有问题
							//每个问题都需要生成页面
							// 填充页面数据
							String qid = (String)question.get("questionId");
							Map<String, Object> pageMap = new HashMap<String, Object>();
						
							BaseInfo baseInfo = new BaseInfo();
							baseInfo.setGameId(gameId);
							baseInfo.setGameName((String) game.get("gameName"));
							baseInfo.setListOrDetail("detail");
							baseInfo.setPageType("game");
							baseInfo.setTypeId((String)type.get("typeId"));
							baseInfo.setTypeName((String) type.get("typeName"));
							QuestionInfo questionInfo = new QuestionInfo();
							questionInfo.setTitle((String)question.get("questionTitle"));
							questionInfo.setContent(getContent((String)question.get("content")));
							pageMap.put("questionInfo", questionInfo);
							pageMap.put("baseInfo", baseInfo);
							pageMap.put("seomap", getKeyWord());
							pageMap.put("activessideadvdata", getActiviesSideAdvHtml());
							pageMap.put("latestplaygamesideadvdata", getLatestPlayGameSideAdv());
							logger.info("===开始生成详情模版===");							
							//String tempPath = "d:/tmp/game/";
							String tempPath=htmlTemplate.getTemplateroot();
							String templateFileName = "detail.html";
							String htmlFilePath=isPreView?htmlTemplate.getPreviewhtmlroot():htmlTemplate.getHtmlroot();
							//String htmlFilePath = "d:/tmp/";
							String dirname = "question/";
							logger.info("dirname===========>"+dirname);
							File file = new File(htmlFilePath+dirname);
							if(!file.exists()){//如果目录不存在，则创建目录
								file.mkdirs();
							}
							String htmlFileName = dirname +qid+ ".html";					
							logger.info("filename=========>" + htmlFileName);
							FreemarkerUtil.buildHtml(tempPath, templateFileName,pageMap, htmlFilePath, htmlFileName);
							logger.info("===详情模版生成结束===");
						}
					}
					
				}
			}
		} catch (SQLException e) {
			e.printStackTrace();
		} catch (Exception e) {
			e.printStackTrace();
		} finally {
			try {
				allquestions.clear();
				gameList.clear();
				typeList.clear();
				questionList.clear();
				if (articlers != null) {
					articlers.close();
					articlers = null;
				}
				if (typers != null) {
					typers.close();
					typers = null;
				}
				if (gamers != null) {
					gamers.close();
					gamers = null;
				}
				if (conn != null) {
					conn.close();
					conn = null;
				}
			} catch (Exception e) {
				e.printStackTrace();
			}
		}
	}

	
	public void findType(List<Map<String, String>> types,String gameId,List<Map<String, String>> typeList){
		Map<String, String> alltype = new HashMap<String, String>();
		alltype.put("typeId", "all");
		alltype.put("typeName", "全部");
		types.add(alltype);
		for(Map<String, String> type:typeList){
			String typeGameId = (String)(type.get("gameId"));
			if(typeGameId.trim().equals(gameId.trim())){
				types.add(type);
			}
		}
	}
	
	public void findQuestion(List<Map<String, String>> allquestions,List<Map<String, String>> typeList,String gameId,List<Map<String, String>> questionList){
		for(Map<String, String> type:typeList){
			String typeGameId = (String)(type.get("gameId"));
			if(typeGameId.trim().equals(gameId.trim())){
				String questiontypeid = (String)(type.get("typeId"));
				for(Map<String, String> question:questionList){
					if(questiontypeid.trim().equals((String)question.get("typeId").trim())){
						allquestions.add(question);
					}
				}
			}
		}
	}
	
	private Map<String,Object> getKeyWord() {
        Map<String,Object> map=new HashMap<String,Object>();
        List<LinkInfo> llist=FacadeFactory.INSTANCE.getLinkInfoBo().getValidteLinkInfoListByLinkLocId(LinkLocationIdConstant.NIUX_OFFICIAL_KEYWORD, 1, false);
        for(LinkInfo linkinfo:llist){
            map.put("title",linkinfo.getLinktitle()==null?"":linkinfo.getLinktitle());
            map.put("desc",linkinfo.getLinkdesc()==null?"":linkinfo.getLinkdesc());
            map.put("keyword",linkinfo.getExt1()==null?"":linkinfo.getExt1());
        }
        return map;
    }

	/**
	 * 获取我的奖品旁的广告位
	 * @return
	 */
	private LinkInfo getActiviesSideAdvHtml(){
		LinkInfo linkInfo=FacadeFactory.INSTANCE.getLinkInfoBo().getValidteLinkInfoByLinkLocId(LinkLocationIdConstant.NIUX_OFFICIAL_MYACTIVITYSIDE_ADV, ispreview);
        return linkInfo;
	}
	/**
	 * 最近玩过的游戏旁广告
	 * @return
	 */
	private String getLatestPlayGameSideAdv(){
		StringBuilder sb=new StringBuilder();
		//获取广告
		LinkInfo li=FacadeFactory.INSTANCE.getLinkInfoBo().getValidteLinkInfoByLinkLocId(LinkLocationIdConstant.NIUX_OFFICIAL_LATESTPALYGAMESIDE_ADV,ispreview);
		if(li==null){
			return "";
		}
		//获取游戏信息
		Games g=FacadeFactory.INSTANCE.getGamesBo().getGameByGameId(li.getGameidbytuijian());
		//获取最新开区
		GameServers gstemp=FacadeFactory.INSTANCE.getGameServersBo().getLatestGameServerByGameId(li.getGameidbytuijian(), ispreview);
		if(g==null||gstemp==null){
			return "";
		}
		sb.append("您最近还没玩游戏，不过听说他们最近都在玩\"").append(g.getGameName()).append("\",推荐你也  <a href=\"javascript:niux.game.enter_game(").append(gstemp.getFenQuNum()).append(",'").append(g.getGameNo())
		.append("');\">去试试&gt;&gt;</a>");
		return sb.toString();
	}

	
	

	/**
	 * 生成游戏类常见问题模版
	 */
	private void buildCommonPlanformQuestion() {
		Connection conn = JdbcUtil.getConnection();
		String sql = "SELECT contentno,pcontentno,contentname FROM `contents` WHERE pcontentno = '000700010004' AND inuser='1'";// 取出所有问题分类
		ResultSet typers = JdbcUtil.getResultSet(conn, sql);
		logger.info("sql==============>"+sql);
		sql = "SELECT seqid,articleno,title,contents FROM `articles` WHERE articleno LIKE '000700010004%'";// 取得类别下所有文章
		ResultSet articlers = JdbcUtil.getResultSet(conn, sql);
	    sql = "SELECT contentno,pcontentno,contentname FROM `contents` WHERE pcontentno = '00050001' AND inuser='1'";// 取出所有游戏
	    ResultSet gamers = JdbcUtil.getResultSet(conn, sql);
		List<Map<String, String>> questionList = new ArrayList<Map<String, String>>();
		List<Map<String, String>> typeList = new ArrayList<Map<String, String>>();
		List<Map<String, String>> gameList = new ArrayList<Map<String, String>>();
		List<Map<String,String>> allquestions = new ArrayList<Map<String,String>>();
		Map<String,String> alltype = new HashMap<String,String>();
		alltype.put("typeId", "all");
		alltype.put("typeName", "全部");
		typeList.add(alltype);
		try{
			while (typers.next()) {
				Map type = new HashMap();
				type.put("gameId", typers.getString("pcontentno"));
				type.put("typeId", typers.getString("contentno"));
				type.put("typeName", typers.getString("contentname"));
				typeList.add(type);
			}
			logger.info("typeList.size============>" + typeList.size());
			while (articlers.next()) {
				Map article = new HashMap();
				article.put("questionId", articlers.getString("seqid"));
				article.put("typeId", (String) (articlers.getString("articleno")));
				article.put("questionTitle", articlers.getString("title"));
				article.put("content", articlers.getString("contents"));
				questionList.add(article);
			}
			logger.info("questionList.size============>" + questionList.size());
			while (gamers.next()) {
				Map game = new HashMap();
				game.put("gameId", gamers.getString("contentno"));
				game.put("gameName", gamers.getString("contentname"));
				gameList.add(game);
			}
			logger.info("gameList.size============>" + gameList.size());
			
			String typeId = null;
			String questionTypeId = null;
			List<Map<String,String>> questions = new ArrayList<Map<String,String>>();
			for(Map<String,String> type:typeList){
				typeId = (String)type.get("typeId");
				questions.clear();
				for(Map<String,String> question:questionList){
					questionTypeId = (String)question.get("typeId");
					if(questionTypeId.trim().equals(typeId.trim())){
						questions.add(question);	
						allquestions.add(question);
					}
				}
				//计算出一个分类下面有多少个问题
				
				// 填充页面数据
				Map<String, Object> pageMap = new HashMap<String, Object>();
			
				BaseInfo baseInfo = new BaseInfo();
				baseInfo.setGameId("");
				baseInfo.setGameName("");
				baseInfo.setListOrDetail("list");
				baseInfo.setPageType("platform");
				baseInfo.setTypeId((String)type.get("typeId"));
				baseInfo.setTypeName((String) type.get("typeName"));
				pageMap.put("baseInfo", baseInfo);
				
				pageMap.put("seomap", getKeyWord());
				
				pageMap.put("gameList", gameList);
				pageMap.put("typeList", typeList);
				pageMap.put("activessideadvdata", getActiviesSideAdvHtml());
				pageMap.put("latestplaygamesideadvdata", getLatestPlayGameSideAdv());
				PageInfo pageInfo = new PageInfo();
				int i = 0;						
				pageInfo.setPageSize(15);
				int pageTotal = questions.size();//总记录数
				int pageCount = pageTotal%pageInfo.getPageSize()==0?pageTotal/pageInfo.getPageSize():pageTotal/pageInfo.getPageSize()+1;
				if(pageCount<=1){
					pageCount = 1;
				}
				pageInfo.setTotalNum(pageCount);
				
				List<Map<String,String>> pageQuestions = new ArrayList<Map<String,String>>();
				int count = 0;
				if(questions.size() <= pageInfo.getPageSize()){												
					pageInfo.setCurPage(1);
					pageMap.put("pageInfo", pageInfo);
					count = questions.size();

					for(int j=i*(pageInfo.getPageSize());j<count;j++){
						pageQuestions.add(questions.get(j));
					}
					pageMap.put("questionList", pageQuestions);					
					logger.info("===开始生成平台模版===");
					// 生成模版页
					String tempPath=htmlTemplate.getTemplateroot();
					//String tempPath = "d:/tmp/game/";
					String templateFileName = "list.html";
				    String htmlFilePath=isPreView?htmlTemplate.getPreviewhtmlroot():htmlTemplate.getHtmlroot();
					//String htmlFilePath = "d:/tmp/";
					String dirname = "platform/"+typeId+"/";
					logger.info("dirname===========>"+dirname);
					File file = new File(htmlFilePath+dirname);
					if(!file.exists()){//如果目录不存在，则创建目录
						file.mkdirs();
					}
					String htmlFileName = dirname + "1.html";					
					logger.info("filename=========>" + htmlFileName);
					FreemarkerUtil.buildHtml(tempPath, templateFileName,pageMap, htmlFilePath, htmlFileName);
					System.out.println("===平台模版生成结束===");

					
				}else{
					for(int j=1;j<=pageCount;j++){
						pageInfo.setCurPage(j);
						pageMap.put("pageInfo", pageInfo);
						if(j==pageCount){								
							count = ((pageTotal%(pageInfo.getPageSize()))==0)?(j*(pageInfo.getPageSize())):((j-1)*(pageInfo.getPageSize())+pageTotal%(pageInfo.getPageSize()));
						}else{
							count = j*(pageInfo.getPageSize());	

						}
						
				        pageQuestions.clear();
						for(int jj=(j-1)*(pageInfo.getPageSize());jj<count;jj++){
							pageQuestions.add(questions.get(jj));
						}
						pageMap.put("questionList", pageQuestions);
						logger.info("===开始生成平台模版===");
						// 生成模版页
					    String tempPath=htmlTemplate.getTemplateroot();
						//String tempPath = "d:/tmp/game/";
						String templateFileName = "list.html";
						String htmlFilePath=isPreView?htmlTemplate.getPreviewhtmlroot():htmlTemplate.getHtmlroot();
						//String htmlFilePath = "d:/tmp/";
						String dirname = "platform/"+typeId+"/";
						logger.info("dirname===========>"+dirname);
						File file = new File(htmlFilePath+dirname);
						if(!file.exists()){//如果目录不存在，则创建目录
							file.mkdirs();
						}
						String htmlFileName = dirname+ j+".html";
						FreemarkerUtil.buildHtml(tempPath, templateFileName,pageMap, htmlFilePath, htmlFileName);
						logger.info("===平台模版生成结束===");

					}												
				}															

			}
			
			//生成某平台类别下全部问题
			// 填充页面数据
			Map<String, Object> pageMap = new HashMap<String, Object>();
		
			BaseInfo baseInfo = new BaseInfo();
			baseInfo.setGameId("");
			baseInfo.setGameName("");
			baseInfo.setListOrDetail("list");
			baseInfo.setPageType("platform");
			baseInfo.setTypeId("all");
			baseInfo.setTypeName("全部");
			pageMap.put("baseInfo", baseInfo);

			pageMap.put("seomap", getKeyWord());
			
			pageMap.put("gameList", gameList);
			logger.info("gameList================>"+gameList.size());
			pageMap.put("typeList", typeList);
			pageMap.put("activessideadvdata", getActiviesSideAdvHtml());
			pageMap.put("latestplaygamesideadvdata", getLatestPlayGameSideAdv());
			PageInfo pageInfo = new PageInfo();
			int i = 0;					
			pageInfo.setPageSize(15);
			int pageTotal = allquestions.size();//总记录数	
			int pageCount = pageTotal%pageInfo.getPageSize()==0?pageTotal/pageInfo.getPageSize():pageTotal/pageInfo.getPageSize()+1;
			if(pageCount<=1){
				pageCount = 1;
			}
			pageInfo.setTotalNum(pageCount);
			
			List<Map<String,String>> pageQuestions = new ArrayList<Map<String,String>>();
			int count = 0;
			if(allquestions.size() <= pageInfo.getPageSize()){												
				pageInfo.setCurPage(1);
				pageMap.put("pageInfo", pageInfo);
				count = allquestions.size();

				for(int j=i*(pageInfo.getPageSize());j<count;j++){
					pageQuestions.add(allquestions.get(j));
				}
				pageMap.put("questionList", pageQuestions);					
				logger.info("===开始生成平台列表模版===");
				// 生成模版页
				String tempPath=htmlTemplate.getTemplateroot();
				//String tempPath = "d:/tmp/game/";
				String templateFileName = "list.html";
				String htmlFilePath=isPreView?htmlTemplate.getPreviewhtmlroot():htmlTemplate.getHtmlroot();
				//String htmlFilePath = "d:/tmp/";
				String dirname = "platform/all/";
				File file = new File(htmlFilePath+dirname);
				if(!file.exists()){//如果目录不存在，则创建目录
					file.mkdirs();
				}
				String htmlFileName = dirname + "1.html";					
				logger.info("filename=========>" + htmlFileName);
				FreemarkerUtil.buildHtml(tempPath, templateFileName,pageMap, htmlFilePath, htmlFileName);
				logger.info("===平台列表模版生成结束===");

				
			}else{
				for(int j=1;j<=pageCount;j++){
					pageInfo.setCurPage(j);
					pageMap.put("pageInfo", pageInfo);
					if(j==pageCount){								
						count = ((pageTotal%(pageInfo.getPageSize()))==0)?(j*(pageInfo.getPageSize())):((j-1)*(pageInfo.getPageSize())+pageTotal%(pageInfo.getPageSize()));
					}else{
						count = j*(pageInfo.getPageSize());	
					}
					
					logger.info("count=================>"+count);
			        pageQuestions.clear();
					for(int jj=(j-1)*(pageInfo.getPageSize());jj<count;jj++){
						pageQuestions.add(allquestions.get(jj));
					}
					pageMap.put("questionList", pageQuestions);
					logger.info("===开始生成平台列表模版===");
					// 生成模版页
					String tempPath=htmlTemplate.getTemplateroot();
					//String tempPath = "d:/tmp/game/";
					String templateFileName = "list.html";
					String htmlFilePath=isPreView?htmlTemplate.getPreviewhtmlroot():htmlTemplate.getHtmlroot();
					//String htmlFilePath = "d:/tmp/";
					String dirname = "platform/all/";
					File file = new File(htmlFilePath+dirname);
					if(!file.exists()){//如果目录不存在，则创建目录
						file.mkdirs();
					}
					String htmlFileName = dirname+ j+".html";
					FreemarkerUtil.buildHtml(tempPath, templateFileName,pageMap, htmlFilePath, htmlFileName);
					logger.info("===平台列表模版生成结束===");

				}												
			}
			
			
			   //生成问题详细页面			
				for (Map type : typeList) {					
					typeId = (String) (type.get("typeId"));
					for (Map question : questionList) {
						questionTypeId = (String) (question.get("typeId"));
						if (typeId.trim().equals(questionTypeId.trim())) {// 查到同一个类别下的所有问题
							//每个问题都需要生成页面
							// 填充页面数据
							String qid = (String)question.get("questionId");					
							baseInfo.setListOrDetail("detail");
							baseInfo.setPageType("platform");
							baseInfo.setTypeId(typeId);
							baseInfo.setTypeName((String)type.get("typeName"));
							QuestionInfo questionInfo = new QuestionInfo();
							questionInfo.setTitle((String)question.get("questionTitle"));
							questionInfo.setContent(getContent((String)question.get("content")));
							pageMap.put("questionInfo", questionInfo);
							pageMap.put("baseInfo", baseInfo);
							pageMap.put("seomap", getKeyWord());
							pageMap.put("activessideadvdata", getActiviesSideAdvHtml());
							pageMap.put("latestplaygamesideadvdata", getLatestPlayGameSideAdv());
							logger.info("===开始生成详情模版===");	
                            String tempPath=htmlTemplate.getTemplateroot();
							//String tempPath = "d:/tmp/game/";
							String templateFileName = "detail.html";
							String htmlFilePath=isPreView?htmlTemplate.getPreviewhtmlroot():htmlTemplate.getHtmlroot();
							//String htmlFilePath = "d:/tmp/";
							String dirname = "question/";
							logger.info("dirname===========>"+dirname);
							File file = new File(htmlFilePath+dirname);
							if(!file.exists()){//如果目录不存在，则创建目录
								file.mkdirs();
							}
							String htmlFileName = dirname +qid+ ".html";					
							logger.info("filename=========>" + htmlFileName);
							FreemarkerUtil.buildHtml(tempPath, templateFileName,pageMap, htmlFilePath, htmlFileName);
							logger.info("===详情模版生成结束===");
						}
					}
					
				}
			

		}catch(Exception e){
			e.printStackTrace();
		}finally{
			try{
				allquestions.clear();
				gameList.clear();
				typeList.clear();
				questionList.clear();
				if (articlers != null) {
					articlers.close();
					articlers = null;
				}
				if (typers != null) {
					typers.close();
					typers = null;
				}
				if (gamers != null) {
					gamers.close();
					gamers = null;
				}
				if (conn != null) {
					conn.close();
					conn = null;
				}
			}catch(Exception e){
				e.printStackTrace();
			}
		}	
	}
	
	/**
	 * 获得处理过图片的内容
	 * @param content
	 * @return
	 */
	private static String getContent(String content){
		if(content == null||"".equals(content))return "";
		StringBuffer sb = new StringBuffer();
		if(content.indexOf("src=")!=-1){
			String subcontents[]  = content.split("src=");
			int index = 1;
			for(String subcontent:subcontents){
				System.out.println("subcontent:"+subcontent);
				if(index == 1)
				    sb.append(subcontent);				      
				else{
					sb .append(" src=");
					if(subcontent.indexOf("http://")!=-1){
						sb.append(subcontent);
					}else{
						sb.append("\""+PHOTOURL+subcontent.substring(1));
					}
				}			
				index ++;
			}
			return sb.toString();
		}		
		return content;
	}
	
	public static void main(String[] args) throws Exception {
		new CommonQuestionBuilder().executeShcema();
		//String img = "213213阿斯顿发<img src=\"/upload3.0/image/niucha1.jpg \"  width=\"120\" />asdfasdfasdf阿斯顿发<img src=\"/upload3.0/image/niucha1.jpg \"  width=\"120\" />123213<img src=\"/upload3.0/image/niucha1.jpg \"  width=\"120\" />";
		//System.out.println(getContent(img));
	}
}





