package com.xunlei.niux.manager.template.builder.propmarket;


import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import com.ferret.common.dao.enums.OrderType;
import com.ferret.common.dao.vo.Page;
import com.xunlei.niux.data.vipgame.facade.FacadeFactory;
import com.xunlei.niux.data.vipgame.vo.GameServers;
import com.xunlei.niux.data.vipgame.vo.Games;
import com.xunlei.niux.data.vipgame.vo.LinkInfo;
import com.xunlei.niux.data.vipgame.vo.MarketProduct;
import com.xunlei.niux.manager.constant.LinkLocationIdConstant;
import com.xunlei.niux.manager.template.builder.AbstractTemplateBuilder;
import com.xunlei.niux.manager.web.cache.GameCache;
import com.xunlei.niux.manager.web.util.FreemarkerUtil;

/**
 * 道具商城模版生成工具
 * @author lisu
 *  2013-07-05
 */
public class MarketBuilder extends AbstractTemplateBuilder {
	  private List<MarketProduct> mplist;
	
	  private boolean ispreview = false;//是否预览
	  
		public static void main(String args[]) {
			try {
				new MarketBuilder().executeShcema();
			} catch (Exception e) {
				e.printStackTrace();
			}
		}

	 /**
	  * 获得普通商品列表	
	  * @return
	  * @throws Exception
	  */
	 public List<MarketProduct> getCommonMarketProductList() throws Exception{
		 if(mplist == null){
			 initProduct();
		 }
		 return mplist;
	 }
	 
	 @Override
	 public void executeShcema() throws Exception {
		 makeIndex();//生成主页
		
	}
	
	 /**
	  *  生成主页
	  * @throws Exception
	  */
	 private void makeIndex()  throws Exception{
			Map<String,Object> rootMap=new HashMap<String,Object>();
			Map<String,String> games = getGames();
			rootMap.put("newestPropList", getNewestPropList(games));
			rootMap.put("hotPropList",getHotPropList(games));
			rootMap.put("propOne",getPropOne(games));
			rootMap.put("propTwo",getPropTwo(games));
			rootMap.put("sliderImgList", getSliderImgList());	
			rootMap.put("propGameList", getPropGameList());	
			rootMap.put("latestplaygamesideadvdata", getLatestPlayGameSideAdv());
			rootMap.put("propMarketKfMap", getPropMarketKfMap());			
//	        String root = "c:/tmp/office/market/";
//	        String roothtml = "c:/tmp/office/market/test/";
//			FreemarkerUtil.buildHtml(root, "index.html", rootMap, roothtml,
//					"index.html");
			String htmlFilePath=isPreView?htmlTemplate.getPreviewhtmlroot():htmlTemplate.getHtmlroot();
			if(htmlFilePath.endsWith("/")){
				htmlFilePath=htmlFilePath.substring(0, htmlFilePath.length()-1);
			}
			FreemarkerUtil.buildHtml(htmlTemplate.getTemplateroot(),
					"index.html", rootMap, htmlFilePath,
					"index.html");
            FreemarkerUtil.buildHtml(htmlTemplate.getTemplateroot(),
                 "propmarket_side.html", rootMap, htmlFilePath,
                 "propmarket_side.html");
			
	 }
	 	 
	
	/**
	 * 获得道具商城首页轮播图
	 * @return
	 * @throws Exception
	 */
	public List<Map<String,Object>> getSliderImgList() throws Exception{
		   //具商城首页轮播图的数据
		    List<LinkInfo> list = FacadeFactory.INSTANCE.getLinkInfoBo().getValidteLinkInfoListByLinkLocId("611", 5, false);  //获得按生效时间逆序的 5 条数据
		    if(list==null||list.size()==0)return null;
		    List<Map<String,Object>> result = new ArrayList<Map<String,Object>>();
		    for(int i=0;i<list.size();i++){		    	  
		    	  LinkInfo info = list.get(i);
		    	  Map<String,Object> map = new HashMap<String,Object>();
		    	  map.put("img", info.getPicurl());
		    	  map.put("url", info.getLinkurl());
		    	  map.put("title", info.getLinktitle());
		    	  result.add(map);
		    }
		    return result;
	}
	
	/**
	 * 获得道具商城最新的一个特惠商品
	 * @return
	 * @throws Exception
	 */
	public Map<String,Object> getPropOne(Map<String,String> games) throws Exception{
		//道具商城最新的一个特惠商品
		MarketProduct product = new MarketProduct();
		product.setType(new Integer(2));//特惠商品
		product.setIsValid(true);//有效的商品
		Page page = new Page();
		page.addOrder("display", OrderType.DESC);//排序
		page.addOrder("validateTime", OrderType.DESC);//生效时间
		List<MarketProduct> mplist = FacadeFactory.INSTANCE.getMarketProductBo().findMarketProduct(product, page);
		if(mplist == null||mplist.size()==0)return null;
		
		MarketProduct mp = mplist.get(0);//取得排序最前一个特惠商品	  
		 Map<String,Object> result = new HashMap<String,Object>();
	    String gameid = mp.getGameId();//获得游戏编号
		Games game=GameCache.getInstance().getGameByGameId(gameid);
	    result.put("id", mp.getSeqid());
	    result.put("type", 2);
	    result.put("title", mp.getTitle());
	    result.put("gameNo", game.getGameNo());
	    result.put("gameName", game.getGameName());
	    result.put("price", mp.getPrice());
	    result.put("discountPrice", mp.getDiscountPrice());
	    result.put("hotGrade",mp.getHotGrade());
	    result.put("sImg", mp.getSmallImg());//有效期
	    result.put("desc", mp.getDescrition());
	    result.put("content", mp.getContent());
	    result.put("saleNum", mp.getSaleSum());
        result.put("gameId",mp.getGameId());
        result.put("isPay",mp.getIsPay());
        result.put("realPayMoney",mp.getMoney());
        if(games == null){
        	result.put("payMode","3");
        }else{
        	result.put("payMode",games.get(mp.getGameId())==null?"3":games.get(mp.getGameId()));
        }
	    List<String> bImgList = new ArrayList<String>();
	    if(mp.getBigImg1() != null && !"".equals(mp.getBigImg1())){
	    	bImgList.add(mp.getBigImg1());
	    }
	    if(mp.getBigImg2() != null && !"".equals(mp.getBigImg2())){
	    	bImgList.add(mp.getBigImg2());
	    }
	    if(mp.getBigImg3() != null && !"".equals(mp.getBigImg3())){
	    	bImgList.add(mp.getBigImg3());
	    }
	    if(mp.getBigImg4() != null && !"".equals(mp.getBigImg4())){
	    	bImgList.add(mp.getBigImg4());
	    }
	    if(mp.getBigImg5() != null && !"".equals(mp.getBigImg5())){
	    	bImgList.add(mp.getBigImg5());
	    }
	    result.put("bImgList", bImgList);	 	  	    

		return result;
	}
	
	public Map<String,String> getGames(){
        LinkInfo info = new LinkInfo();
        info.setLinklocid("610");
        List<LinkInfo> linklist = FacadeFactory.INSTANCE.getLinkInfoBo().find(info, new Page());
        if(linklist == null||linklist.size()==0)return null;
        Map<String,String> result = new HashMap<String,String>();
        for(LinkInfo li:linklist){
        	result.put(li.getGameidbytuijian(), li.getExt1());
        }
        return result;
	}
	
	/**
	 * 获得道具商城最新的一个限时抢购商品
	 * @return
	 * @throws Exception
	 */
	public Map<String,Object> getPropTwo(Map<String,String> games) throws Exception{
		//道具商城最新的一个限时抢购商品
		MarketProduct product = new MarketProduct();
		product.setType(new Integer(3));//限时抢购商品
		product.setIsValid(true);//有效的商品
		Page page = new Page();
		page.addOrder("display", OrderType.DESC);//排序
		page.addOrder("validateTime", OrderType.DESC);//生效时间
		List<MarketProduct> mplist = FacadeFactory.INSTANCE.getMarketProductBo().findMarketProduct(product, page);
		if(mplist == null||mplist.size()==0)return null;
		
		MarketProduct mp = mplist.get(0);//取得排序最前一个限时抢购商品  
		 Map<String,Object> result = new HashMap<String,Object>();
	    String gameid = mp.getGameId();//获得游戏编号
		Games game=GameCache.getInstance().getGameByGameId(gameid);
	    result.put("id", mp.getSeqid());
	    result.put("type", 3);
	    result.put("title", mp.getTitle());
	    result.put("gameNo", game.getGameNo());
	    result.put("gameName", game.getGameName());
	    result.put("price", mp.getPrice());
	    result.put("discountPrice", mp.getDiscountPrice());
	    result.put("validateTime",mp.getValidateTime());
	    result.put("sImg", mp.getSmallImg());//有效期
	    result.put("desc", mp.getDescrition());
	    result.put("content", mp.getContent());
	    result.put("saleNum", mp.getSaleSum());
        result.put("gameId",mp.getGameId());
        result.put("isPay",mp.getIsPay());
        result.put("realPayMoney",mp.getMoney());
        if(games == null){
        	result.put("payMode","3");
        }else{
        	result.put("payMode",games.get(mp.getGameId())==null?"3":games.get(mp.getGameId()));
        }
	    List<String> bImgList = new ArrayList<String>();
	    if(mp.getBigImg1() != null && !"".equals(mp.getBigImg1())){
	    	bImgList.add(mp.getBigImg1());
	    }
	    if(mp.getBigImg2() != null && !"".equals(mp.getBigImg2())){
	    	bImgList.add(mp.getBigImg2());
	    }
	    if(mp.getBigImg3() != null && !"".equals(mp.getBigImg3())){
	    	bImgList.add(mp.getBigImg3());
	    }
	    if(mp.getBigImg4() != null && !"".equals(mp.getBigImg4())){
	    	bImgList.add(mp.getBigImg4());
	    }
	    if(mp.getBigImg5() != null && !"".equals(mp.getBigImg5())){
	    	bImgList.add(mp.getBigImg5());
	    }
	    result.put("bImgList", bImgList);	 	  	    

		return result;
	}
	
	
	/**
	 * 礼包上面的标签
	 * @return
	 */
	public 	String  getGiftListAdText(){
		LinkInfo linkInfo = new LinkInfo();
	    linkInfo.setLinklocid("606");//会员专区标签配置中最新的一条数据
	    Page page = new Page();
	    page.addOrder("validdatetime", OrderType.DESC);
	    List<LinkInfo> list = FacadeFactory.INSTANCE.getLinkInfoBo().find(linkInfo, page);	    
	    if(list == null||list.size()==0)return null;
	    LinkInfo ino = list.get(0);
	    return ino.getLinktitle()==null?"":ino.getLinktitle();
	}
	
	/**
	 * 初始化普通奖品
	 */
	public void initProduct() throws Exception{
		 MarketProduct product = new MarketProduct();
	     product.setType(new Integer(1));//普通商品
	     product.setIsValid(true);//有效的商品
	     List<MarketProduct> mplist = FacadeFactory.INSTANCE.getMarketProductBo().findMarketProduct(product, new Page());
		this.mplist = mplist;
	}
	
	/**
	 * 获得热门道具
	 * @return
	 */
	public List<Map<String,Object>> getHotPropList(Map<String,String> games) throws Exception{
	     List<MarketProduct> mplist = getCommonMarketProductList();
		 List<LinkInfo> list = FacadeFactory.INSTANCE.getLinkInfoBo().getValidteLinkInfoListByLinkLocId("612", 6, false); //热门道具    
		 if(list == null || list.size()==0)return null;
		 List<Map<String,Object>> result = new ArrayList<Map<String,Object>>();
		 for(LinkInfo info:list){
			 long  id = new Long(info.getLinktitle());
			 for(MarketProduct mp:mplist){
				if(id == mp.getSeqid().longValue()){//如果找到对应的普通商品信息
					Map<String,Object> map = new HashMap<String,Object>();
					String gameid = mp.getGameId();
					Games game=GameCache.getInstance().getGameByGameId(gameid);
					map.put("id", id);
					map.put("type",1);
					map.put("title", mp.getTitle());
					map.put("gameName", game.getGameName());
					map.put("gameNo", game.getGameNo());
					map.put("price",mp.getPrice());
					map.put("sImg", mp.getSmallImg());
					map.put("desc", mp.getDescrition());
					map.put("content", mp.getContent());
					map.put("saleNum", mp.getSaleSum());
                    map.put("gameId",mp.getGameId());
                    map.put("isPay",mp.getIsPay());
                    map.put("realPayMoney",mp.getMoney());
                    if(games == null){
                    	map.put("payMode","3");
                    }else{
                    	map.put("payMode",games.get(mp.getGameId())==null?"3":games.get(mp.getGameId()));
                    }
					List<String> bImgList = new ArrayList<String>();
				    if(mp.getBigImg1() != null && !"".equals(mp.getBigImg1())){
				    	bImgList.add(mp.getBigImg1());
				    }
				    if(mp.getBigImg2() != null && !"".equals(mp.getBigImg2())){
				    	bImgList.add(mp.getBigImg2());
				    }
				    if(mp.getBigImg3() != null && !"".equals(mp.getBigImg3())){
				    	bImgList.add(mp.getBigImg3());
				    }
				    if(mp.getBigImg4() != null && !"".equals(mp.getBigImg4())){
				    	bImgList.add(mp.getBigImg4());
				    }
				    if(mp.getBigImg5() != null && !"".equals(mp.getBigImg5())){
				    	bImgList.add(mp.getBigImg5());
				    }
				    map.put("bImgList", bImgList);	 	 
				    result.add(map);
				}				
		  	 }
		 }
		 return result;
	}
	
	/**
	 * 获得最新推荐
	 * @return
	 */
	public List<Map<String,Object>> getNewestPropList(Map<String,String> games) throws Exception{
	     List<MarketProduct> mplist = getCommonMarketProductList();
		 List<LinkInfo> list = FacadeFactory.INSTANCE.getLinkInfoBo().getValidteLinkInfoListByLinkLocId("613", 6, false); //最新推荐    
		 if(list == null || list.size()==0)return null;
		 List<Map<String,Object>> result = new ArrayList<Map<String,Object>>();
		 for(LinkInfo info:list){
			 long  id = new Long(info.getLinktitle());
			 for(MarketProduct mp:mplist){
				if(id == mp.getSeqid().longValue()){//如果找到对应的普通商品信息
					Map<String,Object> map = new HashMap<String,Object>();
					String gameid = mp.getGameId();
					Games game=GameCache.getInstance().getGameByGameId(gameid);
					map.put("id", id);
					map.put("type",1);
					map.put("title", mp.getTitle());
					map.put("gameName", game.getGameName());
					map.put("gameNo", game.getGameNo());
					map.put("price",mp.getPrice());
					map.put("sImg", mp.getSmallImg());
					map.put("desc", mp.getDescrition());
					map.put("content", mp.getContent());
					map.put("saleNum", mp.getSaleSum());
                    map.put("gameId",mp.getGameId());
                    map.put("isPay",mp.getIsPay());
                    map.put("realPayMoney",mp.getMoney());
                    if(games == null){
                    	map.put("payMode","3");
                    }else{
                    	map.put("payMode",games.get(mp.getGameId())==null?"3":games.get(mp.getGameId()));
                    }
					List<String> bImgList = new ArrayList<String>();
				    if(mp.getBigImg1() != null && !"".equals(mp.getBigImg1())){
				    	bImgList.add(mp.getBigImg1());
				    }
				    if(mp.getBigImg2() != null && !"".equals(mp.getBigImg2())){
				    	bImgList.add(mp.getBigImg2());
				    }
				    if(mp.getBigImg3() != null && !"".equals(mp.getBigImg3())){
				    	bImgList.add(mp.getBigImg3());
				    }
				    if(mp.getBigImg4() != null && !"".equals(mp.getBigImg4())){
				    	bImgList.add(mp.getBigImg4());
				    }
				    if(mp.getBigImg5() != null && !"".equals(mp.getBigImg5())){
				    	bImgList.add(mp.getBigImg5());
				    }
				    map.put("bImgList", bImgList);	 	 
				    result.add(map);
				}				
		  	 }
		 }
		 return result;
	}
	
	/**
	 * 获得配置过商品的游戏
	 * @return
	 */
	public List<Map<String,Object>> getPropGameList() throws Exception{
		 List<Map<String,Object>> result = new ArrayList<Map<String,Object>>();
		 Set<String> gameSet = new HashSet<String>();
		 MarketProduct product = new MarketProduct();
	     product.setIsValid(true);//有效的商品
	     List<MarketProduct> mplist = FacadeFactory.INSTANCE.getMarketProductBo().findMarketProduct(product, new Page());
	     for(MarketProduct mp:mplist){
	    	 gameSet.add(mp.getGameId());//统计有多少种游戏
	     }
	     	     
	     //查询配置游戏相关的客服信息
	     LinkInfo info = new LinkInfo();
	     info.setLinklocid("615");
	     List<LinkInfo> lilist = FacadeFactory.INSTANCE.getLinkInfoBo().find(info, new Page());
	     
	     
	     for(Iterator<String> iter=gameSet.iterator();iter.hasNext();){
	    	 String gameid = iter.next();
	    	 Games game=GameCache.getInstance().getGameByGameId(gameid);
	    	 Map<String,Object> map = new HashMap<String,Object>();
	    	 map.put("gameNo", game.getGameNo());
	    	 map.put("gameName", game.getGameName());
	    	 
	    	 List<Map<String,Object>> propList = new ArrayList<Map<String,Object>>();
	    	 //生成游戏商品
	    	 for(MarketProduct mp:mplist){
	    		 if(mp.getGameId().trim().equals(gameid.trim())){
	    			    Map<String,Object> myresult = new HashMap<String,Object>();
	    			    myresult.put("id", mp.getSeqid());
	    			    myresult.put("type", mp.getType());
	    			    myresult.put("title", mp.getTitle());
	    			    myresult.put("gameNo", game.getGameNo());
	    			    myresult.put("gameName", game.getGameName());
	    			    myresult.put("price", mp.getPrice());
	    			    myresult.put("discountPrice", mp.getDiscountPrice());
	    			    myresult.put("validateTime",mp.getValidateTime());
	    			    myresult.put("sImg", mp.getSmallImg());//有效期
	    			    myresult.put("desc", mp.getDescrition());
	    			    myresult.put("content", mp.getContent());
	    			    myresult.put("saleNum", mp.getSaleSum());
	    			    List<String> bImgList = new ArrayList<String>();
	    			    if(mp.getBigImg1() != null && !"".equals(mp.getBigImg1())){
	    			    	bImgList.add(mp.getBigImg1());
	    			    }
	    			    if(mp.getBigImg2() != null && !"".equals(mp.getBigImg2())){
	    			    	bImgList.add(mp.getBigImg2());
	    			    }
	    			    if(mp.getBigImg3() != null && !"".equals(mp.getBigImg3())){
	    			    	bImgList.add(mp.getBigImg3());
	    			    }
	    			    if(mp.getBigImg4() != null && !"".equals(mp.getBigImg4())){
	    			    	bImgList.add(mp.getBigImg4());
	    			    }
	    			    if(mp.getBigImg5() != null && !"".equals(mp.getBigImg5())){
	    			    	bImgList.add(mp.getBigImg5());
	    			    }
	    			    myresult.put("bImgList", bImgList);	 
	    			    propList.add(myresult);
	    		 }
	    	 }
	    	 makeGameNo(game.getGameNo(),map,propList);
	    	 result.add(map);
	     }
	     Map<String,String> games = getGames();
	     for(MarketProduct mp:mplist){
	    	 Games game=GameCache.getInstance().getGameByGameId(mp.getGameId());
	    	 makeProductDetail(lilist,games,mp,game);
	     }	     
		 return result;
	}
	
   /**
    * 生成游戏商品
    * @param map
    * @param propList
    * @throws Exception
    */
	public void makeGameNo(String gameNo,Map<String,Object> map,List<Map<String,Object>> propList) throws Exception{		
		Map<String,Object> rootMap=new HashMap<String,Object>();
		rootMap.put("propPageInfo",map);
		rootMap.put("propList",propList);	
//        String root = "c:/tmp/office/market/";
//        String roothtml = "c:/tmp/office/market/test/";
//		FreemarkerUtil.buildHtml(root, "gameNo.html", rootMap, roothtml,
//				gameNo+".html");
		String htmlFilePath=isPreView?htmlTemplate.getPreviewhtmlroot():htmlTemplate.getHtmlroot();
		if(htmlFilePath.endsWith("/")){
			htmlFilePath=htmlFilePath.substring(0, htmlFilePath.length()-1);
		}
		FreemarkerUtil
		.buildHtml(htmlTemplate.getTemplateroot(),
				"gameNo.html", rootMap, htmlFilePath,
				gameNo+".html");
	}
	
	
	/**
	 * 获得道具商城首页客服
	 * @return
	 * @throws Exception
	 */
	public Map<String,Object> getPropMarketKfMap() throws Exception{
		 Map<String,Object> map = new HashMap<String,Object>();
		  //查询配置游戏相关的客服信息
	     LinkInfo lif = new LinkInfo();
	     lif.setLinklocid("615");
	     List<LinkInfo> lilist = FacadeFactory.INSTANCE.getLinkInfoBo().find(lif, new Page());
	     
	     Set<String> gameSet = new HashSet<String>();
	     for(LinkInfo info:lilist){	
	    	 gameSet.add(info.getGameid().trim());
	     }
	     for(Iterator<String> iter=gameSet.iterator();iter.hasNext();){
	    	
	    	 List<Map<String,String>> list = new ArrayList<Map<String,String>>();
	    	 String gameid = iter.next();
	    	 String gameNo = null;
	    	 for(LinkInfo info:lilist){	
	    		 String mygameid = info.getGameid().trim();
	    		 if(gameid.equals(mygameid)){
	    			 Games games = GameCache.getInstance().getGameByGameId(gameid);
	    			 gameNo = games.getGameNo();
	    			 Map<String,String> m  = new HashMap<String,String>();
    				 m.put("name",info.getLinktitle());
    				 m.put("tel",info.getExt2());
    				 m.put("qq",info.getExt3());
    				 list.add(m);
	    		 }
	    	 }
	    	 map.put(gameNo, list);
	     }
	   return map;
	}
	
	/**
	 * 生成商品详情
	 * @param lilist
	 * @param mp
	 * @throws Exception
	 */
	public void makeProductDetail(List<LinkInfo> lilist,Map<String,String> games,MarketProduct mp,Games game) throws Exception{
		    Map<String,Object> rootMap=new HashMap<String,Object>();
		    Map<String,Object> myresult = new HashMap<String,Object>();
		    myresult.put("id", mp.getSeqid());
		    myresult.put("type", mp.getType());
		    myresult.put("title", mp.getTitle());
		    myresult.put("gameNo", game.getGameNo());
		    myresult.put("gameName", game.getGameName());
		    myresult.put("price", mp.getPrice());
		    myresult.put("discountPrice", mp.getDiscountPrice());
		    myresult.put("validateTime",mp.getValidateTime());
		    myresult.put("sImg", mp.getSmallImg());//有效期
		    myresult.put("desc", mp.getDescrition());
		    myresult.put("content", mp.getContent());
		    myresult.put("saleNum", mp.getSaleSum());
            myresult.put("gameId",mp.getGameId());
            myresult.put("isPay",mp.getIsPay());
            myresult.put("realPayMoney",mp.getMoney());
            if(games == null){
            	 myresult.put("payMode","3");
            }else{
            	 myresult.put("payMode",games.get(mp.getGameId())==null?"3":games.get(mp.getGameId()));
            }
           
		    List<String> bImgList = new ArrayList<String>();
		    if(mp.getBigImg1() != null && !"".equals(mp.getBigImg1())){
		    	bImgList.add(mp.getBigImg1());
		    }
		    if(mp.getBigImg2() != null && !"".equals(mp.getBigImg2())){
		    	bImgList.add(mp.getBigImg2());
		    }
		    if(mp.getBigImg3() != null && !"".equals(mp.getBigImg3())){
		    	bImgList.add(mp.getBigImg3());
		    }
		    if(mp.getBigImg4() != null && !"".equals(mp.getBigImg4())){
		    	bImgList.add(mp.getBigImg4());
		    }
		    if(mp.getBigImg5() != null && !"".equals(mp.getBigImg5())){
		    	bImgList.add(mp.getBigImg5());
		    }
		    myresult.put("bImgList", bImgList);	 
		    
		    rootMap.put("propMap", myresult);
		    List<Map<String,Object>> kfList = new ArrayList<Map<String,Object>>();
		    
			for(LinkInfo info:lilist){
				if(info.getGameid().trim().equals(mp.getGameId())){//查询出该商品对应游戏的客服
					Map<String,Object> m  = new HashMap<String,Object>();
					m.put("name",info.getLinktitle());
					m.put("tel",info.getExt2());
					m.put("qq",info.getExt3());
					kfList.add(m);
				}
			}
			 rootMap.put("kfList", kfList);
			 
//	        String root = "c:/tmp/office/market/";
//	        String roothtml = "c:/tmp/office/market/test/";
//			FreemarkerUtil.buildHtml(root, "detail.html", rootMap, roothtml,
//					mp.getSeqid()+".html");
			String htmlFilePath=isPreView?htmlTemplate.getPreviewhtmlroot():htmlTemplate.getHtmlroot();
			if(htmlFilePath.endsWith("/")){
				htmlFilePath=htmlFilePath.substring(0, htmlFilePath.length()-1);
			}
			FreemarkerUtil
			.buildHtml(htmlTemplate.getTemplateroot(),
					"detail.html", rootMap, htmlFilePath+"/detail",
					mp.getSeqid()+".html");
	}
	
	
	/**
	 * 最近玩过的游戏旁广告
	 * @return
	 */
	private Map<String,Object> getLatestPlayGameSideAdv(){
		Map<String,Object> map = new HashMap<String,Object>();		
		//获取广告
		LinkInfo li=FacadeFactory.INSTANCE.getLinkInfoBo().getValidteLinkInfoByLinkLocId(LinkLocationIdConstant.NIUX_OFFICIAL_LATESTPALYGAMESIDE_ADV,ispreview);
		if(li==null){
			return map;
		}
		//获取游戏信息
		Games g=FacadeFactory.INSTANCE.getGamesBo().getGameByGameId(li.getGameidbytuijian());
		//获取最新开区
		GameServers gstemp=FacadeFactory.INSTANCE.getGameServersBo().getLatestGameServerByGameId(li.getGameidbytuijian(), ispreview);
		if(g==null||gstemp==null){
			return map;
		}
		map.put("gameName", g.getGameName());
		map.put("serverId", gstemp.getFenQuNum());
		map.put("gameNo", g.getGameNo());
		map.put("gameOfficialUrl", g.getOfficialWebSite());
		return map;
	}
}
