package com.xunlei.niux.manager.template.builder.pinpaye;

import java.io.File;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

import com.xunlei.httptool.util.JsonObjectUtil;
import com.xunlei.niux.data.vipgame.facade.FacadeFactory;
import com.xunlei.niux.data.vipgame.vo.GameServers;
import com.xunlei.niux.data.vipgame.vo.Games;
import com.xunlei.niux.data.vipgame.vo.LinkInfo;
import com.xunlei.niux.manager.template.builder.AbstractTemplateBuilder;
import com.xunlei.niux.manager.web.util.FileUploadUtil;
import com.xunlei.niux.manager.web.util.FileUtil;

public class PinPayYeBuilder extends AbstractTemplateBuilder {

	public void executeShcema() throws Exception {
		buildTuiJianFenQu();
		buildTuiJianGame();
	}
	private void buildTuiJianFenQu()throws Exception{
		
		LinkInfo li=FacadeFactory.INSTANCE.getLinkInfoBo().getValidteLinkInfoByLinkLocId("209", isPreView);
		if(li==null){
			throw new Exception("没有满足条件的推荐分区");
		}
		Map<String,Object> root=new HashMap<String,Object>();
		root.put("isentergame", String.valueOf(!li.getIsjump()));
		if(li.getIsjump()){	
			root.put("jumpurl",  li.getLinkurl());
			root.put("gameno", "");
			root.put("gameid", "");
			root.put("fenqunum", "");
			root.put("seqid", "");
			root.put("isenterbox", "");
			root.put("serverid", "");
			root.put("fenquname", "");
			root.put("picurl","");
		}else{
			//获取游戏信息
			Games games=FacadeFactory.INSTANCE.getGamesBo().getGameByGameId(li.getGameidbytuijian());
			GameServers queryGS=new GameServers();
			queryGS.setGameId(li.getGameidbytuijian());
			queryGS.setFenQuNum(Integer.valueOf(li.getExt1()));
			List<GameServers> gsList=FacadeFactory.INSTANCE.getGameServersBo().findGameServers(queryGS, 1, 1);
			if(gsList==null||gsList.size()==0){
				throw new RuntimeException(li.getGameidbytuijian()+"游戏的分区"+li.getExt1()+"不存在");
			}
			GameServers gs=gsList.get(0);
			root.put("jumpurl",  li.getLinkurl());
			root.put("gameno", games.getGameNo());
			root.put("gameid", games.getGameId());
			root.put("fenqunum", String.valueOf(gs.getFenQuNum()));
			root.put("seqid", String.valueOf(gs.getSeqId()));
			root.put("isenterbox",li.getExt2());
			root.put("serverid",gs.getServerId());
			root.put("fenquname", gs.getFenQuName());
			root.put("picurl",li.getPicurl());
		}
		String jsonStr=JsonObjectUtil.getDataJsonObject(root);
	    jsonStr="var PIN_PA_YE_FENQU_INFO="+jsonStr;
		String htmlFilePath=isPreView?htmlTemplate.getPreviewhtmlroot():htmlTemplate.getHtmlroot();
	    File file=FileUtil.createFile(htmlFilePath, "pinpayefenquinfo.js");
	    FileUploadUtil.write(file, jsonStr);
	
	}
	private void buildTuiJianGame()throws Exception{
		List<LinkInfo> list=FacadeFactory.INSTANCE.getLinkInfoBo().getValidteLinkInfoListByLinkLocId("210", 4, isPreView);
		List<Object> tlist=new ArrayList<Object>();
		for(LinkInfo li:list){
			Map<String,Object> map=new HashMap<String,Object>();
			Games game=FacadeFactory.INSTANCE.getGamesBo().getGameByGameId(li.getGameidbytuijian());
			map.put("gameId", li.getGameidbytuijian());
			map.put("gameNo", game==null?"":game.getGameNo());
			map.put("picUrl", li.getPicurl());
			map.put("officialUrl", game==null?"":game.getOfficialWebSite());
			tlist.add(map);
		}
		String jsonStr=JsonObjectUtil.getDataJsonObject(tlist);
	    jsonStr="var PINPAYETUIJIANGAME="+jsonStr;
		String htmlFilePath=isPreView?htmlTemplate.getPreviewhtmlroot():htmlTemplate.getHtmlroot();
	    File file=FileUtil.createFile(htmlFilePath, "pinpayetuijiangame.js");
	    FileUploadUtil.write(file, jsonStr);
	}
}
