package com.xunlei.niux.manager.template.builder.pay;

import com.xunlei.common.util.StringTools;
import com.xunlei.niux.data.vipgame.facade.FacadeFactory;
import com.xunlei.niux.data.vipgame.vo.*;
import com.xunlei.niux.manager.template.builder.AbstractTemplateBuilder;
import com.xunlei.niux.manager.web.util.FreemarkerUtil;
import freemarker.ext.beans.BeansWrapper;
import org.apache.log4j.Logger;
import java.text.SimpleDateFormat;
import java.util.*;

/**
 * @author hezhong
 */
public class PayBuilder extends AbstractTemplateBuilder {
    private static final SimpleDateFormat sdf=new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");

    private static final Logger logger = Logger.getLogger(PayBuilder.class);

    @Override
    public void executeShcema() throws Exception {
        String gameId = this.schema.getExt1();

        executeById(gameId);
    }


    private void executeById(String gameId) {
        List<GamePayInfo> list = FacadeFactory.INSTANCE.getGamePayInfoBo().find(new GamePayInfo(), 0, 0);

        List<GamePayInfo> gamePayInfoList = new ArrayList<GamePayInfo>();
        GamePayInfo defaultGamePayInfo = null;
        GamePayInfo gamePayInfo = null;
        for(GamePayInfo g : list) {

            Games query = new Games();
            query.setGameId(g.getGameid());
            Games game = FacadeFactory.INSTANCE.getBaseSo().findObject(query);
            if(game != null){
                g.setSimpleName(game.getSimpleName()==null?"":game.getSimpleName());
                g.setRunType(StringTools.isEmpty(game.getRunType())?"0":game.getRunType());
            }else {
                g.setSimpleName("");
                g.setRunType("0");
            }

            if(g.getGameid().equals("000000")){
                defaultGamePayInfo = g;
            }else {
                gamePayInfoList.add(g);
            }

            if(g.getGameid().equals(gameId)) {
                gamePayInfo = g;
                continue;
            }

        }

        if (gamePayInfo == null) {
            logger.error("游戏支付信息id：" + gameId + "没有有效的数据");
            throw new RuntimeException("游戏支付信息id：" + gameId + "没有有效的数据");
        }

        Collections.sort(gamePayInfoList,new Comparator<GamePayInfo>() {
            @Override
            public int compare(GamePayInfo o1, GamePayInfo o2) {
                return o1.getSimpleName().compareToIgnoreCase(o2.getSimpleName());
            }
        });


        LiveCount livecount = FacadeFactory.INSTANCE.getLiveCountBo().find(new Long(3));
        Map<String, Object> root = new HashMap<String, Object>();
        root.put("gamePayInfos", gamePayInfoList);
        root.put("payDjqSwitch", livecount.getLiveCount());
        root.put("statics", BeansWrapper.getDefaultInstance().getStaticModels());
        root.put("defaultgamePayInfo", defaultGamePayInfo==null?new GamePayInfo():defaultGamePayInfo);

        String tempPath = htmlTemplate.getTemplateroot();

        String htmlFilePath = isPreView ? htmlTemplate.getPreviewhtmlroot() : htmlTemplate.getHtmlroot() ;
        if(!htmlFilePath.endsWith("/")) {
            htmlFilePath = htmlFilePath + "/";
        }

        //生成JS
        FreemarkerUtil.buildHtml(tempPath, "config.ftl", root, htmlFilePath + "js/config", "baseConfig.js");

        root = new HashMap<String, Object>();
        root.put("gameno", gamePayInfo.getGameno());


        String gamePath = gamePayInfo.getGamepath();
        htmlFilePath = htmlFilePath + gamePath;

        //模版名字
        String templateFileName = this.htmlTemplate.getExt2();

        String htmlFileName = "index.html";

        //生成页面
        FreemarkerUtil.buildHtml(tempPath, templateFileName, root, htmlFilePath, htmlFileName);
    }

    @Override
    public void addTeamplateSchema(HtmlTemplate ht, boolean isPreview) {

        List<GamePayInfo> list = FacadeFactory.INSTANCE.getGamePayInfoBo().find(new GamePayInfo(), 0, 0);

        for (GamePayInfo gamePayInfo : list) {
            String nowStr=sdf.format(new Date());
            //添加执行计划
            TemplateSchema ts=new TemplateSchema();
            ts.setTemplateid(ht.getTemplateid());
            ts.setSchematime(nowStr);
            ts.setIsexecuted(false);
            ts.setInputby("系统");
            ts.setInputtime(nowStr);
            ts.setIspreview(isPreview);
            ts.setExt1(gamePayInfo.getGameid());

            FacadeFactory.INSTANCE.getTemplateSchemaBo().insert(ts);
        }

    }
}
