package com.xunlei.niux.manager.template.builder.niuofficial3_0;

import com.google.gson.Gson;
import com.xunlei.httptool.util.JsonObjectUtil;
import com.xunlei.niux.data.vipgame.facade.FacadeFactory;
import com.xunlei.niux.data.vipgame.vo.GameServers;
import com.xunlei.niux.data.vipgame.vo.Games;
import com.xunlei.niux.manager.template.builder.AbstractTemplateBuilder;
import com.xunlei.niux.manager.web.util.DateUtil;
import com.xunlei.niux.manager.web.util.FreemarkerUtil;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.collections.MapUtils;
import org.apache.commons.lang.StringUtils;

import java.util.*;

/**
 * Created by jamesjxin on 14-7-14.
 */
public class TodayAndTomorrowOpenServerBuilder extends AbstractTemplateBuilder {

    @Override
    public void executeShcema() throws Exception {
        String rootPath = htmlTemplate.getTemplateroot();
        if(!rootPath.endsWith("/")){
            rootPath += "/";
        }

        String htmlPath = htmlTemplate.getHtmlroot();
        if(htmlPath.endsWith("/")){
            htmlPath += "/";
        }

//        String rootPath = "/Users/jamesjxin/Work/XL工作目录/20140607牛x官网3.0/模版/templatefiles";
//        String htmlPath = "/Users/jamesjxin/Work/XL工作目录/20140607牛x官网3.0/模版/output";

        Map<String,Object> rootMap = new HashMap<String, Object>();
        rootMap.put("newServers",getNewServerJsonStr());

        FreemarkerUtil.buildHtml(rootPath+"/include/", "newservers.html", rootMap, htmlPath+"/include/", "newservers.html");

    }

    private String getNewServerJsonStr(){
        Map<String,Object> map = getTodayAndTomorrowServersData();
        map.put("current",new Date().getTime());

        Gson gson = new Gson();
        String jsonStr = gson.toJson(map);
        return jsonStr;
    }

    private Map<String,Object> getTodayAndTomorrowServersData(){
        Map<String,Object> resultMap = new HashMap<String, Object>();
        String pattern = "yyyy-MM-dd";
        Calendar calendar = Calendar.getInstance();
        Date today = calendar.getTime();
        String todayStr = DateUtil.format(today, pattern);

        calendar.add(Calendar.DAY_OF_YEAR,1);
        Date tomorrow = calendar.getTime();
        String tomorrowStr = DateUtil.format(tomorrow,pattern);

        List<GameServers> todayServersList = FacadeFactory.INSTANCE.getGameServersBo()
                .getNewOpenServersByFromDateAndToDate(todayStr,todayStr,true);

        List<GameServers> tomorrowServersList = FacadeFactory.INSTANCE.getGameServersBo()
                .getNewOpenServersByFromDateAndToDate(tomorrowStr,tomorrowStr,true);

        if(CollectionUtils.isEmpty(todayServersList) && CollectionUtils.isEmpty(tomorrowServersList)){
            return new HashMap<String, Object>();
        }

        resultMap.put("today",getTimeMapByServerList(todayServersList));
        resultMap.put("tomorrow",getTimeMapByServerList(tomorrowServersList));

        return resultMap;
    }

    private Map<String,Object> getTimeMapByServerList(List<GameServers> serversList){
        Map<String,Object> resultTimeMap = new LinkedHashMap<String, Object>();
        if(CollectionUtils.isEmpty(serversList)){
            return resultTimeMap;
        }
        for(GameServers server : serversList){
            String openServerTime = server.getOpenTime();
            String time = openServerTime.substring(11,16);
            List<Map<String,Object>> timeServerList = null;
            if(resultTimeMap.containsKey(time)){
                timeServerList = (List<Map<String,Object>>)resultTimeMap.get(time);
            }else {
                timeServerList = new ArrayList<Map<String, Object>>();
            }

            timeServerList.add(getGameServerShowMap(server));
            resultTimeMap.put(time,timeServerList);
        }

        return resultTimeMap;
    }

    private Map<String, Object> getGameServerShowMap(GameServers server){
        Map<String,Object> map = new HashMap<String, Object>();

        if(server == null){
            throw new RuntimeException("method[getGameServerShowMap] param server can not be null!");
        }

        Games game = FacadeFactory.INSTANCE.getGamesBo().getGameByGameId(server.getGameId());
        if(game == null){
            throw new RuntimeException("method[getGameServerShowMap] game is not exist by gameId:"+server.getGameId());
        }

        map.put("gameName",game.getGameName()==null?"":game.getGameName());
        map.put("gameId",server.getGameId());
        map.put("gameNo",game.getGameNo()==null?"":game.getGameNo());
        map.put("fenQuNickName", StringUtils.isEmpty(server.getFenQuNickName())?server.getFenQuName():server.getFenQuNickName());
        map.put("fenQuNum",server.getFenQuNum());
        map.put("isHot",game.getIsHot()?1:0);
        map.put("isNew",game.getIsNew()?1:0);

        return map;
    }
}
