package com.xunlei.niux.manager.template.builder.niuofficial3_0;

import com.xunlei.niux.data.vipgame.facade.FacadeFactory;
import com.xunlei.niux.data.vipgame.vo.GameServers;
import com.xunlei.niux.data.vipgame.vo.Games;
import com.xunlei.niux.data.vipgame.vo.LinkInfo;
import com.xunlei.niux.manager.constant.LinkLocationIdConstant;
import com.xunlei.niux.manager.web.cache.GameCache;
import com.xunlei.niux.manager.web.util.FreemarkerUtil;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

/**
 * Created by jamesjxin on 14-6-27.
 */
public class PlayedGamePageBuilder {

    private String rootPath;
    private String htmlPath;
    private boolean isPreView;

    public PlayedGamePageBuilder(String rootPath, String htmlPath, boolean isPreView) {
        this.rootPath = rootPath;
        this.htmlPath = htmlPath;
        this.isPreView = isPreView;
    }

    public void build(){
        Map<String,Object> rootMap=new HashMap<String,Object>();
        rootMap.put("latestplaygamesideadvdata", getLatestPlayGameSideAdv());

        FreemarkerUtil.buildHtml(rootPath + "/include/", "playedgame.html", rootMap, htmlPath + "/include/", "playedgame.html");
    }

    /**
     * 最近玩过的游戏旁广告
     * @return
     */
    private Map<String,Object> getLatestPlayGameSideAdv(){
        Map<String,Object> map = new HashMap<String,Object>();
        //获取广告
        LinkInfo li= FacadeFactory.INSTANCE.getLinkInfoBo().getValidteLinkInfoByLinkLocId(LinkLocationIdConstant.NIUX_COMMON_GAMEADV,isPreView);
        if(li==null){
            return map;
        }
        //获取游戏信息
        Games g=FacadeFactory.INSTANCE.getGamesBo().getGameByGameId(li.getGameidbytuijian());
        //获取最新开区
        GameServers gstemp=FacadeFactory.INSTANCE.getGameServersBo().getLatestGameServerByGameId(li.getGameidbytuijian(), isPreView);
        if(g==null||gstemp==null){
            return map;
        }
        map.put("gameName", g.getGameName());
        map.put("serverId", gstemp.getFenQuNum());
        map.put("gameNo", g.getGameNo());
        map.put("gameOfficialUrl", g.getOfficialWebSite());
        return map;
    }

    public List<Map<String,Object>> getNewCardBoxList(){
        List<Map<String,Object>> templist=new ArrayList<Map<String,Object>>();
        LinkInfo info = new LinkInfo();
        info.setLinklocid(LinkLocationIdConstant.NIUX_OFFICIAL_NEWCARD);
        List<LinkInfo> lilist=FacadeFactory.INSTANCE.getLinkInfoBo().find(info);
        for(LinkInfo ll:lilist){
            String gameid = ll.getGameidbytuijian().trim();
            Games games = GameCache.getInstance().getGameByGameId(gameid);
            Map<String,Object> m = new HashMap<String,Object>();
            m.put("gameName", games.getGameName());
            m.put("newCardUrl", ll.getLinkurl());
            templist.add(m);
        }
        return templist;
    }
}
