package com.xunlei.niux.manager.template.builder.niuofficial3_0;

import com.ferret.common.dao.vo.Page;
import com.xunlei.common.facade.IFacadeCommon;
import com.xunlei.niux.data.vipgame.facade.FacadeFactory;
import com.xunlei.niux.data.vipgame.vo.Games;
import com.xunlei.niux.data.vipgame.vo.LinkInfo;
import com.xunlei.niux.data.vipgame.vo.mobilegameapkversion.MobileChannel;
import com.xunlei.niux.manager.web.cache.GameCache;
import com.xunlei.niux.manager.web.util.FreemarkerUtil;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

/**
 * Created by jamesjxin on 14-6-26.
 */
public class MobileIndexPageBuilder {
    private static final Logger logger = Logger.getLogger(MobileIndexPageBuilder.class);
    private String rootPath;
    private String htmlPath;
    private boolean isPreView;

    public MobileIndexPageBuilder(String rootPath, String htmlPath,boolean isPreView) {
        this.rootPath = rootPath;
        this.htmlPath = htmlPath;
        this.isPreView = isPreView;
    }

    public void build(){

        Map<String,Object> rootMap=new HashMap<String,Object>();
        //获取轮播图
        List<LinkInfo> lilist= FacadeFactory.INSTANCE.getLinkInfoBo().getValidteLinkInfoListByLinkLocId_V2("1275", 4, isPreView);
        List<Map<String,String>> lunbotuList=new ArrayList<Map<String,String>>();
        for(int i=0;i<lilist.size();i++){
            LinkInfo li=lilist.get(i);
            Map<String,String> map=new HashMap<String,String>();
            map.put("title", li.getLinktitle()==null?"":li.getLinktitle());
            map.put("content", li.getLinkdesc()==null?"":li.getLinkdesc());
            map.put("url", li.getLinkurl()==null?"":li.getLinkurl());
            map.put("img", li.getPicurl()==null?"":li.getPicurl());
            lunbotuList.add(map);
        }
        rootMap.put("sliderImgList", lunbotuList);
        //手机页的轮播图
        lilist=FacadeFactory.INSTANCE.getLinkInfoBo().getValidteLinkInfoListByLinkLocId_V2("1277", 5, isPreView);
        List<Map<String,String>> mobilelunbotuList=new ArrayList<Map<String,String>>();
        for(int i=0;i<lilist.size();i++){
            LinkInfo li=lilist.get(i);
            Map<String,String> map=new HashMap<String,String>();
            map.put("title", li.getLinktitle()==null?"":li.getLinktitle());
            map.put("content", li.getLinkdesc()==null?"":li.getLinkdesc());
            map.put("url", li.getLinkurl()==null?"":li.getLinkurl());
            map.put("img", li.getPicurl()==null?"":li.getPicurl());
            mobilelunbotuList.add(map);
        }
        rootMap.put("mobilesliderImgList", mobilelunbotuList);

        //获取下载链接
        List<Map<String,Object>> downloadList=new ArrayList<Map<String,Object>>();
        lilist=FacadeFactory.INSTANCE.getLinkInfoBo().getValidteLinkInfoListByLinkLocId_V2("1276", 400, isPreView);
        for(int i=0;i<lilist.size();i++){
            LinkInfo li=lilist.get(i);
            Map<String,Object> map=new HashMap<String,Object>();
            Games game= GameCache.getInstance().getGameByGameId(li.getGameidbytuijian());
            if(game==null){
                continue;
            }
            map.put("imgSrc",  li.getPicurl()==null?"":li.getPicurl());
            map.put("title",game.getGameName());
            String typeName="";
            if(game.getGameType().equals("1")){
                typeName="角色扮演";
            }else if(game.getGameType().equals("2")){
                typeName="写实";
            }else if(game.getGameType().equals("3")){
                typeName="Q版萌系";
            }else if(game.getGameType().equals("4")){
                typeName="战争策略";
            }
            map.put("yxType",typeName);
            map.put("yxEditon", li.getExt1()==null?"":li.getExt1());
            map.put("yxSize", li.getExt2()==null?"":li.getExt2());
            map.put("yxDownUrl", li.getLinkurl()==null?"":li.getLinkurl().trim());
            map.put("yxDimenson", li.getSmallpicurl()==null?"":li.getSmallpicurl());
            map.put("yxDetail", game.getGameDesc()==null?"":game.getGameDesc());
            map.put("yxStar", li.getExt3()==null?0:Integer.valueOf(li.getExt3()));
            map.put("yxPeople", li.getExt4()==null?"":li.getExt4());
            map.put("gameid", game.getGameId());
            String commonUrl=li.getLinkurl()==null?"":li.getLinkurl().trim();
            if(commonUrl.lastIndexOf("_")==commonUrl.length()-23){
                commonUrl=commonUrl.substring(0, commonUrl.lastIndexOf("_"))+"_<%=advNo%>.apk";
            }
            map.put("tmplDownUrl", commonUrl);
            downloadList.add(map);
        }
        rootMap.put("sliderYouxiList", downloadList);

//
//		List<LinkInfo> channellilist=FacadeFactory.INSTANCE.getLinkInfoBo().getValidteLinkInfoListByLinkLocId_V2("1291", 1000, isPreView);
//		Map<String,Map<String,Object>> channelGameMap=new HashMap<String, Map<String,Object>>();
//		for(LinkInfo li:channellilist){
//			Map<String,Object>tempGameMap=channelGameMap.get(li.getExt1());
//			if(tempGameMap==null){
//				tempGameMap=new HashMap<String, Object>();
//				channelGameMap.put(li.getExt1(), tempGameMap);
//			}
//			tempGameMap.put(li.getGameidbytuijian(), li.getDisplaysort());
//		}
//		List<Map<String,String>> sortList=new ArrayList<Map<String,String>>();
//		Set<String> ketSet=channelGameMap.keySet();
//		Iterator<String> it=ketSet.iterator();
//		while(it.hasNext()){
//			String key=it.next();
//			Map<String,Object> gameSortMap=channelGameMap.get(key);
//			String jsonStr=JsonObjectUtil.getDataJsonObject(gameSortMap);
//			Map<String,String> tempMap=new HashMap<String, String>();
//			tempMap.put("advNo", key);
//			tempMap.put("sortJson", jsonStr);
//			sortList.add(tempMap);
//		}
        List<MobileChannel> mcList=FacadeFactory.INSTANCE.getBaseSo().findObjects(new MobileChannel(), new Page());
        List<Map<String,String>> mcMapList=new ArrayList<Map<String,String>>();
        for(MobileChannel mc:mcList){
            Map<String,String> tempMap=new HashMap<String, String>();
            tempMap.put("advNo", mc.getChannelId());
            mcMapList.add(tempMap);
        }
        rootMap.put("advList", mcMapList);

        String qcodePath = IFacadeCommon.INSTANCE.getLibconfigValueByConfigNo("qcodePath");
        rootMap.put("qrcodeImgPath", StringUtils.isEmpty(qcodePath)?"":qcodePath);

        FreemarkerUtil.buildHtml(rootPath, "mobilegame_inner.html", rootMap, htmlPath,
                "mobilegame_inner.html");
    }
}
