package com.xunlei.niux.manager.template.builder.niuofficial3_0;


import java.text.DateFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.*;

import com.xunlei.niux.data.vipgame.vo.topgames.TopGamesDay;
import com.xunlei.niux.data.vipgame.vo.topgames.TopGamesWeek;
import com.xunlei.niux.manager.web.file.Game;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;
import org.json.JSONObject;

import com.ferret.common.dao.enums.OrderType;
import com.ferret.common.dao.vo.Page;
import com.xunlei.common.facade.IFacadeCommon;
import com.xunlei.common.vo.LibClassD;
import com.xunlei.common.vo.LibClassM;
import com.xunlei.niux.data.activity.dto.ActivityDTO;
import com.xunlei.niux.data.vipgame.facade.FacadeFactory;
import com.xunlei.niux.data.vipgame.vo.Advice;
import com.xunlei.niux.data.vipgame.vo.GameServers;
import com.xunlei.niux.data.vipgame.vo.Games;
import com.xunlei.niux.data.vipgame.vo.LinkInfo;
import com.xunlei.niux.manager.constant.LinkLocationIdConstant;
import com.xunlei.niux.manager.web.cache.GameCache;
import com.xunlei.niux.manager.web.util.FreemarkerUtil;
import com.xunlei.niux.manager.web.util.HttpClientUtil;

/**
 * Created by jamesjxin on 14-6-24.
 */
public class IndexPageBuilder {
    private static final Logger logger = Logger.getLogger(IndexPageBuilder.class);
    private String rootPath;
    private String htmlPath;
    private boolean isPreView;
    private HashMap<String,String> gameCategoryMap;
    private static Map<String, String> gameTypeMap;
    private static final String ACTPEOPLENUMURL = IFacadeCommon.INSTANCE.getLibconfigValueByConfigNo("actpeoplenumurl");

    static {
        if (gameTypeMap == null) {
            gameTypeMap = new HashMap<String, String>();
            List datas = LibClassM.getLibClassDList("gamecategory");
            for (int i = 0; i < datas.size(); i++) {
                gameTypeMap.put(( (LibClassD) datas.get(i)).getItemno().trim(), ((LibClassD) datas.get(i)).getItemname());
            }

//            gameTypeMap.put("1", "模拟经营");
//            gameTypeMap.put("2", "休闲竞技");
//            gameTypeMap.put("3", "宠物养成");
//            gameTypeMap.put("4", "战争策略");
//            gameTypeMap.put("5", "角色扮演");
        }
    }

    public IndexPageBuilder(String rootPath, String htmlPath, boolean isPreView) {
        this.rootPath = rootPath;
        this.htmlPath = htmlPath;
        this.isPreView = isPreView;
    }

    public void build() {
        Map<String, Object> rootMap = new HashMap<String, Object>();
        rootMap.put("bannerList", getBannerList());  //轮播图 ok
        rootMap.put("lastActList", getLastActList());    //最新活动
        rootMap.put("hotServerBannerMap", getHotServerBannerMap());    //开服列表旁边的火爆开服轮播图
        rootMap.put("noticeList", getNoticeList());  //公告列表 ok
        rootMap.put("recommendedList", getNewRecommendedList());    //本周推荐游戏列表 ok
        rootMap.put("hotList", getHotGameList());    //热门游戏列表  ok
        rootMap.put("adMap", getAdMap());    //底部广告位 ok
        rootMap.put("rightAdMap", getRightAdMap()); //右侧对联
        rootMap.put("leftAdMap", getLeftAdMap()); 
        rootMap.put("allNewGameList", getAllGameList());   
        rootMap.put("gameBannerList", getGameBannerList());    //底部更多游戏旁边的轮播图
        rootMap.put("userRecommendList", getUserRecommendList());    //牛友推荐
        rootMap.put("moreGameList", getMoreGameList());    //更多游戏
        rootMap.put("recommendVideoMap", getRecommendedVideoMap());    //本周推荐视频
        rootMap.put("topGamesDay", getTopGamesDay());    //日游戏排行榜
        rootMap.put("topGamesWeek", getTopGamesWeek());    //周游戏排行榜
        rootMap.put("openStatus", "1");
        FreemarkerUtil.buildHtml(rootPath, "index.html", rootMap, htmlPath, "index.html");
        rootMap.put("openStatus", "2");
        FreemarkerUtil.buildHtml(rootPath, "index.html", rootMap, htmlPath + "video/", "index.html");
        //个人中心，客服页面左下角广告位
        rootMap.put("recActList",getRecommendActList());
        FreemarkerUtil.buildHtml(rootPath+"include/", "side_link.html", rootMap, htmlPath + "include/", "side_link.html");
    }

  
    
    /**
	 * 获得所有游戏信息
	 * @return
	 */
	private List<Map<String,Object>> getAllGameList(){
		List<Map<String,Object>> result = new ArrayList<Map<String,Object>>();
		Games query = new Games();
		query.setStatus("1");//只展示已经接入的游戏
		Page page = new Page();
		page.addOrder("gameType", OrderType.DESC);
		page.addOrder("recommendIndex", OrderType.DESC);
		List<Games> games = FacadeFactory.INSTANCE.getBaseSo().findObjects(query, page);
		Set<String> set = new TreeSet<String>();
		for(Games game:games){
			set.add(game.getGameType());
		}
		HashMap<String,String> gameTypeMap =  getGameCategory();
		Object gameTypes [] = (Object [])set.toArray();
		for(Object type:gameTypes){
			String gameType = (String)type;
			Map<String,Object> map = new HashMap<String,Object>();
			map.put("gameTypeId", gameType);			
			map.put("gameType", gameTypeMap.get(gameType));
			List<Map<String,Object>> gameList = new ArrayList<Map<String,Object>>();
			for(Games game:games){
				if(game.getClientType().intValue()==3)continue;//去掉手游
				if(gameType.equals(game.getGameType())){
					Map<String,Object> gameMap = new HashMap<String,Object>();
					gameMap.put("gameName", game.getGameName());
					gameMap.put("gameOfficalUrl", game.getOfficialWebSite());
					gameMap.put("isHot", game.getIsHot()?1:0);
					gameMap.put("isNew", game.getIsNew()?1:0);
					gameList.add(gameMap);
				}
			}
			map.put("gameList", gameList);
			map.put("gameNum", gameList.size());
			result.add(map);
		}
		return result;
	}
	
	public HashMap<String,String> getGameCategory(){
        List datas = LibClassM.getLibClassDList("gamecategory");
        if(gameCategoryMap== null){
        	HashMap<String,String> tempMap = new HashMap<String,String>();
              for(int i = 0; i < datas.size(); i++){
            	  tempMap.put(((LibClassD)datas.get(i)).getItemno(), ((LibClassD)datas.get(i)).getItemname()); 	
              }	   
              gameCategoryMap = tempMap; 
        }                       
		       
		    return gameCategoryMap;
	  }

    
	private String getFormatDay(){
		SimpleDateFormat sdf = new SimpleDateFormat("yyyyMMddHH");
		return sdf.format(new Date());
	}
    
    private long getActPeopleNum(String actNo){
		String formatDay = getFormatDay();
		String date = formatDay.substring(0,formatDay.length()-2);
		String hour = formatDay.substring(formatDay.length()-2);
		StringBuffer sb = new StringBuffer(ACTPEOPLENUMURL);
		sb.append("date=").append(date).append("&hour=").append(hour).append("&actNo=").append(actNo);
		logger.info("actPeopleNum:"+sb);
		String jsonStr = HttpClientUtil.getInfoForHttpGetMothed(sb.toString());
		long peopleNum = 10000L;
		try{
			JSONObject result = new JSONObject(jsonStr);
			JSONObject data = result.getJSONObject("data");
			peopleNum = data.getLong("uv");
		}catch(Exception e){
			logger.info("actPeopleNum:"+sb+",exception:"+e.getMessage());
		}
		return peopleNum;
	}
	
    
    //本周推荐视频公用背景图
    private List<LinkInfo> getRecommendedVideoPhoto(){
	   	 LinkInfo query = new LinkInfo();
	   	 query.setLinklocid("1515");
	   	 Page page = new Page();
	   	 page.addOrder("displaysort",  OrderType.ESC);
	   	 page.setPageNo(1);
	   	 page.setPageSize(3);	   	 
	   	 return FacadeFactory.INSTANCE.getLinkInfoBo().find(query, page);
    }
    
    //本周推荐视频
    private Map<String,Object> getRecommendedVideoMap(){
    	 Map<String,Object> result = new HashMap<String,Object>();
    	 LinkInfo query = new LinkInfo();
    	 query.setLinklocid("1514");
    	 Page page = new Page();
    	 page.addOrder("displaysort",  OrderType.ESC);
    	 page.setPageNo(1);
    	 page.setPageSize(1);
    	 
    	 List<LinkInfo> linkInfoList =  FacadeFactory.INSTANCE.getLinkInfoBo().find(query, page);
    	 if(CollectionUtils.isEmpty(linkInfoList)){
    		 return result;
    	 }
    	 LinkInfo info = linkInfoList.get(0);
		 String gameid = info.getGameidbytuijian();
		 Games games = GameCache.getInstance().getGameByGameId(gameid);
		 result.put("gameName",games.getGameName());
		 result.put("gameNo",games.getGameNo());
		 result.put("gameId", gameid);    	
		 result.put("gameOfficialUrl", games.getOfficialWebSite());
		 result.put("gameType", gameTypeMap.get(games.getGameType()));
		 result.put("peopleNum", info.getExt1());
		 result.put("awardUrl", info.getLinkurl());
		 result.put("content", info.getLinkcontents());
		 result.put("videoUrl", info.getExt2());
		 result.put("videoPic", info.getPicurl());		
		 result.put("logoPic", info.getExt5());
		 result.put("persionPic", info.getExt6());
		 result.put("scenePic", info.getExt7());
		 
		 List<LinkInfo> photolist = getRecommendedVideoPhoto();
		 if(CollectionUtils.isEmpty(photolist)){
			 result.put("bg", "");
		 }else{
			 String photos = "";
			 for(int i=0;i<photolist.size();i++){
				 LinkInfo photo = photolist.get(i);
				 photos += photo.getPicurl();
				 if(i<photolist.size()-1){
					 photos += "@@";
				 }
			 }
			 result.put("bg", photos);
		 }
		 
    	return result;
    }
    
    
    

    //新的本周推荐游戏
    private List<Map<String,Object>> getNewRecommendedList(){
    	 List<Map<String,Object>> result = new ArrayList<Map<String,Object>>();
    	 LinkInfo query = new LinkInfo();
    	 query.setLinklocid("1513");
    	 Page page = new Page();
        page.addOrder("displaysort", OrderType.DESC);//按照降序序排
        page.addOrder("validdatetime", OrderType.DESC);//生效时间
    	 page.setPageNo(1);
    	 page.setPageSize(5);
    	 
    	 List<LinkInfo> linkInfoList =  FacadeFactory.INSTANCE.getLinkInfoBo().find(query, page);
    	 if(CollectionUtils.isEmpty(linkInfoList)){
    		 return result;
    	 }
    	 for(LinkInfo info:linkInfoList){
    		 Map<String,Object> map = new HashMap<String,Object>();
    		 String gameid = info.getGameidbytuijian();
   		     Games games = GameCache.getInstance().getGameByGameId(gameid);
    		 map.put("gameName",games.getGameName());
    		 map.put("gameNo",games.getGameNo());
    		 map.put("gameId", gameid);    	
    		 map.put("bigPic", info.getPicurl()==null?"":info.getPicurl());
    		 map.put("gameOfficialUrl", games.getOfficialWebSite());
    		 map.put("gameType", gameTypeMap.get(games.getGameType()));
    		 map.put("peopleNum", info.getExt1());
    		 map.put("awardUrl", info.getLinkurl());
    		 map.put("content", info.getLinkcontents());
    		 result.add(map);
    	 }
    	return result;
    }
    
    
    //更多游戏
     private List<Map<String,Object>> getMoreGameList(){
     	 List<Map<String,Object>> result = new ArrayList<Map<String,Object>>();
     	 List<LinkInfo> linkInfoList =  FacadeFactory.INSTANCE.getLinkInfoBo().getLinkListByOrderByLimit("1511", "displaysort", OrderType.ESC, false);
     	 if(CollectionUtils.isEmpty(linkInfoList)){
     		 return result;
     	 }
     	 for(LinkInfo info:linkInfoList){
     		 Map<String,Object> map = new HashMap<String,Object>();
     		 String gameid = info.getGameidbytuijian();
    		 Games games = GameCache.getInstance().getGameByGameId(gameid);
     		 map.put("gameName",games.getGameName());
     		 map.put("gameId",gameid);
     		 map.put("gameNo",games.getGameNo());
     		 map.put("pic", info.getPicurl());
     		 map.put("gameOfficialUrl", games.getOfficialWebSite());
     		//获取logo图片
			 LinkInfo logoli=FacadeFactory.INSTANCE.getLinkInfoBo().getGameValidteLinkInfoByLinkLocId(LinkLocationIdConstant.GAME_LOGO, gameid, isPreView);
     		 map.put("icon", logoli==null?"":logoli.getPicurl());
     		 result.add(map);
     	 }
     	return result;
     }

     private List<Map<String,Object>> getTopGamesDay(){
     	 List<Map<String,Object>> result = new ArrayList<Map<String,Object>>();
     	 List<TopGamesDay> list = FacadeFactory.INSTANCE.getBaseSo().findObjects(new TopGamesDay(),new Page());
         List<String> gameids = new ArrayList<String>();
         for(TopGamesDay games:list){
             gameids.add(games.getGameId());
         }
         List<GameServers> gsList = FacadeFactory.INSTANCE.getGameServersBo().getNewestOpenedGameServersByGameIdList(gameids);
         Map<String, GameServers> gsMap = new HashMap<String, GameServers>();
         for(GameServers gs : gsList){
            gsMap.put(gs.getGameId(),gs);
         }
         for(TopGamesDay games:list){
             Map<String,Object> map = new HashMap<String, Object>();
             map.put("gameid",games.getGameId());
             Games game = GameCache.getInstance().getGameByGameId(games.getGameId());
             map.put("gamename",game.getGameName());
             map.put("gameno", game.getGameNo());
             map.put("officialwebsite", game.getOfficialWebSite());
             GameServers gs = gsMap.get(games.getGameId());
             map.put("serverid", gs==null?"":gs.getServerId());
             map.put("usernum",games.getLogin_users());
             result.add(map);
         }
     	return result;
     }

     private List<Map<String,Object>> getTopGamesWeek(){
     	 List<Map<String,Object>> result = new ArrayList<Map<String,Object>>();
     	 List<TopGamesWeek> list = FacadeFactory.INSTANCE.getBaseSo().findObjects(new TopGamesWeek(),new Page());
         List<String> gameids = new ArrayList<String>();
         for(TopGamesWeek games:list){
             gameids.add(games.getGameId());
         }
         List<GameServers> gsList = FacadeFactory.INSTANCE.getGameServersBo().getNewestOpenedGameServersByGameIdList(gameids);
         Map<String, GameServers> gsMap = new HashMap<String, GameServers>();
         for(GameServers gs : gsList){
            gsMap.put(gs.getGameId(),gs);
         }
         for(TopGamesWeek games:list){
             Map<String,Object> map = new HashMap<String, Object>();
             map.put("gameid",games.getGameId());
             Games game = GameCache.getInstance().getGameByGameId(games.getGameId());
             map.put("gamename",game.getGameName());
             map.put("gameno", game.getGameNo());
             map.put("officialwebsite", game.getOfficialWebSite());
             GameServers gs = gsMap.get(games.getGameId());
             map.put("serverid", gs==null?"":gs.getServerId());
             map.put("usernum",games.getLogin_users());
             result.add(map);
         }
     	return result;
     }
   
    //牛友推荐
    private List<Map<String,Object>> getUserRecommendList(){
    	 List<Map<String,Object>> result = new ArrayList<Map<String,Object>>();
    	 List<LinkInfo> linkInfoList =  FacadeFactory.INSTANCE.getLinkInfoBo().getLinkListByOrderByLimit("1510", "displaysort", OrderType.ESC, false);
    	 if(CollectionUtils.isEmpty(linkInfoList)){
    		 return result;
    	 }
    	 for(LinkInfo info:linkInfoList){
    		 Map<String,Object> map = new HashMap<String,Object>();
    		 String gameid = info.getGameidbytuijian();
    		 Games games = GameCache.getInstance().getGameByGameId(gameid);
    		 map.put("gameId", gameid);
    		 map.put("gameName", games.getGameName());
    		 map.put("gameNo",games.getGameNo());
    		 map.put("gameOfficialUrl",games.getOfficialWebSite());
    		 map.put("rate",games.getRecommendIndex()==null?8.0:games.getRecommendIndex());
    		 map.put("personPic",info.getPicurl()==null?"":info.getPicurl());
    		 map.put("personBgPic",info.getExt1()==null?"":info.getExt1());
    		 map.put("bigPic",info.getExt2()==null?"":info.getExt2());
    		 result.add(map);
    	 }
    	return result;
    }
    
    //开服列表旁边的火爆开服轮播图
    private Map<String,Object> getHotServerBannerMap(){
    	 Map<String,Object> result = new HashMap<String,Object>();
    	 List<LinkInfo> linkInfoList =  FacadeFactory.INSTANCE.getLinkInfoBo().getLinkListByOrderByLimit("1509", "displaysort", OrderType.ESC, false);
    	 if(CollectionUtils.isEmpty(linkInfoList)){
    		 return result;
    	 }
    	 LinkInfo info = linkInfoList.get(0);
		 String gameid = info.getGameidbytuijian();
		 Games games = GameCache.getInstance().getGameByGameId(gameid);
		 if(games==null){
			 return result;
		 }
		 result.put("url", info.getLinkurl());
		 result.put("gameNo",games.getGameNo());
		 result.put("gameOfficialUrl", games.getOfficialWebSite());
		 result.put("newCardUrl", games.getForumUrl());
		 result.put("img",info.getPicurl());
		 GameServers query = new GameServers();
		 query.setOpenStatus("1");
		 query.setGameId(gameid);
		 Page page = new Page();
		 page.setPageNo(1);
		 page.setPageSize(1);
		 page.addOrder("openTime", OrderType.DESC);
		 List<GameServers> gslist = FacadeFactory.INSTANCE.getBaseSo().findObjects(query, page);
		 if(CollectionUtils.isEmpty(gslist)){
			 return result;
		 }
		 GameServers gs = gslist.get(0);
		 result.put("fenQuName", gs.getFenQuName());
		 result.put("fenQuNum", gs.getFenQuNum());
    	return result;
    }
    
    
   //开服列表旁边的火爆开服轮播图
    private List<Map<String,Object>> getHotServerBannerList(){
    	 List<Map<String,Object>> result = new ArrayList<Map<String,Object>>();
    	 List<LinkInfo> linkInfoList =  FacadeFactory.INSTANCE.getLinkInfoBo().getLinkListByOrderByLimit("1509", "displaysort", OrderType.ESC, false);
    	 if(CollectionUtils.isEmpty(linkInfoList)){
    		 return result;
    	 }
    	 for(LinkInfo info:linkInfoList){
    		 Map<String,Object> map = new HashMap<String,Object>();
    		 map.put("title", info.getLinktitle());
    		 map.put("pic", info.getPicurl());
    		 map.put("url", info.getLinkurl());
    		 result.add(map);
    	 }
    	return result;
    }
    
    //底部更多游戏旁边的轮播图
    private List<Map<String,Object>> getGameBannerList(){
    	 List<Map<String,Object>> result = new ArrayList<Map<String,Object>>();
    	 List<LinkInfo> linkInfoList =  FacadeFactory.INSTANCE.getLinkInfoBo().getLinkListByOrderByLimit("1512", "displaysort", OrderType.DESC, false);
    	 if(CollectionUtils.isEmpty(linkInfoList)){
    		 return result;
    	 }
    	 for(LinkInfo info:linkInfoList){
    		 Map<String,Object> map = new HashMap<String,Object>();
    		 map.put("title", info.getLinktitle());
    		 map.put("pic", info.getPicurl());
    		 map.put("url", info.getLinkurl());
    		 result.add(map);
    	 }
    	return result;
    }
    
    private List<Map<String, Object>> getBannerList() {
        List<Map<String, Object>> resultList = new ArrayList<Map<String, Object>>();
        List<LinkInfo> linkInfoList = FacadeFactory.INSTANCE.getLinkInfoBo().getValidteLinkInfoListByLinkLocId_V2("690", 10, false, -1);
        if (CollectionUtils.isEmpty(linkInfoList)) {
            return resultList;
        }

        for (LinkInfo linkInfo : linkInfoList) {
            Map<String, Object> map = new HashMap<String, Object>();
            map.put("title", linkInfo.getLinktitle() == null ? "" : linkInfo.getLinktitle());
            map.put("pic", linkInfo.getPicurl() == null ? "" : linkInfo.getPicurl());
            map.put("bgColor", linkInfo.getExt1() == null ? "" : linkInfo.getExt1()); //ext1-－背景颜色
            map.put("url", linkInfo.getLinkurl() == null ? "" : linkInfo.getLinkurl());

            resultList.add(map);
        }

        return resultList;
    }

    private List<Map<String, Object>> getLastActList() {
        List<Map<String, Object>> resultList = new ArrayList<Map<String, Object>>();
        List<ActivityDTO> activityDTOList = com.xunlei.niux.data.activity.facade.FacadeFactory.INSTANCE.getActivityBo().getActivityPhotoInfoList("officalIndex", 12);
        if (CollectionUtils.isEmpty(activityDTOList)) {
            return resultList;
        }

        for (ActivityDTO dto : activityDTOList) {
            Map<String, Object> map = new HashMap<String, Object>();
            String gameId = dto.getGameid();
            Games game = GameCache.getInstance().getGameByGameId(gameId);

            map.put("gameId", gameId == null ? "" : gameId);
            if (game == null) {
                map.put("gameNo", "");
            } else {
                map.put("gameNo", game.getGameNo() == null ? "" : game.getGameNo());
            }

            map.put("title", dto.getTitle());
            map.put("pic", dto.getPhoto());
            map.put("actNo", dto.getActno());
            //map.put("joinNum", getActPeopleNum(dto.getActno()));
            map.put("award", dto.getExt1());
            map.put("url", dto.getLinkUrl());
            map.put("isnew", 0);
            String gameid = dto.getGameid();
            if("000000".equals(gameid)){
            	map.put("isPlatform", 1);
            }else{
            	map.put("isPlatform", 0);
            }
            resultList.add(map);
        }

        return resultList;
    }
    
    public Map<String,Object> getRightAdMap(){
        LinkInfo rightli=FacadeFactory.INSTANCE.getLinkInfoBo().getValidteLinkInfoByLinkLocId_V2("1505", isPreView);
        if(rightli == null){
            return null;
        }
        String type = "img";
        if(rightli.getPicurl().endsWith(".swf")){
            type = "swf";
        }
        Map<String,Object> map=new HashMap<String,Object>();
        map.put("type",type);
        map.put("src", rightli.getPicurl()==null?"":rightli.getPicurl());
        map.put("url", rightli.getLinkurl()==null?"":rightli.getLinkurl());
        return map;
    }
    public Map<String,Object> getLeftAdMap(){
        LinkInfo leftli=FacadeFactory.INSTANCE.getLinkInfoBo().getValidteLinkInfoByLinkLocId_V2("1506", isPreView);
        if(leftli == null){
            return null;
        }
        String type = "img";
        if(leftli.getPicurl().endsWith(".swf")){
            type = "swf";
        }
        Map<String,Object> map=new HashMap<String,Object>();
        map.put("type",type);
        map.put("src", leftli.getPicurl()==null?"":leftli.getPicurl());
        map.put("url", leftli.getLinkurl()==null?"":leftli.getLinkurl());
        return map;
    }


    private List<Map<String, Object>> getNoticeList() {
        String sql = "select * from advice where platformno != 'question' and adviceType = '1' order by displayOrder asc limit 0,3";
        List<Advice> list = FacadeFactory.INSTANCE.getAdviceBo().executeQuery(
                Advice.class, sql, new ArrayList());
        List<Map<String, Object>> result = new ArrayList<Map<String, Object>>();
        logger.info("getAdviceAdv.size=====================>" + list.size());
        if (list == null || list.size() == 0) return result;
        for (Advice info : list) {
            String gameid = info.getGameId();

            //游戏信息
            logger.info("gameid================>" + gameid);
            Games game = FacadeFactory.INSTANCE.getGamesBo().getGameByGameId(
                    gameid);

            Map<String, Object> map = new HashMap<String, Object>();
            map.put("id", info.getSeqId());
            map.put("gameId", game == null ? "" : game.getGameNo());
            map.put("gameName", game == null ? "" : game.getGameName());
            map.put("title", info.getTitle() == null ? "" : info.getTitle());
            String url = "";
            if(info.getJump()){
                url = info.getJumpUrl();
            }else {
//                url = advice.getContenturl2();
                url="/notice/"+info.getSeqId()+".html";
            }
            map.put("url", url==null?"":url);
            map.put("pic", info.getExt1() == null ? "" : info.getExt1());
            map.put("content", info.getRemark() == null ? "" : info.getRemark());
            map.put("gameOfficialUrl", game == null ? "" : game.getOfficialWebSite());
            map.put("date", formatTime(info.getPublishDate()));

            map.put("isRed", info.getRed() == false ? 0 : 1);
            map.put("isBlod", info.getBold() == false ? 0 : 1);
            map.put("platformno", info.getPlatformno());
            result.add(map);
            if (result.size() >= 3) {
                break;
            }
        }

        return result;
    }

    private String formatTime(String time) {
        if (time == null) return "";
        if (time.length() == 19) {
            time = time.split(" ")[0];
        }
        if (time.length() == 10) {
            time = time.substring(5);
        }
        return time;
    }

    private List<Map<String, Object>> getRecommendedList() {
        List<Map<String, Object>> templist = new ArrayList<Map<String, Object>>();
        List<LinkInfo> lilist = FacadeFactory.INSTANCE.getLinkInfoBo()
                .getValidteLinkInfoListByLinkLocId_V2("691", 12, false, -1);
        if (lilist == null || lilist.size() == 0) return templist;
//        GameServers qgs = new GameServers();

        for (LinkInfo li : lilist) {
            Map<String, Object> map = new HashMap<String, Object>();
            map.put("bgImg", li.getPicurl());
            Games game = GameCache.getInstance().getGameByGameId(li.getGameidbytuijian());
            map.put("gameId", game.getGameNo());
            map.put("gameName", game.getGameName());
            map.put("gameNo", game.getGameNo());
            map.put("gameOfficialUrl", game.getOfficialWebSite());
            map.put("gameType", (gameTypeMap.get(li.getExt3())).toString());
            map.put("gameServerId", li.getExt1());
//            map.put("gameServerName", gs.getServerName());
            map.put("content", li.getExt2());
//            map.put("gameServerName", gs.getFenQuName());
            map.put("peopleNumber", li.getDisplayorder());
            map.put("dateTime", getFormatDay(li.getValiddatetime()));
            map.put("isHot", !(game.getIsHot() == null) && game.getIsHot() ? 1 : 0);
            templist.add(map);
        }
        return templist;
    }


    private String getFormatDay(String time) {
        time = time.split(" ")[0];
        time = time.substring(5);
        return time;
    }

    private List<Map<String, Object>> getHotGameList() {
        List<Map<String, Object>> resultList = new ArrayList<Map<String, Object>>();
        List<LinkInfo> lilist = FacadeFactory.INSTANCE.getLinkInfoBo()
                .getValidteLinkInfoListByLinkLocId_V2("692", 12, false, -1);

        if (CollectionUtils.isEmpty(lilist)) {
            return resultList;
        }

        for (LinkInfo linkInfo : lilist) {
            String gameId = linkInfo.getGameidbytuijian();
            Games game = GameCache.getInstance().getGameByGameId(gameId);
            if (game == null) {
                continue;
            }
            Map<String, Object> map = new HashMap<String, Object>();
            map.put("gameId", game.getGameId());
            map.put("gameNo", game.getGameNo() == null ? "" : game.getGameNo());
            map.put("gameName", game.getGameName() == null ? "" : game.getGameName());
            map.put("bgImg", game.getPicUrl() == null ? "" : game.getPicUrl());
            map.put("gameOfficialUrl", game.getOfficialWebSite() == null ? "" : game.getOfficialWebSite());
            map.put("isHot", !(game.getIsHot() == null) && game.getIsHot() ? 1 : 0);
            map.put("peopleNumber", linkInfo.getExt1());
            String gameType = gameTypeMap.get(game.getGameType());
            map.put("gameType", gameType == null ? "" : gameType);
            resultList.add(map);
        }

        return resultList;
    }

    private Map<String, Object> getAdMap() {
        Map<String, Object> map = new HashMap<String, Object>();
        LinkInfo linkInfo = FacadeFactory.INSTANCE.getLinkInfoBo().getValidteLinkInfoByLinkLocId("693", false);
        if (linkInfo == null) {
            return null;
        }
        String pic =  linkInfo.getPicurl() == null ? "" : linkInfo.getPicurl();
        System.out.println("type:"+pic);
        map.put("type", pic.indexOf(".swf")!=-1?"swf":"img");
        map.put("src",pic);
        map.put("url", linkInfo.getLinkurl() == null ? "" : linkInfo.getLinkurl());
        return map;
    }

    private List<Map<String,Object>> getRecommendActList(){

        List<Map<String,Object>> resultList = new ArrayList<Map<String, Object>>();
        List<ActivityDTO> activityDTOList = com.xunlei.niux.data.activity.facade.FacadeFactory.INSTANCE.getActivityBo().getActivityPhotoInfoList("userCenter",10);

        if(CollectionUtils.isEmpty(activityDTOList)){
            return resultList;
        }


        for(ActivityDTO dto : activityDTOList){
            Map<String,Object> map = new HashMap<String, Object>();
            map.put("title",dto.getTitle()==null?"":dto.getTitle());
            map.put("img",dto.getPhoto()==null?"":dto.getPhoto());
            map.put("link",dto.getLinkUrl()==null?"":dto.getLinkUrl());
            map.put("content",dto.getActDesc()==null?"":dto.getActDesc());

            Calendar startCal = getTimeCalendar(dto.getStarttime());
            map.put("startTime",startCal==null?"":(startCal.get(Calendar.MONTH)+1)+"月"+startCal.get(Calendar.DAY_OF_MONTH)+"日");
            Calendar endCal = getTimeCalendar(dto.getEndtime());
            map.put("endTime",endCal==null?"":(endCal.get(Calendar.MONTH)+1)+"月"+endCal.get(Calendar.DAY_OF_MONTH)+"日");
            resultList.add(map);
        }

        return  resultList;
    }

    private Calendar getTimeCalendar(String timeStr){
        if(StringUtils.isEmpty(timeStr)){
            return null;
        }
        DateFormat sdf_time = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        Date dateTime = null;
        try {
            dateTime = sdf_time.parse(timeStr);
        } catch (ParseException e) {
            logger.error("getTimeCalendar time Parse Exception:",e);
            return null;
        }
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(dateTime);

        return calendar;
    }
}
