package com.xunlei.niux.manager.template.builder.niuofficial3_0;

import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;

import org.apache.commons.collections.CollectionUtils;
import org.apache.log4j.Logger;
import org.json.JSONObject;
import com.ferret.common.dao.enums.OrderType;
import com.ferret.common.dao.vo.Page;
import com.xunlei.common.facade.IFacadeCommon;
import com.xunlei.niux.data.active.vo.commonactivity.ActivityGiftRecord;
import com.xunlei.niux.data.vipgame.facade.FacadeFactory;
import com.xunlei.niux.data.vipgame.vo.Activity;
import com.xunlei.niux.data.vipgame.vo.GameLoginRecord;
import com.xunlei.niux.data.vipgame.vo.GamePeopleNum;
import com.xunlei.niux.data.vipgame.vo.Games;
import com.xunlei.niux.data.vipgame.vo.gift.Gift;
import com.xunlei.niux.manager.template.builder.AbstractTemplateBuilder;
import com.xunlei.niux.manager.web.cache.GameCache;
import com.xunlei.niux.manager.web.util.AccountUtil;
import com.xunlei.niux.manager.web.util.FreemarkerUtil;
import com.xunlei.niux.manager.web.util.HttpClientUtil;
import com.xunlei.proxy.socket.bin.resp.Resp_getuserinfo_base;
import com.xunlei.util.StringTools;

/**
 * 牛x官网3.0首页 用户登录游戏 或 活动参加活动领取奖品 广播消息
 * @author lisu
 *  2014-08-01
 */
public class ActivityAdviceBuilder extends AbstractTemplateBuilder {
	private static final Logger logger = Logger.getLogger(ActivityAdviceBuilder.class.getName());
	private boolean ispreview=false;
	private String root = null;
    private  String roothtml = null;
    private static final String GAMEPEOPLENUMURL = IFacadeCommon.INSTANCE.getLibconfigValueByConfigNo("gamepeoplenumurl");
    private static final int COUNTSIZE = 30;
    
	@Override
	public void executeShcema() throws Exception {
		root = htmlTemplate.getTemplateroot();
	    roothtml = getHtmlRoot();
		buildUserLoginGameNoticeList();
		buildUserJoinActNoticeList();
	}	
	
	/**
	 * 用户登录游戏通知
	 * @throws Exception
	 */
	private void buildUserLoginGameNoticeList() throws Exception {
		Map<String, Object> rootMap = new HashMap<String, Object>();
		rootMap.put("recBroadcastList", getUserLoginGameNoticeList());
		FreemarkerUtil.buildHtml(root+"include/", "recbroadcast.html", rootMap, roothtml
				+ "/include/", "recbroadcast.html");
	}
	
	public List<Map<String,Object>> getUserLoginGameNoticeList(){
		List<Map<String,Object>> result = new ArrayList<Map<String,Object>>();
		GamePeopleNum query = new GamePeopleNum();
		Page page = new Page();
		page.addOrder("seqId", OrderType.DESC);
		page.setPageNo(1);
		page.setPageSize(3000);
		List<GamePeopleNum> glrlist = FacadeFactory.INSTANCE.getBaseSo().findObjects(query, page);
		if(CollectionUtils.isEmpty(glrlist)){
			return result;
		}
		int count = 0;
		for(GamePeopleNum glr:glrlist){
			if(count>=20)break;
			Map<String,Object> map = new HashMap<String,Object>();
			String userName = glr.getUserName();
			String gameId = glr.getGameId();
			Games games = GameCache.getInstance().getGameByGameId(gameId);
			if(games.getClientType().intValue()!=0)continue;
			long peopleNum = glr.getPeopleNum();
			if("真命天子".equals(glr.getUserName()))continue;
			
			map.put("gameId", gameId);
			map.put("gameNo",games.getGameNo());
			map.put("gameName", games.getGameName());
			map.put("gameOfficialUrl", games.getOfficialWebSite());
			map.put("userName",userName);
			map.put("peopleNum", peopleNum);			
			result.add(map);
			count ++;
		}
		return result;
	}
	
	private String getFormatDay(){
		SimpleDateFormat sdf = new SimpleDateFormat("yyyyMMddHH");
		return sdf.format(new Date());
	}
	
	private long getGamePeopleNum(String gameId){
		String formatDay = getFormatDay();
		String date = formatDay.substring(0,formatDay.length()-2);
		String hour = formatDay.substring(formatDay.length()-2);
		StringBuffer sb = new StringBuffer(GAMEPEOPLENUMURL);
		sb.append("date=").append(date).append("&hour=").append(hour).append("&gameId=").append(gameId);
		logger.info("gamePeopleNum:"+sb);		
		long peopleNum = 2000L;		
		try{
			String jsonStr = new GamePeopleThread(sb.toString()).call();
			JSONObject result = new JSONObject(jsonStr);
			JSONObject data = result.getJSONObject("data");
			peopleNum = data.getLong("login");
		}catch(Exception e){
			logger.info("gamePeopleNum:"+sb+",exception:"+e.getMessage());
		}
		return peopleNum;
	}
	
	
	private void buildUserJoinActNoticeList() throws Exception {
		Map<String, Object> rootMap = new HashMap<String, Object>();
		rootMap.put("actBroadcastList", getUserJoinActNoticeList());
		FreemarkerUtil.buildHtml(root+"include/", "actbroadcast.html", rootMap, roothtml
				+ "/include/", "actbroadcast.html");
	}
	
	public List<Map<String,Object>> getUserJoinActNoticeList(){
		List<Map<String,Object>> result = new ArrayList<Map<String,Object>>();
		ActivityGiftRecord query = new ActivityGiftRecord();
		Page page = new Page();
		page.addOrder("recordTime", OrderType.DESC);
		page.addOrder("seqid", OrderType.DESC);
		page.setPageNo(1);
		page.setPageSize(100);
		List<ActivityGiftRecord>  agrlist =  com.xunlei.niux.data.active.facade.FacadeFactory.INSTANCE.getBaseSo().findObjects(query, page);
		if(CollectionUtils.isEmpty(agrlist)){
			return result;
		}
		System.out.println("agrlist:"+agrlist.size());
		int count = 0;
        for(ActivityGiftRecord agr:agrlist){
        	if(count>=COUNTSIZE) break;
        	String actNo = agr.getActNo();
        	String userid = agr.getUserId()+"";
        	String giftId = agr.getGiftId()+"";
        	Activity activity = getActivity(actNo);
        	if(activity==null)continue;
        	String actUrl = activity.getLink();
        	if(StringTools.isEmpty(actUrl)||actUrl.length()<10)continue;
        	Map<String,Object> map = new HashMap<String,Object>();
    		map.put("actUrl", actUrl);
    		map.put("award", getGiftName(giftId));
    		map.put("actName",activity.getTitle());
    		try{
    			Resp_getuserinfo_base userinfo = AccountUtil.getUserBaseInfo(userid);
    			if(StringTools.isEmpty(userinfo.getNickname())){
    				String uname = userinfo.getUsrname();
    				if(StringTools.isEmpty(uname)){
    					String account = userinfo.getUserAccount();
    					if(StringTools.isEmpty(account)){
    						map.put("userName","真命天子");
    					}else{
    						map.put("userName",account);
    					}
    				}else{
    					map.put("userName",uname);
    				}    				
    			}else{    				
    				map.put("userName",userinfo.getNickname());
    			}    		
    		}catch(Exception e){
    			map.put("userName","真命天子");
    		}   
    		result.add(map);
    		count++;    		
        }
		return result;
	}

	
	private Activity  getActivity(String actNo){
		Activity query = new Activity();
		query.setActno(actNo);
		Activity act = FacadeFactory.INSTANCE.getActivityBo().findByActno(actNo);
		return act;
	}
	
	private String getGiftName(String giftId){
		Gift query = new Gift();
		query.setGiftId(Long.parseLong(giftId));
		Gift gift = FacadeFactory.INSTANCE.getBaseSo().findObject(query);
		if(StringTools.isEmpty(giftId)) return "金钻会员";
		return gift.getGiftName();
	}
}
