package com.xunlei.niux.manager.template.builder.niuoffical.v3;

import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import org.springframework.util.CollectionUtils;
import com.ferret.common.dao.enums.OrderType;
import com.ferret.common.dao.vo.Page;
import com.xunlei.common.util.StringTools;
import com.xunlei.common.vo.LibClassD;
import com.xunlei.common.vo.LibClassM;
import com.xunlei.niux.data.vipgame.facade.FacadeFactory;
import com.xunlei.niux.data.vipgame.vo.GameServers;
import com.xunlei.niux.data.vipgame.vo.Games;
import com.xunlei.niux.data.vipgame.vo.LinkInfo;
import com.xunlei.niux.manager.constant.LinkLocationIdConstant;
import com.xunlei.niux.manager.template.builder.AbstractTemplateBuilder;
import com.xunlei.niux.manager.web.cache.GameCache;
import com.xunlei.niux.manager.web.util.DateUtil;
import com.xunlei.niux.manager.web.util.FreemarkerUtil;


/**
 * 牛x官网3.0头部和友情链接模版
 * @author lisu
 *  2014-06-26
 */
public class HeaderBuilder extends AbstractTemplateBuilder {
	private boolean ispreview=false;
	private String root = null;
    private  String roothtml = null;
    private HashMap<String,String> gameCategoryMap;
  
  public static void main(String args[]){
	  try {
		new HeaderBuilder().executeShcema();
	} catch (Exception e) {
		e.printStackTrace();
	}
  }
	
	@Override
	public void executeShcema() throws Exception {
		root = htmlTemplate.getTemplateroot();
	    roothtml = getHtmlRoot();
	    buildHead();
	    buildHeader();
	    buildFriendLink();
	    buildServerList();
	}
	
	private void buildServerList() throws Exception {
		Map<String, Object> rootMap = new HashMap<String, Object>();
		rootMap.put("openServerList", getTodayNewGameServers());
		String root = htmlTemplate.getTemplateroot();
		String roothtml = getHtmlRoot();
		FreemarkerUtil.buildHtml(root+"include/", "serverlist.html", rootMap, roothtml
				+ "/include/", "serverlist.html");
	}
	
	
    private List<Map<String,Object>> getTodayNewGameServers(){
  	  List<Map<String, Object>> result = new ArrayList<Map<String, Object>>();
  	  
        String endingToday = DateUtil.format(Calendar.getInstance().getTime(),"yyyy-MM-dd") + " 23:59:59";

        List<GameServers> tomorrowServersList = FacadeFactory.INSTANCE.getGameServersBo()
                .getXmpOpenServersByFromDateAndToDate(endingToday,false,10);
        int i =0;
        for(GameServers server:tomorrowServersList){	
        	if(i>=20)break;
        	Games game=GameCache.getInstance().getGameByGameId(server.getGameId());
        	//获取logo图片
			LinkInfo logoli=FacadeFactory.INSTANCE.getLinkInfoBo().getGameValidteLinkInfoByLinkLocId(LinkLocationIdConstant.GAME_LOGO,game.getGameId(), ispreview);           				
			Map<String,Object> map=new HashMap<String,Object>();
			String opentime = server.getOpenTime();				
			String strs[] = opentime.split(" ");
			String date = strs[0].substring(5);//日期
			String time = strs[1].substring(0,5);//时间
			map.put("date", date);
			map.put("time", time);
			map.put("gameName", game.getGameName());
			map.put("gameNo", game.getGameNo());
			map.put("gameOfficialUrl",game.getOfficialWebSite());
			map.put("fenQuNum", server.getFenQuNum());
			map.put("serverName", server.getFenQuName());
			map.put("seqId", server.getSeqId());
			map.put("gameImg", logoli==null?"":logoli.getPicurl());
			result.add(map);
			i++;
        }
        return result;
  }
	
	/**
	 * 获得会员特权页面最新开服列表的数据
	 * @return
	 */
	public List<Map<String,Object>> getOpenServerList() throws Exception{
		List<Map<String,Object>> result = new ArrayList<Map<String,Object>>();
		SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd");
		Calendar cal = Calendar.getInstance();
		cal.add(Calendar.DAY_OF_MONTH, 1);	
		String tomorrow = sdf.format(cal.getTime());//获得明天的日期	
		//获得后台录入的 首页最新开服列表中的数据
		LinkInfo linkInfo = new LinkInfo();
	    linkInfo.setLinklocid("1240");//牛x官网开服列表
	    Page page = new Page();
	    page.addOrder("validdatetime", OrderType.DESC);
	    List<LinkInfo> list = FacadeFactory.INSTANCE.getLinkInfoBo().find(linkInfo, page);	    
	    if(list == null||list.size()==0)return null;
	    
	    //获得游戏的区服信息
	    GameServers qgs=new GameServers();
		qgs.setToopentime(tomorrow+" 00:00:00");//只取今天以前的数据，其中包含今天的
		Page page1 = new Page();
		page1.addOrder("openTime", OrderType.DESC);
		List<GameServers> serverList=FacadeFactory.INSTANCE.getGameServersBo().find(qgs, page1);
		int jj = 0;
		boolean flag = true;
		for(GameServers server:serverList){		
			if(flag){
				for(int i=0;i<list.size();i++){				
					LinkInfo li=list.get(i);
				    if(server.getGameId().trim().equals(li.getGameidbytuijian().trim())&&(server.getFenQuNum()+"").equals(li.getExt1().trim())){
				    	//获取logo图片
						LinkInfo logoli=FacadeFactory.INSTANCE.getLinkInfoBo().getGameValidteLinkInfoByLinkLocId(LinkLocationIdConstant.GAME_LOGO, li.getGameidbytuijian(), ispreview);
						//游戏信息
						Games game=FacadeFactory.INSTANCE.getGamesBo().getGameByGameId(li.getGameidbytuijian());		               					
						Map<String,Object> map=new HashMap<String,Object>();
						String opentime = server.getOpenTime();
						String strs[] = opentime.split(" ");
						String date = strs[0].substring(5);//日期
						String time = strs[1].substring(0,5);//时间
						map.put("date", date);
						map.put("time", time);
						map.put("gameName", game.getGameName());
						map.put("gameNo", game.getGameNo());
						map.put("gameOfficialUrl",game.getOfficialWebSite());
						map.put("fenQuNum", server.getFenQuNum());
						map.put("serverName", server.getFenQuName());
						map.put("seqId", server.getSeqId());
						map.put("gameImg", logoli==null?"":logoli.getPicurl());
						result.add(map);
						jj ++;
						if(jj>=10){
							flag = false;
							break;//取其中9条记录
						}
				    }												
				}
			}
			
		}

		return result;
	}
	
	private void buildHead() {
		Map<String, Object> rootMap = new HashMap<String, Object>();
		rootMap.put("seomap", getKeyWord());
		rootMap.put("clientDownload", getClientDownloadLink());
        rootMap.put("bigAdMap", getIndexFlash());    //flash大图
		String root = htmlTemplate.getTemplateroot();
		String roothtml = getHtmlRoot();
		FreemarkerUtil.buildHtml(root+"include/", "head.html", rootMap, roothtml
				+ "/include/", "head.html");
	}
	
	private Map<String, Object> getKeyWord() {
		Map<String, Object> map = new HashMap<String, Object>();
		List<LinkInfo> llist = FacadeFactory.INSTANCE.getLinkInfoBo()
				.getValidteLinkInfoListByLinkLocId(
						LinkLocationIdConstant.NIUX_COMMON_KEYWORD, 1, false);
		if(llist == null||llist.size()==0)return null;
		for (LinkInfo linkinfo : llist) {
			map.put("title", linkinfo.getLinktitle() == null ? "" : linkinfo
					.getLinktitle());
			map.put("description", linkinfo.getLinkdesc() == null ? ""
					: linkinfo.getLinkdesc());
			map.put("keywords", linkinfo.getExt1() == null ? "" : linkinfo
					.getExt1());
		}
		return map;
	}
	private Map<String, Object> getClientDownloadLink() {
		List<LinkInfo> llist = FacadeFactory.INSTANCE.getLinkInfoBo()
				.getValidteLinkInfoListByLinkLocId(
						LinkLocationIdConstant.NIUX_COMMON_CLIENTDOWNLOADLINK,
						2, false);
		if(llist == null ||llist.size()==0)return null;
		if (llist.size() < 2)
			return null;
		LinkInfo one = llist.get(0);
		LinkInfo two = llist.get(1);
		Map<String, Object> map = new LinkedHashMap<String, Object>();
		map.put("gameBoxURL", one.getLinkurl());
		map.put("jsqURL", two.getLinkurl());
		return map;
	}
	
	/**
	 * 头部模版
	 */
	private void buildHeader(){
		Map<String,Object> rootMap=new HashMap<String,Object>();
		rootMap.put("allNewGameList", getAllGameList());        
		rootMap.put("hotSearch", getHotSearch());    
		rootMap.put("logoMap", getLogoMap());
		rootMap.put("headerAdMap", getHeaderAdMap());
		rootMap.put("gameAdMap", getGameAdMap());
		rootMap.put("searchResultRecMap", getSearchResultRecMap());
		rootMap.put("searchHotList", getSearchHotList());
		FreemarkerUtil.buildHtml(root+"include/","header.html", rootMap, roothtml+"include/", "header.html");
	}
	
	private Map<String,Object> getGameAdMap(){
		Map<String,Object> result = new HashMap<String,Object>();
		List<LinkInfo> infoList = FacadeFactory.INSTANCE.getLinkInfoBo().getValidteLinkInfoListByLinkLocId_V2("1521", 1, false);
		if(CollectionUtils.isEmpty(infoList)){
			return result;
		}
		LinkInfo info = infoList.get(0);
		result.put("src", info.getPicurl());
		result.put("url", info.getLinkurl());
		return result;
	}
	
	private Map<String,Object> getSearchResultRecMap(){
		Map<String,Object> result = new HashMap<String,Object>();
		List<LinkInfo> infoList = FacadeFactory.INSTANCE.getLinkInfoBo().getValidteLinkInfoListByLinkLocId_V2("1523", 1, false);
		if(!CollectionUtils.isEmpty(infoList)){
			LinkInfo info = infoList.get(0);
			result.put("gameKeyword", info.getLinktitle());
		}	
		infoList = FacadeFactory.INSTANCE.getLinkInfoBo().getValidteLinkInfoListByLinkLocId_V2("1524", 1, false);
		if(!CollectionUtils.isEmpty(infoList)){
			LinkInfo info = infoList.get(0);
			result.put("actKeyword", info.getLinktitle());
		}		
		return result;
	}
	
	  /**
     * 官网首页 flash
     * @return
     */
    private Map<String,Object> getIndexFlash(){
    	Map<String,Object> result = new HashMap<String,Object>();
    	List<LinkInfo> infoList = FacadeFactory.INSTANCE.getLinkInfoBo().getValidteLinkInfoListByLinkLocId_V2("1516", 1, false);
    	if(CollectionUtils.isEmpty(infoList)){
    		return result;
    	}
    
    	LinkInfo info = infoList.get(0);
    	result.put("flash", info.getPicurl());
    	result.put("url", info.getLinkurl());
    	result.put("img", info.getExt1());
    	String gameid = info.getGameidbytuijian();
    	if(StringTools.isEmpty(gameid)){
    		return result;
    	}
    	Games games = GameCache.getInstance().getGameByGameId(gameid);
    	if(games == null){
    		return result;
    	}
    	result.put("gameNo", games.getGameNo());
    	return result;
    }
    
	
	private List<Map<String,Object>> getSearchHotList(){
		List<Map<String, Object>> list = new ArrayList<Map<String, Object>>();
		LinkInfo info = new LinkInfo();
		info.setLinklocid("1508");
		info.setIstest(false);
		Page page = new Page();
		page.setPageNo(1);
		page.setPageSize(4);	
		page.addOrder("displaysort", OrderType.DESC);
		List<LinkInfo> llist = FacadeFactory.INSTANCE.getLinkInfoBo().find(info, page);
		if(llist == null||llist.size()==0)return null;
		for(LinkInfo llinfo:llist){
			Map<String,Object> map = new HashMap<String,Object>();
			map.put("keyword", llinfo.getLinktitle());
			map.put("isColor", llinfo.getIsredtitle()?1:0);
			list.add(map);
		}
		return list;
	}
	
	private Map<String,Object> getLogoMap(){
		Map<String, Object> map = new HashMap<String, Object>();
		LinkInfo info = new LinkInfo();
		info.setLinklocid("1507");
		info.setExt1("1");//	左边	
		info.setIsvalid(true);
		Page page = new Page();
		page.setPageNo(1);
		page.setPageSize(1);
		page.addOrder("displayorder", OrderType.DESC);
		List<LinkInfo> llist = FacadeFactory.INSTANCE.getLinkInfoBo().find(info, page);
        if(llist == null||llist.size()==0)return null;
        LinkInfo linkinfo = llist.get(0);
        map.put("src", linkinfo.getPicurl());
        map.put("url", linkinfo.getLinkurl());
        map.put("type", formatType(linkinfo.getExt2()));
        return map;
	}
	
	private String formatType(String type){
		if("2".equals(type)){
			return "swf";
		}
		return "img";
	}
	
	private Map<String,Object> getHeaderAdMap(){
		Map<String, Object> map = new HashMap<String, Object>();
		LinkInfo info = new LinkInfo();
		info.setLinklocid("1507");
		info.setExt1("2");//	中间		
		info.setIsvalid(true);
		Page page = new Page();
		page.setPageNo(1);
		page.setPageSize(1);
		page.addOrder("displayorder", OrderType.DESC);
		List<LinkInfo> llist = FacadeFactory.INSTANCE.getLinkInfoBo().find(info, page);
        if(llist == null||llist.size()==0)return null;
        LinkInfo linkinfo = llist.get(0);
        map.put("src", linkinfo.getPicurl());
        map.put("url", linkinfo.getLinkurl());
        map.put("type", formatType(linkinfo.getExt2()));
        return map;
	}
	/**
	 * 获得搜索词
	 * @return
	 */
	private Map<String,String> getHotSearch(){
		Map<String,String> result = new HashMap<String,String>();
		LinkInfo linkInfo = new LinkInfo();
	    linkInfo.setLinklocid("1504");//搜索词
	    Page page = new Page();
	    page.setPageNo(1);
	    page.setPageSize(1);
	    page.addOrder("validdatetime", OrderType.DESC);//按照生效时间逆序
	    List<LinkInfo> list = FacadeFactory.INSTANCE.getLinkInfoBo().find(linkInfo, page);	
	    if(list == null||list.size()==0)return result;
	    LinkInfo info = list.get(0);
	    result.put("text", info.getLinkdesc());
	    result.put("word", info.getLinktitle());
		return result;
	}
	
	/**
	 * 友情链接模版
	 */
	private void buildFriendLink(){
		Map<String,Object> rootMap=new HashMap<String,Object>();
		List<Map<String,Object>> xlProductList = new ArrayList<Map<String,Object>>();
		List<Map<String,Object>> mediaList = new ArrayList<Map<String,Object>>();
		initFriendLinkList(xlProductList,mediaList);
		rootMap.put("xlProductList", xlProductList);        
		rootMap.put("mediaList", mediaList);    
		FreemarkerUtil.buildHtml(root+"include/","friendlink.html", rootMap, roothtml+"include/", "friendlink.html");
	}

	/**
	 * 公用友情链接
	 * @return
	 */
	private void initFriendLinkList(List<Map<String,Object>> xlProductList,List<Map<String,Object>> mediaList){
		LinkInfo linkInfo = new LinkInfo();
	    linkInfo.setLinklocid("1503");//友情链接
	    Page page = new Page();
	    page.addOrder("validdatetime", OrderType.DESC);//按照生效时间逆序
	    List<LinkInfo> list = FacadeFactory.INSTANCE.getLinkInfoBo().find(linkInfo, page);	    	    
		for(LinkInfo info:list){			
			Map<String,Object> map = new HashMap<String,Object>();
			map.put("name", info.getLinktitle());
			map.put("url", info.getLinkurl());
            String ext2 = info.getExt2();
            if("001".equals(ext2)){
            	xlProductList.add(map);
            }else{
            	mediaList.add(map);
            }
		}
	}
	
	/**
	 * 获得所有游戏信息
	 * @return
	 */
	private List<Map<String,Object>> getAllGameList(){
		List<Map<String,Object>> result = new ArrayList<Map<String,Object>>();
		Games query = new Games();
		query.setStatus("1");//只展示已经接入的游戏
		Page page = new Page();
		page.addOrder("gameType", OrderType.DESC);
		page.addOrder("recommendIndex", OrderType.DESC);
		List<Games> games = FacadeFactory.INSTANCE.getBaseSo().findObjects(query, page);
		Set<String> set = new TreeSet<String>();
		for(Games game:games){
			set.add(game.getGameType());
		}
		HashMap<String,String> gameTypeMap =  getGameCategory();
		Object gameTypes [] = (Object [])set.toArray();
		for(Object type:gameTypes){
			String gameType = (String)type;
			Map<String,Object> map = new HashMap<String,Object>();
			map.put("gameTypeId", gameType);			
			map.put("gameType", gameTypeMap.get(gameType));
			List<Map<String,Object>> gameList = new ArrayList<Map<String,Object>>();
			for(Games game:games){
				if(game.getClientType().intValue()==3)continue;//去掉手游
				if(gameType.equals(game.getGameType())){
					Map<String,Object> gameMap = new HashMap<String,Object>();
					gameMap.put("gameName", game.getGameName());
					gameMap.put("gameOfficalUrl", game.getOfficialWebSite());
					gameMap.put("isHot", game.getIsHot()?1:0);
					gameMap.put("isNew", game.getIsNew()?1:0);
					gameList.add(gameMap);
				}
			}
			map.put("gameList", gameList);
			map.put("gameNum", gameList.size());
			result.add(map);
		}
		return result;
	}

	
	public HashMap<String,String> getGameCategory(){
        List datas = LibClassM.getLibClassDList("gamecategory");
        if(gameCategoryMap== null){
        	HashMap<String,String> tempMap = new HashMap<String,String>();
              for(int i = 0; i < datas.size(); i++){
            	  tempMap.put(((LibClassD)datas.get(i)).getItemno(), ((LibClassD)datas.get(i)).getItemname()); 	
              }	   
              gameCategoryMap = tempMap; 
        }                       
		       
		    return gameCategoryMap;
		}
}
