package com.xunlei.niux.manager.template.builder.niuoffical.v3;

import java.io.File;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

import org.springframework.util.CollectionUtils;

import com.ferret.common.dao.enums.OrderType;
import com.ferret.common.dao.vo.Page;
import com.xunlei.common.facade.IFacadeCommon;
import com.xunlei.common.vo.LibClassD;
import com.xunlei.common.vo.LibClassM;
import com.xunlei.httptool.util.JsonObjectUtil;
import com.xunlei.niux.data.vipgame.facade.FacadeFactory;
import com.xunlei.niux.data.vipgame.vo.Games;
import com.xunlei.niux.data.vipgame.vo.LinkInfo;
import com.xunlei.niux.manager.template.builder.AbstractTemplateBuilder;
import com.xunlei.niux.manager.web.cache.GameCache;
import com.xunlei.niux.manager.web.proxy.SynchGameInfoToBoxProxy;
import com.xunlei.niux.manager.web.util.FileUtil;
import com.xunlei.niux.manager.web.util.FreemarkerUtil;
import com.xunlei.util.StringTools;

public class GameCenterBuilder extends AbstractTemplateBuilder {
	private static final String boxDataUrl =  IFacadeCommon.INSTANCE.getLibconfigValueByConfigNo("boxDataUrl");	
	private boolean ispreview=false;
	private HashMap<String,String> gameCategoryMap;
	private String root = null;
    private  String roothtml = null;
//  String root = "d:/tmp/before";
//  String roothtml = "d:/tmp/format";
  
  public static void main(final String args[]){
	  try {
		new GameCenterBuilder().executeShcema();
	} catch (Exception e) {
		e.printStackTrace();
	}
  }
	
	@Override
	public void executeShcema() throws Exception {
		root = htmlTemplate.getTemplateroot();
	    roothtml = getHtmlRoot();
		buildGameCenter();
		buildActivity();
		buildSearch();
	}
	
	/**
	 * 搜索页模版
	 */
	private void buildSearch(){
		Map<String,Object> rootMap=new HashMap<String,Object>();
		rootMap.put("relatedList", getGuessList());    
		List<Map<String,Object>> recommendGameList = getRecommendGame();
		rootMap.put("recommendGame", recommendGameList);    
		String jsonStr=JsonObjectUtil.getDataJsonObject(recommendGameList);
		makeSearchJson(recommendGameList);
		makeSearchJs(jsonStr);
		FreemarkerUtil.buildHtml(root+"include/","related.html", rootMap, roothtml+"include/", "related.html");		
		Map<String,Object> rootMap2=new HashMap<String,Object>();
		rootMap2.put("adMap", getAdvMap());
		FreemarkerUtil.buildHtml(root,"search.html", rootMap2, roothtml, "search.html");
	}
	
	private void makeSearchJson(List<Map<String,Object>> recommendGameList){
        Map<String,Object> resultMap = new HashMap<String, Object>();
        resultMap.put("recommand",recommendGameList);
        String jsonStr = JsonObjectUtil.getDataJsonObject(resultMap);

		File file = FileUtil.createFile(boxDataUrl,"search.json");
		FileUtil.writeByChar(file, jsonStr);		
	}
	
	private void makeSearchJs(String jsonStr){
		jsonStr = "var searchArray="+jsonStr;
		File file = FileUtil.createFile(boxDataUrl,"search.js");
		FileUtil.writeByChar(file, jsonStr);		
	}

	private Map<String,Object> getAdvMap(){
		Map<String,Object> result = new HashMap<String,Object>();
		List<LinkInfo> infoList = FacadeFactory.INSTANCE.getLinkInfoBo().getValidteLinkInfoListByLinkLocId_V2("1522", 1, false);
		if(CollectionUtils.isEmpty(infoList)){
			return result;
		}
		LinkInfo info = infoList.get(0);
		result.put("src", info.getPicurl());
		result.put("url", info.getLinkurl());
		String url = info.getPicurl();
		String type = "img";
		if(StringTools.isNotEmpty(url)&&url.indexOf(".swf")!=-1){
			type = "swf";
		}
		result.put("type", type);
		return result;
	}
	
	
	private  List<Map<String,Object>> getRecommendGame(){
		List<Map<String,Object>> result = new ArrayList<Map<String,Object>>();
		LinkInfo linkInfo = new LinkInfo();
	    linkInfo.setLinklocid("1518");//搜索页猜你喜欢
	    Page page = new Page();
	    page.setPageNo(1);
	    page.setPageSize(5);
	    page.addOrder("validdatetime", OrderType.DESC);//
	    List<LinkInfo> list = FacadeFactory.INSTANCE.getLinkInfoBo().find(linkInfo, page);	
	    if(CollectionUtils.isEmpty(list))return result;
	    for(LinkInfo info :list){
	    	Map<String,Object> map = new HashMap<String,Object>();
	    	map.put("acturl", info.getLinkurl());
	  	    String gameId = info.getGameidbytuijian();
	  	    Games games = GameCache.getInstance().getGameByGameId(gameId);
	  	    map.put("gameid",gameId );
	  	    map.put("acturl", info.getLinkurl());
	  	    map.put("gamename", games.getGameName());
	  	    if(StringTools.isEmpty(info.getLinkurl())){
	  	    	 map.put("type", 1);
	  	    }else{
	  	    	 map.put("type", 2);
	  	    }
	  	    map.put("prior", info.getDisplaysort());
	  	   result.add(map);
	    }	  
	    return result;
	}
	
	/**
	 * 搜索页猜你喜欢
	 * @return
	 */
	private List<Map<String,Object>> getGuessList(){
		List<Map<String,Object>> datalist = new ArrayList<Map<String,Object>>();
		LinkInfo linkInfo = new LinkInfo();
	    linkInfo.setLinklocid("1502");//搜索页猜你喜欢
	    Page page = new Page();
	    page.setPageNo(1);
	    page.setPageSize(4);
	    page.addOrder("validdatetime", OrderType.DESC);//按照生效时间逆序
	    List<LinkInfo> list = FacadeFactory.INSTANCE.getLinkInfoBo().find(linkInfo, page);	    	    
		for(LinkInfo info:list){			
			Map<String,Object> map = new HashMap<String,Object>();
			String gameId = info.getGameidbytuijian();
			Games games = GameCache.getInstance().getGameByGameId(gameId);
			map.put("gameName", games.getGameName());
			map.put("gameNo", games.getGameNo());
			map.put("gameId", games.getGameId());
			map.put("content", info.getLinkdesc());
			map.put("bgImg", games.getPicUrl()==null?"":games.getPicUrl());
			map.put("gameOfficialUrl", games.getOfficialWebSite());
			datalist.add(map);
		}
		System.out.println("datalist:"+datalist);
		return datalist;
	}
	
	
	/**
	 * 活动页模版
	 */
	private void buildActivity(){
		Map<String,Object> rootMap=new HashMap<String,Object>();
		rootMap.put("bannerList", getActivityBannerList());
		FreemarkerUtil.buildHtml(root,"activity.html", rootMap, roothtml, "activity.html");
		FreemarkerUtil.buildHtml(root,"box_activity.html", rootMap, roothtml, "box_activity.html");
	}
	
	/**
	 * 游戏中心模版
	 */
	private void buildGameCenter(){
		Map<String,Object> rootMap=new HashMap<String,Object>();
        final List<Map<String,Object>> hotGameList = getHotList();
		rootMap.put("hotList", hotGameList);
		rootMap.put("conditions", getConditions());  
		final List<Map<String,Object>> allGameList = getAllGameList();
		rootMap.put("allGameList", allGameList);    		
//      String root = "d:/tmp/office";
//      String roothtml = "d:/tmp/offical";
		FreemarkerUtil.buildHtml(root,"gamecenter.html", rootMap, roothtml, "gamecenter.html");
		syncToBox(allGameList,hotGameList);
	}
    
	private void syncToBox(final List<Map<String,Object>> allGameList,final List<Map<String,Object>> hotGameList) {
		SynchGameInfoToBoxProxy.getInstance().makeAllGameListJS(allGameList,hotGameList);
	}

	private List<Map<String,Object>> getActivityBannerList(){
		List<Map<String,Object>> datalist = new ArrayList<Map<String,Object>>();
		LinkInfo linkInfo = new LinkInfo();
	    linkInfo.setLinklocid("1501");//活动页背景图
	    Page page = new Page();
        page.addOrder("displaysort", OrderType.DESC);
	    page.addOrder("validdatetime", OrderType.DESC);//按照生效时间逆序
	    List<LinkInfo> list = FacadeFactory.INSTANCE.getLinkInfoBo().find(linkInfo, page);	    
	    
		for(LinkInfo info:list){			
			Map<String,Object> map = new HashMap<String,Object>();
			map.put("title", info.getLinktitle());
			map.put("pic", info.getPicurl());
			map.put("url", info.getLinkurl());
			datalist.add(map);
		}
		System.out.println("datalist:"+datalist);
		return datalist;
	}
	
	/**
	 * 获得热门游戏列表
	 * @return
	 */
	private List<Map<String,Object>> getHotList(){
		List<Map<String,Object>> datalist = new ArrayList<Map<String,Object>>();
		LinkInfo linkInfo = new LinkInfo();
	    linkInfo.setLinklocid("1500");//牛x官网开服列表
	    Page page = new Page();
        page.addOrder("displaysort", OrderType.DESC);//按照降序序排
        page.addOrder("validdatetime", OrderType.DESC);//生效时间
	    List<LinkInfo> list = FacadeFactory.INSTANCE.getLinkInfoBo().find(linkInfo, page);	    
	    Map<String,String> gameCategory = getGameCategory();
		for(LinkInfo info:list){
			String gameId = info.getGameidbytuijian();
			Map<String,Object> map = new HashMap<String,Object>();
			Games games = GameCache.getInstance().getGameByGameId(gameId);
			map.put("gameName", games.getGameName());
			map.put("gameNo", games.getGameNo());
			map.put("gameId", games.getGameId());
			map.put("bgImg", info.getPicurl());
			map.put("isHot", games.getIsHot());
			map.put("gameOfficialUrl", games.getOfficialWebSite());
			map.put("peopleNumber", info.getExt1());
			map.put("gameTypeName", gameCategory.get(games.getGameType()));
			datalist.add(map);
		}
		return datalist;
	}
	
	public HashMap<String,String> getGameCategory(){
            List datas = LibClassM.getLibClassDList("gamecategory");
            if(gameCategoryMap== null){
            	HashMap<String,String> tempMap = new HashMap<String,String>();
                  for(int i = 0; i < datas.size(); i++){
                	  tempMap.put(((LibClassD)datas.get(i)).getItemno(), ((LibClassD)datas.get(i)).getItemname()); 	
                  }	   
                  gameCategoryMap = tempMap; 
            }                       
           
        return gameCategoryMap;
 }
	
	private Map<String,Object> getConditions(){
		Map<String,Object> conditions = new HashMap<String,Object>();		
		 List<Map<String,String>> gameTypeList =  getGameTypeList();
		 conditions.put("gameTypeList", gameTypeList);		 
		 List<Map<String,String>> gameFeatureList = getGameFeatureList();
		 conditions.put("gameFeatureList", gameFeatureList);		 
		 List<Map<String,String>> difficultyList = getDifficultyList();
		 conditions.put("difficultyList", difficultyList);
		// conditions.put("newHostList", getNewHotList());
		return conditions;
	}
	
	private List<Map<String,String>> getGameTypeList(){
		 List<Map<String,String>> gameTypeList = new ArrayList<Map<String,String>>();
		 List adatas = LibClassM.getLibClassDList("gamecategory");
		 for(int i = 0; i < adatas.size(); i++){
			Map<String,String> map = new HashMap<String,String>();
			map.put("typeId", ((LibClassD)adatas.get(i)).getItemno());
			map.put("typeName", ((LibClassD)adatas.get(i)).getItemname());
			gameTypeList.add(map);
         }	  
		 return gameTypeList;
	}
	
	private List<Map<String,String>> getGameFeatureList(){
		 List<Map<String,String>> gameFeatureList = new ArrayList<Map<String,String>>();
		 List bdatas = LibClassM.getLibClassDList("gameFeatures");
		 for(int i = 0; i < bdatas.size(); i++){
			Map<String,String> map = new HashMap<String,String>();
			map.put("featureId", ((LibClassD)bdatas.get(i)).getItemno());
			map.put("featureName", ((LibClassD)bdatas.get(i)).getItemname());
			gameFeatureList.add(map);
         }	  
		 return gameFeatureList;
	}
	
	private List<Map<String,String>> getNewHotList(){
		 List<Map<String,String>> difficultyList = new ArrayList<Map<String,String>>();
		 Map<String,String> map = new HashMap<String,String>();
		 map.put("isNew", "0");
		 map.put("isHot", "1");
		 map.put("typeName", "热门游戏");
		 difficultyList.add(map);
		 map = new HashMap<String,String>();
		 map.put("isNew", "1");
		 map.put("isHot", "0");
		 map.put("typeName", "最新游戏");
		 difficultyList.add(map);
		return difficultyList;
	}
	
	private List<Map<String,String>> getDifficultyList(){
		 List<Map<String,String>> difficultyList = new ArrayList<Map<String,String>>();
		 Map<String,String> map = new HashMap<String,String>();
		 map.put("difficultyId", "1");
		 map.put("difficultyName", "易");
		 difficultyList.add(map);
		 map = new HashMap<String,String>();
		 map.put("difficultyId", "2");
		 map.put("difficultyName", "中等");
		 difficultyList.add(map);
		 map = new HashMap<String,String>();
		 map.put("difficultyId", "3");
		 map.put("difficultyName", "难");
		 difficultyList.add(map);
		return difficultyList;
	}
	
	private List<Map<String,Object>> getAllGameList(){
		List<Map<String,Object>> list = new ArrayList<Map<String,Object>>();
		Games query = new Games();
		query.setStatus("1");//已经接入的游戏
		Page page = new Page();
		page.addOrder("simpleName", OrderType.ESC);
		List<Games> gameslist = FacadeFactory.INSTANCE.getBaseSo().findObjects(query, page);
		 Map<String,String> gameCategory = getGameCategory();
		for(Games game:gameslist){
			if(game.getClientType().intValue()==2||game.getClientType().intValue()==3)continue;//去掉手游
			Map<String,Object> map = new HashMap<String,Object>();
			map.put("gameName", game.getGameName());
			map.put("gameNo", game.getGameNo());
			map.put("gameId", game.getGameId());
			map.put("bgImg", game.getPicUrl()==null?"":game.getPicUrl());
			map.put("gameOfficialUrl", game.getOfficialWebSite());
			map.put("isNew", game.getIsNew()?1:0);
			map.put("isHot", game.getIsHot()?1:0);
			map.put("recommendIndex", game.getRecommendIndex());
			map.put("gameTypeId", game.getGameType());
			map.put("gameTypeName", gameCategory.get(game.getGameType()));
			map.put("gameFeatureId", game.getGameFeature());
			map.put("difficultyId", game.getPlayLevel());
			map.put("gameDesc", game.getGameDesc());
			String simpleName = game.getSimpleName();
			if(StringTools.isEmpty(simpleName)){
				simpleName = simpleName.substring(0,1);
				simpleName = simpleName.toUpperCase();
			}
			map.put("aleph", simpleName);
			list.add(map);
		}
		return list;
	}
}
