package com.xunlei.niux.manager.template.builder.niuoffical.taskcenter;

import com.ferret.common.dao.enums.OrderType;
import com.ferret.common.dao.vo.Page;
import com.xunlei.httptool.util.JsonObjectUtil;
import com.xunlei.niux.data.vipgame.dto.tasks.TaskGameConfigDTO;
import com.xunlei.niux.data.vipgame.facade.FacadeFactory;
import com.xunlei.niux.data.vipgame.vo.Games;
import com.xunlei.niux.data.vipgame.vo.LinkInfo;
import com.xunlei.niux.data.vipgame.vo.lottery.LotteryActivity;
import com.xunlei.niux.data.vipgame.vo.tasks.TaskDutyConfig;
import com.xunlei.niux.manager.constant.LinkLocationIdConstant;
import com.xunlei.niux.manager.template.builder.AbstractTemplateBuilder;
import com.xunlei.niux.manager.web.cache.GameCache;
import com.xunlei.niux.manager.web.util.FreemarkerUtil;
import org.apache.commons.collections.CollectionUtils;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

/**
 * Created by jamesjxin on 14-6-13.
 */
public class TaskCenterPageBuilder extends AbstractTemplateBuilder {

    private String root;
    private String roothtml;

    public TaskCenterPageBuilder(){
    }

    public TaskCenterPageBuilder(String root, String roothtml){
        this.root = root;
        this.roothtml = roothtml;
    }

    @Override
    public void executeShcema() throws Exception {

        Map<String,Object> rootMap = new HashMap<String,Object>();
        rootMap.put("taskLotteryMap",getTaskLotteryMap());
        rootMap.put("taskQuestionList",getTaskQuestionList());
        rootMap.put("recommentTaskList",getCurTasklist(true));//所有列表

        List<Map<String,Object>> taskList = getCurTasklist(false);
        rootMap.put("curTasklist",taskList);//所有列表 

        if(htmlTemplate != null){
            root = htmlTemplate.getTemplateroot();
            roothtml = getHtmlRoot();

            if(root.endsWith("/")){
                root += "include/";
            }else{
                root += "/include/";
            }

            if(roothtml.endsWith("/")){
                roothtml += "include/";
            }else {
                roothtml += "/include/";
            }
        }

        FreemarkerUtil.buildHtml(root, "taskbox.html", rootMap, roothtml, "taskbox.html");

        Map<String, Object> taskListMap = new HashMap<String, Object>();
        taskListMap.put("curTasklist", "var TASK_LIST = " + JsonObjectUtil.getDataJsonObject(taskList));
        FreemarkerUtil.buildHtml(root, "taskbox.js", taskListMap, roothtml, "taskbox.js");

    }

    private Map<String,Object> getTaskLotteryMap(){
        Map<String,Object> map = new HashMap<String, Object>();
        map.put("giftImg",getDayLotteryPicUrl());
        map.put("bonus",getDayLotteryConsumeBonus());

        return map;
    }

    private String getDayLotteryPicUrl(){
        LinkInfo info = new LinkInfo();
        info.setLinklocid(LinkLocationIdConstant.NIUX_OFFICIAL_TASKCENTERLOTTERYPIC);
        Page page = new Page();
        page.setPageNo(1);//第一页
        page.setPageSize(1);//只取前6个
        page.addOrder("displayorder", OrderType.DESC);//按照降序排
        List<LinkInfo> lilist = FacadeFactory.INSTANCE.getLinkInfoBo().find(info, page);
        if(CollectionUtils.isEmpty(lilist)){
            return "";
        }
        return lilist.get(0).getPicurl();
    }

    private int getDayLotteryConsumeBonus(){
        String actNo = "taskcenterlottery";
        LotteryActivity query = new LotteryActivity();
        query.setActNo(actNo);
        LotteryActivity activity = FacadeFactory.INSTANCE.getBaseSo().findObject(query);
        if(activity == null){
            return 0;
        }
        return activity.getBonusNum();
    }

    private List<Map<String,Object>> getTaskQuestionList(){
        List<Map<String,Object>> questionList = new ArrayList<Map<String, Object>>();
        List<LinkInfo> linkList=FacadeFactory.INSTANCE.getLinkInfoBo().getValidteLinkInfoListByLinkLocId_V2
                (LinkLocationIdConstant.NIUX_OFFICIAL_TASKCENTERCOMMONQUESTION, 1000, isPreView);
        if(CollectionUtils.isEmpty(linkList)){
            return questionList;
        }

        for(LinkInfo linkInfo : linkList){
            Map<String,Object> map = new HashMap<String, Object>();
            map.put("title",linkInfo.getLinktitle()==null?"":linkInfo.getLinktitle());
            map.put("content",linkInfo.getLinkcontents()==null?"":linkInfo.getLinkcontents());
            questionList.add(map);
        }

        return questionList;
    }

    private List<Map<String,Object>> getCurTasklist(boolean isRecommend){
        List<Map<String,Object>> resultList = new ArrayList<Map<String, Object>>();
        List<TaskGameConfigDTO> taskGameConfigDTOList = FacadeFactory.INSTANCE.getTaskGameConfigBo().getAllTaskGameConfigDTOList();

        if(CollectionUtils.isEmpty(taskGameConfigDTOList)){
            return resultList;
        }

        for(TaskGameConfigDTO gameConfigDTO : taskGameConfigDTOList){
            if(isRecommend){//过滤推荐列表
                if(resultList.size() >= 5){   //推荐列表只显示5个
                    break;
                }

                if(!gameConfigDTO.getIsRecommend()){
                    continue;
                }
            }

            Map<String,Object> gameConfigMap = new HashMap<String, Object>();
            gameConfigMap.put("seqId",gameConfigDTO.getSeqId());
            gameConfigMap.put("img",gameConfigDTO.getPicUrl()==null?"":gameConfigDTO.getPicUrl());
            gameConfigMap.put("gameId",gameConfigDTO.getGameId());
            gameConfigMap.put("muliPhotoUrl", gameConfigDTO.getMuliPhotoUrl());
            Games game = GameCache.getInstance().getGameByGameId(gameConfigDTO.getGameId());
            if(game!=null){
                gameConfigMap.put("gameName",game.getGameName());
                gameConfigMap.put("gameNo",game.getGameNo());
            }else {
                gameConfigMap.put("gameName","");
                gameConfigMap.put("gameNo","");
            }

            List<Map<String,Object>> itemList = new ArrayList<Map<String, Object>>();
            List<TaskDutyConfig> taskDutyConfigList = gameConfigDTO.getTaskConfigList();
            if(CollectionUtils.isNotEmpty(taskDutyConfigList)){
                for(TaskDutyConfig taskDutyConfig : taskDutyConfigList){
                    if(taskDutyConfig==null){
                        continue;
                    }
                    Map<String,Object> map = new HashMap<String, Object>();
                    map.put("conditionText",taskDutyConfig.getDutyDesc()==null?"":taskDutyConfig.getDutyDesc());
                    map.put("prizeText",taskDutyConfig.getRewardDesc()==null?"":taskDutyConfig.getRewardDesc());
                    map.put("prizeId",taskDutyConfig.getRewardGiftId()==null?"":taskDutyConfig.getRewardGiftId());
                    map.put("level", taskDutyConfig.getDutyType()==1?taskDutyConfig.getDutyValue():"0");    //如果任务类型为1（即等级任务），则返回等级，否则返回0
                    map.put("seqId",taskDutyConfig.getSeqId());
                    itemList.add(map);
                }
            }

            gameConfigMap.put("items",itemList);

            resultList.add(gameConfigMap);
        }

        return resultList;
    }


}
