package com.xunlei.niux.manager.template.builder.niuoffical.simplegameofficial;

import com.ferret.common.dao.enums.OrderType;
import com.ferret.common.dao.vo.Page;
import com.xunlei.niux.data.vipgame.bo.BaseSo;
import com.xunlei.niux.data.vipgame.facade.FacadeFactory;
import com.xunlei.niux.data.vipgame.vo.GameServers;
import com.xunlei.niux.data.vipgame.vo.Games;
import com.xunlei.niux.data.vipgame.vo.LinkInfo;
import com.xunlei.niux.data.vipgame.vo.PageStatisticsJs;
import com.xunlei.niux.data.vipgame.vo.gamebox.GameBoxDownLoadInfo;
import com.xunlei.niux.data.vipgame.vo.gamebox.OtherGBoxDownLoadInfo;
import com.xunlei.niux.manager.constant.LinkLocationIdConstant;
import com.xunlei.niux.manager.template.builder.AbstractTemplateBuilder;
import com.xunlei.niux.manager.web.util.FreemarkerUtil;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

/**
 * Created with IntelliJ IDEA.
 * User: admin
 * Date: 13-11-15
 * Time: 下午4:45
 * To change this template use File | Settings | File Templates.
 */
public class SimpleWebBuilder extends AbstractTemplateBuilder {
    private static final Logger logger = Logger.getLogger(SimpleWebBuilder.class);
    private BaseSo baseSo;
    private Map<String,Object> rootMap = new HashMap<String,Object>();
    private String root;
    private String roothtml;
    private String gameNo;

    public static void main(String[] args){
        try {
            new SimpleWebBuilder().executeShcema();
        }catch (Exception e){
            logger.error("SimpleWebBuilder build error!",e);
        }
    }

    @Override
    public void executeShcema() throws Exception {
        baseSo = FacadeFactory.INSTANCE.getBaseSo();
        root = htmlTemplate.getTemplateroot();
        roothtml = getHtmlRoot();
        String gameId = schema.getExt1();

        buildHead(gameId);

        buildContent(gameId);

        buildGameBoxInfo();
    }

    private void buildHead(String gameId){
        rootMap.put("headMap",getHeadMap(gameId));
        rootMap.put("gameMap",getGameMap(gameId));

        String foldPath = "";
        if(StringUtils.isEmpty(gameNo)){
            foldPath = "/tv3/official/"+"default"+"/simpleinclude/";
        }else {
            foldPath = "/tv3/official/"+gameNo+"/simpleinclude/";
        }
        FreemarkerUtil.buildHtml(root+"/simpleinclude/", "head.shtml", rootMap, roothtml+foldPath,
                "head.shtml");

    }

    private void buildContent(String gameId){
        rootMap.put("bannerImg",getLinkInfoImg(gameId,"622"));
        rootMap.put("exchangeStepOne",getExchangeStepMap(gameId, "623"));
        rootMap.put("exchangeStepTwo",getExchangeStepMap(gameId, "624"));

        String foldPath = "";
        if(StringUtils.isEmpty(gameNo)){
            foldPath = "/tv3/official/"+"default/";
        }else {
            foldPath = "/tv3/official/"+gameNo+"/";
        }
        FreemarkerUtil.buildHtml(root, "index.shtml", rootMap, roothtml+foldPath,
                "index.shtml");
    }

    private void buildGameBoxInfo(){
        rootMap.put("gameBox",getGameBoxInfo());
        rootMap.put("otherGameBox",getOtherGameBoxInfo());

        String foldpath = "/tv3/simpleinclude/";
        FreemarkerUtil.buildHtml(root+"/simpleinclude/", "gameBox.shtml", rootMap, roothtml+foldpath,
                "gameBox.shtml");
    }

    private Map<String,Object> getHeadMap(String gameId){
        Map<String,Object> map = new HashMap<String,Object>();
        LinkInfo linkquery = new LinkInfo();
        linkquery.setGameid(gameId);
        linkquery.setLinklocid("302");
        Page page = new Page();
        page.addOrder("linkid", OrderType.DESC);
        List<LinkInfo> linkInfoList = baseSo.findObjects(linkquery, page);

        if(CollectionUtils.isEmpty(linkInfoList)) {
            map.put("title","");
            map.put("keywords","");
            map.put("description","");
            map.put("gsid","");
            map.put("baiduId","");
            return map;
        }

        LinkInfo seoInfo = linkInfoList.get(0);

        map.put("title",seoInfo.getLinktitle()==null?"":seoInfo.getLinktitle());
        map.put("keywords",seoInfo.getExt1()==null?"":seoInfo.getExt1());
        map.put("description",seoInfo.getLinkdesc()==null?"":seoInfo.getLinkdesc());

        PageStatisticsJs jsQuery = new PageStatisticsJs();
        jsQuery.setGameId(gameId);
        Page page1 = new Page();
        page1.addOrder("seqId",OrderType.DESC);
        List<PageStatisticsJs> pageStatisticsJsList = baseSo.findObjects(jsQuery, page1);
        if(CollectionUtils.isEmpty(pageStatisticsJsList)){
        	 map.put("gsid","");
             map.put("baiduId","");
        }else{
            PageStatisticsJs statisticsJs = pageStatisticsJsList.get(0);
            map.put("gsid",statisticsJs.getStatisticsId()==null?"":statisticsJs.getStatisticsId());
            map.put("baiduId",statisticsJs.getBaiDuId()==null?"":statisticsJs.getBaiDuId());
        }

        return map;
    }
    private Map<String,Object> getGameMap(String gameId){
        Map<String,Object> map = new HashMap<String,Object>();
        Games query = new Games();
        query.setGameId(gameId);
        Page page = new Page();
        page.addOrder("seqId",OrderType.DESC);
        List<Games> gamesList = baseSo.findObjects(query,page);
        if(CollectionUtils.isEmpty(gamesList)){
            map.put("gameNo","");
            map.put("gameId","");
            map.put("gameName","");
            map.put("gameOfficial","");
            map.put("gameBBSUrl","");
            map.put("gameLogo","");
            map.put("gameDesc","");
            map.put("fenQuNum","");
            map.put("serverId","");
            map.put("newcardList",null);
            return map;
        }
        Games game = gamesList.get(0);
        map.put("gameNo",game.getGameNo()==null?"":game.getGameNo());
        map.put("gameId",gameId);
        map.put("gameName",game.getGameName());
        map.put("gameOfficial",game.getOfficialWebSite());
        map.put("gameBBSUrl",game.getForumUrl());

        map.put("gameLogo",getLinkInfoImg(gameId,"626"));

        map.put("gameDesc",game.getGameDesc()==null?"":game.getGameDesc());
        this.gameNo=game.getGameNo();
        //怎么取？
        GameServers serverQuery = new GameServers();
        serverQuery.setGameId(gameId);
        serverQuery.setOpenStatus("1");
        Page serverpage = new Page();
        serverpage.setPageNo(1);
        serverpage.setPageSize(1);
        page.addOrder("openTime",OrderType.DESC);

        List<GameServers> serversList = baseSo.findObjects(serverQuery,serverpage);
        if(CollectionUtils.isEmpty(serversList)){
            map.put("fenQuNum","");
            map.put("serverId","");
        }else {
            GameServers gameServer = serversList.get(0);
            map.put("fenQuNum",gameServer.getFenQuNum()==null?"":gameServer.getFenQuNum());
            map.put("serverId",gameServer.getServerId()==null?"":gameServer.getServerId());
        }

        map.put("newcardList",getNewCardTypeList(gameId));
        return map;
    }

    private String getLinkInfoImg(String gameId,String linkLocId){
        if(StringUtils.isEmpty(gameId)){
            return "";
        }
        LinkInfo query = new LinkInfo();
        query.setLinklocid(linkLocId);
        query.setGameid(gameId);

        List<LinkInfo> linkInfoList = FacadeFactory.INSTANCE.getBaseSo().findObjects(query,new Page());
        if(CollectionUtils.isEmpty(linkInfoList)){
            return "";
        }
        LinkInfo result = linkInfoList.get(0);

        return result.getPicurl();
    }

    private Map<String,Object> getExchangeStepMap(String gameId,String linklocid){
        Map<String,Object> map = new HashMap<String,Object>();
        if(StringUtils.isEmpty(gameId) || StringUtils.isEmpty(linklocid)){
            map.put("title","");
            map.put("img","");
            return map;
        }
        LinkInfo query = new LinkInfo();
        query.setLinklocid(linklocid);
        query.setGameid(gameId);
        Page page = new Page();
        page.addOrder("linkid",OrderType.DESC);
        List<LinkInfo> linkInfoList = FacadeFactory.INSTANCE.getBaseSo().findObjects(query,page);
        if(CollectionUtils.isEmpty(linkInfoList)){
            map.put("title","");
            map.put("img","");
            return map;
        }
        LinkInfo result = linkInfoList.get(0);

        map.put("title",result.getLinktitle()==null?"":result.getLinktitle());
        map.put("img",result.getPicurl()==null?"":result.getPicurl());

        return map;
    }

    private Map<String,Object> getGameBoxInfo(){
        Map<String,Object> map = new HashMap<String,Object>();
        GameBoxDownLoadInfo query = new GameBoxDownLoadInfo();
        Page page = new Page();
        page.addOrder("seqid",OrderType.DESC);

        List<GameBoxDownLoadInfo> gameBoxList = baseSo.findObjects(query,page);
        if(CollectionUtils.isEmpty(gameBoxList)){
            map.put("link","");
            map.put("date","");
            map.put("size","");
            return map;
        }
        GameBoxDownLoadInfo gameBox = gameBoxList.get(0);
        map.put("link",gameBox.getLink()==null?"":gameBox.getLink());
        map.put("date",gameBox.getDate()==null?"":gameBox.getDate());
        map.put("size",gameBox.getSize()==null?"":gameBox.getSize().toString());

        return map;
    }

    private Map<String,Object> getOtherGameBoxInfo(){
        Map<String,Object> map = new HashMap<String,Object>();
        OtherGBoxDownLoadInfo query = new OtherGBoxDownLoadInfo();
        Page page = new Page();
        page.addOrder("seqid",OrderType.DESC);

        List<OtherGBoxDownLoadInfo> otherGameBoxList = baseSo.findObjects(query,page);
        if(CollectionUtils.isEmpty(otherGameBoxList)){
            map.put("link","");
            map.put("title","");
            return map;
        }
        OtherGBoxDownLoadInfo otherGameBox = otherGameBoxList.get(0);
        map.put("link",otherGameBox.getLink()==null?"":otherGameBox.getLink());
        map.put("title",otherGameBox.getTitle()==null?"":otherGameBox.getTitle());
        return map;
    }

    private List<Map<String, String>> getNewCardTypeList(String gameId) {
        if(StringUtils.isEmpty(gameId)){
            return null;
        }
        List<Map<String, String>> newCardTypeList = new ArrayList<Map<String, String>>();
        List<LinkInfo> list = FacadeFactory.INSTANCE.getLinkInfoBo()
                .getGameValidteLinkInfoListByLinkLocId_v2("251", gameId, 20, isPreView);
        for (LinkInfo li : list) {
            Map<String, String> map = new HashMap<String, String>();
            map.put("id", li.getLinkid() + "");
            map.put("name", li.getLinktitle());
            newCardTypeList.add(map);
        }
        return newCardTypeList;
    }



}
