package com.xunlei.niux.manager.template.builder.niuoffical.indexbuilderthread;

import com.ferret.common.dao.enums.OrderType;
import com.ferret.common.dao.vo.Page;
import com.xunlei.niux.data.vipgame.facade.FacadeFactory;
import com.xunlei.niux.data.vipgame.vo.GameServers;
import com.xunlei.niux.data.vipgame.vo.Games;
import com.xunlei.niux.data.vipgame.vo.LinkInfo;
import com.xunlei.niux.manager.constant.LinkLocationIdConstant;
import com.xunlei.niux.manager.web.cache.GameCache;
import com.xunlei.niux.manager.web.util.DateUtil;
import com.xunlei.niux.manager.web.util.FreemarkerUtil;

import java.text.SimpleDateFormat;
import java.util.*;
import java.util.concurrent.Callable;

/**
 * Created by jamesjxin on 14-7-31.
 */
public class BuildServiceThread implements Callable{

    private String tempPath;
    private String htmlFilePath;
    private boolean isPreview;

    public BuildServiceThread(String tempPath, String htmlFilePath, boolean isPreview) {
        this.tempPath = tempPath;
        this.htmlFilePath = htmlFilePath;
        this.isPreview = isPreview;
    }

    @Override
    public Object call() throws Exception {
        buildService();
        return "";
    }

    /**
     * 生成最新开服列表
     */
    private void buildService(){
        Map<String,Object> rootMap=new HashMap<String,Object>();
        rootMap.put("yesterdayServiceList", getYesterdayLatestEreaList());
        rootMap.put("todayServiceList", getTodayLatestEreaList());
        rootMap.put("tomorrowServiceList", getTomorrowLatestEreaList());

        //String root = "d:/tmp/office";
        FreemarkerUtil.buildHtml(tempPath, "side_newServiceList.html", rootMap, htmlFilePath + "/include/", "side_newServiceList.html");
    }

    /**
     * 获得昨天的最新开服列表
     * @return
     */
    private List<Map<String,Object>> getYesterdayLatestEreaList(){
    	List<Map<String, Object>> result = new ArrayList<Map<String, Object>>();
	    String pattern = "yyyy-MM-dd";
        Calendar calendar = Calendar.getInstance();       
        calendar.add(Calendar.DAY_OF_YEAR,-1);
        Date yesterday = calendar.getTime();
        String yesterdayStr = DateUtil.format(yesterday,pattern);

	    List<GameServers> tomorrowServersList = FacadeFactory.INSTANCE.getGameServersBo()
	                .getNewOpenServersByFromDateAndToDate(yesterdayStr,yesterdayStr,true);
        for(GameServers server:tomorrowServersList){
        	String gameid = server.getGameId();
            LinkInfo logoli=FacadeFactory.INSTANCE.getLinkInfoBo().getGameValidteLinkInfoByLinkLocId(LinkLocationIdConstant.GAME_LOGO,gameid, isPreview);
            Games game= GameCache.getInstance().getGameByGameId(gameid);
            Map<String,Object> map=new HashMap<String,Object>();
            map.put("time", formatTimeH(server.getOpenTime()));
            map.put("gameName", game.getGameName());
            map.put("gameId", game.getGameNo());
            map.put("gameOfficialUrl",game.getOfficialWebSite());
            map.put("gameServerId", server.getFenQuNum());
            map.put("gameServerName", server.getFenQuName());
            map.put("gameImg", logoli==null?"":logoli.getPicurl());
            result.add(map);
        }

        return result;
    }

    /**
     * 获得今天的最新开服列表
     * @return
     */
    private List<Map<String,Object>> getTodayLatestEreaList(){
    	List<Map<String, Object>> result = new ArrayList<Map<String, Object>>();
	    String pattern = "yyyy-MM-dd";
        Calendar calendar = Calendar.getInstance();       
        Date today = calendar.getTime();
        String todayStr = DateUtil.format(today,pattern);

	    List<GameServers> tomorrowServersList = FacadeFactory.INSTANCE.getGameServersBo()
	                .getNewOpenServersByFromDateAndToDate(todayStr,todayStr,true);
        for(GameServers server:tomorrowServersList){
        	String gameid = server.getGameId();
            LinkInfo logoli=FacadeFactory.INSTANCE.getLinkInfoBo().getGameValidteLinkInfoByLinkLocId(LinkLocationIdConstant.GAME_LOGO,gameid, isPreview);
            Games game= GameCache.getInstance().getGameByGameId(gameid);
            Map<String,Object> map=new HashMap<String,Object>();
            map.put("time", formatTimeH(server.getOpenTime()));
            map.put("gameName", game.getGameName());
            map.put("gameId", game.getGameNo());
            map.put("gameOfficialUrl",game.getOfficialWebSite());
            map.put("gameServerId", server.getFenQuNum());
            map.put("gameServerName", server.getFenQuName());
            map.put("gameImg", logoli==null?"":logoli.getPicurl());
            result.add(map);
        }

        return result;}

    /**
     * 获得明天的最新开服列表
     * @return
     */
    private List<Map<String,Object>> getTomorrowLatestEreaList(){
    	List<Map<String, Object>> result = new ArrayList<Map<String, Object>>();
	    String pattern = "yyyy-MM-dd";
        Calendar calendar = Calendar.getInstance();       
        calendar.add(Calendar.DAY_OF_YEAR,1);
        Date tomorrow = calendar.getTime();
        String tomorrowStr = DateUtil.format(tomorrow,pattern);

	    List<GameServers> tomorrowServersList = FacadeFactory.INSTANCE.getGameServersBo()
	                .getNewOpenServersByFromDateAndToDate(tomorrowStr,tomorrowStr,true);
        for(GameServers server:tomorrowServersList){
        	String gameid = server.getGameId();
            LinkInfo logoli=FacadeFactory.INSTANCE.getLinkInfoBo().getGameValidteLinkInfoByLinkLocId(LinkLocationIdConstant.GAME_LOGO,gameid, isPreview);
            Games game= GameCache.getInstance().getGameByGameId(gameid);
            Map<String,Object> map=new HashMap<String,Object>();
            map.put("time", formatTimeH(server.getOpenTime()));
            map.put("gameName", game.getGameName());
            map.put("gameId", game.getGameNo());
            map.put("gameOfficialUrl",game.getOfficialWebSite());
            map.put("gameServerId", server.getFenQuNum());
            map.put("gameServerName", server.getFenQuName());
            map.put("gameImg", logoli==null?"":logoli.getPicurl());
            result.add(map);
        }

        return result;
    }

    public String formatTimeH(String time){
        if(time == null)return "";
        if(time.length() == 19){
            time = time.split(" ")[1];
            time = time.substring(0,5);
        }
        return time;
    }
}
