package com.xunlei.niux.manager.template.builder.niuoffical.indexbuilderthread;

import com.ferret.common.dao.enums.OrderType;
import com.ferret.common.dao.vo.Page;
import com.xunlei.niux.data.vipgame.facade.FacadeFactory;
import com.xunlei.niux.data.vipgame.vo.Games;
import com.xunlei.niux.data.vipgame.vo.LinkInfo;
import com.xunlei.niux.manager.constant.LinkLocationIdConstant;
import com.xunlei.niux.manager.web.cache.GameCache;
import com.xunlei.niux.manager.web.util.FreemarkerUtil;

import java.util.*;
import java.util.concurrent.Callable;

/**
 * Created by jamesjxin on 14-7-31.
 */
public class BuildHeaderThread implements Callable {

    private String tempPath;
    private String htmlFilePath;
    private boolean isPreview;

    public BuildHeaderThread(String tempPath, String htmlFilePath, boolean isPreview) {
        this.tempPath = tempPath;
        this.htmlFilePath = htmlFilePath;
        this.isPreview = isPreview;
    }

    @Override
    public Object call() throws Exception {
        buildHeader();
        return "";
    }

    private void buildHeader() {
        Map<String, Object> rootMap = new HashMap<String, Object>();
        rootMap.put("clientDownload", getClientDownloadLink());
        rootMap.put("seomap", getKeyWord());
        rootMap.put("gameListMap", getHeaderGames());
        //rootMap.put("topAD", getAdv());
        rootMap.put("leftPhoto", getLeftTitlePhoto());
        rootMap.put("middlePhoto", getMiddleTitlePhoto());
        rootMap.put("topRecommandGameList", getRecommandGameList());

        //String root = "d:/tmp/office";
        FreemarkerUtil.buildHtml(tempPath, "header.html", rootMap, htmlFilePath
                + "/include/", "header.html");

        FreemarkerUtil.buildHtml(tempPath, "head.html", rootMap, htmlFilePath
                + "/include/", "head.html");
    }

    /**
     * 获取客户端下载链接
     * @return
     */
    private Map<String, Object> getClientDownloadLink() {
        List<LinkInfo> llist = FacadeFactory.INSTANCE.getLinkInfoBo()
                .getValidteLinkInfoListByLinkLocId(
                        LinkLocationIdConstant.NIUX_COMMON_CLIENTDOWNLOADLINK,
                        2, false);
        if(llist == null ||llist.size()==0)return null;
        if (llist.size() < 2)
            return null;
        LinkInfo one = llist.get(0);
        LinkInfo two = llist.get(1);
        Map<String, Object> map = new LinkedHashMap<String, Object>();
        map.put("gameBoxURL", one.getLinkurl());
        map.put("jsqURL", two.getLinkurl());
        return map;
    }

    private Map<String, Object> getKeyWord() {
        Map<String, Object> map = new HashMap<String, Object>();
        List<LinkInfo> llist = FacadeFactory.INSTANCE.getLinkInfoBo()
                .getValidteLinkInfoListByLinkLocId(
                        LinkLocationIdConstant.NIUX_COMMON_KEYWORD, 1, false);
        if(llist == null||llist.size()==0)return null;
        for (LinkInfo linkinfo : llist) {
            map.put("title", linkinfo.getLinktitle() == null ? "" : linkinfo
                    .getLinktitle());
            map.put("description", linkinfo.getLinkdesc() == null ? ""
                    : linkinfo.getLinkdesc());
            map.put("keywords", linkinfo.getExt1() == null ? "" : linkinfo
                    .getExt1());
        }
        return map;
    }

    private static Map<String,List<Map<String,String>>> getHeaderGames(){
        Map<String,List<Map<String,String>>> map = new TreeMap<String,List<Map<String,String>>>();
        Games games = new Games();
        games.setStatus("1");//已接入的游戏
        Page page = new Page();
        page.addOrder("simpleName", OrderType.ESC);
        List<Games> gameslist = FacadeFactory.INSTANCE.getGamesBo().findGames(games, page);
        for(int i=(int)'A';i<'A'+26;i++){
            char ch = (char)i;
            List<Map<String,String>> list = new ArrayList<Map<String,String>>();
            for(Games game:gameslist){
                if(game.getClientType().intValue()==3)continue;//屏蔽掉手游
                String  simpleName = game.getSimpleName();
                simpleName = simpleName.substring(0,1);//首字母
                if(simpleName.equalsIgnoreCase(""+ch)){
                    Map<String,String> gmap = new HashMap<String,String>();
                    gmap.put("gameId", game.getGameId());
                    gmap.put("name", game.getGameName());
                    gmap.put("gameNo", game.getGameNo());
                    gmap.put("url", game.getOfficialWebSite()==null?"":game.getOfficialWebSite());
                    list.add(gmap);
                }
            }
            map.put(ch+"", list);
        }

        return map;
    }

    private Map<String,Object> getLeftTitlePhoto(){
        Map<String, Object> map = new HashMap<String, Object>();
        LinkInfo info = new LinkInfo();
        info.setLinklocid("663");
        info.setExt1("1");//	左边
        info.setIsvalid(true);
        Page page = new Page();
        page.setPageNo(1);
        page.setPageSize(1);
        page.addOrder("displayorder", OrderType.DESC);
        List<LinkInfo> llist = FacadeFactory.INSTANCE.getLinkInfoBo().find(info, page);
        if(llist == null||llist.size()==0)return null;
        LinkInfo linkinfo = llist.get(0);
        map.put("photo", linkinfo.getPicurl());
        map.put("linkurl", linkinfo.getLinkurl());
        map.put("type", linkinfo.getExt2());
        return map;
    }

    private Map<String,Object> getMiddleTitlePhoto(){
        Map<String, Object> map = new HashMap<String, Object>();
        LinkInfo info = new LinkInfo();
        info.setLinklocid("663");
        info.setExt1("2");//	中间
        info.setIsvalid(true);
        Page page = new Page();
        page.setPageNo(1);
        page.setPageSize(1);
        page.addOrder("displayorder", OrderType.DESC);
        List<LinkInfo> llist = FacadeFactory.INSTANCE.getLinkInfoBo().find(info, page);
        if(llist == null||llist.size()==0)return null;
        LinkInfo linkinfo = llist.get(0);
        map.put("photo", linkinfo.getPicurl());
        map.put("linkurl", linkinfo.getLinkurl());
        map.put("type", linkinfo.getExt2());
        return map;
    }

    private List<Map<String,Object>>  getRecommandGameList(){
        List<Map<String,Object>> resultlist = new ArrayList<Map<String,Object>>();
        LinkInfo info = new LinkInfo();
        info.setLinklocid("667");
        Page page = new Page();
        page.setPageNo(1);
        page.setPageSize(6);
        page.addOrder("validdatetime", OrderType.DESC);
        List<LinkInfo> llist = FacadeFactory.INSTANCE.getLinkInfoBo().find(info, page);
        for(LinkInfo link:llist){
            Map<String,Object> map = new HashMap<String,Object>();
            String gameid = link.getGameidbytuijian();
            Games  games = GameCache.getInstance().getGameByGameId(gameid);
            map.put("gameId", gameid);
            map.put("gameNo", games.getGameNo());
            map.put("gameName", games.getGameName());
            map.put("linkUrl", link.getLinkurl());
            map.put("isStrong", "1".equals(link.getExt1())?true:false);
            resultlist.add(map);
        }
        return resultlist;
    }



}
