package com.xunlei.niux.manager.template.builder.niuoffical.indexbuilderthread;

import com.ferret.common.dao.enums.OrderType;
import com.ferret.common.dao.vo.Page;
import com.xunlei.common.facade.IFacadeCommon;
import com.xunlei.httptool.util.JsonObjectUtil;
import com.xunlei.niux.data.vipgame.facade.FacadeFactory;
import com.xunlei.niux.data.vipgame.vo.GameServers;
import com.xunlei.niux.data.vipgame.vo.Games;
import com.xunlei.niux.data.vipgame.vo.LinkInfo;
import com.xunlei.niux.manager.constant.LinkLocationIdConstant;
import com.xunlei.niux.manager.web.cache.GameCache;
import com.xunlei.niux.manager.web.util.FileUploadUtil;
import com.xunlei.niux.manager.web.util.FileUtil;

import java.io.File;
import java.text.SimpleDateFormat;
import java.util.*;
import java.util.concurrent.Callable;

/**
 * Created by jamesjxin on 14-7-31.
 */
public class BuildGameServerJsonThread implements Callable{

    private String tempPath;
    private String htmlFilePath;
    private boolean isPreview;

    public BuildGameServerJsonThread(String tempPath, String htmlFilePath, boolean isPreview) {
        this.tempPath = tempPath;
        this.htmlFilePath = htmlFilePath;
        this.isPreview = isPreview;
    }

    @Override
    public Object call() throws Exception {
        buildGameServerJson();
        return "";
    }

    private void buildGameServerJson() throws Exception{
        String jsonStr = JsonObjectUtil.getDataJsonObject(getGameServerJson());
        jsonStr = "latest_server_list = "+jsonStr+";";
//		String htmlFilePath = isPreView ? htmlTemplate.getPreviewhtmlroot()
//				: htmlTemplate.getHtmlroot();

        String niuOfficialJsPath = IFacadeCommon.INSTANCE.getLibconfigValueByConfigNo("niuOfficialJsPath");
        if (niuOfficialJsPath.endsWith("/")) {
            niuOfficialJsPath = niuOfficialJsPath.substring(0, niuOfficialJsPath.length() - 1);
        }

        File file = FileUtil.createFile(niuOfficialJsPath + "/gamedata/", "lastestgameserver.js");
        FileUploadUtil.write(file, jsonStr);
    }

    /**
     * 获得开服列表的json数据
     * @return
     */
    private List<Map<String,Object>> getGameServerJson(){
        List<Map<String,Object>> result=new ArrayList<Map<String,Object>>();
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd");
        Calendar cal = Calendar.getInstance();
        cal.add(Calendar.DAY_OF_MONTH, 1);
        String tomorrow = sdf.format(cal.getTime());//获得明天的日期
        //获得后台录入的 首页最新开服列表中的数据
        LinkInfo linkInfo = new LinkInfo();
        linkInfo.setLinklocid("1240");//牛x官网开服列表
        Page page = new Page();
        page.addOrder("validdatetime", OrderType.DESC);//按照生效时间逆序
        List<LinkInfo> list = FacadeFactory.INSTANCE.getLinkInfoBo().find(linkInfo, page);
        if(list == null||list.size()==0)return null;

        //获得游戏的区服信息
        GameServers qgs=new GameServers();
        qgs.setOpenStatus("1");//状态为 “已开区”
        qgs.setToopentime(tomorrow+" 00:00:00");//只取今天以前的数据，其中包含今天的
        Page page1 = new Page();
        page1.addOrder("openTime", OrderType.DESC);
        List<GameServers> serverList=FacadeFactory.INSTANCE.getGameServersBo().find(qgs, page1);
        int jj = 0;
        boolean flag = true;
        for(GameServers server:serverList){
            if(flag){
                for(int i=0;i<list.size();i++){
                    LinkInfo li=list.get(i);
                    if(server.getGameId().trim().equals(li.getGameidbytuijian().trim())&&(server.getFenQuNum()+"").equals(li.getExt1().trim())){
                        //获取logo图片
                        LinkInfo logoli=FacadeFactory.INSTANCE.getLinkInfoBo().getGameValidteLinkInfoByLinkLocId(LinkLocationIdConstant.GAME_LOGO, li.getGameidbytuijian(), isPreview);
                        //游戏信息
//						Games game=FacadeFactory.INSTANCE.getGamesBo().getGameByGameId(li.getGameidbytuijian());
                        Games game= GameCache.getInstance().getGameByGameId(li.getGameidbytuijian());
                        Map<String,Object> map=new HashMap<String,Object>();
                        String opentime = server.getOpenTime();
                        map.put("openTime", opentime);
                        map.put("gameName", game.getGameName());
                        map.put("gameno", game.getGameNo());
                        map.put("gameid", game.getGameId());
                        map.put("officialurl",game.getOfficialWebSite());
                        map.put("fenQuNum", server.getFenQuNum());
                        map.put("clientType", game.getLoadClientType()==null?"0":game.getLoadClientType()+"");
                        map.put("picurl", logoli==null?"":logoli.getPicurl());
                        result.add(map);
                        jj ++;
                        if(jj>=20){
                            flag = false;
                            break;//取其中20条记录
                        }
                    }
                }
            }
        }
        System.out.println("result:"+result);
        return result;
    }
}
