package com.xunlei.niux.manager.template.builder.niuoffical.indexbuilderthread;

import com.xunlei.niux.data.vipgame.facade.FacadeFactory;
import com.xunlei.niux.data.vipgame.vo.Advice;
import com.xunlei.niux.data.vipgame.vo.Games;
import com.xunlei.niux.manager.web.cache.GameCache;
import com.xunlei.niux.manager.web.util.FreemarkerUtil;
import org.apache.log4j.Logger;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Callable;

/**
 * Created by jamesjxin on 14-7-31.
 */
public class BuildAdviceThread implements Callable{
    private static final Logger logger = Logger.getLogger(BuildAdviceThread.class);

    private String tempPath;
    private String htmlFilePath;
    private boolean isPreview;

    public BuildAdviceThread(String tempPath, String htmlFilePath, boolean isPreview) {
        this.tempPath = tempPath;
        this.htmlFilePath = htmlFilePath;
        this.isPreview = isPreview;
    }

    @Override
    public Object call() throws Exception {
        buildAdvice();
        return "";
    }

    private void buildAdvice() {
        Map<String, Object> rootMap = new HashMap<String, Object>();
        rootMap.put("announcementList", getAdviceAdv());
        rootMap.put("actList", getActivityAdv());

        //				        String root = "d:/tmp/office";
        //				        String roothtml = "d:/tmp/offical";
        FreemarkerUtil.buildHtml(tempPath, "side_announcement.html", rootMap,
                htmlFilePath + "/include/", "side_announcement.html");

    }

    /**
     * 获得公告
     * @return
     */
    public List<Map<String, Object>> getAdviceAdv() {
        String sql = "select * from advice where platformno='game' or platformno='platform' and adviceType in ('1','2','3') order by displayOrder asc limit 0,10";
        List<Advice> list = FacadeFactory.INSTANCE.getAdviceBo().executeQuery(
                Advice.class, sql, new ArrayList());
        List<Map<String, Object>> result = new ArrayList<Map<String, Object>>();
        logger.info("getAdviceAdv.size=====================>" + list.size());
        if(list == null||list.size()==0)return null;
        for (Advice info : list) {
            String gameid = info.getGameId();

            //游戏信息
            logger.info("gameid================>" + gameid);
//			Games game = FacadeFactory.INSTANCE.getGamesBo().getGameByGameId(
//					gameid);
            Games game= GameCache.getInstance().getGameByGameId(gameid);
            Map<String, Object> map = new HashMap<String, Object>();
            map.put("id", info.getSeqId());
            map.put("gameId", game == null ? "" : game.getGameNo());
            map.put("gameName", game == null ? "" : game.getGameName());
            map.put("title", info.getTitle());
            map.put("url", info.getJumpUrl()==null?"":info.getJumpUrl());
            map.put("gameOfficialUrl", game == null ? "" : game
                    .getOfficialWebSite());
            map.put("date", formatTime(info.getPublishDate()));
            result.add(map);
        }

        return result;
    }

    /**
     * 获得活动类公告
     * @return
     */
    public List<Map<String,Object>> getActivityAdv() {
        String sql = "select * from advice where platformno='activity' or platformno='gameact' and adviceType in ('1','2','3') order by displayOrder asc limit 0,10";
        List<Advice> list = FacadeFactory.INSTANCE.getAdviceBo().executeQuery(Advice.class, sql, new ArrayList());
        List<Map<String,Object>> result = new ArrayList<Map<String,Object>>();
        for(Advice info:list){
            String gameid = info.getGameId();
            //游戏信息
//	    		Games game=FacadeFactory.INSTANCE.getGamesBo().getGameByGameId(gameid);
            Games game=GameCache.getInstance().getGameByGameId(info.getGameId());
            Map<String,Object> map = new HashMap<String,Object>();
            map.put("id", info.getSeqId());
            map.put("gameId", game==null?"":game.getGameNo());
            map.put("gameName",game==null?"":game.getGameName());
            map.put("title", info.getTitle());
            map.put("url", info.getJumpUrl()==null?"":info.getJumpUrl());
            map.put("gameOfficialUrl",game==null?"":game.getOfficialWebSite());
            map.put("date", formatTime(info.getPublishDate()));
            result.add(map);
        }
        return result;
    }

    public String formatTime(String time){
        if(time == null)return "";
        if(time.length() == 19){
            time = time.split(" ")[0];
        }
        if(time.length() == 10){
            time = time.substring(5);
        }
        return time;
    }


}
