package com.xunlei.niux.manager.template.builder.niuoffical;

import java.io.File;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

import com.ferret.common.dao.enums.OrderType;
import com.ferret.common.dao.vo.Page;
import com.xunlei.httptool.util.JsonObjectUtil;
import com.xunlei.niux.data.vipgame.facade.FacadeFactory;
import com.xunlei.niux.data.vipgame.vo.Games;
import com.xunlei.niux.data.vipgame.vo.LinkInfo;
import com.xunlei.niux.manager.constant.LinkLocationIdConstant;
import com.xunlei.niux.manager.template.builder.AbstractTemplateBuilder;
import com.xunlei.niux.manager.web.util.FileUploadUtil;
import com.xunlei.niux.manager.web.util.FileUtil;

public class RiLiActBuilder extends AbstractTemplateBuilder {
	SimpleDateFormat sdf=new SimpleDateFormat("yyyy-MM-dd");
	public void executeShcema() throws Exception {
		String weekDate[]=new String[7];
		getWeekDate(weekDate);
		LinkInfo qli=new LinkInfo();
	    qli.setFromvaliddatetime(weekDate[0]+" 00:00:00");
	    qli.setTovaliddatetime(weekDate[6]+" 23:59:59");
	    qli.setLinklocid(LinkLocationIdConstant.NIUX_ACT_RILIACT);
	    Page page=new Page();
	    page.addOrder("validdatetime", OrderType.ESC);
	    List<LinkInfo> list=FacadeFactory.INSTANCE.getLinkInfoBo().find(qli,page);
	   
	    List<Map<String,Object>> gActList=new ArrayList<Map<String,Object>>();
	    for(LinkInfo li:list){
	    	String gameId=li.getGameidbytuijian();
	    	Map<String,Object> gameActMap=getGameActMap(gActList, gameId);
	    	if(gameActMap==null){
	    		gameActMap=new HashMap<String,Object>();
	    		Games game=FacadeFactory.INSTANCE.getGamesBo().getGameByGameId(gameId);
	    		gameActMap.put("gamename", game.getGameName());
	    		gameActMap.put("gameId",game.getGameId());
	    		gActList.add(gameActMap);
	    	}
	    	addLinkInfo(gameActMap,li,weekDate);
	    }
	    String jsonStr=JsonObjectUtil.getDataJsonObject(gActList);
	    jsonStr="var RILIACTS="+jsonStr;
		String htmlFilePath=isPreView?htmlTemplate.getPreviewhtmlroot():htmlTemplate.getHtmlroot();
	    File file=FileUtil.createFile(htmlFilePath, "riliact.js");
	    FileUploadUtil.write(file, jsonStr);
	}
	private void addLinkInfo(Map<String,Object> gameActMap,LinkInfo li,String[] weekDate){
		String validTime=li.getValiddatetime();
		int k=-2;
		for(int i=0;i<7;i++){
			if(validTime.startsWith(weekDate[i])){
				if(i==6){
					k=-1;
				}else{
					k=i;
				}
				break;
			}
		}
		if(k==-2){
			return;
		}
		k=k+1;
		@SuppressWarnings("unchecked")
		List<Map<String,Object>> tempList =(List<Map<String, Object>>) gameActMap.get(""+k);
		if(tempList==null){
			tempList=new ArrayList<Map<String,Object>>();
			gameActMap.put(""+k,tempList);
		}
		Map<String,Object> map=new HashMap<String,Object>();
		map.put("acttime", li.getValiddatetime());
		map.put("actname", li.getLinktitle());
		map.put("actlink", li.getLinkurl());
		tempList.add(map);
	}
	private Map<String,Object> getGameActMap(List<Map<String,Object>> gActList,String gameId){
		if(gActList==null){
			return null;
		}
		for(Map<String,Object> map:gActList){
			Object o=map.get("gameId");
			if(o==null){
				continue;
			}
			String tGameId=o.toString();
			if(gameId.equals(tGameId)){
				return map;
			}
		}
		return null;
	}
	private void getWeekDate(String weekDate[]){
		Calendar calendar=Calendar.getInstance();
		Date date = new Date();
		calendar.setTime(date);
	    int dayOfWeek = calendar.get(Calendar.DAY_OF_WEEK);
	    int i=0;
	    if(dayOfWeek==1){
	    	i=-6;
	    }else{
	    	i=2-dayOfWeek;
	    }
	    long cur=date.getTime();
	    long fromtime=cur+(i)*24*60*60*1000;
	    for(int k=0;k<7;k++){
	    	weekDate[k]=sdf.format(new Date(fromtime+(k)*24*60*60*1000));
	    }
	}
}
