package com.xunlei.niux.manager.template.builder.niuoffical;

import java.io.File;
import java.sql.Connection;
import java.sql.ResultSet;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

import com.xunlei.common.facade.IFacadeCommon;
import org.apache.log4j.Logger;
import com.xunlei.httptool.util.JsonObjectUtil;
import com.xunlei.niux.data.vipgame.facade.FacadeFactory;
import com.xunlei.niux.data.vipgame.vo.Games;
import com.xunlei.niux.data.vipgame.vo.LinkInfo;
import com.xunlei.niux.manager.constant.LinkLocationIdConstant;
import com.xunlei.niux.manager.template.builder.AbstractTemplateBuilder;
import com.xunlei.niux.manager.web.cache.GameCache;
import com.xunlei.niux.manager.web.util.FileUploadUtil;
import com.xunlei.niux.manager.web.util.FileUtil;
import com.xunlei.proxy.ProxyFactory;
import com.xunlei.proxy.socket.UserInfoProxy;
import com.xunlei.proxy.socket.bin.resp.Resp_getuserinfo_base;

/**
 * 他们都在玩业务处理类
 * @author lisu 
 * 2013-01-24
 */
public class PeoperGamingBuilder extends AbstractTemplateBuilder {
	private boolean ispreview = false;
	private static final Logger logger = Logger.getLogger(PeoperGamingBuilder.class);

	public static void main(String args[]) {
		try {
			new PeoperGamingBuilder().executeShcema();
		} catch (Exception e) {
			e.printStackTrace();
		}
	}

	public void executeShcema() throws Exception {
		logger.info("====开始生成他们都在玩js====");
		buildTop5Game();//top5
		logger.info("====他们都在玩js生成完毕====");
	}

	

	/**
	 * 生成他们都在玩js
	 */
	private void buildTop5Game() throws Exception {		
		//生成我的地盘所有游戏js
		String jsonStr = JsonObjectUtil.getDataJsonObject(getTop5());
		jsonStr = "var TOP_GAME_STATISTICS=" + jsonStr + ";";
		jsonStr += "\n";
		List<Map<String, Object>> mlist = new ArrayList<Map<String, Object>>();
		Map<String, Object> m = null;
		UserInfoProxy userInfoProxy = ProxyFactory.getInstance().getUserInfoProxy();	
		LinkInfo linfo = new LinkInfo();
		linfo.setLinklocid("236");//取得top5中的图片
		List<LinkInfo> lilist = FacadeFactory.INSTANCE.getLinkInfoBo().find(linfo);
		Connection conn = PeopleGamingConnection.getConnection();
		String sql = "select userid,game from niux_user_game_time  order by recdate desc,last_rectime desc limit 0,30";
		ResultSet rs = PeopleGamingConnection.getResultSet(conn, sql);
		while(rs.next()){
			 String userid = rs.getString("userid");//用户id
			 String gameNo = rs.getString("game");					 
			 for(LinkInfo info:lilist){
				 String gameId = info.getGameidbytuijian().trim();
				 Games game = GameCache.getInstance().getGameByGameId(gameId);
				 if(game.getGameNo().trim().equals(gameNo)){//查询用户游戏编号对应的游戏图片
					 m = new HashMap<String, Object>();
					 m.put("logo",info.getPicurl());
					 m.put("gameNo", gameNo);
					 //调用远程接口查询账户名
				     Resp_getuserinfo_base base = userInfoProxy.getuserinfo_base(userid, (byte)2);
					 m.put("userName", base.getUserAccount());//账号
					 mlist.add(m);
				 }
			 }

		}
		String str = JsonObjectUtil.getDataJsonObject(mlist);
		str = "var RECENTLY_PLAYER_STATISTICS=" + str + ";";
		jsonStr = jsonStr + str;
//		String htmlFilePath = isPreView ? htmlTemplate.getPreviewhtmlroot()
//				: htmlTemplate.getHtmlroot();
		// String root = "d:/tmp/office";
		//String htmlFilePath = "d:/tmp/offical";

        String niuOfficialJsPath = IFacadeCommon.INSTANCE.getLibconfigValueByConfigNo("niuOfficialJsPath");
        if (niuOfficialJsPath.endsWith("/")) {
            niuOfficialJsPath = niuOfficialJsPath.substring(0, niuOfficialJsPath.length() - 1);
        }

		File file = FileUtil.createFile(niuOfficialJsPath + "/gamedata/","top5game.js");
		FileUploadUtil.write(file, jsonStr);
	}


	/**
	 * 获得top5
	 * @return
	 */
	public List<Map<String, Object>> getTop5() {
		List<Map<String, Object>> result = new ArrayList<Map<String, Object>>();
		List<LinkInfo> lilist = FacadeFactory.INSTANCE.getLinkInfoBo()
				.getValidteLinkInfoListByLinkLocId(LinkLocationIdConstant.NIUX_COMMON_TOP5, 5, isPreView);
		if(lilist == null||lilist.size()==0)return null;
		for (LinkInfo info : lilist) {
			Map<String, Object> map = new HashMap<String, Object>();
			map.put("peopleNumber", info.getExt1());
			Games game = GameCache.getInstance().getGameByGameId(
					info.getGameidbytuijian().trim());
			map.put("gameName", game.getGameName());
			map.put("gameOfficialUrl", game.getOfficialWebSite());
			map.put("logo", info.getPicurl());
			result.add(map);
		}
		return result;

	}
	
}
