package com.xunlei.niux.manager.template.builder.niuoffical;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

import com.xunlei.niux.data.vipgame.facade.FacadeFactory;
import com.xunlei.niux.data.vipgame.vo.LinkInfo;
import com.xunlei.niux.manager.constant.LinkLocationIdConstant;
import com.xunlei.niux.manager.template.builder.AbstractTemplateBuilder;
import com.xunlei.niux.manager.web.util.FreemarkerUtil;
/**
 * 牛X活动
 * @author Administrator
 *
 */
public class NiuOfficialActBuilder extends AbstractTemplateBuilder {

	public void executeShcema() throws Exception {
		Map<String,Object> root=new HashMap<String,Object>();
		root.put("lunBolist", getLunBoList());
		root.put("advList", getAdvList());
		String tempPath=htmlTemplate.getTemplateroot();
		String templateFileName="act.ftl";
		String htmlFilePath=isPreView?htmlTemplate.getPreviewhtmlroot():htmlTemplate.getHtmlroot();
		String htmlFileName="act.html";
		FreemarkerUtil.buildHtml(tempPath, templateFileName, root, htmlFilePath, htmlFileName);
		
	}
	/**
	 * 获取轮播图信息
	 * @return
	 */
	public List<Object> getLunBoList(){
		List<Object> templist=new ArrayList<Object>();
		List<LinkInfo> lilist=FacadeFactory.INSTANCE.getLinkInfoBo().getValidteLinkInfoListByLinkLocId(LinkLocationIdConstant.NIUX_ACT_LUNBO, 3, isPreView);
		for(LinkInfo li:lilist){
			Map<String,Object> map=new HashMap<String,Object>();
			map.put("title", li.getLinktitle());
			map.put("desc", li.getLinkdesc());
			map.put("actNo", li.getExt2());
			map.put("picUrl", li.getPicurl());
			map.put("linkUrl", li.getLinkurl());
			templist.add(map);
		}
		return templist;
	}
	/**
	 * 获取广告位
	 */
	public List<Object> getAdvList(){
		List<Object> list=new ArrayList<Object>();
		LinkInfo li=FacadeFactory.INSTANCE.getLinkInfoBo().getValidteLinkInfoByLinkLocId(LinkLocationIdConstant.NIUX_ACT_ADV, isPreView);
		if(li!=null){
			Map<String,Object> map=new HashMap<String,Object>();
			map.put("title", li.getLinktitle());
			map.put("desc", li.getLinkdesc()==null?"":li.getLinkdesc());
			map.put("linkUrl", li.getLinkurl()==null?"":li.getLinkurl());
			map.put("picUrl", li.getPicurl()==null?"":li.getPicurl());
			list.add(map);
		}
		return list;
	}
}
