package com.xunlei.niux.manager.template.builder.niuoffical;

import com.ferret.common.dao.vo.Page;
import com.xunlei.niux.data.vipgame.facade.FacadeFactory;
import com.xunlei.niux.data.vipgame.vo.GameServers;
import com.xunlei.niux.data.vipgame.vo.Games;
import com.xunlei.niux.data.vipgame.vo.LinkInfo;
import com.xunlei.niux.manager.constant.LinkLocationIdConstant;
import com.xunlei.niux.manager.template.builder.AbstractTemplateBuilder;
import com.xunlei.niux.manager.web.util.FreemarkerUtil;

import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.*;

/**
 * 牛官网首页最新分区
 *
 * @author hezhong
 */
public class NiuOfficalNewFenquBuilder extends AbstractTemplateBuilder {

    public static final DateFormat DATE_FORMAT = new SimpleDateFormat("yyyy-MM-dd");

    @Override
    public void executeShcema() throws Exception {
        Map<String, Object> rootMap = new HashMap<String, Object>();

        String now = DATE_FORMAT.format(new Date());
        String[] week = getWeek();

        for(int i=0; i < 7; i++) {
            if(week[i].equals(now)) {
                rootMap.put("now", now.substring(5, 10));
                rootMap.put("nowday", i);
                break;
            }

        }

        rootMap.put("latestEreaDataList", getLatestEreaList());
        FreemarkerUtil.buildHtml(htmlTemplate.getTemplateroot(), "newfenqu.ftl", rootMap, getHtmlRoot(), "newfenqu.js");
    }


    /**
     * 获取一周时间
     *
     * @return
     */
    private static String[] getWeek() {
        Calendar calendar = Calendar.getInstance();
        calendar.setFirstDayOfWeek(Calendar.MONDAY);

        String[] week = new String[8];

        calendar.set(Calendar.DAY_OF_WEEK, Calendar.MONDAY);
        week[0] = DATE_FORMAT.format(calendar.getTime());

        for (int i = 1; i < 8; i++) {
            calendar.add(Calendar.DAY_OF_YEAR, 1);
            week[i] = DATE_FORMAT.format(calendar.getTime());
        }

        return week;
    }

    private static Map<String, List<Map<String, Object>>> getLatestEreaList() {
        String[] week = getWeek();

        List<LinkInfo> list = FacadeFactory.INSTANCE.getLinkInfoBo().
                getLinkInfoByLinkLocIdandTime(LinkLocationIdConstant.NIUX_LATESTOPENAREA, week[0] + " 00:00:00", week[7] + " 00:00:00", false);
        List<Map<String, Object>> result = new ArrayList<Map<String, Object>>();
        for (int i = 0; i < list.size(); i++) {
            LinkInfo li = list.get(i);
            if (li == null) {
                continue;
            }
            //获取logo图片
            LinkInfo logoli = FacadeFactory.INSTANCE.getLinkInfoBo().getGameValidteLinkInfoByLinkLocId(LinkLocationIdConstant.GAME_LOGO, li.getGameidbytuijian(), false);
            //游戏信息
            Games game = FacadeFactory.INSTANCE.getGamesBo().getGameByGameId(li.getGameidbytuijian());
            //游戏分区
            GameServers qgs = new GameServers();
            qgs.setGameId(li.getGameidbytuijian());
            qgs.setFenQuNum(Integer.valueOf(li.getExt1()));
            List<GameServers> gsList = FacadeFactory.INSTANCE.getGameServersBo().find(qgs, new Page());
            if (gsList == null || gsList.size() == 0) {
                continue;
            }
            GameServers gs = gsList.get(0);
            Map<String, Object> map = new HashMap<String, Object>();
            map.put("openTime", gs.getOpenTime());
            map.put("gameName", game.getGameName());
            map.put("gameNo", game.getGameNo());
            map.put("fenQuNum", gs.getFenQuNum());
            map.put("fenQuName", gs.getFenQuName());
            map.put("logoUrl", logoli == null ? "" : logoli.getPicurl());
            map.put("officialWebSite", game.getOfficialWebSite());
            map.put("openStatus", gs.getOpenStatus());
            map.put("isHot", "0");
            result.add(map);

        }

        Map<String, List<Map<String, Object>>> tempMap = new HashMap<String, List<Map<String, Object>>>();

        for (String day : week) {
            tempMap.put(day, new ArrayList<Map<String, Object>>());
        }

        for (Map<String, Object> infoMap : result) {
            String day = infoMap.get("openTime").toString().substring(0, 10);

            List<Map<String, Object>> maps = tempMap.get(day);
            if (maps != null) {
                maps.add(infoMap);
            }
        }

        Map<String, List<Map<String, Object>>> dataMap = new HashMap<String, List<Map<String, Object>>>();
        for(int i=0; i < 7; i++) {
            dataMap.put(String.valueOf(i), tempMap.get(week[i]));
        }


        return dataMap;
    }
}
