package com.xunlei.niux.manager.template.builder.niuoffical;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

import com.ferret.common.dao.vo.Page;
import com.xunlei.niux.data.vipgame.facade.FacadeFactory;
import com.xunlei.niux.data.vipgame.vo.GameServers;
import com.xunlei.niux.data.vipgame.vo.Games;
import com.xunlei.niux.data.vipgame.vo.LinkInfo;
import com.xunlei.niux.manager.constant.LinkLocationIdConstant;
import com.xunlei.niux.manager.template.builder.AbstractTemplateBuilder;
import com.xunlei.niux.manager.web.util.FreemarkerUtil;

/**
 * 创建牛官网模板
 * @author lin
 * @date 2012-10-10
 * @Descripter:
 */
public class NiuOfficalBuilder extends AbstractTemplateBuilder{
	private boolean ispreview=false;
    /**
	 * 生成首页模板
	 */
	private void buildIndex(){
		Map<String,Object> rootMap=new HashMap<String,Object>();
		rootMap.put("tuijiangamedata",getTuiJianGameHtml());
		rootMap.put("activessideadvdata", getActiviesSideAdvHtml());
		rootMap.put("latestplaygamesideadvdata", getLatestPlayGameSideAdv());
        rootMap.put("noticeadvdata", getNoticeAdv());

        rootMap.put("seomap", getKeyWord());
        rootMap.put("frieldlinklist", getFriendLink());
		//rootMap.put("latestEreaDataList", getLatestEreaList());
		//System.out.println(htmlTemplate.getTemplateroot());
		FreemarkerUtil.buildHtml(htmlTemplate.getTemplateroot(),"index.ftl", rootMap, getHtmlRoot(), "index.html");
	}

    private Map<String,Object> getKeyWord() {
        Map<String,Object> map=new HashMap<String,Object>();

        List<LinkInfo> llist=FacadeFactory.INSTANCE.getLinkInfoBo().getValidteLinkInfoListByLinkLocId(LinkLocationIdConstant.NIUX_OFFICIAL_KEYWORD, 1, false);
        for(LinkInfo linkinfo:llist){

            map.put("title",linkinfo.getLinktitle()==null?"":linkinfo.getLinktitle());
            map.put("desc",linkinfo.getLinkdesc()==null?"":linkinfo.getLinkdesc());
            map.put("keyword",linkinfo.getExt1()==null?"":linkinfo.getExt1());
        }
        return map;
    }

    private List<Map<String,Object>> getLatestEreaList(){
		List<LinkInfo> list=FacadeFactory.INSTANCE.getLinkInfoBo().getValidteLinkInfoListByLinkLocId(LinkLocationIdConstant.NIUX_LATESTOPENAREA, 5, isPreView);
		List<Map<String,Object>> result=new ArrayList<Map<String,Object>>();
		for(int i=0;i<list.size();i++){
			LinkInfo li=list.get(i);
			if(li==null){
				continue;
			}
			//获取logo图片
			LinkInfo logoli=FacadeFactory.INSTANCE.getLinkInfoBo().getGameValidteLinkInfoByLinkLocId(LinkLocationIdConstant.GAME_LOGO, li.getGameidbytuijian(), ispreview);
			//游戏信息
			Games game=FacadeFactory.INSTANCE.getGamesBo().getGameByGameId(li.getGameidbytuijian());
			//游戏分区
			GameServers qgs=new GameServers();
			qgs.setGameId(li.getGameidbytuijian());
			qgs.setFenQuNum(Integer.valueOf(li.getExt1()));
			List<GameServers> gsList=FacadeFactory.INSTANCE.getGameServersBo().find(qgs, new Page());
			if(gsList==null||gsList.size()==0){
				continue;
			}
			GameServers gs=gsList.get(0);
			Map<String,Object> map=new HashMap<String,Object>();
			map.put("openTime", gs.getOpenTime());
			map.put("gameName", game.getGameName());
			map.put("gameNo", game.getGameNo());
			map.put("fenQuNum", gs.getFenQuNum());
			map.put("fenQuName", gs.getFenQuName());
			map.put("logoUrl", logoli==null?"":logoli.getPicurl());
			map.put("officialWebSite", game.getOfficialWebSite());
			map.put("openStatus", gs.getOpenStatus());
			result.add(map);
			
		}
		return result;
	}
	/**
	 * 最近玩过的游戏旁广告
	 * @return
	 */
	private String getLatestPlayGameSideAdv(){
		StringBuilder sb=new StringBuilder();
		//获取广告
		LinkInfo li=FacadeFactory.INSTANCE.getLinkInfoBo().getValidteLinkInfoByLinkLocId(LinkLocationIdConstant.NIUX_OFFICIAL_LATESTPALYGAMESIDE_ADV,ispreview);
		if(li==null){
			return "";
		}
		//获取游戏信息
		Games g=FacadeFactory.INSTANCE.getGamesBo().getGameByGameId(li.getGameidbytuijian());
		//获取最新开区
		GameServers gstemp=FacadeFactory.INSTANCE.getGameServersBo().getLatestGameServerByGameId(li.getGameidbytuijian(), ispreview);
		if(g==null||gstemp==null){
			return "";
		}
		sb.append("您最近还没玩游戏，不过听说他们最近都在玩\"").append(g.getGameName()).append("\",推荐你也  <a href=\"javascript:niux.game.enter_game(").append(gstemp.getFenQuNum()).append(",'").append(g.getGameNo())
		.append("');\">去试试&gt;&gt;</a>");
		return sb.toString();
	}
	/**
	 * 获取我的奖品旁的广告位
	 * @return
	 */
	private LinkInfo getActiviesSideAdvHtml(){
		LinkInfo linkInfo=FacadeFactory.INSTANCE.getLinkInfoBo().getValidteLinkInfoByLinkLocId(LinkLocationIdConstant.NIUX_OFFICIAL_MYACTIVITYSIDE_ADV, ispreview);

        return linkInfo;
	}
	/**
	 * 获取推荐游戏
	 * @return
	 */
	private List<Map<String, String>> getTuiJianGameHtml(){
        List<Map<String, String>> tuijianGame = new ArrayList<Map<String, String>>();

		List<LinkInfo> list=FacadeFactory.INSTANCE.getLinkInfoBo().getValidteLinkInfoListByLinkLocId(LinkLocationIdConstant.NIUX_OFFICIAL_TUJIANGAME, 2, ispreview);

		for(int i=0;i<list.size();i++){
			LinkInfo linkInfo=list.get(i);
			//获取被推荐游戏信息
			Games games=FacadeFactory.INSTANCE.getGamesBo().getGameByGameId(linkInfo.getGameidbytuijian());
			if(games==null){
				continue;
			}

			String logoUrl=linkInfo.getPicurl();
			if(logoUrl==null||"".equals(logoUrl)){
				//获取游戏logo
				LinkInfo logoli=FacadeFactory.INSTANCE.getLinkInfoBo().getGameValidteLinkInfoByLinkLocId(LinkLocationIdConstant.GAME_LOGO,linkInfo.getGameidbytuijian() ,ispreview);
				if(logoli!=null){
					logoUrl=logoli.getPicurl();
				}
			}

            Map<String, String> data = new HashMap<String, String>();
            data.put("officialWebSite", games.getOfficialWebSite());
            data.put("logoUrl", logoUrl);
            data.put("gameName", games.getGameName());

            tuijianGame.add(data);

		}
		return tuijianGame;
	}
	public void executeShcema() throws Exception {
		ispreview=isPreView;
		//生成模板
		buildIndex();
	}

    public List<LinkInfo> getNoticeAdv() {
        List<LinkInfo> list=FacadeFactory.INSTANCE.getLinkInfoBo().getValidteLinkInfoListByLinkLocId(LinkLocationIdConstant.NIUX_OFFICIA_RILIACT, 10, ispreview);

        return list;
    }

    public List<Map<String,Object>> getFriendLink() {
        List<Map<String,Object>> list=new ArrayList<Map<String,Object>>();
        List<LinkInfo> llist=FacadeFactory.INSTANCE.getLinkInfoBo().getValidteLinkInfoListByLinkLocId(LinkLocationIdConstant.NIUX_OFFICIA_FRIENDLINK, 30, ispreview);
        for(LinkInfo linkinfo:llist){
            Map<String,Object> map=new HashMap<String,Object>();
            map.put("title", linkinfo.getLinktitle()==null?"":linkinfo.getLinktitle());
            map.put("linkurl", linkinfo.getLinkurl()==null?"":linkinfo.getLinkurl());
            list.add(map);
        }
        return list;
    }
}
