package com.xunlei.niux.manager.template.builder.niuoffical;

import com.ferret.common.dao.enums.OrderType;
import com.ferret.common.dao.vo.Page;
import com.xunlei.niux.data.vipgame.facade.FacadeFactory;
import com.xunlei.niux.data.vipgame.vo.FortuneGift;
import com.xunlei.niux.data.vipgame.vo.gift.Gift;
import com.xunlei.niux.data.vipgame.vo.lottery.LotteryActivity;
import com.xunlei.niux.data.vipgame.vo.lottery.LotteryGift;
import com.xunlei.niux.data.vipgame.enums.GiftTypeEnum;
import com.xunlei.niux.manager.template.builder.AbstractTemplateBuilder;
import com.xunlei.niux.manager.web.util.FreemarkerUtil;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;

import java.util.*;

/**
 * Created with IntelliJ IDEA.
 * User: admin
 * Date: 13-11-8
 * Time: 下午3:46
 * To change this template use File | Settings | File Templates.
 */
public class LotteryBuilder extends AbstractTemplateBuilder {
    private static final Logger logger = Logger.getLogger(LotteryBuilder.class);

    public static void main(String args[]) {
        try {
            new LotteryBuilder().executeShcema();
        } catch (Exception e) {
            logger.error("Error when LotteryBuilder executeShcema: ",e);
        }
    }

    @Override
    public void executeShcema() throws Exception {
        buildLottery();
    }

    private void buildLottery(){
        Map<String, Object> rootMap = new HashMap<String, Object>();
        rootMap.put("lotteryOne",getLotteryGiftListByActNo("lottery0001"));
        rootMap.put("renPinGift",getRenPinGift());
        rootMap.put("lotteryTwo",getRealLotteryGiftByActNo("lottery0002"));
        rootMap.put("lotteryThree",getRealLotteryGiftByActNo("lottery0003"));
        rootMap.put("lotteryFour",getRealLotteryGiftByActNo("lottery0004"));

        String root = htmlTemplate.getTemplateroot();
        String roothtml = getHtmlRoot();
        FreemarkerUtil.buildHtml(root, "lottery.html", rootMap, roothtml,
                "lottery.html");
//        FreemarkerUtil.buildHtml("D:\\lottery\\", "lottery.html", rootMap, "D:\\lottery\\output",
//                "lottery.html");
    }

    private List<Map<String,Object>> getLotteryGiftListByActNo(String actNo){
        List<Map<String,Object>> result = new ArrayList<Map<String,Object>>();
        if(StringUtils.isEmpty(actNo)){
            return result;
        }
        LotteryGift query = new LotteryGift();
        query.setActNo(actNo);
        query.setIsValid(true);

        Page page = new Page();
        page.addOrder("displayOrder", OrderType.DESC);
        List<LotteryGift> giftList = FacadeFactory.INSTANCE.getBaseSo().findObjects(query,page);

        if(CollectionUtils.isEmpty(giftList)){
            return result;
        }

        for(LotteryGift lotteryGift : giftList){
            Map<String,Object> map = new HashMap<String,Object>();
            String giftId = lotteryGift.getGiftId();
            Gift gift = getGiftById(giftId);

            if(gift == null){
                logger.error("lotteryGift: " + giftId + " not exist!");
                continue;
            }

            map.put("id",lotteryGift.getGiftId());
            map.put("name",lotteryGift.getGiftName());
            map.put("desc",gift.getSimpleDesc()==null?"":gift.getSimpleDesc());
            map.put("img",lotteryGift.getPhoto()==null?"":lotteryGift.getPhoto());

            result.add(map);
        }

        return result;
    }

    private Map<String,Object> getRealLotteryGiftByActNo(String actNo){
        Map<String,Object> map = new HashMap<String,Object>();
        if(StringUtils.isEmpty(actNo)){
            return map;
        }

        //获取lotterygift
        LotteryGift query = new LotteryGift();
        query.setActNo(actNo);
        query.setIsValid(true);
        query.setGiftType(GiftTypeEnum.GOTGIFT);
        Page page = new Page();
        page.addOrder("displayOrder", OrderType.ESC);
        List<LotteryGift> giftList = FacadeFactory.INSTANCE.getBaseSo().findObjects(query,page);

        if(CollectionUtils.isEmpty(giftList)){
            return map;
        }

        LotteryGift lotteryGift = giftList.get(0);
        String giftId = lotteryGift.getGiftId();
        Gift gift = getGiftById(giftId);

        LotteryActivity activity = getLotteryActivityByActNo(actNo);
        if(activity == null){
            return map;
        }


        map.put("id",lotteryGift.getGiftId());
        map.put("name",lotteryGift.getGiftName());
        map.put("desc",gift.getSimpleDesc()==null?"":gift.getSimpleDesc());
        map.put("price",gift.getProductUnitPrice());
        map.put("amount",lotteryGift.getTotalCount());
        map.put("vipLevel",activity.getJinKaVipNum());
        map.put("img",lotteryGift.getPhoto()==null?"":lotteryGift.getPhoto());

        return map;
    }

    private List<Map<String,Object>> getRenPinGift(){
        List<Map<String,Object>> result = new ArrayList<Map<String,Object>>();

        List<FortuneGift> giftList = FacadeFactory.INSTANCE.getFortuneGiftBo().getValidFortuneGifts(new Date(),6);
        if(CollectionUtils.isEmpty(giftList)){
            return result;
        }

        for(FortuneGift fortuneGift : giftList){
            Gift giftEntity = getGiftById(fortuneGift.getGiftId().toString());
            if(giftEntity == null){
                continue;
            }
            Map<String,Object> map = new HashMap<String,Object>();
            map.put("id",fortuneGift.getFortuneGiftId().toString());
            map.put("name",giftEntity.getGiftName()==null?"":giftEntity.getGiftName());
            map.put("desc",giftEntity.getSimpleDesc()==null?"":giftEntity.getSimpleDesc());
            map.put("img",fortuneGift.getGiftPic()==null?"":fortuneGift.getGiftPic());
            map.put("rpValue",fortuneGift.getFortunePoint()==null?0:fortuneGift.getFortunePoint());
            result.add(map);
        }

        return result;
    }

    private Gift getGiftById(String giftId){
        if(StringUtils.isEmpty(giftId)){
            return null;
        }
        Gift query = new Gift();
        query.setGiftId(Long.parseLong(giftId));

        Gift gift = FacadeFactory.INSTANCE.getBaseSo().findObject(query);

        return gift;
    }

    private LotteryActivity getLotteryActivityByActNo(String actNo){
        if(StringUtils.isEmpty(actNo)){
            return null;
        }

        LotteryActivity query = new LotteryActivity();
        query.setActNo(actNo);
        query.setIsValid(true);

        List<LotteryActivity> list = FacadeFactory.INSTANCE.getBaseSo().findObjects(query,new Page());

        if(CollectionUtils.isEmpty(list)){
            return null;
        }
        return list.get(0);
    }
}
