package com.xunlei.niux.manager.template.builder.niuoffical;

import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

import com.xunlei.niux.data.vipgame.facade.FacadeFactory;
import com.xunlei.niux.data.vipgame.vo.LinkInfo;
import com.xunlei.niux.manager.constant.LinkLocationIdConstant;
import com.xunlei.niux.manager.template.builder.AbstractTemplateBuilder;
import com.xunlei.niux.manager.web.util.FreemarkerUtil;

public class HeadBuilder extends AbstractTemplateBuilder{
	private boolean ispreview=false;

	public void executeShcema() throws Exception {
		buildHead();
		buildHeader();
	}
	 /**
	 * 生成头文件
	 */
	private void buildHead(){
		Map<String,Object> rootMap=new HashMap<String,Object>();
        rootMap.put("seomap", getKeyWord());
        rootMap.put("clientDownload", getClientDownloadLink());
        String root = htmlTemplate.getTemplateroot();
        String roothtml = getHtmlRoot();
        //String root = "d:/tmp/office";
		FreemarkerUtil.buildHtml(root,"head.html", rootMap, roothtml+"/include/", "head.html");
	}
	private void buildHeader(){
		Map<String,Object> rootMap=new HashMap<String,Object>();
        rootMap.put("clientDownload", getClientDownloadLink());
        rootMap.put("seomap", getKeyWord());
        rootMap.put("topAD", getAdv());
        String root = htmlTemplate.getTemplateroot();
        String roothtml = getHtmlRoot();
        //String root = "d:/tmp/office";
		FreemarkerUtil.buildHtml(root,"header.html", rootMap, roothtml+"/include/", "header.html");
	}
	
	 private Map<String,Object> getKeyWord() {
	        Map<String,Object> map=new HashMap<String,Object>();
	        List<LinkInfo> llist=FacadeFactory.INSTANCE.getLinkInfoBo().getValidteLinkInfoListByLinkLocId(LinkLocationIdConstant.NIUX_COMMON_KEYWORD, 1, false);
	        for(LinkInfo linkinfo:llist){
	            map.put("title",linkinfo.getLinktitle()==null?"":linkinfo.getLinktitle());
	            map.put("description",linkinfo.getLinkdesc()==null?"":linkinfo.getLinkdesc());
	            map.put("keywords",linkinfo.getExt1()==null?"":linkinfo.getExt1());
	        }
	        return map;
	    }
	 
	 /**
	  * 获取客户端下载链接
	  * @return
	  */
	 private Map<String,Object> getClientDownloadLink(){
		 List<LinkInfo> llist=FacadeFactory.INSTANCE.getLinkInfoBo().getValidteLinkInfoListByLinkLocId(LinkLocationIdConstant.NIUX_COMMON_CLIENTDOWNLOADLINK, 2, false);
		 if(llist.size() < 2) return null;
		 LinkInfo one = llist.get(0);
		 LinkInfo two = llist.get(1);
		 Map<String,Object> map = new LinkedHashMap<String,Object>();
		 map.put("gameBoxURL", one.getLinkurl());
		 map.put("jsqURL", two.getLinkurl());
		 return map;
	 }
	 
	 /**
		 * 获取公用广告位
		 * @return
		 */
		public Map<String,Object> getAdv(){
			List<LinkInfo> lilist=FacadeFactory.INSTANCE.getLinkInfoBo().getValidteLinkInfoListByLinkLocId(LinkLocationIdConstant.NIUX_COMMON_ADV, 1, isPreView);
			Map<String,Object> map=new HashMap<String,Object>();
			if(lilist == null||lilist.size()==0){
				return null;
			}else{
				LinkInfo li = lilist.get(0);			
				map.put("img", li.getPicurl());
				map.put("url", li.getLinkurl());
			}
			
			return map;
		}
}
