package com.xunlei.niux.manager.template.builder.niuoffical;

import java.io.File;
import java.text.DateFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

import com.xunlei.common.facade.IFacadeCommon;
import org.apache.log4j.Logger;
import com.ferret.common.dao.enums.OrderType;
import com.ferret.common.dao.vo.Page;
import com.xunlei.httptool.util.JsonObjectUtil;
import com.xunlei.niux.data.vipgame.facade.FacadeFactory;
import com.xunlei.niux.data.vipgame.vo.GameServers;
import com.xunlei.niux.data.vipgame.vo.Games;
import com.xunlei.niux.data.vipgame.vo.LinkInfo;
import com.xunlei.niux.manager.constant.LinkLocationIdConstant;
import com.xunlei.niux.manager.template.builder.AbstractTemplateBuilder;
import com.xunlei.niux.manager.web.cache.GameCache;
import com.xunlei.niux.manager.web.util.DateUtil;
import com.xunlei.niux.manager.web.util.FileUploadUtil;
import com.xunlei.niux.manager.web.util.FileUtil;
import com.xunlei.niux.manager.web.util.FreemarkerUtil;

public class GameServerBuilder extends AbstractTemplateBuilder{
	private boolean ispreview=false;
	private static final Logger logger = Logger.getLogger(GameServerBuilder.class);
	private static final  int pagesize = 15;

	
	public void executeShcema() throws Exception {
		buildGameServer();//生成牛x官网开服列表
		buildGameServerJs();//生成盒子开服列表js文件
		bulidBoxNewGameServerJs();//生成盒子最新开服列表js
	}
	
	
	/**
	 * 开服列表
	 */
	private void buildGameServer() {
		Map<String, Object> rootMap = new HashMap<String, Object>();
		rootMap.put("newGameServerList", getNewPreviewGameServer());
		rootMap.put("oldGameServerList", getNewOldGameServer());
		String root = htmlTemplate.getTemplateroot();
		String roothtml = getHtmlRoot();
		FreemarkerUtil.buildHtml(root, "openservice.html", rootMap, roothtml,
				"openservice.html");
	}
	
	/**
	 * 旧版盒子用的开服列表
	 * @throws Exception
	 */
	private void buildGameServerJs() throws Exception{
		String jsonStr = JsonObjectUtil.getDataJsonObject(getNewGameServerJs());
		jsonStr = "latest_server_list = "+jsonStr+";";

        String niuOfficialJsPath = IFacadeCommon.INSTANCE.getLibconfigValueByConfigNo("niuOfficialJsPath");
        if (niuOfficialJsPath.endsWith("/")) {
            niuOfficialJsPath = niuOfficialJsPath.substring(0, niuOfficialJsPath.length() - 1);
        }

		File file = FileUtil.createFile(niuOfficialJsPath + "/gamedata/","lastestgameserver.js");
		FileUploadUtil.write(file, jsonStr);
	}
	
	/**
	 * 新版盒子用的开服列表
	 * @throws Exception
	 */
	private void bulidBoxNewGameServerJs() throws Exception{
//		List<Map<String,Object>> alllist = new ArrayList<Map<String,Object>>();
//		getYesterdayLatestEreaList(alllist);
//        getTodayLatestEreaList(alllist);
//		getTomorrowLatestEreaList(alllist);		
		String jsonStr = JsonObjectUtil.getDataJsonObject(getNewBoxGameServerList());
		jsonStr = "latest_server_list = "+jsonStr+";";
//		String htmlFilePath = isPreView ? htmlTemplate.getPreviewhtmlroot()
//				: htmlTemplate.getHtmlroot();
        String niuOfficialJsPath = IFacadeCommon.INSTANCE.getLibconfigValueByConfigNo("niuOfficialJsPath");
        if (niuOfficialJsPath.endsWith("/")) {
            niuOfficialJsPath = niuOfficialJsPath.substring(0, niuOfficialJsPath.length() - 1);
        }

		File file = FileUtil.createFile(niuOfficialJsPath + "/gamedata/","newlastestgameserver.js");
		FileUploadUtil.write(file, jsonStr);
	}
	
	/**
	 * 获得明天的最新开服列表
	 * @return
	 */
	private List<Map<String,Object>> getoldTomorrowLatestEreaList(){
		SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd");
		Calendar cal = Calendar.getInstance();
		cal.add(Calendar.DAY_OF_MONTH, -1);	
		String yesterday = sdf.format(cal.getTime());
		cal.add(Calendar.DAY_OF_MONTH, 3);	
		String tomorrow = sdf.format(cal.getTime());				
		LinkInfo linkInfo = new LinkInfo();
	    linkInfo.setLinklocid("1240");
	    Page page = new Page();
	    page.addOrder("validdatetime", OrderType.DESC);
	    List<LinkInfo> list = FacadeFactory.INSTANCE.getLinkInfoBo().find(linkInfo, page);	    
		//游戏分区
		GameServers qgs=new GameServers();
		qgs.setFromopentime(yesterday+" 00:00:00");
		qgs.setToopentime(tomorrow+" 00:00:00");
		Page page1 = new Page();
		page1.addOrder("openTime", OrderType.ESC);
		List<GameServers> serverList=FacadeFactory.INSTANCE.getGameServersBo().find(qgs, page1);	    
		List<Map<String,Object>> result=new ArrayList<Map<String,Object>>();
		int jj = 0;
		for(GameServers server:serverList){		
			for(int i=0;i<list.size();i++){				
				LinkInfo li=list.get(i);
			    if(server.getGameId().trim().equals(li.getGameidbytuijian().trim())&&(server.getFenQuNum()+"").equals(li.getExt1().trim())){
			    	//获取logo图片
					LinkInfo logoli=FacadeFactory.INSTANCE.getLinkInfoBo().getGameValidteLinkInfoByLinkLocId(LinkLocationIdConstant.GAME_LOGO, li.getGameidbytuijian(), ispreview);
					//游戏信息
					Games game=FacadeFactory.INSTANCE.getGamesBo().getGameByGameId(li.getGameidbytuijian());
					Map<String,Object> map=new HashMap<String,Object>();
					String opentime = server.getOpenTime();
					map.put("sid", server.getSeqId());
					map.put("serverid", server.getServerId());
					map.put("openTime", opentime);
					map.put("gameName", game.getGameName());
					map.put("gameno", game.getGameNo());
					map.put("gameid", game.getGameId());
					map.put("officialurl",game.getOfficialWebSite());
					map.put("fenQuNum", server.getFenQuNum());
					map.put("clientType", game.getLoadClientType()==null?"0":game.getLoadClientType()+"");
					map.put("picurl", logoli==null?"":logoli.getPicurl());
					result.add(map);
					jj ++;
					if(jj>=6)break;//取其中5条记录
			    }												
			}
		}
		return result;
	}
	
	
	private List<Map<String,Object>> getNewGameServerJs(){
		    List<Map<String, Object>> result = new ArrayList<Map<String, Object>>();
		    String pattern = "yyyy-MM-dd";
	        Calendar calendar = Calendar.getInstance();
	        Date today = calendar.getTime();
	        String todayStr = DateUtil.format(today, pattern);	        
	        calendar.add(Calendar.DAY_OF_YEAR,1);
	        Date tomorrow = calendar.getTime();
	        String tomorrowStr = DateUtil.format(tomorrow,pattern);

	        List<GameServers> tomorrowServersList = FacadeFactory.INSTANCE.getGameServersBo()
	                .getNewOpenServersByFromDateAndToDate(todayStr,tomorrowStr,false);
	        boolean flag = true;
	        int jj = 0;
	        for(GameServers server:tomorrowServersList){		
	        	if(flag){
	        		Games game = GameCache.getInstance().getGameByGameId(server.getGameId());
	        		//获取logo图片
					LinkInfo logoli=FacadeFactory.INSTANCE.getLinkInfoBo().getGameValidteLinkInfoByLinkLocId(LinkLocationIdConstant.GAME_LOGO, game.getGameId(), ispreview);               					
					Map<String,Object> map=new HashMap<String,Object>();
					String opentime = server.getOpenTime();
					map.put("openTime", opentime);
					map.put("gameName", game.getGameName());
					map.put("gameno", game.getGameNo());
					map.put("gameid", game.getGameId());
					map.put("officialurl",game.getOfficialWebSite());
					map.put("fenQuNum", server.getFenQuNum());
					map.put("clientType", game.getLoadClientType()==null?"0":game.getLoadClientType()+"");
					map.put("picurl", logoli==null?"":logoli.getPicurl());
					result.add(map);
					jj ++;
					if(jj>=20){
						flag = false;
						break;//取其中20条记录
					}
	        	}
	        }
	        return result;
	}
	
	/**
	 * 获得开服列表的json数据
	 * @return
	 */
	private List<Map<String,Object>> getGameServerJs(){
		List<Map<String,Object>> result=new ArrayList<Map<String,Object>>();
		SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd");
		Calendar cal = Calendar.getInstance();
		cal.add(Calendar.DAY_OF_MONTH, 1);	
		String tomorrow = sdf.format(cal.getTime());//获得明天的日期	
		//获得后台录入的 首页最新开服列表中的数据
		LinkInfo linkInfo = new LinkInfo();
	    linkInfo.setLinklocid("1240");//牛x官网开服列表
	    Page page = new Page();
	    page.addOrder("validdatetime", OrderType.DESC);//按照生效时间逆序
	    List<LinkInfo> list = FacadeFactory.INSTANCE.getLinkInfoBo().find(linkInfo, page);	    
	    if(list == null||list.size()==0)return null;
	    
	    //获得游戏的区服信息
	    GameServers qgs=new GameServers();
	    qgs.setOpenStatus("1");//状态为 “已开区”
		qgs.setToopentime(tomorrow+" 00:00:00");//只取今天以前的数据，其中包含今天的
		Page page1 = new Page();
		page1.addOrder("openTime", OrderType.DESC);
		List<GameServers> serverList=FacadeFactory.INSTANCE.getGameServersBo().find(qgs, page1);
		int jj = 0;
		boolean flag = true;
		for(GameServers server:serverList){		
			if(flag){
				for(int i=0;i<list.size();i++){				
					LinkInfo li=list.get(i);
				    if(server.getGameId().trim().equals(li.getGameidbytuijian().trim())&&(server.getFenQuNum()+"").equals(li.getExt1().trim())){
				    	//获取logo图片
						LinkInfo logoli=FacadeFactory.INSTANCE.getLinkInfoBo().getGameValidteLinkInfoByLinkLocId(LinkLocationIdConstant.GAME_LOGO, li.getGameidbytuijian(), ispreview);
						//游戏信息
						Games game=FacadeFactory.INSTANCE.getGamesBo().getGameByGameId(li.getGameidbytuijian());		               					
						Map<String,Object> map=new HashMap<String,Object>();
						String opentime = server.getOpenTime();
						map.put("openTime", opentime);
						map.put("gameName", game.getGameName());
						map.put("gameno", game.getGameNo());
						map.put("gameid", game.getGameId());
						map.put("officialurl",game.getOfficialWebSite());
						map.put("fenQuNum", server.getFenQuNum());
						map.put("clientType", game.getLoadClientType()==null?"0":game.getLoadClientType()+"");
						map.put("picurl", logoli==null?"":logoli.getPicurl());
						result.add(map);
						jj ++;
						if(jj>=20){
							flag = false;
							break;//取其中20条记录
						}
				    }												
				}
			}			
		}
		return result;
	}

	public List<Map<String, Object>> getLatestAndComingOneGameServer() {
		    List<Map<String, Object>> result = new ArrayList<Map<String, Object>>();

	        List<GameServers> tomorrowServersList = FacadeFactory.INSTANCE.getGameServersBo()
	                .getLatestAndComingOneGameServer();
        //取得新手卡集合
			LinkInfo cardinfo = new LinkInfo();
			cardinfo.setLinklocid("233");
			List<LinkInfo> cardList = FacadeFactory.INSTANCE.getLinkInfoBo().find(cardinfo);
        for (GameServers server : tomorrowServersList) {
            Games game = GameCache.getInstance().getGameByGameId(server.getGameId());
            Map<String, Object> map = new HashMap<String, Object>();
            map.put("gameId", game.getGameId());
            map.put("gameName", game.getGameName());
            map.put("gameNo", game.getGameNo());
            map.put("gameOfficialUrl", game.getOfficialWebSite());
            String url = "";
            for (LinkInfo card : cardList) {
                if (card.getGameidbytuijian().trim().equals(game.getGameId())) {
                    url = card.getLinkurl();
                    break;
                }
            }
            LinkInfo logoli=FacadeFactory.INSTANCE.getLinkInfoBo().getGameValidteLinkInfoByLinkLocId(LinkLocationIdConstant.GAME_LOGO,game.getGameId(), ispreview);
            map.put("gameImg", logoli==null?"":logoli.getPicurl());
            map.put("newCardUrl", url);
            map.put("serverId", (server.getFenQuNum() + ""));
            map.put("serverName", server.getFenQuName());
            map.put("date", server.getOpenTime());
            map.put("openstatus", server.getOpenStatus());//开区状态;0:未开区；1：已开区；2：关闭区
            result.add(map);
			}

			return result;
	}
	public List<Map<String, Object>> getNewPreviewGameServer() {
		    List<Map<String, Object>> result = new ArrayList<Map<String, Object>>();
		    String pattern = "yyyy-MM-dd";
	        Calendar calendar = Calendar.getInstance();
	        calendar.add(Calendar.DAY_OF_YEAR,1);
	        Date tomorrow = calendar.getTime();
	        String tomorrowStr = DateUtil.format(tomorrow,pattern);

	        List<GameServers> tomorrowServersList = FacadeFactory.INSTANCE.getGameServersBo()
	                .getNewOpenServersByFromDateAndToDate(tomorrowStr,tomorrowStr,false);
	    	//取得新手卡集合
			LinkInfo cardinfo = new LinkInfo();
			cardinfo.setLinklocid("233");
			List<LinkInfo> cardList = FacadeFactory.INSTANCE.getLinkInfoBo().find(cardinfo);
        for (GameServers server : tomorrowServersList) {
            Games game = GameCache.getInstance().getGameByGameId(server.getGameId());
            Map<String, Object> map = new HashMap<String, Object>();
            map.put("gameName", game.getGameName());
            map.put("gameNo", game.getGameNo());
            map.put("gameOfficialUrl", game.getOfficialWebSite());
            String url = "";
            for (LinkInfo card : cardList) {
                if (card.getGameidbytuijian().trim().equals(game.getGameId())) {
                    url = card.getLinkurl();
                    break;
                }
            }
            LinkInfo logoli=FacadeFactory.INSTANCE.getLinkInfoBo().getGameValidteLinkInfoByLinkLocId(LinkLocationIdConstant.GAME_LOGO,game.getGameId(), ispreview);
            map.put("gameImg", logoli==null?"":logoli.getPicurl());
            map.put("newCardUrl", url);
            map.put("serverId", (server.getFenQuNum() + ""));
            map.put("serverName", server.getFenQuName());
            map.put("date", server.getOpenTime());
            result.add(map);
			}

			return result;
	}

	
	/**
	 * 获得开服预告
	 * @return
	 */
	public List<Map<String, Object>> getPreviewGameServer() {
		logger.info("开始获取开服预告");
		SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd");
		SimpleDateFormat sdf2 = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
		Calendar cal = Calendar.getInstance();
		String fromtime = sdf2.format(cal.getTime());//当前时间
		cal.add(Calendar.DAY_OF_MONTH, 1);
		//String fromtime = sdf.format(cal.getTime());
		cal.add(Calendar.DAY_OF_MONTH, 1);//生效时间是后一天
		String totime = sdf.format(cal.getTime());
		logger.info("fromtime============>" + fromtime);
		logger.info("totime============>" + totime);
		List<Map<String, Object>> result = new ArrayList<Map<String, Object>>();
		LinkInfo linkInfo = new LinkInfo();
		linkInfo.setLinklocid("1240");
		Page page = new Page();
		page.addOrder("validdatetime", OrderType.DESC);
		List<LinkInfo> list = FacadeFactory.INSTANCE.getLinkInfoBo().find(
				linkInfo, page);
		if(list == null||list.size()==0)return null;
		//取得游戏集合
		Games games = new Games();
		List<Games> gamesList = FacadeFactory.INSTANCE.getGamesBo().findGames(
				games, 0, 0);

		//取得游戏区服集合
		GameServers qgs = new GameServers();
		qgs.setFromopentime(fromtime);
		qgs.setToopentime(totime + " 00:00:00");
		Page page1 = new Page();
		page1.addOrder("openTime", OrderType.DESC);
		List<GameServers> serverList = FacadeFactory.INSTANCE
				.getGameServersBo().find(qgs, page1);

		//取得新手卡集合
		LinkInfo cardinfo = new LinkInfo();
		cardinfo.setLinklocid("233");
		List<LinkInfo> cardList = FacadeFactory.INSTANCE.getLinkInfoBo().find(
				cardinfo);
		for (GameServers server : serverList) {
			//游戏分区
			for (LinkInfo info : list) {
				String gameid = info.getGameidbytuijian().trim();//获得游戏id
				if (server.getGameId().trim().equals(gameid)
						&& (server.getFenQuNum() + "").equals(info.getExt1()
								.trim())) {//如果最新开服的游戏，在游戏列表中			    		
					Map<String, Object> map = new HashMap<String, Object>();
					for (Games game : gamesList) {//取得游戏相关信息
						if (game.getGameId().trim().equals(gameid)) {
							map.put("gameName", game.getGameName());
							map.put("gameNo", game.getGameNo());
							map.put("gameOfficialUrl", game
									.getOfficialWebSite());
							String url = "";
							for (LinkInfo card : cardList) {
								if (card.getGameidbytuijian().trim().equals(
										gameid.trim())) {
									url = card.getLinkurl();
								}
							}
							map.put("newCardUrl", url);
							map.put("serverId", (server.getFenQuNum() + ""));
							map.put("serverName", server.getFenQuName());
							map.put("date", server.getOpenTime());
							result.add(map);
						}
					}
				}
			}
		}
		return result;
	}
	
	public List<List<Map<String, Object>>> getNewOldGameServer() {
		   List<List<Map<String, Object>>> returndata = new ArrayList<List<Map<String, Object>>>();
		   List<Map<String, Object>> result = new ArrayList<Map<String, Object>>();
		   String pattern = "yyyy-MM-dd";
	       Calendar calendar = Calendar.getInstance();
	       Date today = calendar.getTime();
	       String todayStr = DateUtil.format(today, pattern);
	       calendar.add(Calendar.DAY_OF_MONTH, -8);
	       String beforeStr = DateUtil.format(calendar.getTime(), pattern);
	       List<GameServers> todayServersList = FacadeFactory.INSTANCE.getGameServersBo()
	                .getNewOpenServersByFromDateAndToDate(beforeStr,todayStr,false);
	    	//取得新手卡集合
			LinkInfo cardinfo = new LinkInfo();
			cardinfo.setLinklocid("233");//按照开服时间逆序
			List<LinkInfo> cardList = FacadeFactory.INSTANCE.getLinkInfoBo().find(cardinfo);
	    	for (GameServers server : todayServersList) {
    			Games game = GameCache.getInstance().getGameByGameId(server.getGameId());
    			Map<String, Object> map = new HashMap<String, Object>();
				map.put("gameName", game.getGameName());
				map.put("gameNo", game.getGameNo());
				map.put("gameOfficialUrl", game
						.getOfficialWebSite());
				String url = "";
				for (LinkInfo card : cardList) {
					if (card.getGameidbytuijian().trim().equals(server.getGameId())) {
						url = card.getLinkurl();
						break;
					}
				}
                LinkInfo logoli=FacadeFactory.INSTANCE.getLinkInfoBo().getGameValidteLinkInfoByLinkLocId(LinkLocationIdConstant.GAME_LOGO,game.getGameId(), ispreview);
                map.put("gameImg", logoli==null?"":logoli.getPicurl());
				map.put("newCardUrl", url);
				map.put("serverId", (server.getFenQuNum() + ""));
				map.put("serverName", server.getFenQuName());
				map.put("date", server.getOpenTime());
				result.add(map);
			}
			
	    	String now = todayStr;
			now = now + " 00:00:00";
			int index = 0;
			for (int i = 0; i < result.size(); i++) {
				Map<String, Object> data = result.get(i);
				String time = (String) (data.get("date"));
				if (compareTime(now, time) > 0) {
					index = i;
					break;
				}
			}

			List<Map<String, Object>> alists = new ArrayList<Map<String, Object>>();
			for (int i = 0; i < result.size(); i++) {
				Map<String, Object> data = result.get(i);
				if (index == 0) {
					data.put("isLastToday", "0");
					alists.add(data);
				} else {
					if (i == index - 1) {
						data.put("isLastToday", "1");
						alists.add(data);
					} else {
						data.put("isLastToday", "0");
						alists.add(data);
					}
				}
			}
			int j = 0;
			List<Map<String, Object>> templist = null;
			for (int i = 0; i < alists.size(); i++) {
				if (i % pagesize == 0) {
					templist = new ArrayList<Map<String, Object>>();
				}
				templist.add(alists.get(i));
				j++;
				if (j == pagesize || (alists.size()-i<pagesize &&j == alists.size()%pagesize)) {
					returndata.add(templist);
					j = 0;
				}
			}	
			return returndata;
	}

	/**
	 * 获得今日和历史开服记录
	 * @return
	 */
	public List<List<Map<String, Object>>> getGameServer() {
		int pagesize = 15;
		logger.info("开始获取今日和历史开服记录");
		List<List<Map<String, Object>>> returndata = new ArrayList<List<Map<String, Object>>>();
		List<Map<String, Object>> result = new ArrayList<Map<String, Object>>();
		SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd");
		SimpleDateFormat sdf2 = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
		Calendar cal = Calendar.getInstance();
		String totime = sdf2.format(cal.getTime());
		cal.add(Calendar.DAY_OF_MONTH, 1);//结束时间是明天
		//String totime = sdf.format(cal.getTime());
		cal.add(Calendar.DAY_OF_MONTH, -8);//开始时间是100年前
		String fromtime = sdf.format(cal.getTime());
		logger.info("fromtime============>" + fromtime);
		logger.info("totime============>" + totime);
		LinkInfo linkInfo = new LinkInfo();
		linkInfo.setLinklocid("1240");
		Page page = new Page();
		page.addOrder("validdatetime", OrderType.DESC);
		List<LinkInfo> list = FacadeFactory.INSTANCE.getLinkInfoBo().find(
				linkInfo, page);
		if(list == null||list.size()==0)return null;
		//取得游戏集合
		Games games = new Games();
		List<Games> gamesList = FacadeFactory.INSTANCE.getGamesBo().findGames(
				games, 0, 0);

		//取得游戏区服集合
		GameServers qgs = new GameServers();
		qgs.setFromopentime(fromtime + " 00:00:00");
		qgs.setToopentime(totime);
		Page page1 = new Page();
		page1.addOrder("openTime", OrderType.DESC);
		List<GameServers> serverList = FacadeFactory.INSTANCE
				.getGameServersBo().find(qgs, page1);

		//取得新手卡集合
		LinkInfo cardinfo = new LinkInfo();
		cardinfo.setLinklocid("233");//按照开服时间逆序
		List<LinkInfo> cardList = FacadeFactory.INSTANCE.getLinkInfoBo().find(
				cardinfo);
		for (GameServers server : serverList) {
			//游戏分区
			for (LinkInfo info : list) {
				String gameid = info.getGameidbytuijian().trim();//获得游戏id
				if (server.getGameId().trim().equals(gameid)
						&& (server.getFenQuNum() + "").equals(info.getExt1()
								.trim())) {//如果最新开服的游戏，在游戏列表中			    		
					Map<String, Object> map = new HashMap<String, Object>();
					for (Games game : gamesList) {//取得游戏相关信息
						if (game.getGameId().trim().equals(gameid)) {
							map.put("gameName", game.getGameName());
							map.put("gameNo", game.getGameNo());
							map.put("gameOfficialUrl", game
									.getOfficialWebSite());
							String url = "";
							for (LinkInfo card : cardList) {
								if (card.getGameidbytuijian().trim().equals(
										gameid.trim())) {
									url = card.getLinkurl();
								}
							}
							map.put("newCardUrl", url);
							map.put("serverId", (server.getFenQuNum() + ""));
							map.put("serverName", server.getFenQuName());
							map.put("date", server.getOpenTime());
							result.add(map);
						}
					}
				}
			}
		}
		String now = sdf.format(new Date());
		now = now + " 00:00:00";
		int index = 0;
		for (int i = 0; i < result.size(); i++) {
			Map<String, Object> data = result.get(i);
			String time = (String) (data.get("date"));
			if (compareTime(now, time) > 0) {
				index = i;
				break;
			}
		}

		List<Map<String, Object>> alists = new ArrayList<Map<String, Object>>();
		for (int i = 0; i < result.size(); i++) {
			Map<String, Object> data = result.get(i);
			if (index == 0) {
				data.put("isLastToday", "0");
				alists.add(data);
			} else {
				if (i == index - 1) {
					data.put("isLastToday", "1");
					alists.add(data);
				} else {
					data.put("isLastToday", "0");
					alists.add(data);
				}
			}
		}
		int j = 0;
		List<Map<String, Object>> templist = null;
		for (int i = 0; i < alists.size(); i++) {
			if (i % pagesize == 0) {
				templist = new ArrayList<Map<String, Object>>();
			}
			templist.add(alists.get(i));
			j++;
			if (j == pagesize || (alists.size()-i<pagesize &&j == alists.size()%pagesize)) {
				returndata.add(templist);
				j = 0;
			}
		}	
		return returndata;
	}

	/**
	 * 比较两个时间相隔多少秒
	 * @param time1
	 * @param time2
	 * @return
	 */
	public long compareTime(String time1, String time2) {
		DateFormat df = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
		Date d1 = null;
		Date d2 = null;
		try {
			d1 = df.parse(time1);
			d2 = df.parse(time2);
		} catch (ParseException e) {
			e.printStackTrace();
		}
		long diff = d1.getTime() - d2.getTime();
		return diff / 1000;
	}	
	
	private   List<Map<String, Object>> getNewBoxGameServerList (){
		    List<Map<String, Object>> result = new ArrayList<Map<String, Object>>();
		    String pattern = "yyyy-MM-dd";
	        Calendar calendar = Calendar.getInstance();
	        Date today = calendar.getTime();
	        String todayStr = DateUtil.format(today, pattern);
	        
	        calendar.add(Calendar.DAY_OF_YEAR,1);
	        Date tomorrow = calendar.getTime();
	        String tomorrowStr = DateUtil.format(tomorrow,pattern);

	        List<GameServers> tomorrowServersList = FacadeFactory.INSTANCE.getGameServersBo()
	                .getNewOpenServersByFromDateAndToDate(todayStr,tomorrowStr,false);
	        for(GameServers server:tomorrowServersList){		
	        	Games game=GameCache.getInstance().getGameByGameId(server.getGameId());
	        	//获取logo图片
				LinkInfo logoli=FacadeFactory.INSTANCE.getLinkInfoBo().getGameValidteLinkInfoByLinkLocId(LinkLocationIdConstant.GAME_LOGO,game.getGameId(), ispreview);           				
				Map<String,Object> map=new HashMap<String,Object>();
				String opentime = server.getOpenTime();
				map.put("sid", server.getSeqId());
				map.put("serverid", server.getServerId());
				map.put("openTime", opentime);
				map.put("gameName", game.getGameName());
				map.put("gameno", game.getGameNo());
				map.put("gameid", game.getGameId());
				map.put("officialurl",game.getOfficialWebSite());
				map.put("fenQuNum", server.getFenQuNum());
				map.put("clientType", game.getLoadClientType()==null?"0":game.getLoadClientType()+"");
				map.put("picurl", logoli==null?"":logoli.getPicurl());
				result.add(map);
	        }
	        return result;
	}
	
	/**
	 * 获得昨天的最新开服列表
	 * @return
	 */
	private void getYesterdayLatestEreaList(List<Map<String,Object>> alllist){
		SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd");
		Calendar cal = Calendar.getInstance();
		String today = sdf.format(cal.getTime());
		cal.add(Calendar.DAY_OF_MONTH, -1);	
		String yesterday = sdf.format(cal.getTime());
		
		LinkInfo linkInfo = new LinkInfo();
	    linkInfo.setLinklocid("1240");
	    Page page = new Page();
	    page.setPageNo(1);
	    page.setPageSize(150);
	    page.addOrder("validdatetime", OrderType.DESC);
	    List<LinkInfo> list = FacadeFactory.INSTANCE.getLinkInfoBo().find(linkInfo, page);
	    
		//游戏分区
		GameServers qgs=new GameServers();
		qgs.setFromopentime(yesterday+" 00:00:00");
		qgs.setToopentime(today+" 00:00:00");
		Page page1 = new Page();
		page1.addOrder("openTime", OrderType.ESC);
		List<GameServers> serverList=FacadeFactory.INSTANCE.getGameServersBo().find(qgs,page1);
		int jj = 0;
		for(GameServers server:serverList){		
			for(int i=0;i<list.size();i++){				
				LinkInfo li=list.get(i);
			    if(server.getGameId().trim().equals(li.getGameidbytuijian().trim())&&(server.getFenQuNum()+"").equals(li.getExt1().trim())){
			    	//获取logo图片
					LinkInfo logoli=FacadeFactory.INSTANCE.getLinkInfoBo().getGameValidteLinkInfoByLinkLocId(LinkLocationIdConstant.GAME_LOGO, li.getGameidbytuijian(), ispreview);
					//游戏信息
//					Games game=FacadeFactory.INSTANCE.getGamesBo().getGameByGameId(li.getGameidbytuijian());	               
					Games game=GameCache.getInstance().getGameByGameId(li.getGameidbytuijian());
					Map<String,Object> map=new HashMap<String,Object>();
					String opentime = server.getOpenTime();
					map.put("sid", server.getSeqId());
					map.put("serverid", server.getServerId());
					map.put("openTime", opentime);
					map.put("gameName", game.getGameName());
					map.put("gameno", game.getGameNo());
					map.put("gameid", game.getGameId());
					map.put("officialurl",game.getOfficialWebSite());
					map.put("fenQuNum", server.getFenQuNum());
					map.put("clientType", game.getLoadClientType()==null?"0":game.getLoadClientType()+"");
					map.put("picurl", logoli==null?"":logoli.getPicurl());
					alllist.add(map);
					jj ++;
					if(jj>=6)break;//取其中5条记录
			    }												
			}
		}
	}
	
	/**
	 * 获得明天的最新开服列表
	 * @return
	 */
	private void getTomorrowLatestEreaList(List<Map<String,Object>> alllist){
		SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd");
		Calendar cal = Calendar.getInstance();
		cal.add(Calendar.DAY_OF_MONTH, 1);	
		String tomorrow = sdf.format(cal.getTime());
		cal.add(Calendar.DAY_OF_MONTH, 1);
		String after = sdf.format(cal.getTime());		
		
		LinkInfo linkInfo = new LinkInfo();
	    linkInfo.setLinklocid("1240");
	    Page page = new Page();
	    page.setPageNo(1);
	    page.setPageSize(150);
	    page.addOrder("validdatetime", OrderType.DESC);
	    List<LinkInfo> list = FacadeFactory.INSTANCE.getLinkInfoBo().find(linkInfo, page);
	    
		//游戏分区
		GameServers qgs=new GameServers();
		qgs.setFromopentime(tomorrow+" 00:00:00");
		qgs.setToopentime(after+" 00:00:00");
		Page page1 = new Page();
		page1.addOrder("openTime", OrderType.ESC);
		List<GameServers> serverList=FacadeFactory.INSTANCE.getGameServersBo().find(qgs, page1);
		int jj = 0;
		for(GameServers server:serverList){		
			for(int i=0;i<list.size();i++){
				
				LinkInfo li=list.get(i);
			    if(server.getGameId().trim().equals(li.getGameidbytuijian().trim())&&(server.getFenQuNum()+"").equals(li.getExt1().trim())){
			    	//获取logo图片
					LinkInfo logoli=FacadeFactory.INSTANCE.getLinkInfoBo().getGameValidteLinkInfoByLinkLocId(LinkLocationIdConstant.GAME_LOGO, li.getGameidbytuijian(), ispreview);
					//游戏信息
//					Games game=FacadeFactory.INSTANCE.getGamesBo().getGameByGameId(li.getGameidbytuijian());
	               Games game=GameCache.getInstance().getGameByGameId(li.getGameidbytuijian());
					
					Map<String,Object> map=new HashMap<String,Object>();
					String opentime = server.getOpenTime();
					map.put("sid", server.getSeqId());
					map.put("serverid", server.getServerId());
					map.put("openTime", opentime);
					map.put("gameName", game.getGameName());
					map.put("gameno", game.getGameNo());
					map.put("gameid", game.getGameId());
					map.put("officialurl",game.getOfficialWebSite());
					map.put("fenQuNum", server.getFenQuNum());
					map.put("clientType", game.getLoadClientType()==null?"0":game.getLoadClientType()+"");
					map.put("picurl", logoli==null?"":logoli.getPicurl());
					alllist.add(map);
					jj ++;
					if(jj>=6)break;//取其中5条记录
			    }												
			}
		}
	}
	
	public String formatTime(String time){
		if(time == null)return "";
		if(time.length() == 19){
			time = time.split(" ")[0];
		}
		if(time.length() == 10){
			time = time.substring(5);
		}
		return time;
	}
	
	public String formatTimeH(String time){
		if(time == null)return "";
		if(time.length() == 19){
			time = time.split(" ")[1];
			time = time.substring(0,5);
		}
		return time;
	}
	
	/**
	 * 获得今天的最新开服列表
	 * @return
	 */
	private void getTodayLatestEreaList(List<Map<String,Object>> alllist){
		SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd");
		Calendar cal = Calendar.getInstance();
		String today = sdf.format(cal.getTime());
		cal.add(Calendar.DAY_OF_MONTH, 1);	
		String tomorrow = sdf.format(cal.getTime());
		
		LinkInfo linkInfo = new LinkInfo();
	    linkInfo.setLinklocid("1240");
	    Page page = new Page();
	    page.addOrder("validdatetime", OrderType.DESC);
	    List<LinkInfo> list = FacadeFactory.INSTANCE.getLinkInfoBo().find(linkInfo, page);
	    if(list == null||list.size()==0)return ;
		//游戏分区
		GameServers qgs=new GameServers();
		qgs.setFromopentime(today+" 00:00:00");
		qgs.setToopentime(tomorrow+" 00:00:00");
		Page page1 = new Page();
		page1.addOrder("openTime", OrderType.ESC);
		List<GameServers> serverList=FacadeFactory.INSTANCE.getGameServersBo().find(qgs, page1);
		int jj = 0;
		for(GameServers server:serverList){		
			for(int i=0;i<list.size();i++){
				
				LinkInfo li=list.get(i);
			    if(server.getGameId().trim().equals(li.getGameidbytuijian().trim())&&(server.getFenQuNum()+"").equals(li.getExt1().trim())){
			    	//获取logo图片
					LinkInfo logoli=FacadeFactory.INSTANCE.getLinkInfoBo().getGameValidteLinkInfoByLinkLocId(LinkLocationIdConstant.GAME_LOGO, li.getGameidbytuijian(), ispreview);
					//游戏信息
//					Games game=FacadeFactory.INSTANCE.getGamesBo().getGameByGameId(li.getGameidbytuijian());
	               	Games game=GameCache.getInstance().getGameByGameId(li.getGameidbytuijian());			
					Map<String,Object> map=new HashMap<String,Object>();
					String opentime = server.getOpenTime();
					map.put("sid", server.getSeqId());
					map.put("serverid", server.getServerId());
					map.put("openTime", opentime);
					map.put("gameName", game.getGameName());
					map.put("gameno", game.getGameNo());
					map.put("gameid", game.getGameId());
					map.put("officialurl",game.getOfficialWebSite());
					map.put("fenQuNum", server.getFenQuNum());
					map.put("clientType", game.getLoadClientType()==null?"0":game.getLoadClientType()+"");
					map.put("picurl", logoli==null?"":logoli.getPicurl());
					alllist.add(map);
					jj ++;
					if(jj>=6)break;//取其中5条记录
			    }												
			}
		}
	}
}
