package com.xunlei.niux.manager.template.builder.niuoffical;

import java.io.File;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.log4j.Logger;

import com.xunlei.httptool.util.JsonObjectUtil;
import com.xunlei.niux.data.manager.vo.Game;
import com.xunlei.niux.data.vipgame.facade.FacadeFactory;
import com.xunlei.niux.data.vipgame.vo.Advice;
import com.xunlei.niux.data.vipgame.vo.GameServers;
import com.xunlei.niux.data.vipgame.vo.Games;
import com.xunlei.niux.data.vipgame.vo.LinkInfo;
import com.xunlei.niux.manager.constant.LinkLocationIdConstant;
import com.xunlei.niux.manager.template.builder.AbstractTemplateBuilder;
import com.xunlei.niux.manager.web.cache.GameCache;
import com.xunlei.niux.manager.web.util.FileUploadUtil;
import com.xunlei.niux.manager.web.util.FileUtil;
import com.xunlei.niux.manager.web.util.FreemarkerUtil;

public class AdviceBuilder extends AbstractTemplateBuilder{
	private boolean ispreview=false;
	private static final Logger logger = Logger.getLogger(ActivityBuilder.class);
	
	public static void main(String args[]){
		try {
			new AdviceBuilder().executeShcema();
		} catch (Exception e) {
			e.printStackTrace();
		}
	}
	public void executeShcema() throws Exception {
		buildAdvice();
		buildUserCard();			
	}
	 /**
	 * 公告列表
	 */
	private void buildAdvice(){
		Map<String,Object> rootMap=new HashMap<String,Object>();
        rootMap.put("announcementList", getAdviceAdv());
        rootMap.put("actList", getActivityAdv());      
        String root = htmlTemplate.getTemplateroot();
        String roothtml = getHtmlRoot();
//        String root = "d:/tmp/office";
//        String roothtml = "d:/tmp/offical";
		FreemarkerUtil.buildHtml(root,"side_announcement.html", rootMap, roothtml+"/include/", "side_announcement.html");
		
	}

	
	
	 /**
	 * 新手卡列表
	 */
	private void buildUserCard(){
		Map<String,Object> rootMap=new HashMap<String,Object>();
		rootMap.put("latestplaygamesideadvdata", getLatestPlayGameSideAdv());
		rootMap.put("newCardList", getNewCardBoxList());
        String root = htmlTemplate.getTemplateroot();
        String roothtml = getHtmlRoot();
//        String root = "d:/tmp/office";
//        String roothtml = "d:/tmp/offical";
		FreemarkerUtil.buildHtml(root,"side_playedGame.html", rootMap, roothtml+"/include/", "side_playedGame.html");
		
	}
	
	
	public List<Map<String,Object>> getNewCardBoxList(){
		List<Map<String,Object>> templist=new ArrayList<Map<String,Object>>();
		LinkInfo info = new LinkInfo();
		info.setLinklocid(LinkLocationIdConstant.NIUX_OFFICIAL_NEWCARD);
		List<LinkInfo> lilist=FacadeFactory.INSTANCE.getLinkInfoBo().find(info);		
		for(LinkInfo ll:lilist){
			String gameid = ll.getGameidbytuijian().trim();
			Games games = GameCache.getInstance().getGameByGameId(gameid);
			Map<String,Object> m = new HashMap<String,Object>();
			m.put("gameName", games.getGameName());
			m.put("newCardUrl", ll.getLinkurl());
			templist.add(m);
		}
		return templist;
	}
	
	/**
	 * 最近玩过的游戏旁广告
	 * @return
	 */
	private Map<String,Object> getLatestPlayGameSideAdv(){
		Map<String,Object> map = new HashMap<String,Object>();		
		//获取广告
		LinkInfo li=FacadeFactory.INSTANCE.getLinkInfoBo().getValidteLinkInfoByLinkLocId(LinkLocationIdConstant.NIUX_OFFICIAL_LATESTPALYGAMESIDE_ADV,ispreview);
		if(li==null){
			return map;
		}
		//获取游戏信息
		Games g=FacadeFactory.INSTANCE.getGamesBo().getGameByGameId(li.getGameidbytuijian());
		//获取最新开区
		GameServers gstemp=FacadeFactory.INSTANCE.getGameServersBo().getLatestGameServerByGameId(li.getGameidbytuijian(), ispreview);
		if(g==null||gstemp==null){
			return map;
		}
		map.put("gameName", g.getGameName());
		map.put("serverId", gstemp.getFenQuNum());
		map.put("gameNo", g.getGameNo());
		map.put("gameOfficialUrl", g.getOfficialWebSite());
		return map;
	}
	
	 /**
	  * 获得公告
	  * @return
	  */
	 public List<Map<String,Object>> getAdviceAdv() {
	        String sql = "select * from advice where platformno='game' or platformno='platform' and adviceType in ('1','2','3') order by displayOrder asc limit 0,10";
	        List<Advice> list = FacadeFactory.INSTANCE.getAdviceBo().executeQuery(Advice.class, sql, new ArrayList());
	        List<Map<String,Object>> result = new ArrayList<Map<String,Object>>();
	        logger.info("getAdviceAdv.size=====================>"+list.size());
	        for(Advice info:list){
	        	String gameid = info.getGameId();
	        	
	        	 //游戏信息
	        	logger.info("gameid================>"+gameid);  	
	    		Games game=FacadeFactory.INSTANCE.getGamesBo().getGameByGameId(gameid);
	    		
	    		Map<String,Object> map = new HashMap<String,Object>();
	    		map.put("id", info.getSeqId());
	    		map.put("gameId", game==null?"":game.getGameNo());
	    		map.put("gameName",game==null?"":game.getGameName());
	    		map.put("title", info.getTitle());
	    		map.put("url", info.getJumpUrl());
	    		map.put("gameOfficialUrl",game==null?"":game.getOfficialWebSite());
	    		map.put("date", formatTime(info.getPublishDate()));
	    		result.add(map);
	        }
	       
	        return result;
	    }

	 /**
	  * 获得活动类公告
	  * @return
	  */
	 public List<Map<String,Object>> getActivityAdv() {
	        String sql = "select * from advice where platformno='activity' and adviceType in ('1','2','3') order by displayOrder asc limit 0,10";
	        List<Advice> list = FacadeFactory.INSTANCE.getAdviceBo().executeQuery(Advice.class, sql, new ArrayList());
	        List<Map<String,Object>> result = new ArrayList<Map<String,Object>>();
	        for(Advice info:list){
	        	String gameid = info.getGameId();	        	
	        	 //游戏信息
	    		Games game=FacadeFactory.INSTANCE.getGamesBo().getGameByGameId(gameid);	    		
	    		Map<String,Object> map = new HashMap<String,Object>();
	    		map.put("id", info.getSeqId());
	    		map.put("gameId", game==null?"":game.getGameNo());
	    		map.put("gameName",game==null?"":game.getGameName());
	    		map.put("title", info.getTitle());
	    		map.put("url", info.getJumpUrl());
	    		map.put("gameOfficialUrl",game==null?"":game.getOfficialWebSite());
	    		map.put("date", formatTime(info.getPublishDate()));
	    		result.add(map);
	        }	       
	        return result;
	 }

	 public String formatTime(String time){
			if(time == null)return "";
			if(time.length() == 19){
				time = time.split(" ")[0];
			}
			if(time.length() == 10){
				time = time.substring(5);
			}
			return time;
		}
}
