package com.xunlei.niux.manager.template.builder.niuoffical;

import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.log4j.Logger;
import com.ferret.common.dao.vo.Page;
import com.xunlei.niux.data.vipgame.facade.FacadeFactory;
import com.xunlei.niux.data.vipgame.vo.GameServers;
import com.xunlei.niux.data.vipgame.vo.Games;
import com.xunlei.niux.data.vipgame.vo.LinkInfo;
import com.xunlei.niux.manager.constant.LinkLocationIdConstant;
import com.xunlei.niux.manager.template.builder.AbstractTemplateBuilder;
import com.xunlei.niux.manager.web.cache.GameCache;
import com.xunlei.niux.manager.web.util.FreemarkerUtil;

public class ActivityBuilder extends AbstractTemplateBuilder{
	private boolean ispreview=false;
	private static final Logger logger = Logger.getLogger(ActivityBuilder.class);
	
	public static void main(String args[]){
		try {
			new ActivityBuilder().executeShcema();
		} catch (Exception e) {
			e.printStackTrace();
		}
	}

	public void executeShcema() throws Exception {
		buildActivity();
	}
	 /**
	 * 生成活动页模版
	 */
	private void buildActivity(){
		Map<String,Object> rootMap=new HashMap<String,Object>();
		rootMap.put("sliderImgList", getBigPhoto());
		rootMap.put("prizeRcmdActivity", getAdv());
		rootMap.put("onGoingActivityList", getActing());
        rootMap.put("yesterdayServiceList", getYesterdayLatestEreaList());
        rootMap.put("loginRcmdActivity", getActProduct());
        List<Map<String,Object>> activityCalendarGameList = new ArrayList<Map<String,Object>>();
        Map<String,Object> activityCalendar = getActCalender(activityCalendarGameList);
        rootMap.put("activityCalendar", activityCalendar);
        rootMap.put("activityCalendarGameList", activityCalendarGameList);
      
        String root = htmlTemplate.getTemplateroot();
        String roothtml = getHtmlRoot();
//      String root = "d:/tmp/office";
//      String roothtml = "d:/tmp/offical";
		FreemarkerUtil.buildHtml(root,"activity.html", rootMap, roothtml, "activity.html");
	}
	
	
	/**
	 * 获得活动页奖品区活动
	 * @return
	 */
	private Map<String,Object> getActProduct(){
		List<LinkInfo> lilist=FacadeFactory.INSTANCE.getLinkInfoBo().getValidteLinkInfoListByLinkLocId(LinkLocationIdConstant.NIUX_OFFICIAL_ACT_PRODUCT, 1, isPreView);
		Map<String,Object> map = new HashMap<String,Object>();
		if(lilist == null||lilist.size()==0)return null;
		LinkInfo info = lilist.get(0);
		map.put("url", info.getLinkurl());
		map.put("title", info.getLinktitle());		
		return map;
	}
	
	/**
	 * 获得活动页轮播图
	 * @return
	 */
	private List<Map<String,Object>> getBigPhoto(){
		List<Map<String,Object>> result = new ArrayList<Map<String,Object>>();
		List<LinkInfo> lilist=FacadeFactory.INSTANCE.getLinkInfoBo().getValidteLinkInfoListByLinkLocId(LinkLocationIdConstant.NIUX_ACTIVITY_LUNBO,4, isPreView);
		if(lilist == null||lilist.size()==0)return null;
		for(LinkInfo info:lilist){
			Map<String,Object> map = new HashMap<String,Object>();
			map.put("title", info.getLinktitle());
			map.put("content", info.getLinkdesc());
			map.put("url", info.getLinkurl());
			map.put("img", info.getPicurl());
			result.add(map);
		}
		return result;
	}
	
	
	
	/**
	 * 获得活动日历
	 * @return
	 */
	public Map<String,Object> getActCalender(List<Map<String,Object>> activityCalendarGameList){
		//List<Map<String,Object>> result = new ArrayList<Map<String,Object>>();
		List<LinkInfo> lilist=FacadeFactory.INSTANCE.getLinkInfoBo().getValidteLinkInfoListByLinkLocId(LinkLocationIdConstant.NIUX_ACTIVITY_CALENDARACT, 1000, isPreView);
		Set<String> set = new HashSet<String>();
		for(LinkInfo info:lilist){			
			if(set.size()==3)break;
			set.add(info.getGameidbytuijian());
		}
		for(String gameid:set){
			Games games = GameCache.getInstance().getGameByGameId(gameid);
			String gameName = games.getGameName();
			Map<String,Object> m = new LinkedHashMap<String,Object>();
			m.put("id", games.getGameNo());
			m.put("name", gameName);
			activityCalendarGameList.add(m);

		}
		SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd");
	    Calendar calendar = Calendar.getInstance();
	    //int min = calendar.getActualMinimum(Calendar.DAY_OF_WEEK); //获取周开始基准
	    //int current = calendar.get(Calendar.DAY_OF_WEEK); //获取当天周内天数
	    //calendar.add(Calendar.DAY_OF_WEEK, min-current+1); //当天-基准，获取周开始日期
	    getMondayOfThisWeek(calendar);//本周的第一天	 
	    String starttime = null;   
        String endtime =  null;
       
        int i = 0;  
        Map<String,Object> gamemap = new LinkedHashMap<String,Object>();
        for(String gameid:set){
        	System.out.println("gameid=============>"+gameid);
        	List<List<Map<String,Object>>> gameList = new ArrayList<List<Map<String,Object>>>();
        	i = 0;
        	while(i < 7){       		
            	i++;
            	starttime = sdf.format(calendar.getTime());
            	endtime = getAfterDay(sdf,calendar,starttime);
            	System.out.println("starttime======>"+starttime+",endtime=========>"+endtime);
            	List<Map<String,Object>> dayList = new ArrayList<Map<String,Object>>();
            	List<LinkInfo> linklist = FacadeFactory.INSTANCE.getLinkInfoBo().getLinkInfoByLinkLocIdandTime(LinkLocationIdConstant.NIUX_ACTIVITY_CALENDARACT, starttime + " 00:00:00", endtime + " 00:00:00", false);
            	for(LinkInfo inf:linklist){
            		if(gameid.trim().equals(inf.getGameidbytuijian().trim())){
            			Map<String,Object> map = new LinkedHashMap<String,Object>();
            			map.put("activityTime", formatTime(inf.getValiddatetime()));
            			map.put("activityName", inf.getLinktitle());
            			map.put("activityUrl", inf.getLinkurl());
            			dayList.add(map);
            		}
            		if(dayList.size()>=5)break;
            		
            	}
            	gameList.add(dayList);
            	
            }
        	System.out.println("gameList>"+gameList);
        	calendar.add(Calendar.DAY_OF_WEEK, -7);//还原时间为周一 
        	Games games = GameCache.getInstance().getGameByGameId(gameid);
        	gamemap.put(games.getGameNo(),gameList);
        }	    
		return gamemap;
	}
	
	
	public String formatTime(String time){
		time = time.split(" ")[1];
		time = time.substring(0,5);
		return time;
	}
	

	/**
	  * 得到本周周一
	  * 
	  * @return yyyy-MM-dd
	  */
	 public static String getMondayOfThisWeek(Calendar c) {	 
	  int dayofweek = c.get(Calendar.DAY_OF_WEEK) - 1;
	  if (dayofweek == 0)
	  dayofweek = 7;
	  c.add(Calendar.DATE, -dayofweek + 1);
	  SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd");
	  return sdf.format(c.getTime());
	 }
	
	/**
	 * 获得活动页广告
	 * @return
	 */
	private Map<String,Object> getAdv(){
		Map<String,Object>  map = new HashMap<String,Object>();
		List<LinkInfo> lilist=FacadeFactory.INSTANCE.getLinkInfoBo().getValidteLinkInfoListByLinkLocId(LinkLocationIdConstant.NIUX_ACTIVITY_ADV, 1, isPreView);
		if(lilist == null || lilist.size()==0)return null;
		if(lilist != null && lilist.size()==1){
			LinkInfo info = lilist.get(0);
			map.put("url", info.getLinkurl());
			map.put("img", info.getPicurl());
			map.put("content", info.getLinkdesc());
		}
		return map;
	}
	
	
	public  String getAfterDay(SimpleDateFormat sdf,Calendar cal,String daytime){
		if(daytime==null||"".equals(daytime))return null;
		Date date = null;
		try {
			date = sdf.parse(daytime);
		} catch (ParseException e) {
			e.printStackTrace();
		}
		cal.setTime(date);
		cal.add(Calendar.DAY_OF_MONTH, 1);	
		String now = sdf.format(cal.getTime());	
		return now;
	}
	
	
	/**
	 * 获得活动页中正在进行的活动
	 * @return
	 */
	private List<Map<String,Object>> getActing(){
		List<Map<String,Object>> result = new ArrayList<Map<String,Object>>();
		List<LinkInfo> lilist=FacadeFactory.INSTANCE.getLinkInfoBo().getValidteLinkInfoListByLinkLocId(LinkLocationIdConstant.NIUX_OFFICIAL_ACT_ACTING, 10000, isPreView);
		if(lilist == null||lilist.size()==0)return null;
		for(LinkInfo info:lilist){
			Map<String,Object> map = new HashMap<String,Object>();
			map.put("title", info.getLinktitle());
			map.put("content", info.getLinkdesc());
			map.put("url", info.getLinkurl());
			map.put("img", info.getPicurl());
			map.put("date", info.getValiddatetime());
			result.add(map);
		}
		return result;
	}
	
	/**
	 * 获得昨天今天明天的最新开服列表
	 * @return
	 */
	private List<Map<String,Object>> getYesterdayLatestEreaList(){
		SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd");
		Calendar cal = Calendar.getInstance();
		String today = sdf.format(cal.getTime());
		cal.add(Calendar.DAY_OF_MONTH, -1);	
		String yesterday = sdf.format(cal.getTime());
		List<LinkInfo> list=FacadeFactory.INSTANCE.getLinkInfoBo().getLinkInfoByLinkLocIdandTime(LinkLocationIdConstant.NIUX_LATESTOPENAREA, yesterday + " 00:00:00", today + " 00:00:00", false);
		if(list == null||list.size()==0)return null;
		List<Map<String,Object>> result=new ArrayList<Map<String,Object>>();
		int jj = 0;
		for(int i=0;i<list.size();i++){
			jj ++;
			if(jj>=6)break;//取其中5条记录
			LinkInfo li=list.get(i);
			if(li==null){
				continue;
			}
			//获取logo图片
			LinkInfo logoli=FacadeFactory.INSTANCE.getLinkInfoBo().getGameValidteLinkInfoByLinkLocId(LinkLocationIdConstant.GAME_LOGO, li.getGameidbytuijian(), ispreview);
			//游戏信息
			Games game=FacadeFactory.INSTANCE.getGamesBo().getGameByGameId(li.getGameidbytuijian());
			//游戏分区
			GameServers qgs=new GameServers();
			qgs.setGameId(li.getGameidbytuijian());
			qgs.setFenQuNum(Integer.valueOf(li.getExt1()));
			List<GameServers> gsList=FacadeFactory.INSTANCE.getGameServersBo().find(qgs, new Page());
			if(gsList==null||gsList.size()==0){
				continue;
			}
			GameServers gs=gsList.get(0);
			Map<String,Object> map=new HashMap<String,Object>();
			map.put("time", gs.getOpenTime());
			map.put("gameName", game.getGameName());
			map.put("gameId", game.getGameNo());
			map.put("gameServerId", gs.getFenQuNum());
			map.put("gameServerName", gs.getFenQuName());
			map.put("gameImg", logoli==null?"":logoli.getPicurl());
			result.add(map);
			
		}
		return result;
	}
	
	
}
