package com.xunlei.niux.manager.template.builder.mobilegameofficial.v1;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Callable;

import org.apache.commons.collections.MapUtils;
import org.apache.commons.lang.StringUtils;
import org.springframework.util.CollectionUtils;
import com.xunlei.niux.data.vipgame.facade.FacadeFactory;
import com.xunlei.niux.data.vipgame.vo.Advice;
import com.xunlei.niux.data.vipgame.vo.Games;
import com.xunlei.niux.manager.template.builder.AbstractTemplateBuilder;
import com.xunlei.niux.manager.web.cache.GameCache;
import com.xunlei.niux.manager.web.util.FreemarkerUtil;


public class MobileAdviceBuilder extends AbstractTemplateBuilder{
	private String root = null;
    private  String roothtml = null;
    

    
	@Override
	public void executeShcema() throws Exception {
		root = htmlTemplate.getTemplateroot();
	    roothtml = getHtmlRoot();
	    buildAdvice();//公告页模版
	}
	
	
	
	 public void buildAdvice(){
	        Map<String,List<Advice>> resultMap = getActivityAndActList();
	        if(MapUtils.isEmpty(resultMap)){
	            return;
	        }
	        List<Advice> newsList = resultMap.get("newsList");
	        List<Advice> gonggaoList = resultMap.get("gonggaoList");
	        List<Advice> gonglueList = resultMap.get("gonglueList");
	        if(!CollectionUtils.isEmpty(newsList)){
	            buildAdviceListPages(newsList,"news");
	        }
	        if(!CollectionUtils.isEmpty(gonggaoList)){
	            buildAdviceListPages(gonggaoList,"gonggao");
	        }
	        if(!CollectionUtils.isEmpty(gonglueList)){
	            buildAdviceListPages(gonglueList,"gonglue");
	        }
	    }
	
	  private Map<String,List<Advice>> getActivityAndActList(){
	        Map<String,List<Advice>> resultMap = new HashMap<String, List<Advice>>();
	        String sql = "select * from advice where platformno in ('news','gonggao','gonglue') and adviceType=5 order by displayOrder asc";
	        List<Advice> list = FacadeFactory.INSTANCE.getAdviceBo().executeQuery(
	                Advice.class, sql, new ArrayList());
	        if(CollectionUtils.isEmpty(list)){
	            return resultMap;
	        }
	        List<Advice> newsList = new ArrayList<Advice>();
	        List<Advice> gonggaoList = new ArrayList<Advice>();
	        List<Advice> gonglueList = new ArrayList<Advice>();
	        for(Advice advice : list){
	            if(!advice.getJump()){
	                buildNoticeDetail(advice);
	            }

	            if(advice.getPlatformno().equals("news")){
	            	newsList.add(advice);
	            }else if(advice.getPlatformno().equals("gonggao")) {
	            	gonggaoList.add(advice);
	            }else{
	            	gonglueList.add(advice);
	            }
	        }
	        resultMap.put("newsList",newsList);
	        resultMap.put("gonggaoList",gonggaoList);
	        resultMap.put("gonglueList",gonglueList);
	        return resultMap;
	    }

	    private void buildNoticeDetail(Advice advice){
	        Map<String, Object> rootMap = new HashMap<String, Object>();
	        rootMap.put("detail", getDetailMap(advice));
	        FreemarkerUtil.buildHtml(root+"/notice/", "detail.html", rootMap,
	        		roothtml + "/notice/", advice.getSeqId() + ".html");
	    }

	    private Map<String,Object> getDetailMap(Advice advice){
	        Map<String,Object> map = new HashMap<String, Object>();
	        map.put("title",advice.getTitle());
	        map.put("content",advice.getContent());
	        if(advice.getPlatformno().equals("news")){
	            map.put("type","news");
	        }else if(advice.getPlatformno().equals("gonggao")){
	            map.put("type","gonggao");
	        }else {
	            map.put("type","gonglue");
	        }
	        return map;
	    }

	    private void buildAdviceListPages(List<Advice> adviceList,String noticeType){
	        int pageSize = 20;
	        int pageCount = 0;
	        List<Advice> printList = new ArrayList<Advice>();
	        if(!CollectionUtils.isEmpty(adviceList)){
	            int totalCount = adviceList.size();
	            int pageIndex = 0;
	            if(totalCount%pageSize == 0){
	                pageCount = totalCount/pageSize;
	            }else {
	                pageCount = totalCount/pageSize + 1;
	            }
	            String path = "/notice/";
	            String path_html = path+noticeType;
	           
	            int startindex = 0, endIndex = 0;
	            for(int i=0;i<pageCount;i++){
	                startindex = i*pageSize;
	                endIndex = (((i+1)*pageSize) > totalCount) ? totalCount : ((i+1)*pageSize);
	                printList = adviceList.subList(startindex,endIndex);
	                Map<String, Object> rootMap = new HashMap<String, Object>();
	                rootMap.put("noticeType",noticeType);
	                rootMap.put("noticeList",getNoticeMapList(printList));
	                rootMap.put("pageInfo", getPageInfoMap(pageCount,pageIndex+1));
	                pageIndex++;
	                FreemarkerUtil.buildHtml(root+path, "list.html", rootMap,
	                		roothtml + path_html, (pageIndex==1?"index":("index_"+String.valueOf(pageIndex))) + ".html");
	            }
	        }
	    }

	    private List<Map<String,Object>> getNoticeMapList(List<Advice> adviceList){
	        List<Map<String,Object>> resultList = new ArrayList<Map<String, Object>>();
	        if(CollectionUtils.isEmpty(adviceList)){
	            return resultList;
	        }
	        for(Advice advice : adviceList){
	            Map<String,Object> map = new HashMap<String,Object>();
	            String gameId = advice.getGameId();
	            Games game= GameCache.getInstance().getGameByGameId(gameId);
	            map.put("gameName",game==null?"":game.getGameName());
	            map.put("gameId",gameId);
	            map.put("gameOfficialUrl",game==null?"":game.getOfficialWebSite());
	            map.put("id",advice.getSeqId()==null?"":advice.getSeqId());
	            map.put("title",advice.getTitle()==null?"":advice.getTitle());
	            String url = "";
	            if(advice.getJump()){
	                url = advice.getJumpUrl();
	            }else {
//	                url = advice.getContenturl2();
//	                url="/notice/"+advice.getSeqId()+".html";
	            }
	            map.put("url",url==null?"":url);
	            map.put("date", StringUtils.isEmpty(advice.getPublishDate()) ? "" : advice.getPublishDate().substring(0, 10));

	            resultList.add(map);
	        }

	        return resultList;
	    }

	    private Map<String,Integer> getPageInfoMap(int totalNum,int curPage){
	        Map<String,Integer> map = new HashMap<String, Integer>();
	        map.put("totalNum",totalNum);
	        map.put("curPage",curPage);
	        return map;
	    }



	
	
	
	

}
