package com.xunlei.niux.manager.template.builder.mobilegameofficial.v1;

import com.ferret.common.dao.enums.OrderType;
import com.xunlei.common.vo.LibClassD;
import com.xunlei.common.vo.LibClassM;
import com.xunlei.niux.data.vipgame.bo.AdviceBo;
import com.xunlei.niux.data.vipgame.bo.LinkInfoBo;
import com.xunlei.niux.data.vipgame.dto.game.GameDTO;
import com.xunlei.niux.data.vipgame.enums.AdviceTypeEnum;
import com.xunlei.niux.data.vipgame.facade.FacadeFactory;
import com.xunlei.niux.data.vipgame.vo.Advice;
import com.xunlei.niux.data.vipgame.vo.LinkInfo;
import com.xunlei.niux.manager.web.util.FreemarkerUtil;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.collections.MapUtils;
import org.apache.commons.lang.StringUtils;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Callable;

/**
* Created by jamesjxin on 14-8-12.
*/
public class IndexPageBuilderThread implements Callable {

    private String inputPath;
    private String outputPath;
    private boolean isPreview;
    private String fileName;
    private LinkInfoBo linkInfoBo;
    private Map<String, LinkInfo> mobileGameDownloadInfoMap;

    private Map<String,String> gameFeaturesMap;
    private Map<String,GameDTO> appGamesMap;

    public IndexPageBuilderThread(String inputPath, String outputPath,String fileName, boolean isPreview,Map<String, LinkInfo> mobileGameDownloadInfoMap) {
        this.inputPath = inputPath;
        this.outputPath = outputPath;
        this.fileName = fileName;
        this.isPreview = isPreview;
        this.mobileGameDownloadInfoMap = mobileGameDownloadInfoMap;
    }

    private void init() {
        linkInfoBo = FacadeFactory.INSTANCE.getLinkInfoBo();
        initGameFeaturesMap();
        initAllAppGameMap();
    }



    private void initGameFeaturesMap(){
        gameFeaturesMap = new HashMap<String, String>();

//        gameFeaturesMap.put("0","其他");
//        gameFeaturesMap.put("1","三国");
//        gameFeaturesMap.put("2","卡牌");
//        gameFeaturesMap.put("3","仙侠");
//        gameFeaturesMap.put("4","武侠");
//        gameFeaturesMap.put("5","魔幻");
//        gameFeaturesMap.put("6","塔防");
//        gameFeaturesMap.put("7","奇幻");
//        gameFeaturesMap.put("8","历史");
//        gameFeaturesMap.put("9","热血");
//        gameFeaturesMap.put("10","休闲");

        List datas = LibClassM.getLibClassDList("gameFeatures");

        for (int i = 0; i < datas.size(); i++) {
            String typeid = ((LibClassD) datas.get(i)).getItemno().trim();
            gameFeaturesMap.put(typeid,((LibClassD) datas.get(i)).getItemname().trim());
        }
    }

    private void initAllAppGameMap(){
        appGamesMap = new HashMap<String, GameDTO>();
        List<GameDTO> list = FacadeFactory.INSTANCE.getGamesBo().getAllValidAppGames();
        if(CollectionUtils.isEmpty(list)){
            return;
        }

        for(GameDTO gameDTO:list){
            appGamesMap.put(gameDTO.getGameId(),gameDTO);
        }
    }

    @Override
    public Object call() throws Exception {
        init();
        buildIndex();

        buildGameRank();

        buildHotGift();

        return "";
    }

    private void buildIndex() {
        Map<String, Object> rootMap = new HashMap<String, Object>();
        rootMap.put("sliderList", getLuoBoPicList());
        rootMap.put("noticeList", getNoticeList());
        rootMap.put("noticeADMap", getNoticeADMap());
        rootMap.put("newGameList", getNewGameList());
        rootMap.put("hotGameList", getHotGameList());

        FreemarkerUtil.buildHtml(inputPath, this.fileName, rootMap, outputPath, this.fileName);
    }

    private void buildGameRank() {
        Map<String, Object> rootMap = new HashMap<String, Object>();
        rootMap.put("gameMonthRankList",getGameMonthRankList());
        rootMap.put("gameWeekRankList",getGameWeekRankList());

        FreemarkerUtil.buildHtml(inputPath + "include/", "gamerank.html", rootMap, outputPath + "include/", "gamerank.html");
    }

    private void buildHotGift() {
        Map<String, Object> rootMap = new HashMap<String, Object>();
        rootMap.put("hotGiftList", getHotGiftList());

        FreemarkerUtil.buildHtml(inputPath + "include/", "hotgift.html", rootMap, outputPath + "include/", "hotgift.html");
    }


    private List<Map<String, Object>> getLuoBoPicList() {
        List<Map<String, Object>> resultList = new ArrayList<Map<String, Object>>();
        List<LinkInfo> lunBoList = linkInfoBo.getLinkListByOrderByLimit("694", 10, "displaysort", OrderType.DESC, false);
        if (CollectionUtils.isEmpty(lunBoList)) {
            return resultList;
        }

        for (LinkInfo lunBo : lunBoList) {
            Map<String, Object> map = new HashMap<String, Object>();
            map.put("title", lunBo.getLinktitle());
            map.put("img", lunBo.getPicurl());
            map.put("bgColor", lunBo.getExt1() == null ? "" : lunBo.getExt1());
            map.put("url", lunBo.getLinkurl());
            map.put("downloadLink", lunBo.getExt2());
            resultList.add(map);
        }

        return resultList;
    }

    private List<Map<String, Object>> getNoticeList() {
        List<Map<String, Object>> resultList = new ArrayList<Map<String, Object>>();
        AdviceBo adviceBo = FacadeFactory.INSTANCE.getAdviceBo();
        List<Advice> adviceList = adviceBo.getAdviceListByAdviceTypeOrderByPublishDateDesc(AdviceTypeEnum.SouYouAdvice, 5);
        if (CollectionUtils.isEmpty(adviceList)) {
            return resultList;
        }

        for (Advice advice : adviceList) {
            Map<String, Object> map = new HashMap<String, Object>();
            map.put("type", advice.getPlatformno());
            map.put("title", advice.getTitle());
            if(advice.getJump()){
                map.put("url", advice.getJumpUrl()==null?"":advice.getJumpUrl());
            }else{
                map.put("url", "/notice/" + advice.getSeqId() + ".html");
            }

            resultList.add(map);
        }
        return resultList;
    }

    private Map<String, Object> getNoticeADMap() {
        Map<String, Object> resultMap = new HashMap<String, Object>();
        List<LinkInfo> adList = linkInfoBo.getLinkListByOrderByLimit("698", 1, "validdatetime", OrderType.DESC, isPreview);

        if (CollectionUtils.isEmpty(adList)) {
            return resultMap;
        }

        LinkInfo adLinkInfo = adList.get(0);
        resultMap.put("title", adLinkInfo.getLinktitle());
        resultMap.put("img", adLinkInfo.getPicurl());
        resultMap.put("url", adLinkInfo.getLinkurl());
        return resultMap;
    }

    private List<Map<String, Object>> getNewGameList() {
        return getGameInfoListByLinklocIdWithLimit("695", 4, "displaysort");
    }

    private List<Map<String, Object>> getHotGameList() {
        List<Map<String,Object>> resultList = new ArrayList<Map<String, Object>>();

        Map<Integer,Object> hotGameFeatureMap = getHotGameMap();
        for(Map.Entry entry : hotGameFeatureMap.entrySet()){
            Map<String,Object> map = new HashMap<String, Object>();
            String gameTypeId = entry.getKey().toString();
            if(StringUtils.isEmpty(gameTypeId) || "0".equals(gameTypeId)){
                continue;
            }
            map.put("gameTypeId",gameTypeId);
            map.put("gameType",gameFeaturesMap.get(gameTypeId)==null?"":gameFeaturesMap.get(gameTypeId));
            map.put("gameList",entry.getValue());
            resultList.add(map);
        }

        return resultList;
    }

    /**
     * 首页热门游戏
     *
     * @return
     */
    private Map<Integer, Object> getHotGameMap() {
        Map<Integer, Object> resultMap = new HashMap<Integer, Object>();
        //按照游戏前一天的收入排序
        List<LinkInfo> hotGameList = linkInfoBo.getLinkListByOrderByLimit("696","ext8",OrderType.DESC,isPreview);
        if(CollectionUtils.isEmpty(hotGameList)){
            return resultMap;
        }

        for(LinkInfo hotGameLinkInfo : hotGameList){
            String gameId = hotGameLinkInfo.getGameidbytuijian();
            if(StringUtils.isEmpty(gameId)) continue;

            GameDTO game = appGamesMap.get(gameId);
            if(game == null){
                continue;
            }


            List<Map<String,Object>> gameList = null;
            Map<String,Object> map = null;
            int gameFeature;
            gameFeature = game.getGameFeature();
            gameList = (List<Map<String,Object>>)resultMap.get(gameFeature);
            if(gameList == null){
                gameList = new ArrayList<Map<String, Object>>();
            }

            map = game.generateAppGameMap(mobileGameDownloadInfoMap);
            gameList.add(map);
            resultMap.put(gameFeature,gameList);
        }

        return resultMap;
    }

    private List<Map<String,Object>> getGameMonthRankList(){
        return getGameInfoListByLinklocIdWithLimit("697", 10, "ext8");
    }

    private List<Map<String,Object>> getGameWeekRankList(){
        return getGameInfoListByLinklocIdWithLimit("699", 10, "ext8");
    }

    private List<Map<String,Object>> getHotGiftList(){
        List<Map<String, Object>> resultList = new ArrayList<Map<String, Object>>();
        List<LinkInfo> giftList = linkInfoBo.getHotShouyouGiftList(8);
        if(CollectionUtils.isEmpty(giftList)){
            return resultList;
        }

        for(LinkInfo hotGiftLinkInfo : giftList){
            Map<String, Object> map = new HashMap<String, Object>();
            String gameId = hotGiftLinkInfo.getGameid();
            GameDTO game = appGamesMap.get(gameId);
            if(game == null){
                continue;
            }

            map.put("icon",hotGiftLinkInfo.getPicurl()==null?"":hotGiftLinkInfo.getPicurl());
            map.put("gameId",gameId);
            map.put("gameName",game.getGameName());
            map.put("gameNo", game.getGameNo());
            map.put("giftId",hotGiftLinkInfo.getLinkid());
            map.put("giftName",hotGiftLinkInfo.getLinktitle());
            map.put("gameOfficialLink",game.getOfficialWebSite()==null?"":game.getOfficialWebSite());
            map.put("isNeedSelectServer",1);
            map.put("mulPhotoUrl",game.getMulPhotoUrl());
            resultList.add(map);
        }

        return resultList;
    }

    private List<Map<String, Object>> getGameInfoListByLinklocIdWithLimit(String linklocid,int limit, String orderNum) {
        List<Map<String, Object>> resultList = new ArrayList<Map<String, Object>>();
        if(StringUtils.isEmpty(linklocid)) {
            return resultList;
        }
        List<LinkInfo> newGameList = linkInfoBo.getLinkListByOrderByLimit(linklocid, 10, orderNum, OrderType.DESC, isPreview);
        if (CollectionUtils.isEmpty(newGameList)) {
            return resultList;
        }

        for (LinkInfo newGameLinkInfo : newGameList) {
            Map<String,Object> map;
            String gameId = newGameLinkInfo.getGameidbytuijian();
            if(StringUtils.isEmpty(gameId)){
                continue;
            }

            GameDTO game = appGamesMap.get(gameId);
            if(game == null) continue;

            map = game.generateAppGameMap(mobileGameDownloadInfoMap);

            if(MapUtils.isNotEmpty(map)){
                resultList.add(map);
            }

            if(resultList.size() >= limit){
                break;
            }
        }

        return resultList;
    }
}
