
package com.xunlei.niux.manager.template.builder.mobilegameofficial;


import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import com.ferret.common.dao.enums.OrderType;
import com.ferret.common.dao.vo.Page;
import com.xunlei.niux.data.vipgame.facade.FacadeFactory;
import com.xunlei.niux.data.vipgame.vo.Advice;
import com.xunlei.niux.data.vipgame.vo.Games;
import com.xunlei.niux.data.vipgame.vo.LinkInfo;
import com.xunlei.niux.data.vipgame.vo.PageStatisticsJs;
import com.xunlei.niux.manager.template.builder.AbstractTemplateBuilder;
import com.xunlei.niux.manager.web.cache.GameCache;
import com.xunlei.niux.manager.web.util.FreemarkerUtil;


/**
 * 生成手游网页版官网
 * @author lisu
 *  2014-04-28
 */
public class MobileGameWebOfficialBuilder extends AbstractTemplateBuilder {
    private static final 	int pageSize = 20;
	private Games games = null;
	
	@Override
	public void executeShcema() throws Exception {
		games = GameCache.getInstance().getGameByGameId(schema.getExt1());
		LinkInfo info = getGameInfo();
		String title = buildHeadList(info);//生成头部
		buildIndexList(info,title);//生成手游官网首页
		buildBannerList();//生成背景图
		buildRightList(info);//生成右边信息
		buildArticleList(title);//生成文章列表
		//buildAdvice(info,title);//生成文章详情
	}
	
	private void buildArticleList(String title){
		
		
	}
	private String getContent(final Games games,final Advice advice){
		//替换静态图片访问地址
		String content=advice.getContent()==null?"":advice.getContent();
		content=content.replaceAll("src=\"/xlniuxmanager/userUploadFile/image","src=\"http://img.smxj.webgame.kanimg.com/userUploadFile/image");
		content=content.replaceAll("src=\"/xlniumanager/userUploadFile/image","src=\"http://img.smxj.webgame.kanimg.com/userUploadFile/image");
		//替换关键字
        if(games != null){
            List<LinkInfo> lilist=FacadeFactory.INSTANCE.getLinkInfoBo().getGameValidteLinkInfoListByLinkLocId("256", games.getGameId(), 10, false);
            for(LinkInfo li:lilist){
                if(li.getLinktitle()==null||"".equals(li.getLinktitle())){
                    continue;
                }
                content=content.replace(li.getLinktitle(), "<a href=\""+li.getLinkurl()+"\" target=\"_blank\">"+li.getLinktitle()+"</a>");
            }
        }

		return content;
	}
	
	private String getArticeUrlName(final Advice advice){
		if(advice.getContenturl()==null||"".equals(advice.getContenturl())){
			return System.currentTimeMillis()+".html";
		}
		String contentUrl=advice.getContenturl();
		if(contentUrl.contains("/a/")){
			return contentUrl.substring(contentUrl.lastIndexOf("/")+1);
		}
		return System.currentTimeMillis()+".html";
	}
	
	private void buildAdvice(LinkInfo info,String title){
		Games games = GameCache.getInstance().getGameByGameId(info.getGameidbytuijian());
		Advice query = new Advice();
		query.setAdviceType("5");
		query.setGameId(games.getGameId());
		List<Advice> list = FacadeFactory.INSTANCE.getBaseSo().findObjects(query, new Page());
		for(Advice adv:list){
			bulidMobileAdvice(adv,title);
		}
	}
	
	 private void bulidMobileAdvice(Advice advice,String title){
	        Games game = null;
	        game=GameCache.getInstance().getGameByGameId(advice.getGameId());	     
	        Map<String,String> articleInfoMap=new HashMap<String,String>();
	        articleInfoMap.put("typeId", advice.getPlatformno()+"");
	        articleInfoMap.put("title", advice.getTitle()+"");
	        articleInfoMap.put("red", advice.getRed()+"");
	        articleInfoMap.put("bold", advice.getBold()+"");
	        articleInfoMap.put("content", getContent(game, advice));
	        articleInfoMap.put("date", advice.getPublishDate().substring(0, 10));
	        String articeUrlName=getArticeUrlName(advice);
	        Map<String,Object> root=new HashMap<String,Object>();
	        root.put("articleMap", articleInfoMap);
	    	Map<String,String> result = new HashMap<String,String>();
			result.put("title", title);
			root.put("headMap", result);
	        String templateFilePath = htmlTemplate.getTemplateroot();
	        if(templateFilePath.endsWith("/")){
	            templateFilePath = templateFilePath.substring(0,templateFilePath.length()-1);
	        }

	        String htmlFilePath=htmlTemplate.getHtmlroot();
	        if(htmlFilePath.endsWith("/")){
	            htmlFilePath=htmlFilePath.substring(0, htmlFilePath.length()-1);
	        }

	        htmlFilePath += "/official/" + games.getGameNo();
	        //生成手游公告详情
	        String gameid = advice.getGameId();
	    	Games games = GameCache.getInstance().getGameByGameId(gameid);
	    	if(games.getClientType().intValue()==3){//如果是手游
	    		 FreemarkerUtil.buildHtml(templateFilePath+"/web/","article.html", root, htmlFilePath + "/web/a",articeUrlName);
	    	}
	    }
	    
	
	private LinkInfo getGameInfo(){
		LinkInfo query = new LinkInfo();
		query.setLinklocid("1278");//生成下载地址
		query.setGameidbytuijian(games.getGameId());
		Page page = new Page();
		List<LinkInfo> lilist=FacadeFactory.INSTANCE.getLinkInfoBo().find(query, page);		
		if(lilist!=null&&lilist.size()>0)return lilist.get(0);
		else return null;
	}
	
	
	private String buildHeadList(LinkInfo info){
		Map<String,Object> rootMap=new HashMap<String,Object>();
		Map<String,String> result=new HashMap<String,String>();
		Games games = GameCache.getInstance().getGameByGameId(info.getGameidbytuijian());
		//猜你喜欢
		LinkInfo queryinfo = new LinkInfo();
		queryinfo.setLinklocid("302");
		queryinfo.setGameid(games.getGameId());
		Page page = new Page();
		page.addOrder("displaysort", OrderType.DESC);
		List<LinkInfo> infolist=FacadeFactory.INSTANCE.getLinkInfoBo().find(queryinfo, page);		
		if(infolist != null&& infolist.size()>0){
			LinkInfo mylinkinfo = infolist.get(0);
			result.put("title", mylinkinfo.getLinktitle());
			result.put("description",mylinkinfo.getLinkdesc());
			result.put("keywords", mylinkinfo.getExt1());		
		}else{
			result.put("title", "");
			result.put("description","");
			result.put("keywords", "");		
		}
		result.put("gameNo", games.getGameNo());		
		result.put("gameId", games.getGameId());		
		result.put("gameName", games.getGameName());		
		result.put("gameOfficial", games.getOfficialWebSite()+"web/");		
		result.put("gameBBSUrl", games.getForumUrl());		
//		result.put("gsid", "");		
//		result.put("baiduId","");	
		PageStatisticsJs psjs = getStatisticsJsNo(games.getGameId());
		result.put("gsid", (psjs == null || psjs.getStatisticsId() == null) ? "" : psjs.getStatisticsId());
		result.put("baiduId", (psjs == null || psjs.getBaiDuId() == null) ? "" : psjs.getBaiDuId());
		rootMap.put("headMap", result);
		
		String htmlFilePath = isPreView ? htmlTemplate.getPreviewhtmlroot() : htmlTemplate.getHtmlroot();
		String htmlFilePath1 = htmlFilePath + "/official/" + games.getGameNo();		
		FreemarkerUtil.buildHtml(htmlTemplate.getTemplateroot()+"/web/include/", "head.html", rootMap, htmlFilePath1+ "/web/include" ,  "head.html");
		return  result.get("title");
	}
	public PageStatisticsJs getStatisticsJsNo(String gameId) {
		PageStatisticsJs psjs = new PageStatisticsJs();
		psjs.setGameId(gameId);
		List<PageStatisticsJs> list = FacadeFactory.INSTANCE.getPageStatisticsJsBo().findPageStatisticsJss(
				psjs, 1, 1);
		if (list == null || list.size() == 0) {
			return null;
		}
		return list.get(0);
	}
	private void buildRightList(LinkInfo info){
		Map<String,Object> rootMap=new HashMap<String,Object>();
		Map<String,Object> result= new HashMap<String,Object>();		
		Games games = GameCache.getInstance().getGameByGameId(info.getGameidbytuijian());
		result.put("apkUrl", info.getLinkurl());
		result.put("gameName",games.getGameName());
		result.put("gameIcon", info.getSmallpicurl());		
		rootMap.put("downloadInfo", result);
				
		//猜你喜欢
		LinkInfo queryinfo = new LinkInfo();
		queryinfo.setLinklocid("1282");
		queryinfo.setGameid(games.getGameId());
		Page page = new Page();
		page.addOrder("displaysort", OrderType.DESC);
		List<LinkInfo> infolist=FacadeFactory.INSTANCE.getLinkInfoBo().find(queryinfo, page);
		if(infolist != null&&infolist.size()>21)
		  infolist = infolist.subList(0, 21);
		List<Map<String,Object>> list = new ArrayList<Map<String,Object>>();
		for(LinkInfo qinfo:infolist){
			Map<String,Object> map = new HashMap<String,Object>();
			Games mygames = GameCache.getInstance().getGameByGameId(qinfo.getGameidbytuijian());
			map.put("gameName", mygames.getGameName());
			map.put("pic", qinfo.getPicurl());
			map.put("link", qinfo.getLinkurl());
			list.add(map);
		}
		rootMap.put("likeList", list);
		
		String htmlFilePath = isPreView ? htmlTemplate.getPreviewhtmlroot() : htmlTemplate.getHtmlroot();
		String htmlFilePath1 = htmlFilePath + "/official/" + games.getGameNo();		
		FreemarkerUtil.buildHtml(htmlTemplate.getTemplateroot()+"/web/include/", "right.html", rootMap, htmlFilePath1+ "/web/include" ,  "right.html");
	}
	
	private void buildBannerList(){
		Map<String,Object> rootMap=new HashMap<String,Object>();
		LinkInfo query = new LinkInfo();
		query.setLinklocid("1280");
		query.setGameid(games.getGameId());
		Page page = new Page();
		page.setPageNo(1);
		page.setPageSize(1);
		page.addOrder("validdatetime", OrderType.DESC);
		List<LinkInfo> lilist=FacadeFactory.INSTANCE.getLinkInfoBo().find(query, page);		
		if(lilist != null&&lilist.size()>0){
			LinkInfo info = lilist.get(0);
			rootMap.put("bannerPic", info.getPicurl());
		}else{
			rootMap.put("bannerPic", "");
		}		
		String htmlFilePath = isPreView ? htmlTemplate.getPreviewhtmlroot() : htmlTemplate.getHtmlroot();
		String htmlFilePath1 = htmlFilePath + "/official/" + games.getGameNo();		
		FreemarkerUtil.buildHtml(htmlTemplate.getTemplateroot()+"/web/include/", "banner.html", rootMap, htmlFilePath1+ "/web/include" ,  "banner.html");
	}
	
	private void buildIndexList(LinkInfo info,String title){
		Map<String,Object> rootMap=new HashMap<String,Object>();				
		rootMap.put("gameInfo", getGameInfo(info));//游戏基本信息		
		List<Map<String,Object>> zongHeList = new ArrayList<Map<String,Object>>();
		List<Map<String,Object>> gongGaoList = new ArrayList<Map<String,Object>>();
		List<Map<String,Object>> huoDongList = new ArrayList<Map<String,Object>>();
		getAdviceList(zongHeList,gongGaoList,huoDongList);
		rootMap.put("zongheList", (zongHeList!=null&&zongHeList.size()>6)?zongHeList.subList(0, 6):zongHeList);//综合内容		
		rootMap.put("gonggaoList", (gongGaoList!=null&&gongGaoList.size()>6)?gongGaoList.subList(0, 6):gongGaoList);//公告	
		rootMap.put("huodongList", (huoDongList!=null&&huoDongList.size()>6)?huoDongList.subList(0, 6):huoDongList);//活动	
		rootMap.put("gamePicList", getGamePicList());//游戏截图
		Map<String,String> result = new HashMap<String,String>();
		result.put("title", title);
		rootMap.put("headMap", result);
		String htmlFilePath = isPreView ? htmlTemplate.getPreviewhtmlroot() : htmlTemplate.getHtmlroot();
		String htmlFilePath1 = htmlFilePath + "/official/" + games.getGameNo();		
		FreemarkerUtil.buildHtml(htmlTemplate.getTemplateroot()+"/web/", "index.html", rootMap, htmlFilePath1+ "/web" ,  "index.html");
		
		makeArticlePageList(zongHeList,"zonghe",title);
		makeArticlePageList(gongGaoList,"gonggao",title);
		makeArticlePageList(huoDongList,"huodong",title);
	}
	
	
	private Map<String,Object> getGameInfo(LinkInfo info){
		Map<String,Object> gameMap= new HashMap<String,Object>();		
		Games games = GameCache.getInstance().getGameByGameId(info.getGameidbytuijian());
		gameMap.put("gameName", games.getGameName());
		gameMap.put("gameIcon", info.getSmallpicurl());
		gameMap.put("type", getType(info.getExt1()));
		gameMap.put("style", getStyle(info.getExt2()));
		gameMap.put("intro", games.getGameDesc());
		return gameMap;
	}
	
	
	/**
	 * 综合
	 * @return
	 */
	private void getAdviceList(List<Map<String,Object>> zongHeList,
			List<Map<String,Object>> gongGaoList,
			List<Map<String,Object>> hongDongList){
		Advice query = new Advice();
		query.setGameId(games.getGameId());
		query.setAdviceType("3");
		Page page = new Page();
		page.addOrder("displayOrder", OrderType.ESC);
		List<Advice> advicelist = FacadeFactory.INSTANCE.getBaseSo().findObjects(query, page);
		for(Advice advice:advicelist){
			Map<String,Object> map = new HashMap<String,Object>();
			map.put("url", advice.getJumpUrl().replace("/a/", "/web/a/"));
			map.put("typeId", advice.getPlatformno());
			map.put("aid", advice.getSeqId());
			map.put("title", advice.getTitle());
			map.put("isColor", advice.getRed()?"yes":"no");
			map.put("isStrong", advice.getBold()?"yes":"no");
			String time = advice.getPublishDate();
			time = time.substring(0,10);
			map.put("date",time);
			if("gonggao".equals(advice.getPlatformno().trim())){
				gongGaoList.add(map);
			}else if("huodong".equals(advice.getPlatformno().trim())){
				hongDongList.add(map);
			}			
			map.put("type",advice.getPlatformno().trim());
			zongHeList.add(map);			
		}				
	}
	
	
	
	private void makeArticleDetail(List<Advice> advicelist,String mytypeId){
		
	}
	
	
	private void makeArticlePageList(List<Map<String,Object>> artilcelist,String mytypeId,String title){
		//生成文章列表
		int total = 0;
		if(artilcelist !=null&&artilcelist.size()>0){
			int size = artilcelist.size();
			if(size%pageSize==0){
				total = size/pageSize;
			}else{
				total = size/pageSize+1;
			}
			int index = 1;
			List<Map<String,Object>> list = new ArrayList<Map<String,Object>>();
			for(int i=0;i<size;i++){
				Map<String,Object> map = artilcelist.get(i);
				list.add(map);
				if((i+1)%20==0){
					makeDetail(mytypeId,list,index,total,title);
					list = new ArrayList<Map<String,Object>>();
					index ++;
				}else if(i==size-1){
					makeDetail(mytypeId,list,index,total,title);
				}
			}			
		}		
	}
	
	private void makeDetail(String typeId,List<Map<String,Object>> list,int cur,int total,String title){
		Map<String,Object> rootMap = new HashMap<String,Object>();
		Map<String,Object> result = new HashMap<String,Object>();
		result.put("typeId", typeId);
		result.put("list", list);
		rootMap.put("listInfoMap", result);
		Map<String,Object> pageresult = new HashMap<String,Object>();
		pageresult.put("cur", new Integer(cur));
		pageresult.put("total", new Integer(total));
		rootMap.put("pageInfoMap", pageresult);
		Map<String,String> titlersult = new HashMap<String,String>();
		titlersult.put("title", title);
		rootMap.put("headMap", titlersult);
		String htmlFilePath = isPreView ? htmlTemplate.getPreviewhtmlroot() : htmlTemplate.getHtmlroot();
		String htmlFilePath1 = htmlFilePath + "/official/" + games.getGameNo();		
		FreemarkerUtil.buildHtml(htmlTemplate.getTemplateroot()+"/web/", "articlelist.html", rootMap, htmlFilePath1+ "/web/"+typeId ,  cur+".html");
		
	}
	
	/**
	 * 热门文章
	 * @return
	 */
	private List<Map<String,Object>> getHotArticleList(){
		List<Map<String,Object>> list = new ArrayList<Map<String,Object>>();
		return list;
	}
	
	/**
	 * 游戏截图
	 * @return
	 */
	private List<Map<String,Object>> getGamePicList(){
		List<Map<String,Object>> list = new ArrayList<Map<String,Object>>();
		LinkInfo queryinfo = new LinkInfo();
		queryinfo.setLinklocid("1281");
		queryinfo.setGameid(games.getGameId());
		Page page = new Page();
		page.addOrder("displaysort", OrderType.DESC);
		List<LinkInfo> infolist=FacadeFactory.INSTANCE.getLinkInfoBo().find(queryinfo, page);
		for(LinkInfo info:infolist){
			Map<String,Object> result = new HashMap<String,Object>();
			result.put("src", info.getPicurl());
			list.add(result);
		}
		return list;
	}
	
	private String getType(String type){
   		if("1".equals(type)){
   			return "卡牌手游";
   		}else if("2".equals(type)){
   			return "对战手游";
   		}
   		return "未知";
	}
	
	private String getStyle(String style){
   		if("1".equals(style)){
   			return "可爱";
   		}else if("2".equals(style)){
   			return "养成";
   		}else if("3".equals(style)){
   			return "竞技";
   		}else if("4".equals(style)){
   			return "战斗";
   		}
   		return "未知";
	}
}

