package com.xunlei.niux.manager.template.builder.mobilegameofficial;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import com.ferret.common.dao.enums.OrderType;
import com.ferret.common.dao.vo.Page;
import com.xunlei.common.facade.IFacadeCommon;
import com.xunlei.common.vo.LibClassD;
import com.xunlei.common.vo.LibClassM;
import com.xunlei.niux.data.vipgame.dto.game.GameDTO;
import com.xunlei.niux.data.vipgame.facade.FacadeFactory;
import com.xunlei.niux.data.vipgame.vo.Games;
import com.xunlei.niux.data.vipgame.vo.LinkInfo;
import com.xunlei.niux.data.vipgame.vo.mobilegameapkversion.MobileChannel;
import com.xunlei.niux.easyutils.commonutils.NumParseUtil;
import com.xunlei.niux.manager.template.builder.AbstractTemplateBuilder;
import com.xunlei.niux.manager.web.cache.ApkSpreadCache;
import com.xunlei.niux.manager.web.cache.GameCache;
import com.xunlei.niux.manager.web.util.FreemarkerUtil;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang.StringUtils;


/**
 * app 版  手游官网
 * @author lisu
 * 2014-07-04
 */
public class MobileBuilder extends AbstractTemplateBuilder {
    private Map<String,String> gameFeaturesMap;
    private Map<String,GameDTO> appGamesMap;

	@Override
	public void executeShcema() throws Exception {
        initAllAppGameMap();
        initGameFeaturesMap();
		buildMobile();
	}

    private void initAllAppGameMap(){
        appGamesMap = new HashMap<String, GameDTO>();
        List<GameDTO> list = FacadeFactory.INSTANCE.getGamesBo().getAllValidAppGames();
        if(CollectionUtils.isEmpty(list)){
            return;
        }

        for(GameDTO gameDTO:list){
            appGamesMap.put(gameDTO.getGameId(),gameDTO);
        }
    }

    private void initGameFeaturesMap(){
        gameFeaturesMap = new HashMap<String, String>();

//        gameFeaturesMap.put(0,"其他");
//        gameFeaturesMap.put(1,"三国");
//        gameFeaturesMap.put(2,"卡牌");
//        gameFeaturesMap.put(3,"仙侠");
//        gameFeaturesMap.put(4,"武侠");
//        gameFeaturesMap.put(5,"魔幻");
//        gameFeaturesMap.put(6,"塔防");
//        gameFeaturesMap.put(7,"奇幻");
//        gameFeaturesMap.put(8,"历史");
//        gameFeaturesMap.put(9,"热血");
//        gameFeaturesMap.put(10,"休闲");

        List datas = LibClassM.getLibClassDList("gameFeatures");

        for (int i = 0; i < datas.size(); i++) {
            String typeid = ((LibClassD) datas.get(i)).getItemno().trim();
            gameFeaturesMap.put(typeid,((LibClassD) datas.get(i)).getItemname().trim());
        }
    }
	
	
	private void  makeDetail(String htmlTemlateRoot,String roothtml,GameDTO game,List<Map<String,String>> channelList,LinkInfo li){
        String gameId = game.getGameId();
		Map<String,Object> rootMap=new HashMap<String,Object>();
		Map<String,Object> gameInfoMap = new HashMap<String,Object>();
		gameInfoMap.put("imgSrc",  game.getSmallPicUrl()==null?"":game.getSmallPicUrl());
		gameInfoMap.put("title",game.getGameName());
		gameInfoMap.put("yxType",gameFeaturesMap.get(String.valueOf(game.getGameFeature()))==null?"":gameFeaturesMap.get(String.valueOf(game.getGameFeature())));
		gameInfoMap.put("yxSize", game.getAppSize()==null?"":game.getAppSize());
		gameInfoMap.put("tmplDownUrl", game.getDownLoadUrl()==null?"":game.getDownLoadUrl());
		gameInfoMap.put("gameid", gameId);
		gameInfoMap.put("yxDetail", game.getGameDesc()==null?"":game.getGameDesc());
		rootMap.put("gameInfoMap", gameInfoMap);
		rootMap.put("gamePicList", getGamePicList(gameId));
		rootMap.put("advList", channelList);
		
		FreemarkerUtil.buildHtml(htmlTemlateRoot+"/detail", "gameId.html", rootMap, roothtml+"/detail",
				gameId+".html");
	}
	
	private List<Map<String,Object>> getGamePicList(String gameId){
		List<Map<String,Object>> list = new ArrayList<Map<String,Object>>();
		LinkInfo queryinfo = new LinkInfo();
		queryinfo.setLinklocid("1281");
		queryinfo.setGameid(gameId);
		Page page = new Page();
		page.addOrder("displaysort", OrderType.DESC);
		List<LinkInfo> infolist=FacadeFactory.INSTANCE.getLinkInfoBo().find(queryinfo, page);
		for(LinkInfo info:infolist){
			Map<String,Object> result = new HashMap<String,Object>();
			result.put("src", info.getPicurl());
			list.add(result);
		}
		return list;
	}
	private String getTypeName(Games game){
		String typeName="";
		if(game.getGameType().equals("1")){
			typeName="角色扮演";
		}else if(game.getGameType().equals("2")){
			typeName="写实";
		}else if(game.getGameType().equals("3")){
			typeName="Q版萌系";
		}else if(game.getGameType().equals("4")){
			typeName="战争策略";
		}
		return  typeName;
	}
	
	private void buildMobile(){
		ApkSpreadCache.getInstance().updateCache();
		String htmlTemlateRoot = htmlTemplate.getTemplateroot();
		String roothtml = getHtmlRoot();
		Map<String,Object> rootMap=new HashMap<String,Object>();
		//获取轮播图
		List<LinkInfo> lilist=FacadeFactory.INSTANCE.getLinkInfoBo().getValidteLinkInfoListByLinkLocId_V2("1275", 4, isPreView);
		List<Map<String,String>> lunbotuList=new ArrayList<Map<String,String>>();
		for(int i=0;i<lilist.size();i++){
			LinkInfo li=lilist.get(i);
			Map<String,String> map=new HashMap<String,String>();
			map.put("title", li.getLinktitle()==null?"":li.getLinktitle());
			map.put("content", li.getLinkdesc()==null?"":li.getLinkdesc());
			map.put("url", li.getLinkurl()==null?"":li.getLinkurl());
			map.put("img", li.getPicurl()==null?"":li.getPicurl());
			lunbotuList.add(map);
		}
		rootMap.put("sliderImgList", lunbotuList);
		//手机页的轮播图
		lilist=FacadeFactory.INSTANCE.getLinkInfoBo().getValidteLinkInfoListByLinkLocId_V2("1277", 5, isPreView);
		List<Map<String,String>> mobilelunbotuList=new ArrayList<Map<String,String>>();
		for(int i=0;i<lilist.size();i++){
			LinkInfo li=lilist.get(i);
			Map<String,String> map=new HashMap<String,String>();
			map.put("title", li.getLinktitle()==null?"":li.getLinktitle());
			map.put("content", li.getLinkdesc()==null?"":li.getLinkdesc());
			map.put("url", li.getLinkurl()==null?"":li.getLinkurl());
			map.put("img", li.getPicurl()==null?"":li.getPicurl());
			mobilelunbotuList.add(map);
		}
		rootMap.put("mobilesliderImgList", mobilelunbotuList);
		
		//获取下载链接
		List<Map<String,Object>> downloadList=new ArrayList<Map<String,Object>>();
		lilist=FacadeFactory.INSTANCE.getLinkInfoBo().getValidteLinkInfoListByLinkLocId_V2("1276", 400, isPreView);
		List<Map<String,String>> channelList = getChannelList();
		for(int i=0;i<lilist.size();i++){
			LinkInfo li=lilist.get(i);
			Map<String,Object> map=new HashMap<String,Object>();

            String gameId = li.getGameidbytuijian();
            if(StringUtils.isEmpty(gameId)) continue;

            GameDTO game = appGamesMap.get(gameId);
            if(game == null){
                Games query = new Games();
                query.setGameId(gameId);
                Games games = FacadeFactory.INSTANCE.getBaseSo().findObject(query);
                if(games==null){
                    continue;
                }
                game = getGameDTOByGames(games);
            }

            int downloadNum = 100000;
            if(game.getDownloadNum()!=null && game.getDownloadNum() > 0){
                downloadNum = game.getDownloadNum();
            }else if(StringUtils.isNotEmpty(li.getExt4())){
                downloadNum = Integer.parseInt(li.getExt4());
            }

            String appSize = "100.0M";
            if(StringUtils.isNotEmpty(game.getAppSize())){
                appSize = game.getAppSize();
            }else if(StringUtils.isNotEmpty(li.getExt2())){
                appSize = li.getExt2();
            }

			map.put("imgSrc",  game.getSmallPicUrl()==null?"":game.getSmallPicUrl());
			map.put("title",game.getGameName());
			map.put("clientType",game.getMobileGameType()==null?1:game.getMobileGameType().intValue());
			map.put("yxType",gameFeaturesMap.get(String.valueOf(game.getGameFeature()))==null?"":gameFeaturesMap.get(String.valueOf(game.getGameFeature())));
			map.put("yxSize", appSize);
			map.put("yxDownUrl", game.getDownLoadUrl()==null?"":game.getDownLoadUrl());
			map.put("yxDetail", game.getGameDesc()==null?"":game.getGameDesc());
			map.put("yxStar", li.getExt3()==null?0:Integer.valueOf(li.getExt3()));

			map.put("yxPeople", NumParseUtil.getDownloadNumStr(String.valueOf(downloadNum)));
			map.put("gameid", gameId);
			map.put("tmplDownUrl", game.getDownLoadUrl()==null?"":game.getDownLoadUrl());
			downloadList.add(map);
			makeDetail(htmlTemlateRoot,roothtml,game,channelList,li);
		}
		rootMap.put("sliderYouxiList", downloadList);
		
//		
//		List<LinkInfo> channellilist=FacadeFactory.INSTANCE.getLinkInfoBo().getValidteLinkInfoListByLinkLocId_V2("1291", 1000, isPreView);
//		Map<String,Map<String,Object>> channelGameMap=new HashMap<String, Map<String,Object>>();
//		for(LinkInfo li:channellilist){
//			Map<String,Object>tempGameMap=channelGameMap.get(li.getExt1());
//			if(tempGameMap==null){
//				tempGameMap=new HashMap<String, Object>();
//				channelGameMap.put(li.getExt1(), tempGameMap);
//			}
//			tempGameMap.put(li.getGameidbytuijian(), li.getDisplaysort());
//		}
//		List<Map<String,String>> sortList=new ArrayList<Map<String,String>>();
//		Set<String> ketSet=channelGameMap.keySet();
//		Iterator<String> it=ketSet.iterator();
//		while(it.hasNext()){
//			String key=it.next();
//			Map<String,Object> gameSortMap=channelGameMap.get(key);
//			String jsonStr=JsonObjectUtil.getDataJsonObject(gameSortMap);
//			Map<String,String> tempMap=new HashMap<String, String>();
//			tempMap.put("advNo", key);
//			tempMap.put("sortJson", jsonStr);
//			sortList.add(tempMap);
//		}
		
		rootMap.put("advList", channelList);
//		rootMap.put("advList", sortList);

        String qcodePath = IFacadeCommon.INSTANCE.getLibconfigValueByConfigNo("qcodePath");
        rootMap.put("qrcodeImgPath", StringUtils.isEmpty(qcodePath)?"":qcodePath);
		
//		FreemarkerUtil.buildHtml(htmlTemlateRoot, "mobilegame_inner.html", rootMap, roothtml,
//				"mobilegame_inner.html");
		FreemarkerUtil.buildHtml(htmlTemlateRoot, "index.html", rootMap, roothtml,
				"index.html");
	}

    private GameDTO getGameDTOByGames(Games games){
        GameDTO game = new GameDTO();
        game.setGameId(games.getGameId());
        game.setGameName(games.getGameName());
        game.setMobileGameType(games.getMobileGameType());
        game.setGameFeature(games.getGameFeature());
        game.setGameDesc(games.getGameDesc());
        return game;
    }
	
	private List<Map<String,String>> getChannelList(){
		List<MobileChannel> mcList=FacadeFactory.INSTANCE.getBaseSo().findObjects(new MobileChannel(), new Page());
		List<Map<String,String>> mcMapList=new ArrayList<Map<String,String>>();
		for(MobileChannel mc:mcList){
			Map<String,String> tempMap=new HashMap<String, String>();
			tempMap.put("advNo", mc.getChannelId());
			mcMapList.add(tempMap);
		}
		return mcMapList;
	}
	
	
	public void buildDownLoad(){
		List<LinkInfo> linkList=FacadeFactory.INSTANCE.getLinkInfoBo().getValidteLinkInfoListByLinkLocId_V2("1276", 1000, isPreView);
		Map<String,LinkInfo> gameLiMap=new HashMap<String,LinkInfo>();
		for(int len=linkList.size();len>0;len--){
			LinkInfo li=linkList.get(len-1);
			gameLiMap.put(li.getGameidbytuijian(), li);
		}
		String htmlFilePath = isPreView ? htmlTemplate.getPreviewhtmlroot() : htmlTemplate.getHtmlroot();
		Map<String,Object> rootMap=new HashMap<String,Object>();
		List<Games> gamesList=GameCache.getInstance().getAllGames();
		for(int i=0;i<gamesList.size();i++){
			Games games=gamesList.get(i);
			Map<String,String> downloadmap=new HashMap<String,String>();
			LinkInfo li=gameLiMap.get(games.getGameId());
			
			downloadmap.put("name", games.getGameName());
			String type=games.getGameType();
			if("1".equals(type)){
				type="角色扮演";
			}else if("2".equals(type)){
				type="写实";
			}else if("3".equals(type)){
				type="Q版萌系";
			}else if("4".equals(type)){
				type="战争策略";
			}
			downloadmap.put("type",type);
			downloadmap.put("version", li==null||li.getExt1()==null?"":li.getExt1());
			downloadmap.put("size", li==null||li.getExt2()==null?"":li.getExt2());
			downloadmap.put("os", "android");
			downloadmap.put("description", games.getGameDesc()==null?"":games.getGameDesc());
			downloadmap.put("downloadLink",li==null||li.getLinkurl()==null?"":li.getLinkurl());
			downloadmap.put("image", li==null||li.getPicurl()==null?"":li.getPicurl());
			
			rootMap.put("gameDownLoad", downloadmap);
			//生成列表
			FreemarkerUtil.buildHtml(htmlTemplate.getTemplateroot()+"/mobile/account/gamedownload", "gameId.html", rootMap, htmlFilePath
					+ "/mobile/account/gamedownload" ,  games.getGameId()+".html");
		}
		
	}
}
