package com.xunlei.niux.manager.template.builder.mobilegameofficial;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import com.ferret.common.dao.enums.OrderType;
import com.ferret.common.dao.vo.Page;
import com.xunlei.common.facade.IFacadeCommon;
import com.xunlei.niux.data.vipgame.facade.FacadeFactory;
import com.xunlei.niux.data.vipgame.vo.Games;
import com.xunlei.niux.data.vipgame.vo.LinkInfo;
import com.xunlei.niux.data.vipgame.vo.mobilegameapkversion.CommonSpreadInfo;
import com.xunlei.niux.data.vipgame.vo.mobilegameapkversion.MobileChannel;
import com.xunlei.niux.manager.template.builder.AbstractTemplateBuilder;
import com.xunlei.niux.manager.web.cache.ApkSpreadCache;
import com.xunlei.niux.manager.web.cache.GameCache;
import com.xunlei.niux.manager.web.util.FreemarkerUtil;
import org.apache.commons.lang.StringUtils;

/**
 * app 版 常见问题
 * @author lisu
 *  2014-07-04
 */
public class CommonQuestionBuilder extends AbstractTemplateBuilder {

	@Override
	public void executeShcema() throws Exception {
		buildCommonQuestion();
		buildDownLoad();
	}
	public void buildCommonQuestion(){
		List<LinkInfo> linkList=FacadeFactory.INSTANCE.getLinkInfoBo().getValidteLinkInfoListByLinkLocId_V2("1264", 1000, isPreView);
		String htmlFilePath = isPreView ? htmlTemplate.getPreviewhtmlroot() : htmlTemplate.getHtmlroot();
		Map<String,Object> rootMap=new HashMap<String,Object>();
		List<Map<String,Object>> detailList=new ArrayList<Map<String,Object>>();
		//生成明细
		for(int i=0;i<linkList.size();i++){
			LinkInfo li=linkList.get(i);
			Map<String,Object> detailMap=new HashMap<String,Object>();
			detailMap.put("id", String.valueOf(li.getLinkid()));
			detailMap.put("title", li.getLinktitle()==null?"":li.getLinktitle());
			detailMap.put("content", li.getLinkcontents()==null?"":li.getLinkcontents());
			detailMap.put("date",li.getValiddatetime().length()>10?li.getValiddatetime().substring(0, 10):li.getValiddatetime());
			rootMap.put("commonQuestionMap", detailMap);
			detailList.add(detailMap);
			FreemarkerUtil.buildHtml(htmlTemplate.getTemplateroot()+"/mobile/kf", "detail.html", rootMap, htmlFilePath
					+ "/mobile/kf/detail" ,  li.getLinkid()+".html");
		}
		int totalPageNum=linkList.size()%10>0?linkList.size()/10+1:linkList.size()/10;
		rootMap.put("totalPageNum",totalPageNum);
		List<Map<String,Object>> tempList=new ArrayList<Map<String,Object>>();
		if(totalPageNum>0){
			for(int i=0;i<10&&i<detailList.size();i++){
				tempList.add(detailList.get(i));
			}
		}
		rootMap.put("kfList", tempList);
		//生成首页
		FreemarkerUtil.buildHtml(htmlTemplate.getTemplateroot()+"/mobile/kf", "index.html", rootMap, htmlFilePath
				+ "/mobile/kf" ,  "index.html");
		for(int i=1;i<totalPageNum;i++){
			tempList=new ArrayList<Map<String,Object>>();
			for(int j=0;j<10&&i*10+j<detailList.size();j++){
				tempList.add(detailList.get(i*10+j));
			}
			rootMap.put("kfList", tempList);
			//生成列表
			FreemarkerUtil.buildHtml(htmlTemplate.getTemplateroot()+"/mobile/kf", "list.html", rootMap, htmlFilePath
					+ "/mobile/kf/list" ,  (i+1)+".html");
		}
	}
	
	private void  makeDetail(String htmlTemlateRoot,String roothtml,String gameId,List<Map<String,String>> channelList,LinkInfo li){
		Map<String,Object> rootMap=new HashMap<String,Object>();
		Games game = GameCache.getInstance().getGameByGameId(gameId);
		Map<String,Object> gameInfoMap = new HashMap<String,Object>();
		gameInfoMap.put("imgSrc",  li.getPicurl()==null?"":li.getPicurl());
		gameInfoMap.put("title",game.getGameName());
		gameInfoMap.put("yxType",getTypeName(game));
		gameInfoMap.put("yxSize", li.getExt2()==null?"":li.getExt2());
		String commonUrl=li.getLinkurl()==null?"":li.getLinkurl().trim();
		if(commonUrl.lastIndexOf("_")==commonUrl.length()-23){
			commonUrl=commonUrl.substring(0, commonUrl.lastIndexOf("_"))+"_<%=advNo%>.apk";
		}
		gameInfoMap.put("tmplDownUrl", commonUrl);
		gameInfoMap.put("gameid", game.getGameId());
		gameInfoMap.put("yxDetail", game.getGameDesc());
		rootMap.put("gameInfoMap", gameInfoMap);
		rootMap.put("gamePicList", getGamePicList(gameId));
		rootMap.put("advList", channelList);
		
		FreemarkerUtil.buildHtml(htmlTemlateRoot+"/detail", "gameId.html", rootMap, roothtml+"/detail",
				gameId+".html");
	}
	
	private List<Map<String,Object>> getGamePicList(String gameId){
		List<Map<String,Object>> list = new ArrayList<Map<String,Object>>();
		LinkInfo queryinfo = new LinkInfo();
		queryinfo.setLinklocid("1281");
		queryinfo.setGameid(gameId);
		Page page = new Page();
		page.addOrder("displaysort", OrderType.DESC);
		List<LinkInfo> infolist=FacadeFactory.INSTANCE.getLinkInfoBo().find(queryinfo, page);
		for(LinkInfo info:infolist){
			Map<String,Object> result = new HashMap<String,Object>();
			result.put("src", info.getPicurl());
			list.add(result);
		}
		return list;
	}
	private String getTypeName(Games game){
		String typeName="";
		if(game.getGameType().equals("1")){
			typeName="角色扮演";
		}else if(game.getGameType().equals("2")){
			typeName="写实";
		}else if(game.getGameType().equals("3")){
			typeName="Q版萌系";
		}else if(game.getGameType().equals("4")){
			typeName="战争策略";
		}
		return  typeName;
	}
	
	private List<Map<String,String>> getChannelList(){
		List<MobileChannel> mcList=FacadeFactory.INSTANCE.getBaseSo().findObjects(new MobileChannel(), new Page());
		List<Map<String,String>> mcMapList=new ArrayList<Map<String,String>>();
		for(MobileChannel mc:mcList){
			Map<String,String> tempMap=new HashMap<String, String>();
			tempMap.put("advNo", mc.getChannelId());
			mcMapList.add(tempMap);
		}
		return mcMapList;
	}
	
	
	public void buildDownLoad(){
		List<LinkInfo> linkList=FacadeFactory.INSTANCE.getLinkInfoBo().getValidteLinkInfoListByLinkLocId_V2("1276", 1000, isPreView);
		Map<String,LinkInfo> gameLiMap=new HashMap<String,LinkInfo>();
		for(int len=linkList.size();len>0;len--){
			LinkInfo li=linkList.get(len-1);
			gameLiMap.put(li.getGameidbytuijian(), li);
		}
		String htmlFilePath = isPreView ? htmlTemplate.getPreviewhtmlroot() : htmlTemplate.getHtmlroot();
		Map<String,Object> rootMap=new HashMap<String,Object>();
		List<Games> gamesList=GameCache.getInstance().getAllGames();
		for(int i=0;i<gamesList.size();i++){
			Games games=gamesList.get(i);
			Map<String,String> downloadmap=new HashMap<String,String>();
			LinkInfo li=gameLiMap.get(games.getGameId());
			
			downloadmap.put("name", games.getGameName());
			String type=games.getGameType();
			if("1".equals(type)){
				type="角色扮演";
			}else if("2".equals(type)){
				type="写实";
			}else if("3".equals(type)){
				type="Q版萌系";
			}else if("4".equals(type)){
				type="战争策略";
			}
			downloadmap.put("type",type);
			downloadmap.put("version", li==null||li.getExt1()==null?"":li.getExt1());
			downloadmap.put("size", li==null||li.getExt2()==null?"":li.getExt2());
			downloadmap.put("os", "android");
			downloadmap.put("description", games.getGameDesc()==null?"":games.getGameDesc());
			//modify by lisu 2015-03-18 将以前apk的下载地址，替换成短连接，方便上报数据
			//String commonUrl   = ApkSpreadCache.getInstance().getSpreadJumpUrlByGameId(games.getGameId());
			String commonUrl = li==null||li.getLinkurl()==null?"":li.getLinkurl().trim();
			downloadmap.put("downloadLink",commonUrl);
			downloadmap.put("image", li==null||li.getPicurl()==null?"":li.getPicurl());
			
			rootMap.put("gameDownLoad", downloadmap);
			//生成列表
			FreemarkerUtil.buildHtml(htmlTemplate.getTemplateroot()+"/mobile/account/gamedownload", "gameId.html", rootMap, htmlFilePath
					+ "/mobile/account/gamedownload" ,  games.getGameId()+".html");
		}
		
	}
}
