package com.xunlei.niux.manager.template.builder.member;


import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import com.ferret.common.dao.enums.OrderType;
import com.ferret.common.dao.vo.Page;
import com.xunlei.common.vo.LibClassD;
import com.xunlei.common.vo.LibClassM;
import com.xunlei.niux.data.vipgame.facade.FacadeFactory;
import com.xunlei.niux.data.vipgame.vo.BonusProduct;
import com.xunlei.niux.data.vipgame.vo.GameServers;
import com.xunlei.niux.data.vipgame.vo.Games;
import com.xunlei.niux.data.vipgame.vo.LinkInfo;
import com.xunlei.niux.manager.constant.LinkLocationIdConstant;
import com.xunlei.niux.manager.template.builder.AbstractTemplateBuilder;
import com.xunlei.niux.manager.web.cache.GameCache;
import com.xunlei.niux.manager.web.util.FreemarkerUtil;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang.StringUtils;

/**
 * 会员特权页面模版生成工具
 * @author lisu
 * 2013-06-28
 */
public class MemberBuilder extends AbstractTemplateBuilder {
	  private boolean ispreview = false;//是否预览
//    private static String root = "/Users/jamesjxin/Work/XL工作目录/20131226会员特权专区需求1.4/html/";
//    private static String outputpath = "/Users/jamesjxin/Work/XL工作目录/20131226会员特权专区需求1.4/output";
    private Map<String,Object> rootMap=new HashMap<String,Object>();
    private static final SimpleDateFormat sdf=new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
    private String templateRoot;
    private String htmlFilePath;
    private List<Map<String,Object>> allGiftList;

		public static void main(String args[]) {
			try {
				new MemberBuilder().executeShcema();
			} catch (Exception e) {
				e.printStackTrace();
			}
		}

	 
	 @Override
	 public void executeShcema() throws Exception {
         templateRoot = htmlTemplate.getTemplateroot();
         htmlFilePath=isPreView?htmlTemplate.getPreviewhtmlroot():htmlTemplate.getHtmlroot();
         if(htmlFilePath.endsWith("/")){
             htmlFilePath=htmlFilePath.substring(0, htmlFilePath.length()-1);
         }

		 makeIndex();//生成会员特权首页
		 makeDetail();//生成会员特权详情页
         makeWeeklyFreeList();//免费游戏币历史列表页
         makeActPage();//生成会员活动列表页
	}
	
	private void makeIndex() throws Exception{
        allGiftList = getGiftList();
		rootMap.put("openServerList", getOpenServerList());
		rootMap.put("newGameList",getNewGameList());
		rootMap.put("giftOne",getGiftOne());
        rootMap.put("nextGiftOne",getNextGiftOne());
		rootMap.put("giftTwo",getGiftTwo());
		rootMap.put("giftThree",getGiftThree());
		rootMap.put("slideImg", getSlideImg());		
		Map<String,Object> giftmap = new HashMap<String,Object>();
		giftmap.put("giftListAdText", getSubHeadingAdText("606"));//会员专区副标题
		giftmap.put("giftList", allGiftList);
		rootMap.put("giftmap", giftmap);
        rootMap.put("notification", getNoticeList("633"));
		FreemarkerUtil.buildHtml(templateRoot,"index.html", rootMap, htmlFilePath,"index.html");
	}
	 
	
	
	
	private void makeDetail() throws Exception{
		Map<String,Object> giftmap = new HashMap<String,Object>();
		giftmap.put("giftListAdText", getSubHeadingAdText("606"));
		giftmap.put("giftList", allGiftList);
		rootMap.put("giftmap", giftmap);
		FreemarkerUtil.buildHtml(templateRoot,"zslb.html", rootMap, htmlFilePath,"zslb.html");
	}

    private void makeWeeklyFreeList(){
        rootMap.put("giftOneMap",getGiftOneMap());
        FreemarkerUtil.buildHtml(templateRoot,"weeklyfree.html", rootMap, htmlFilePath,"weeklyfree.html");
    }

    private void makeActPage(){
        rootMap.put("actList",getActList("631"));
        rootMap.put("moreActList",getActList("632"));

        FreemarkerUtil.buildHtml(templateRoot,"act.html", rootMap, htmlFilePath,"act.html");
    }
    
    private List<Map<String,Object>> getNoticeList(String linklocid){
    	   List<Map<String,Object>> result = new ArrayList<Map<String, Object>>();
    	   if(StringUtils.isEmpty(linklocid)){
               return result;
           }
           LinkInfo query = new LinkInfo();
           query.setLinklocid(linklocid);
           Page page = new Page();
           page.addOrder("edittime",OrderType.DESC);
           List<LinkInfo> list = FacadeFactory.INSTANCE.getBaseSo().findObjects(query,page);
           for(LinkInfo info:list){
        	   Map<String,Object> data = new HashMap<String,Object>();
        	   data.put("text", info.getLinktitle());
        	   data.put("link", info.getLinkurl());
        	   result.add(data);
           }
           return result;
    }

    private List<Map<String,Object>> getActList(String linklocid){
        List<Map<String,Object>> result = new ArrayList<Map<String, Object>>();
        if(StringUtils.isEmpty(linklocid)){
            return result;
        }
        LinkInfo query = new LinkInfo();
        query.setLinklocid(linklocid);
        query.setIsvalid(true);
        Page page = new Page();
        page.addOrder("ext7",OrderType.DESC);
        List<LinkInfo> list = FacadeFactory.INSTANCE.getBaseSo().findObjects(query,page);
        if(CollectionUtils.isEmpty(list)){
            return result;
        }
        for(LinkInfo info : list){
            Map<String,Object> map = new HashMap<String, Object>();
            map.put("img",info.getPicurl()==null?"":info.getPicurl());
            map.put("link",info.getLinkurl()==null?"":info.getLinkurl());
            map.put("title",info.getLinktitle()==null?"":info.getLinktitle());
            map.put("desc",info.getLinkdesc()==null?"":info.getLinkdesc());
            map.put("date",info.getExt7()==null?"":info.getExt7());
            result.add(map);
        }

        return result;
    }

	/**
	 * 获得会员特权页面最新开服列表的数据
	 * @return
	 */
	public List<Map<String,Object>> getOpenServerList() throws Exception{
		List<Map<String,Object>> result = new ArrayList<Map<String,Object>>();
		SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd");
		Calendar cal = Calendar.getInstance();
		cal.add(Calendar.DAY_OF_MONTH, 1);	
		String tomorrow = sdf.format(cal.getTime());//获得明天的日期	
		//获得后台录入的 首页最新开服列表中的数据
		LinkInfo linkInfo = new LinkInfo();
	    linkInfo.setLinklocid("1240");//牛x官网开服列表
	    Page page = new Page();
	    page.addOrder("validdatetime", OrderType.DESC);
	    List<LinkInfo> list = FacadeFactory.INSTANCE.getLinkInfoBo().find(linkInfo, page);	    
	    if(list == null||list.size()==0)return null;
	    
	    //获得游戏的区服信息
	    GameServers qgs=new GameServers();
		qgs.setToopentime(tomorrow+" 00:00:00");//只取今天以前的数据，其中包含今天的
		Page page1 = new Page();
		page1.addOrder("openTime", OrderType.DESC);
		List<GameServers> serverList=FacadeFactory.INSTANCE.getGameServersBo().find(qgs, page1);
		int jj = 0;
		boolean flag = true;
		for(GameServers server:serverList){		
			if(flag){
				for(int i=0;i<list.size();i++){				
					LinkInfo li=list.get(i);
				    if(server.getGameId().trim().equals(li.getGameidbytuijian().trim())&&(server.getFenQuNum()+"").equals(li.getExt1().trim())){
				    	//获取logo图片
						LinkInfo logoli=FacadeFactory.INSTANCE.getLinkInfoBo().getGameValidteLinkInfoByLinkLocId(LinkLocationIdConstant.GAME_LOGO, li.getGameidbytuijian(), ispreview);
						//游戏信息
						Games game=FacadeFactory.INSTANCE.getGamesBo().getGameByGameId(li.getGameidbytuijian());		               					
						Map<String,Object> map=new HashMap<String,Object>();
						String opentime = server.getOpenTime();
						String strs[] = opentime.split(" ");
						String date = strs[0].substring(5);//日期
						String time = strs[1].substring(0,5);//时间
						map.put("date", date);
						map.put("time", time);
						map.put("gameName", game.getGameName());
						map.put("gameNo", game.getGameNo());
						map.put("gameOfficialUrl",game.getOfficialWebSite());
						map.put("fenQuNum", server.getFenQuNum());
						map.put("serverName", server.getFenQuName());
						map.put("seqId", server.getSeqId());
						map.put("gameImg", logoli==null?"":logoli.getPicurl());
						result.add(map);
						jj ++;
						if(jj>=10){
							flag = false;
							break;//取其中9条记录
						}
				    }												
				}
			}
			
		}

		return result;
	}
	
	
	/**
	 * 获得会员特权页面最新游戏列表的数据
	 * @return
	 */
	public List<Map<String,Object>> getNewGameList() throws Exception{
		List<Map<String,Object>> result = new ArrayList<Map<String,Object>>();
		SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd");
		Calendar cal = Calendar.getInstance();
		cal.add(Calendar.DAY_OF_MONTH, 1);	
		String tomorrow = sdf.format(cal.getTime());//获得明天的日期
		
		//会员专区最新游戏列表中的数据
		LinkInfo linkInfo = new LinkInfo();
	    linkInfo.setLinklocid("604");//会员专区最新游戏
	    Page page = new Page();
	    page.addOrder("validdatetime", OrderType.DESC);
	    List<LinkInfo> list = FacadeFactory.INSTANCE.getLinkInfoBo().find(linkInfo, page);	    
	    if(list == null||list.size()==0)return null;
	    
	    //获得游戏的区服信息
	    GameServers qgs=new GameServers();
		qgs.setToopentime(tomorrow+" 00:00:00");//只取今天以前的数据，其中包含今天的
		Page page1 = new Page();
		page1.addOrder("openTime", OrderType.DESC);
		List<GameServers> serverList=FacadeFactory.INSTANCE.getGameServersBo().find(qgs, page1);
		
		//add by lisu 2013-08-09
		//每次取得最新区
		for(LinkInfo info:list){
			for(GameServers server:serverList){
				if(server.getGameId().trim().equals(info.getGameidbytuijian().trim())){
					info.setExt1(server.getFenQuNum()+"");
					break;
				}
			}
		}
		
		int jj = 0;
		boolean flag = true;
		for(GameServers server:serverList){		
			if(flag){
				for(int i=0;i<list.size();i++){				
					LinkInfo li=list.get(i);
				    if(server.getGameId().trim().equals(li.getGameidbytuijian().trim())&&(server.getFenQuNum()+"").equals(li.getExt1().trim())){
				    	//获取logo图片
						LinkInfo logoli=FacadeFactory.INSTANCE.getLinkInfoBo().getGameValidteLinkInfoByLinkLocId(LinkLocationIdConstant.GAME_LOGO, li.getGameidbytuijian(), ispreview);
						//游戏信息
						Games game=FacadeFactory.INSTANCE.getGamesBo().getGameByGameId(li.getGameidbytuijian());
		               					
						Map<String,Object> map=new HashMap<String,Object>();
						String opentime = server.getOpenTime();
						String strs[] = opentime.split(" ");
						String date = strs[0].substring(5);//日期
						String time = strs[1].substring(0,5);//时间
						map.put("date", date);
						map.put("time", time);
						map.put("gameName", game.getGameName());
						map.put("gameNo", game.getGameNo());
						map.put("gameOfficialUrl",game.getOfficialWebSite());
						map.put("fenQuNum", server.getFenQuNum());
						map.put("serverName", server.getFenQuName());
						map.put("seqId", server.getSeqId());
						map.put("gameImg", logoli==null?"":logoli.getPicurl());
						result.add(map);
						jj ++;
						if(jj>=10){
							flag = false;
							break;//取其中9条记录
						}
				    }												
				}
			}
			
		}

		return result;
	}
	
	/**
	 * 获得会员特权页面轮播图
	 * @return
	 * @throws Exception
	 */
	public List<Map<String,Object>> getSlideImg() throws Exception{
		   //会员专区轮播图的数据
			LinkInfo linkInfo = new LinkInfo();
		    linkInfo.setLinklocid("601");//会员专区轮播图
		    Page page = new Page();
		    page.addOrder("displaysort", OrderType.ESC);
		    List<LinkInfo> list = FacadeFactory.INSTANCE.getLinkInfoBo().find(linkInfo, page);	    
		    if(list==null||list.size()==0)return null;
		    List<Map<String,Object>> result = new ArrayList<Map<String,Object>>();
		    for(int i=0;i<list.size();i++){		    	  
		    	  LinkInfo info = list.get(i);
		    	  Map<String,Object> map = new HashMap<String,Object>();
		    	  map.put("img", info.getPicurl());
		    	  map.put("link", info.getLinkurl());
		    	  map.put("title", info.getLinktitle());
		    	  result.add(map);
		    }
		    return result;
	}
	
	/**
	 * 获得会员特权页面 免费游戏币相关数据
	 * @return
	 * @throws Exception
	 */
	public Map<String,Object> getGiftOne() throws Exception{
		//会员专区免费游戏币列表中最新的一条数据
		LinkInfo linkInfo = new LinkInfo();
	    linkInfo.setLinklocid("602");//会员专区免费游戏币列表中最新的一条数据
	    Page page = new Page();
	    page.addOrder("displaysort", OrderType.DESC);
	    List<LinkInfo> list = FacadeFactory.INSTANCE.getLinkInfoBo().find(linkInfo, page);	    
	    if(list == null||list.size()==0)return null;
	    LinkInfo info = list.get(0);

        return getGiftOneInfoMap(info);
	}

    private Map<String,Object> getGiftOneInfoMap(LinkInfo info){
        Map<String,Object> result = new HashMap<String,Object>();

        String seqid = info.getLinktitle();//奖品id
        BonusProduct bp = FacadeFactory.INSTANCE.getBonusProductBo().findBonusProductById(new Long (seqid));
        String gameid = bp.getGameId();
        Games game=GameCache.getInstance().getGameByGameId(gameid);
        result.put("adText", getSubHeadingAdText("627"));//免费游戏币标签
        result.put("gameName", game.getGameName());
        result.put("gameNo", game.getGameNo());
        result.put("gameId", game.getGameId());
        result.put("productName", bp.getProductName());
        result.put("productNo", bp.getProductNo());
        result.put("minGameLevel", bp.getMinGameLevel()==null?0:bp.getMinGameLevel());
        result.put("desc",info.getExt2()==null?"":info.getExt2());
        result.put("officialWebSite",game.getOfficialWebSite());
        result.put("validPeriod", info.getValiddatetime());//有效期
        result.put("productImg", info.getPicurl());
        result.put("picLink", info.getLinkurl());
        result.put("picTitle", info.getLinkcontents());
        result.put("picDesc", info.getLinkdesc());

        BonusProduct product =  FacadeFactory.INSTANCE.getBonusProductBo().findBonusProductById(new Long(seqid));
        result.put("totalNum", info.getExt1());//领取人数
        result.put("giveOutType", product.getGiveOutType());
        result.put("isSelectRole", product.getIsSelectRole()?1:0);
        result.put("gameType", getGameCategoryList(game.getGameId()));
        result.put("pid", product.getSeqId());
        result.put("isSelectServer", product.getIsQuFenServer()?"1":"0");

        result.put("getGiftLink",info.getExt4()==null?"":info.getExt4());
        result.put("minServer",info.getExt5()==null?"":info.getExt5());
        result.put("maxServer",info.getExt6()==null?"":info.getExt6());
        result.put("weeklyNum",info.getDisplaysort()==null?0:info.getDisplaysort());
        return result;
    }

    private Map<String,Object> getNextGiftOne(){
        //会员专区免费游戏币列表中最新的一条数据
        LinkInfo linkInfo = new LinkInfo();
        linkInfo.setLinklocid("630");//会员专区免费游戏币列表中最新的一条数据
       // linkInfo.setLinklocid("626");//内网        
        linkInfo.setFromvaliddatetime(sdf.format(new Date()));
        Page page = new Page();
        page.addOrder("displaysort", OrderType.ESC);
        List<LinkInfo> list = FacadeFactory.INSTANCE.getLinkInfoBo().find(linkInfo, page);
        if(list == null||list.size()==0)return null;
        LinkInfo info = list.get(0);
        Map<String,Object> result = new HashMap<String,Object>();

        result.put("productImg", info.getExt7());// 配置的大图
        result.put("picLink", info.getLinkurl());
        result.put("picTitle", info.getLinkcontents());
        result.put("picDesc", info.getLinkdesc());

        return result;
    }

	
	/**
	 * 查询某游戏的游戏类型
	 * @param gameid
	 * @return
	 */
	public String getGameCategoryList(String gameid) {
		Games games = GameCache.getInstance().getGameByGameId(gameid);
		List datas = LibClassM.getLibClassDList("gamecategory");
		String gameType = games.getGameType();
		for (int i = 0; i < datas.size(); i++) {
			String typeid = ((LibClassD) datas.get(i)).getItemno().trim();
			if(typeid.trim().equals(gameType.trim())){
				return  ((LibClassD) datas.get(i)).getItemname();
			}
		}
		return "";
	}

	
	/**
	 * 获得会员特权页面 主打游戏
	 * @return
	 * @throws Exception
	 */
	public Map<String,Object> getGiftTwo() throws Exception{
		//会员专区主打游戏列表中最新的一条数据
		LinkInfo linkInfo = new LinkInfo();
	    linkInfo.setLinklocid("603");//会员专区主打游戏列表中最新的一条数据
	    Page page = new Page();
	    page.addOrder("displaysort", OrderType.DESC);
	    List<LinkInfo> list = FacadeFactory.INSTANCE.getLinkInfoBo().find(linkInfo, page);	    
	    if(list == null||list.size()==0)return null;
	    LinkInfo info = list.get(0);
	    Map<String,Object> result = new HashMap<String,Object>();
	    String seqid = info.getLinktitle();//奖品id
	    BonusProduct bp = FacadeFactory.INSTANCE.getBonusProductBo().findBonusProductById(new Long (seqid));
	    String gameid = bp.getGameId();
	    //游戏信息
		Games game=GameCache.getInstance().getGameByGameId(gameid);
	    result.put("adText", getSubHeadingAdText("628"));//标签
	    result.put("gameName", game.getGameName());
	    //result.put("gameType", game.getGameType());
	    result.put("gameGrade", info.getExt1());
	    result.put("gameNo", game.getGameNo());
	    result.put("gameId", game.getGameId());
	    result.put("productImg", info.getPicurl());
	    result.put("productName", bp.getProductName());
	    result.put("minGameLevel", bp.getMinGameLevel()==null?0:bp.getMinGameLevel());
	    result.put("desc",info.getExt2()==null?"":info.getExt2());
	    result.put("officialWebSite",game.getOfficialWebSite());
	    result.put("validPeriod", info.getValiddatetime());//有效期
	    result.put("picLink", info.getLinkurl());
	    result.put("picTitle", info.getLinkcontents());
	    result.put("picDesc", info.getLinkdesc());	 
	    
	    BonusProduct product =  FacadeFactory.INSTANCE.getBonusProductBo().findBonusProductById(new Long(seqid));
	    result.put("giveOutType", product.getGiveOutType());
	    result.put("gameType", info.getGameidbytuijian());//后台可录入的游戏类型
	    result.put("pid", product.getSeqId());
	    result.put("isSelectRole", product.getIsSelectRole()?1:0);
	    result.put("productNo", product.getProductNo());
	    result.put("isSelectServer", product.getIsQuFenServer()?"1":"0");
        result.put("getGiftLink",info.getExt4()==null?"":info.getExt4());
        result.put("minServer",info.getExt5()==null?"":info.getExt5());
        result.put("maxServer",info.getExt6()==null?"":info.getExt6());
		return result;
	}
	
	public Map<String,Object> getGiftThree() throws Exception{
		//会员专区主打游戏列表中最新的一条数据
		LinkInfo linkInfo = new LinkInfo();
	    linkInfo.setLinklocid("634");//会员专区每周福利活动中最新的一条数据
	    Page page = new Page();
	    page.addOrder("displaysort", OrderType.DESC);
	    List<LinkInfo> list = FacadeFactory.INSTANCE.getLinkInfoBo().find(linkInfo, page);	    
	    if(list == null||list.size()==0)return null;
	    LinkInfo info = list.get(0);
	    Map<String,Object> result = new HashMap<String,Object>();
	    result.put("adText", info.getExt3());//标签
	    result.put("actName",info.getLinktitle());
	    result.put("desc", info.getExt2());
	    result.put("validPeriod", info.getValiddatetime());
	    result.put("actImg", info.getPicurl());
	    result.put("gameDownloadLink", info.getLinkurl());
	    result.put("picLink", info.getExt4());
	    result.put("picTitle",info.getLinkcontents());
	    result.put("picDesc",info.getLinkdesc());
		return result;
	}
	
	/**
	 * 获得奖品兑换类型
	 * @param type
	 * @return
	 */
	public String getGameType(String type){
		if(type == null)return "";
		int gtype = Integer.parseInt(type);
		switch(gtype){
		  case 1:return "激活码";
		  case 2:return "活动产品区";
		  case 3:return "发放到游戏";
		  case 4:return "实物";
		  case 5:return "其他";
		}
		return "";
	}

	/**
	 * 获得礼包列表
	 * @return
	 */
	public List<Map<String,Object>> getGiftList(){
		 BonusProduct product = new BonusProduct();
		 product.setPlatForm("4");//会员专区的礼包
		 List<BonusProduct> bplist = FacadeFactory.INSTANCE.getBonusProductBo().find(product, 0, 0);
		 if(bplist == null||bplist.size()==0)return null;
		 LinkInfo linkInfo = new LinkInfo();
	     linkInfo.setLinklocid("605");//
	     Page page = new Page();
	     page.addOrder("validdatetime", OrderType.DESC);
	     List<LinkInfo> list = FacadeFactory.INSTANCE.getLinkInfoBo().find(linkInfo, page);	    	     
		 List<Map<String,Object>> result = new ArrayList<Map<String,Object>>();
//		 int ii =0;

			 if(list != null && list.size()>0){
				 for(LinkInfo info :list){
//					 if(ii>=8){
//						 break;
//					 }
					 for(BonusProduct  bp:bplist){
						 String seqid = bp.getSeqId()+"";
						 if(seqid.equals(info.getLinktitle())){
							 Map<String,Object> map = new HashMap<String,Object>();
							 map.put("id", bp.getSeqId());
							 map.put("productNo", bp.getProductNo());
							 map.put("productName", bp.getProductName());
							 map.put("giveOutType", bp.getGiveOutType());
							 map.put("isSelectRole", bp.getIsSelectRole()?1:0);
							 map.put("minGameLevel", bp.getMinGameLevel()==null?0:bp.getMinGameLevel());
							 String gameId = bp.getGameId();
							 Games games = GameCache.getInstance().getGameByGameId(gameId);
							 map.put("gameId", gameId);
							 map.put("gameName", games.getGameName());
							 map.put("gameNo", games.getGameNo());
							 map.put("officialWebSite", games.getOfficialWebSite());
							 map.put("isSelectServer", bp.getIsQuFenServer()?"1":"0");		
							 map.put("productImg", info.getPicurl());
                             map.put("playerNum",info.getExt1()==null?"":info.getExt1());
                             map.put("getGiftLink",info.getExt4()==null?"":info.getExt4());
                             map.put("minServer",info.getExt5()==null?"":info.getExt5());
                             map.put("maxServer",info.getExt6()==null?"":info.getExt6());

							 String desc = info.getLinkcontents();
							 if(desc.indexOf("\r\n") != -1){
								 desc = desc.replace("\r\n", "<br>");							 
							 }
							 if(desc.indexOf("\r") != -1){
								 desc = desc.replace("\r", "<br>");							 
							 }
							 if(desc.indexOf("\n") != -1){
								 desc = desc.replace("\n", "<br>");							 
							 }
							 desc = desc.replace("'","");
							 map.put("desc",desc);				
//							 ii++;
							 result.add(map);
						 }
				 }		
			 }
			
		 }
		 return result;
	}
	
	
	/**
	 * 获得全部礼包列表
	 * @return
	 */
	public List<Map<String,Object>> getAllGiftList(){
		 BonusProduct product = new BonusProduct();
		 product.setPlatForm("4");//会员专区的礼包
		 List<BonusProduct> bplist = FacadeFactory.INSTANCE.getBonusProductBo().find(product, 0, 0);
		 if(bplist == null||bplist.size()==0)return null;
		 LinkInfo linkInfo = new LinkInfo();
	     linkInfo.setLinklocid("605");//
	     Page page = new Page();
	     page.addOrder("validdatetime", OrderType.DESC);
	     List<LinkInfo> list = FacadeFactory.INSTANCE.getLinkInfoBo().find(linkInfo, page);
		 List<Map<String,Object>> result = new ArrayList<Map<String,Object>>();
			 if(list != null && list.size()>0){
				 for(LinkInfo info :list){
					 for(BonusProduct  bp:bplist){
						 String seqid = bp.getSeqId()+"";
						 if(seqid.equals(info.getLinktitle())){
							 Map<String,Object> map = new HashMap<String,Object>();
							 map.put("id", bp.getSeqId());
							 map.put("productNo", bp.getProductNo());
							 map.put("productName", bp.getProductName());
							 map.put("giveOutType", bp.getGiveOutType());
							 map.put("isSelectRole", bp.getIsSelectRole()?1:0);
							 map.put("minGameLevel", bp.getMinGameLevel()==null?0:bp.getMinGameLevel());
							 String gameId = bp.getGameId();
							 Games games = GameCache.getInstance().getGameByGameId(gameId);
							 map.put("gameId", gameId);
							 map.put("gameName", games.getGameName());
							 map.put("gameNo", games.getGameNo());
							 map.put("officialWebSite", games.getOfficialWebSite());
							 map.put("isSelectServer", bp.getIsQuFenServer()?"1":"0");
							 map.put("productImg", info.getPicurl());
                             map.put("playerNum",info.getExt1()==null?"":info.getExt1());
                             map.put("getGiftLink",info.getExt4()==null?"":info.getExt4());
                             map.put("minServer",info.getExt5()==null?"":info.getExt5());
                             map.put("maxServer",info.getExt6()==null?"":info.getExt6());
							 String desc = info.getLinkcontents();
							 if(desc.indexOf("\r\n") != -1){
								 desc = desc.replace("\r\n", "<br>");
							 }
							 if(desc.indexOf("\r") != -1){
								 desc = desc.replace("\r", "<br>");
							 }
							 if(desc.indexOf("\n") != -1){
								 desc = desc.replace("\n", "<br>");
							 }
							 desc = desc.replace("'","");
							 map.put("desc",desc);
							 result.add(map);
						 }
				 }
			 }

		 }
		 return result;
	}

    private Map<String,Object> getGiftOneMap(){
        Map<String,Object> result = new HashMap<String,Object>();
        result.put("adText",getSubHeadingAdText("629"));

        List<Map<String,Object>> giftOneList = new ArrayList<Map<String, Object>>();
        LinkInfo linkInfo = new LinkInfo();
        linkInfo.setLinklocid("602");//会员专区免费游戏币列表
        Page page = new Page();
        page.addOrder("displaysort", OrderType.DESC);
        List<LinkInfo> list = FacadeFactory.INSTANCE.getLinkInfoBo().find(linkInfo, page);
        if(list == null||list.size()==0)return null;


        int index = 0;
        for(LinkInfo info:list){
            if(index!=0){
                giftOneList.add(getGiftOneInfoMap(info));
            }
            index++;
        }
        result.put("allList",giftOneList);
        return result;
    }

    public 	String  getSubHeadingAdText(String linklocid){
        LinkInfo linkInfo = new LinkInfo();
        linkInfo.setLinklocid(linklocid);//会员专区标签配置中最新的一条数据
        Page page = new Page();
        page.addOrder("validdatetime", OrderType.DESC);
        List<LinkInfo> list = FacadeFactory.INSTANCE.getLinkInfoBo().find(linkInfo, page);
        if(list == null||list.size()==0)return "";
        LinkInfo ino = list.get(0);
        return ino.getLinktitle()==null?"":ino.getLinktitle();
    }
}
