package com.xunlei.niux.manager.template.builder.laxinye;

import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

import com.ferret.common.dao.vo.Page;
import com.xunlei.niux.data.vipgame.facade.FacadeFactory;
import com.xunlei.niux.data.vipgame.vo.Activity;
import com.xunlei.niux.data.vipgame.vo.Games;
import com.xunlei.niux.data.vipgame.vo.LaXinYe;
import com.xunlei.niux.manager.template.builder.AbstractTemplateBuilder;
import com.xunlei.niux.manager.web.cache.GameCache;
import com.xunlei.niux.manager.web.util.FreemarkerUtil;
/**
 * 拉新页模板生成
 * @author lin
 * @date 2012-10-13
 * @Descripter:
 */
public class LaXinYeBuilder2 extends AbstractTemplateBuilder {
	private static final SimpleDateFormat sdf=new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
	/**
	 * 执行生成模板
	 */
	public void executeShcema() throws Exception {
		String htmlFilePath = isPreView ? htmlTemplate.getPreviewhtmlroot() : htmlTemplate.getHtmlroot();
		if (htmlFilePath.endsWith("/")) {
			htmlFilePath = htmlFilePath.substring(0, htmlFilePath.length() - 1);
		}
		LaXinYe query=new LaXinYe();
		query.setIsValid(true);
		List<LaXinYe> lxyList=FacadeFactory.INSTANCE.getBaseSo().findObjects(query, new Page());
		for(LaXinYe laxinye:lxyList){
			Map<String,Object> rootMap=new HashMap<String,Object>();
			rootMap.put("title", laxinye.getTitle());
			rootMap.put("keywords", laxinye.getTitle());
			if(laxinye.getGameId().equals("")){
				continue;
			}
			Games game=GameCache.getInstance().getGameByGameId(laxinye.getGameId());
			if(game==null){
				continue;
			}
			rootMap.put("niux_actno", "welcome"+laxinye.getLaXinYeId());
			rootMap.put("gameno", game.getGameNo());
			rootMap.put("gameid",game.getGameId());
			rootMap.put("gameName",game.getGameName());
			rootMap.put("flash_url", laxinye.getFlashUrl());
			rootMap.put("flashHeight", laxinye.getHeight());
			rootMap.put("flashWeight", laxinye.getWeight());
            rootMap.put("isWebLogin",laxinye.getIsWebLogin());
            rootMap.put("autoOpenTime",laxinye.getAutoOpenTime());
            rootMap.put("cfgUrl",laxinye.getCfgUrl());

            rootMap.put("isShowTop",laxinye.getHasTop());
            rootMap.put("countDownTime",laxinye.getSaveIconTime()==null?"":laxinye.getSaveIconTime());
            rootMap.put("icoUrl",laxinye.getIconPic()==null?"":laxinye.getIconPic());
            rootMap.put("saveToDeskLink",laxinye.getIconJumpUrl()==null?"":laxinye.getIconJumpUrl());
            rootMap.put("saveToDeskTitle",laxinye.getIconName()==null?"":laxinye.getIconName());
            rootMap.put("moreGameJumpUrl",laxinye.getMoreGameJumpUrl()==null?"":laxinye.getMoreGameJumpUrl());

			FreemarkerUtil.buildHtml(htmlTemplate.getTemplateroot(), laxinye.getLaXinYeType(), rootMap,
					htmlFilePath + "/actives/welcome"+laxinye.getLaXinYeId(), "index.html");
			insertActivity("welcome"+laxinye.getLaXinYeId(), laxinye.getName(), "http://niu.xunlei.com/actives/welcome"+laxinye.getLaXinYeId()+"/");
		}
	}
	
	private void insertActivity(String actNo,String actName,String url){
		Activity query=new Activity();
		query.setActno(actNo);
		int count=FacadeFactory.INSTANCE.getBaseSo().countObject(query);
		if(count>0){
			return;
		}
		String nowTime=sdf.format(new Date());
		Activity activity=new Activity();
		activity.setActno(actNo);
		activity.setLink(url);
		activity.setTitle(actName);
		activity.setInputby("系统");
		activity.setInputtime(nowTime);
		activity.setStarttime(nowTime);
		activity.setEndtime(nowTime);
		activity.setDayMaxmoney(0D);
		activity.setHalfHourMaxmoney(0D);
		activity.setDayvipWarning(0);
		activity.setDayvipCut(0);
		activity.setPeriodvipCut(0);
		activity.setPeriodvipWarn(0);
		FacadeFactory.INSTANCE.getBaseSo().addObject(activity);
	}
}
