package com.xunlei.niux.manager.template.builder.jinzuan;

import com.ferret.common.dao.enums.OrderType;
import com.ferret.common.dao.vo.Page;
import com.xunlei.niux.data.vipgame.facade.FacadeFactory;
import com.xunlei.niux.data.vipgame.vo.Advice;
import com.xunlei.niux.manager.web.util.FreemarkerUtil;
import com.xunlei.util.Log;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Callable;

/**
 * Created by jamesjxin on 14-3-21.
 */
public class QuestionListPageBuilder implements Callable{
    private static final Logger logger = Log.getLogger(QuestionListPageBuilder.class);
    private String inputPath;
    private String outputPath;
    private boolean isPreview;

    public QuestionListPageBuilder(String inputPath, String outputPath, boolean isPreview) {
        this.inputPath = inputPath;
        this.outputPath = outputPath;
        this.isPreview = isPreview;
    }

    @Override
    public Object call() throws Exception {
        Map<String, Object> rootMap = new HashMap<String, Object>();
        rootMap.put("questionList", getQuestionList());

        FreemarkerUtil.buildHtml(inputPath, "faq.html", rootMap, outputPath, "faq.html");
        return "";
    }

    private List<Map<String,Object>> getQuestionList(){
        Advice query = new Advice();
        query.setPlatformno("question");
        query.setAdviceType("4");
        Page page = new Page();
        page.addOrder("displayOrder", OrderType.ESC);
        List<Advice> questionList = FacadeFactory.INSTANCE.getAdviceBo().findAdvice(query,page);

        if(CollectionUtils.isEmpty(questionList)){
            return null;
        }

        Map<String,List<Map<String,String>>> map = new HashMap<String, List<Map<String,String>>>();
        for(Advice question : questionList){
            String TypeName = question.getExt2();
            if(StringUtils.isEmpty(TypeName)){
                continue;
            }
            List<Map<String,String>> list = null;
            if(map.containsKey(TypeName)){
                list = map.get(TypeName);
            }else {
                list = new ArrayList<Map<String,String>>();
            }

            list.add(getMap(question));

            map.put(TypeName,list);
        }

        List<Map<String,Object>> resultList = new ArrayList<Map<String, Object>>();
        for(Map.Entry entry : map.entrySet()){
            Map<String,Object> resultMap = new HashMap<String, Object>();
            resultMap.put("typeName",entry.getKey().toString());
            resultMap.put("list",entry.getValue());
            resultList.add(resultMap);
        }

        return resultList;
    }

    private Map<String,String> getMap(Advice advice){
        Map<String,String> map = new HashMap<String, String>();
        map.put("title",advice.getTitle());
        map.put("content",getContent(advice));

        return map;
    }

    private String getContent(final Advice advice){
        logger.info("builderaarticle id[{}]开始替换静态图片",advice.getSeqId());
        //替换静态图片访问地址
        String content=advice.getContent()==null?"":advice.getContent();
        content=content.replaceAll("src=\"/xlniuxmanager/userUploadFile/image","src=\"http://img.smxj.webgame.kanimg.com/userUploadFile/image");
        content=content.replaceAll("src=\"/xlniumanager/userUploadFile/image","src=\"http://img.smxj.webgame.kanimg.com/userUploadFile/image");

        return content;
    }
}
