package com.xunlei.niux.manager.template.builder.jinzuan;

import com.xunlei.niux.data.vipgame.facade.FacadeFactory;
import com.xunlei.niux.data.vipgame.vo.HtmlTemplate;
import com.xunlei.niux.data.vipgame.vo.gift.Gift;
import com.xunlei.niux.data.vipgame.vo.lottery.LotteryActivity;
import com.xunlei.niux.data.vipgame.vo.lottery.LotteryGift;
import com.xunlei.niux.manager.web.util.FreemarkerUtil;
import org.apache.commons.lang.StringUtils;

import java.util.HashMap;
import java.util.Map;

/**
 * Created by jamesjxin on 14-4-21.
 */
public class LotteryDetailPageBuilder {
    private String inputPath;
    private String outputPath;


    public String build(final LotteryGift lotteryGift) {
        if (!lotteryGift.getHasDetail() || StringUtils.isEmpty(lotteryGift.getDetailContent())) {
            return "";
        }

        Map<String, Object> rootMap = new HashMap<String, Object>();
        rootMap.put("lotteryMap",getLotteryGiftData(lotteryGift));

        HtmlTemplate htmlTemplate=FacadeFactory.INSTANCE.getHtmlTemplateBo().find("000052");
        inputPath = htmlTemplate.getTemplateroot();

        outputPath=htmlTemplate.getHtmlroot();
        if(outputPath.endsWith("/")){
            outputPath=outputPath.substring(0, outputPath.length()-1);
        }


//        inputPath = "/Users/jamesjxin/Work/XL工作目录/20140311金钻/模版/2";
//        outputPath = "/Users/jamesjxin/Work/XL工作目录/20140311金钻/模版/output";

        outputPath += "/lottery/";

        String inputFileName = "lotteryDetail.html";
        String outputfileName = getArticeUrlName(lotteryGift);

        FreemarkerUtil.buildHtml(inputPath,inputFileName,rootMap,outputPath,outputfileName);

        String url = "/lottery/" + outputfileName;
        return url;
    }

    private Map<String, Object> getLotteryGiftData(final LotteryGift lotteryGift) {
        LotteryActivity activity = getLotteryActivity(lotteryGift.getActNo(), lotteryGift.getModuleId());
        if (activity == null) {
            return null;
        }
        Map<String, Object> map = new HashMap<String, Object>();
        String giftId = lotteryGift.getGiftId();
        Gift gift = getGiftById(giftId);

        map.put("id", lotteryGift.getModuleId() == null ? "" : lotteryGift.getModuleId());
        map.put("name", gift.getGiftName()==null?"":gift.getGiftName());
        map.put("desc", gift.getSimpleDesc() == null ? "" : gift.getSimpleDesc());
        map.put("price", gift.getProductTotalPrice() == null ? 0 : gift.getProductTotalPrice());
        map.put("amount", lotteryGift.getTotalCount());
        map.put("everyDayCount", lotteryGift.getMaxNumPerDay());
        map.put("level", activity.getJinKaVipNum());
        map.put("img_list", lotteryGift.getPhoto() == null ? "" : lotteryGift.getPhoto());
        map.put("img_index1", lotteryGift.getExt1() == null ? "" : lotteryGift.getExt1());
        map.put("img_index2", lotteryGift.getExt2() == null ? "" : lotteryGift.getExt2());
        map.put("validPeriod", activity.getEndTime() == null ? "" : activity.getEndTime());
        map.put("detail", getContent(lotteryGift));
        return map;
    }

    private LotteryActivity getLotteryActivity(String actNo, String moduleId) {
        LotteryActivity query = new LotteryActivity();
        query.setActNo(actNo);
        if (StringUtils.isNotEmpty(moduleId)) {
            query.setModuleId(moduleId);
        }

        return FacadeFactory.INSTANCE.getBaseSo().findObject(query);
    }

    private Gift getGiftById(String giftId) {
        if (StringUtils.isEmpty(giftId)) {
            return null;
        }
        Gift query = new Gift();
        query.setGiftId(Long.parseLong(giftId));

        Gift gift = FacadeFactory.INSTANCE.getBaseSo().findObject(query);

        return gift;
    }

    private String getContent(final LotteryGift lotteryGift) {
        //替换静态图片访问地址
        String content = lotteryGift.getDetailContent() == null ? "" : lotteryGift.getDetailContent();
        content = content.replaceAll("src=\"/xlniuxmanager/userUploadFile/image", "src=\"http://img.smxj.webgame.kanimg.com/userUploadFile/image");
        content = content.replaceAll("src=\"/xlniumanager/userUploadFile/image", "src=\"http://img.smxj.webgame.kanimg.com/userUploadFile/image");

        return content;
    }

    private String getArticeUrlName(final LotteryGift lotteryGift){
        if(StringUtils.isEmpty(lotteryGift.getDetailUrl())){
            return System.currentTimeMillis()+".html";
        }
        String contentUrl=lotteryGift.getDetailUrl();
        if(contentUrl.contains("/lottery/")){
            return contentUrl.substring(contentUrl.lastIndexOf("/")+1);
        }

        return System.currentTimeMillis()+".html";
    }
}
